/*******************************************************************************
* ts2ts.h: threaded TS to TS converter
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: ts2ts.h,v 1.1 2001/11/28 19:32:23 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _TS2TS_CONVERTER_H_
#define _TS2TS_CONVERTER_H_


//------------------------------------------------------------------------------
// C_Ts2TsMpegConverter class
//------------------------------------------------------------------------------
// Mpeg 2 TS -> Mpeg 2 TS (no conversion)
//------------------------------------------------------------------------------
class C_Ts2TsMpegConverter : public C_MpegConverter
{
public:
  C_Ts2TsMpegConverter(C_Module* pModule, C_MpegConverterConfig& cConfig);

protected:
  virtual void InitWork();
  virtual void DoWork();

  int FillPacket(C_TsPacket* pPacket);
  int SyncFillPacket(C_TsPacket* pPacket);
};


// Declaration and implementation of C_Ts2TsMpegConverterModule
DECLARE_MODULE(Ts2Ts, MpegConverter, "ts2ts", C_MpegConverterConfig&);


#else
#error "Multiple inclusions of ts2ts.h"
#endif

