/*******************************************************************************
* fileoutput.cpp: file output
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: fileoutput.cpp,v 1.1 2001/11/22 01:51:12 bozo Exp $
*
* Authors: James Courtier-Dutton <James@superbug.demon.co.uk>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../../core/defs.h"

#include "../../core/core.h"
#include "../../mpeg/mpeg.h"
#include "../../mpeg/ts.h"
#include "../../server/buffer.h"
#include "../../server/output.h"

#include "fileoutput.h"


//******************************************************************************
// C_FileOutput class
//******************************************************************************
//
//******************************************************************************

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_FileOutput::C_FileOutput(const C_String& strFileName, bool bAppend)
                : C_Output(1),
                  m_cFile(strFileName),
                  m_strFileName(strFileName)
{
  m_bAppend = bAppend;
}

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_FileOutput::~C_FileOutput()
{
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_FileOutput::OnInit()
{
  {
    // Open the file
    if(m_bAppend)
      m_cFile.Open("a+");
    else
      m_cFile.Open("w+");
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_FileOutput::OnClose()
{
  try
  {
    m_cFile.Close();
  }
  catch(E_Exception e)
  {
    throw E_Output("Output termination failed", e);
  }
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_FileOutput::WriteToPort()
{
  ASSERT(m_pTsProvider);

  unsigned int iPacketNumber = m_cTsBuff.Size();
  
  if(iPacketNumber > 0)
  {
    try
    {
      for(unsigned int i = 0; i < iPacketNumber; i++)
      {
        m_cFile.Write(m_cTsBuff[i], TS_PACKET_LEN);
      }
    }
    catch(E_File e)
    {
      throw E_Output("File output error", e);
    }

    // Free the now unused packets
    C_TsPacket* pPacket;
    for(unsigned int i = 0; i < iPacketNumber; i++)
    {
      // Pop the packet from the buffer
      pPacket = m_cTsBuff.Pop();
      ASSERT(pPacket);
      // And release it
      m_pTsProvider->ReleasePacket(pPacket);
    }
  }
}


