/* gettimeofday() is not POSIX :( If it doesn't exist, use ftime() (resolution
 *  : 1000Hz). The only POSIX solution is to use times() (resolution under
 *  Linux i386 : 100Hz)
 * Don't worry if (var), which is the time in micro-second, overflows : we
 *  only compute differences between values returned by this macro.
 */
#define GET_TIME(var,tmp) ( \
    gettimeofday (&(tmp), NULL), \
    (var) = ((tmp).tv_sec * 1000000) + (tmp).tv_usec \
)

/* The encoder has a 27Mhz clock, but the PCRs have a resolution of 90Khz. We
 * simply ignore the MSB to get it in 32 bits.
 */
#define PCR_FREQUENCY 90000
#define PCR_FREQUENCY_KHZ 90
