/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ConcurrentExecutorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHttpServerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int port = 8080;
    private String hostname;
    private int backlog = -1;
    private Executor executor;
    private Map<String, HttpHandler> contexts;
    private int shutdownDelay = 0;
    private HttpServer server;

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setTaskExecutor(TaskExecutor executor) {
        this.executor = new ConcurrentExecutorAdapter(executor);
    }

    public void setContexts(Map<String, HttpHandler> contexts) {
        this.contexts = contexts;
    }

    public void setShutdownDelay(int shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    @Override
    public void afterPropertiesSet() throws IOException {
        InetSocketAddress address;
        InetSocketAddress inetSocketAddress = address = this.hostname != null ? new InetSocketAddress(this.hostname, this.port) : new InetSocketAddress(this.port);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Binding HttpServer to address " + address));
        }
        this.server = HttpServer.create(address, this.backlog);
        if (this.executor != null) {
            this.server.setExecutor(this.executor);
        }
        if (this.contexts != null) {
            for (Map.Entry<String, HttpHandler> entry : this.contexts.entrySet()) {
                this.server.createContext(entry.getKey(), entry.getValue());
            }
        }
        this.server.start();
    }

    @Override
    public Object getObject() {
        return this.server;
    }

    @Override
    public Class getObjectType() {
        return this.server != null ? this.server.getClass() : HttpServer.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() {
        this.logger.info((Object)"Stopping HttpServer");
        this.server.stop(this.shutdownDelay);
    }
}

