/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.reflect.ReflectionWorld;
import org.aspectj.weaver.tools.ContextBasedMatcher;
import org.aspectj.weaver.tools.FuzzyBoolean;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.MatchingContext;
import org.aspectj.weaver.tools.PointcutDesignatorHandler;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.aspectj.weaver.tools.ShadowMatch;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAwareMethodMatcher;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.aspectj.RuntimeTestWalker;
import org.springframework.aop.framework.autoproxy.ProxyCreationContext;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.support.AbstractExpressionPointcut;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AspectJExpressionPointcut
extends AbstractExpressionPointcut
implements ClassFilter,
IntroductionAwareMethodMatcher,
BeanFactoryAware {
    private static final Set DEFAULT_SUPPORTED_PRIMITIVES = new HashSet();
    private static final Log logger;
    private final Map shadowMapCache = new HashMap();
    private PointcutParser pointcutParser;
    private Class pointcutDeclarationScope;
    private String[] pointcutParameterNames = new String[0];
    private Class[] pointcutParameterTypes = new Class[0];
    private BeanFactory beanFactory;
    private PointcutExpression pointcutExpression;

    public AspectJExpressionPointcut() {
        this(DEFAULT_SUPPORTED_PRIMITIVES);
    }

    public AspectJExpressionPointcut(Set supportedPrimitives) {
        this.pointcutParser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution((Set)supportedPrimitives);
        this.pointcutParser.registerPointcutDesignatorHandler((PointcutDesignatorHandler)new BeanNamePointcutDesignatorHandler());
    }

    public AspectJExpressionPointcut(Class declarationScope, String[] paramNames, Class[] paramTypes) {
        this(DEFAULT_SUPPORTED_PRIMITIVES);
        this.pointcutDeclarationScope = declarationScope;
        if (paramNames.length != paramTypes.length) {
            throw new IllegalStateException("Number of pointcut parameter names must match number of pointcut parameter types");
        }
        this.pointcutParameterNames = paramNames;
        this.pointcutParameterTypes = paramTypes;
    }

    public void setPointcutDeclarationScope(Class pointcutDeclarationScope) {
        this.pointcutDeclarationScope = pointcutDeclarationScope;
    }

    public void setParameterNames(String[] names) {
        this.pointcutParameterNames = names;
    }

    public void setParameterTypes(Class[] types) {
        this.pointcutParameterTypes = types;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClassFilter getClassFilter() {
        this.checkReadyToMatch();
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        this.checkReadyToMatch();
        return this;
    }

    private void checkReadyToMatch() {
        if (this.getExpression() == null) {
            throw new IllegalStateException("Must set property 'expression' before attempting to match");
        }
        if (this.pointcutExpression == null) {
            this.pointcutExpression = this.buildPointcutExpression();
        }
    }

    private PointcutExpression buildPointcutExpression() {
        PointcutParameter[] pointcutParameters = new PointcutParameter[this.pointcutParameterNames.length];
        for (int i = 0; i < pointcutParameters.length; ++i) {
            pointcutParameters[i] = this.pointcutParser.createPointcutParameter(this.pointcutParameterNames[i], this.pointcutParameterTypes[i]);
        }
        return this.pointcutParser.parsePointcutExpression(this.replaceBooleanOperators(this.getExpression()), this.pointcutDeclarationScope, pointcutParameters);
    }

    private String replaceBooleanOperators(String pcExpr) {
        pcExpr = StringUtils.replace(pcExpr, " and ", " && ");
        pcExpr = StringUtils.replace(pcExpr, " or ", " || ");
        pcExpr = StringUtils.replace(pcExpr, " not ", " ! ");
        return pcExpr;
    }

    public PointcutExpression getPointcutExpression() {
        this.checkReadyToMatch();
        return this.pointcutExpression;
    }

    public boolean matches(Class targetClass) {
        this.checkReadyToMatch();
        try {
            return this.pointcutExpression.couldMatchJoinPointsInType(targetClass);
        }
        catch (BCException ex) {
            logger.debug((Object)"PointcutExpression matching rejected target class", (Throwable)ex);
            return false;
        }
    }

    public boolean matches(Method method, Class targetClass, boolean beanHasIntroductions) {
        this.checkReadyToMatch();
        Method targetMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        ShadowMatch shadowMatch = null;
        try {
            shadowMatch = this.getShadowMatch(targetMethod, method);
        }
        catch (ReflectionWorld.ReflectionWorldException ex) {
            return false;
        }
        if (shadowMatch.alwaysMatches()) {
            return true;
        }
        if (shadowMatch.neverMatches()) {
            return false;
        }
        return beanHasIntroductions || this.matchesIgnoringSubtypes(shadowMatch) || this.matchesTarget(shadowMatch, targetClass);
    }

    public boolean matches(Method method, Class targetClass) {
        return this.matches(method, targetClass, false);
    }

    public boolean isRuntime() {
        this.checkReadyToMatch();
        return this.pointcutExpression.mayNeedDynamicTest();
    }

    public boolean matches(Method method, Class targetClass, Object[] args) {
        RuntimeTestWalker originalMethodResidueTest;
        this.checkReadyToMatch();
        ShadowMatch shadowMatch = null;
        ShadowMatch originalShadowMatch = null;
        try {
            shadowMatch = this.getShadowMatch(AopUtils.getMostSpecificMethod(method, targetClass), method);
            originalShadowMatch = this.getShadowMatch(method, method);
        }
        catch (ReflectionWorld.ReflectionWorldException ex) {
            return false;
        }
        ProxyMethodInvocation pmi = null;
        Object targetObject = null;
        Object thisObject = null;
        try {
            MethodInvocation mi = ExposeInvocationInterceptor.currentInvocation();
            targetObject = mi.getThis();
            if (!(mi instanceof ProxyMethodInvocation)) {
                throw new IllegalStateException("MethodInvocation is not a Spring ProxyMethodInvocation: " + mi);
            }
            pmi = (ProxyMethodInvocation)mi;
            thisObject = pmi.getProxy();
        }
        catch (IllegalStateException ex) {
            logger.debug((Object)("Couldn't access current invocation - matching with limited context: " + ex));
        }
        JoinPointMatch joinPointMatch = shadowMatch.matchesJoinPoint(thisObject, targetObject, args);
        if (pmi != null && !(originalMethodResidueTest = new RuntimeTestWalker(originalShadowMatch)).testThisInstanceOfResidue(thisObject.getClass())) {
            return false;
        }
        if (joinPointMatch.matches() && pmi != null) {
            this.bindParameters(pmi, joinPointMatch);
        }
        return joinPointMatch.matches();
    }

    protected String getCurrentProxiedBeanName() {
        return ProxyCreationContext.getCurrentProxiedBeanName();
    }

    private boolean matchesIgnoringSubtypes(ShadowMatch shadowMatch) {
        return !new RuntimeTestWalker(shadowMatch).testsSubtypeSensitiveVars();
    }

    private boolean matchesTarget(ShadowMatch shadowMatch, Class targetClass) {
        return new RuntimeTestWalker(shadowMatch).testTargetInstanceOfResidue(targetClass);
    }

    private void bindParameters(ProxyMethodInvocation invocation, JoinPointMatch jpm) {
        invocation.setUserAttribute(this.getExpression(), jpm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowMatch getShadowMatch(Method targetMethod, Method originalMethod) {
        Map map = this.shadowMapCache;
        synchronized (map) {
            ShadowMatch shadowMatch = (ShadowMatch)this.shadowMapCache.get(targetMethod);
            if (shadowMatch == null) {
                try {
                    shadowMatch = this.pointcutExpression.matchesMethodExecution(targetMethod);
                }
                catch (ReflectionWorld.ReflectionWorldException ex) {
                    if (targetMethod == originalMethod) {
                        throw ex;
                    }
                    shadowMatch = this.pointcutExpression.matchesMethodExecution(originalMethod);
                }
                this.shadowMapCache.put(targetMethod, shadowMatch);
            }
            return shadowMatch;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AspectJExpressionPointcut)) {
            return false;
        }
        AspectJExpressionPointcut otherPc = (AspectJExpressionPointcut)other;
        return ObjectUtils.nullSafeEquals(this.getExpression(), otherPc.getExpression()) && ObjectUtils.nullSafeEquals(this.pointcutDeclarationScope, otherPc.pointcutDeclarationScope) && ObjectUtils.nullSafeEquals(this.pointcutParameterNames, otherPc.pointcutParameterNames) && ObjectUtils.nullSafeEquals(this.pointcutParameterTypes, otherPc.pointcutParameterTypes);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.getExpression());
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.pointcutDeclarationScope);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.pointcutParameterNames);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.pointcutParameterTypes);
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AspectJExpressionPointcut: ");
        if (this.pointcutParameterNames != null && this.pointcutParameterTypes != null) {
            sb.append("(");
            for (int i = 0; i < this.pointcutParameterTypes.length; ++i) {
                sb.append(this.pointcutParameterTypes[i].getName());
                sb.append(" ");
                sb.append(this.pointcutParameterNames[i]);
                if (i + 1 >= this.pointcutParameterTypes.length) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append(" ");
        if (this.getExpression() != null) {
            sb.append(this.getExpression());
        } else {
            sb.append("<pointcut expression not set>");
        }
        return sb.toString();
    }

    static {
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.EXECUTION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.REFERENCE);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.THIS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.TARGET);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ANNOTATION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_TARGET);
        logger = LogFactory.getLog((Class)AspectJExpressionPointcut.class);
    }

    private class BeanNameContextMatcher
    implements ContextBasedMatcher {
        private final NamePattern expressionPattern;

        public BeanNameContextMatcher(String expression) {
            this.expressionPattern = new NamePattern(expression);
        }

        public boolean couldMatchJoinPointsInType(Class someClass) {
            return true;
        }

        public boolean couldMatchJoinPointsInType(Class someClass, MatchingContext context) {
            return this.contextMatch();
        }

        public boolean matchesDynamically(MatchingContext context) {
            return true;
        }

        public FuzzyBoolean matchesStatically(MatchingContext context) {
            return FuzzyBoolean.YES;
        }

        public boolean mayNeedDynamicTest() {
            return false;
        }

        private boolean contextMatch() {
            String advisedBeanName = AspectJExpressionPointcut.this.getCurrentProxiedBeanName();
            if (advisedBeanName == null || BeanFactoryUtils.isGeneratedBeanName(advisedBeanName)) {
                return false;
            }
            if (this.expressionPattern.matches(advisedBeanName)) {
                return true;
            }
            if (AspectJExpressionPointcut.this.beanFactory != null) {
                String[] aliases = AspectJExpressionPointcut.this.beanFactory.getAliases(advisedBeanName);
                for (int i = 0; i < aliases.length; ++i) {
                    if (!this.expressionPattern.matches(aliases[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class BeanNamePointcutDesignatorHandler
    implements PointcutDesignatorHandler {
        private static final String BEAN_DESIGNATOR_NAME = "bean";

        private BeanNamePointcutDesignatorHandler() {
        }

        public String getDesignatorName() {
            return BEAN_DESIGNATOR_NAME;
        }

        public ContextBasedMatcher parse(String expression) {
            return new BeanNameContextMatcher(expression);
        }
    }
}

