/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jrobin.core.Util;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.orders.VlOrder;
import org.videolan.vlma.common.programs.IVlProgram;
import org.videolan.vlma.daemon.IVlStreamWatcher;

public class VlOrderMonitoring {
    private static final Logger logger = Logger.getLogger(VlOrderMonitoring.class);
    private IVlData data;
    private Thread orderMonitorThread;
    private Thread orderMonitorDeamonThread;
    private static final int RRD_INTERVAL = 60;
    private IVlStreamWatcher streamWatcher;
    private Runnable orderMonitor = new Runnable(){

        public void run() {
            Map<InetAddress, InetAddress> streams = VlOrderMonitoring.this.streamWatcher.getStreams();
            boolean shouldCompute = false;
            List<IVlMedia> medias = VlOrderMonitoring.this.data.getMedias();
            for (IVlMedia iVlMedia : medias) {
                IVlProgram program = iVlMedia.getProgram();
                if (program == null || !program.isTimeToPlay()) continue;
                if (streams.get(program.getIp()) == null && !VlOrderMonitoring.this.data.getOrderGiver().isComputing()) {
                    program.setPlayer(null);
                    program.setBroadcastState(false);
                    shouldCompute = true;
                    Iterator<List<VlOrder>> k = VlOrderMonitoring.this.data.getOrders().values().iterator();
                    block1: while (k.hasNext()) {
                        Iterator<VlOrder> l = k.next().iterator();
                        while (l.hasNext()) {
                            VlOrder o = l.next();
                            if (!o.getMedias().medias.contains(iVlMedia)) continue;
                            l.remove();
                            continue block1;
                        }
                    }
                    continue;
                }
                program.setBroadcastState(true);
            }
            for (List list : VlOrderMonitoring.this.data.getOrders().values()) {
                for (VlOrder order : list) {
                    for (IVlMedia media : order.getMedias().medias) {
                        if (media.getProgram() != null) continue;
                        logger.log(Level.DEBUG, "The media " + media.getName() + " which belongs to an order has no more a program.");
                        shouldCompute = true;
                        break;
                    }
                    if (!shouldCompute) continue;
                    break;
                }
                if (!shouldCompute) continue;
                break;
            }
            if (shouldCompute) {
                logger.log(Level.DEBUG, "Ask for programs reassignment.");
                VlOrderMonitoring.this.data.giveOrders();
            }
        }
    };
    private Runnable orderMonitorDeamon = new Runnable(){

        public void run() {
            while (true) {
                VlOrderMonitoring.this.startOrderMonitoringThread();
                try {
                    Thread.sleep(1000L * (60L - Util.getTime() % 60L));
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    };

    public boolean isMonitoring() {
        return this.orderMonitorThread != null && this.orderMonitorThread.isAlive();
    }

    public boolean isDeamonMonitoring() {
        return this.orderMonitorDeamonThread != null && this.orderMonitorDeamonThread.isAlive();
    }

    public VlOrderMonitoring(IVlData data) {
        this.data = data;
    }

    public synchronized void startOrderMonitoringThread() {
        if (!this.isMonitoring()) {
            this.orderMonitorThread = new Thread(this.orderMonitor);
            this.orderMonitorThread.setName("OrderMonitorThread");
            this.orderMonitorThread.start();
        }
    }

    public synchronized void startOrderMonitoringDeamon() {
        if (!this.isDeamonMonitoring()) {
            this.orderMonitorDeamonThread = new Thread(this.orderMonitorDeamon);
            this.orderMonitorDeamonThread.setName("OrderMonitorDeamonThread");
            this.orderMonitorDeamonThread.start();
        }
    }

    public void setStreamWatcher(IVlStreamWatcher streamWatcher) {
        this.streamWatcher = streamWatcher;
    }
}

