/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.files;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.common.IVlData;

import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlFilesChannel;

public class FilesChannelsEditFormController extends SimpleFormController {

    private IVlData data;

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public ModelAndView onSubmit(Object command) throws ServletException,
            UnknownHostException {
        int id = ((FilesChannelsAdd)command).getId();
        
        VlFilesChannel filesChannel = (VlFilesChannel)data.getMedia(id);
        data.setFilesChannelFilesList(filesChannel.getId(), ((FilesChannelsAdd) command).getFiles());
        data.setFilesChannelServer(filesChannel.getId(), ((FilesChannelsAdd) command).getServer());
        data.sortMedias();
        
        return new ModelAndView(new RedirectView(getSuccessView()));
    }

    protected Object formBackingObject(HttpServletRequest request)
            throws ServletException {
        int id = Integer.parseInt(request.getParameter("Id")); 
        IVlMedia media = data.getMedia(id);
        
        FilesChannelsAdd filesChannelsAdd = new FilesChannelsAdd();
        filesChannelsAdd.setId(id);
        filesChannelsAdd.setName(media.getName());
        if (media.getClass() == VlFilesChannel.class) {
            filesChannelsAdd.setServer(((VlFilesChannel)media).getServer().getName());
            
            String filesList = new String();
            for (String file : ((VlFilesChannel)media).getFiles()) {
                filesList += file + "\n";
            }
            filesChannelsAdd.setFiles(filesList);
        }
        
        List<String> serversNames = new ArrayList<String>();
        for (VlServer server : data.getServers()) {
            serversNames.add(server.getName());
        }
        filesChannelsAdd.setServersList(serversNames);
        filesChannelsAdd.setData(data);
        return filesChannelsAdd;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest arg0,
            HttpServletResponse arg1) throws Exception {
        return super.handleRequestInternal(arg0, arg1);
    }

}
