/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.adapters;

import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.exceptions.AdapterParameterDoesNotExistException;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlSatellite;

/**
 * DVB-S card.
 *
 * @author SylV
 * 
 */
public class VlDVBS extends VlAdapter {

    private VlSatellite satellite;

    /**
     * Returns the name describing the adapter type.
     * 
     * @return the adapter type name
     */
    public String getType() {
        return "DVB-S";
    }

    /**
     * Returns the satellite the card uses.
     * 
     * @return the satellite the card uses
     */
    public VlSatellite getSatellite() {
        return satellite;
    }

    /**
     * Sets the satellite the card uses.
     * 
     * @param satellite
     *            the satellite the card uses
     */
    public void setSatellite(VlSatellite satellite) {
        this.satellite = satellite;
    }

    public void setParameter(String parameter, String value, IVlData data)
            throws AdapterParameterDoesNotExistException {
        if (parameter.equalsIgnoreCase("satellite")) {
            this.setSatellite(null);
            for (VlSatellite s : data.getSatellites()) {
                if (s.getName().equalsIgnoreCase(value)) {
                    this.setSatellite(s);
                    break;
                }
            }

        } else {
            throw new AdapterParameterDoesNotExistException("Paramater "
                    + parameter
                    + " doesn't exist among adapters whose type is "
                    + this.getClass().getSimpleName());
        }
    }

    public int hashType() {
        return VlSatChannel.class.hashCode() + satellite.hashCode();
    }

    public boolean canRead(IVlMedia media) {
        return (media.getClass().equals(VlSatChannel.class) && satellite
                .getCoverages().contains(((VlSatChannel) media).getCoverage()));
    }
}
