/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.patchers;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.videolan.BDJClassFilePatcher;
import org.videolan.Logger;

public class ReplaceMethodPatcher
implements BDJClassFilePatcher {
    final String origMethod;
    final String origClass;
    final String newMethod;
    final String newClass;
    final String signature;
    final int callOpcode;
    private static final Logger logger = Logger.getLogger(ReplaceMethodPatcher.class.getName());

    public ReplaceMethodPatcher(String origClass, String origMethod, String newClass, String newMethod, String signature) {
        if (origMethod == null || origClass == null || newMethod == null || newClass == null || signature == null) {
            throw new NullPointerException();
        }
        this.origMethod = origMethod;
        this.origClass = origClass;
        this.newMethod = newMethod;
        this.newClass = newClass;
        this.signature = signature;
        this.callOpcode = 184;
    }

    public byte[] patch(byte[] b) throws ClassFormatError {
        try {
            ClassReader cr = new ClassReader(b);
            ClassWriter cw = new ClassWriter(cr, 0);
            PatchClassVisitor cv = new PatchClassVisitor((ClassVisitor)cw);
            cr.accept(cv, 10);
            return cw.toByteArray();
        }
        catch (Exception e) {
            logger.error("Failed patching class: " + e);
            return b;
        }
    }

    private final class PatchMethodVisitor
    extends MethodVisitor {
        public PatchMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitAttribute(Attribute attr) {
            super.visitAttribute(attr);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == ReplaceMethodPatcher.this.callOpcode && owner.equals(ReplaceMethodPatcher.this.origClass) && name.equals(ReplaceMethodPatcher.this.origMethod) && desc.equals(ReplaceMethodPatcher.this.signature)) {
                super.visitMethodInsn(ReplaceMethodPatcher.this.callOpcode, ReplaceMethodPatcher.this.newClass, ReplaceMethodPatcher.this.newMethod, ReplaceMethodPatcher.this.signature, false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private final class PatchClassVisitor
    extends ClassVisitor {
        public PatchClassVisitor(ClassVisitor cv) {
            super(262144, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new PatchMethodVisitor(mv);
        }
    }
}

