/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; fill-column: 100 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_TEST_VIEW_XFORMLAYERACCESS_HXX
#define INCLUDED_TEST_VIEW_XFORMLAYERACCESS_HXX

#include <com/sun/star/form/XForm.hpp>
#include <com/sun/star/uno/XInterface.hpp>

#include <com/sun/star/uno/Reference.hxx>

#include <test/testdllapi.hxx>

namespace apitest
{
class OOO_DLLPUBLIC_TEST XFormLayerAccess
{
public:
    virtual css::uno::Reference<css::uno::XInterface> init() = 0;
    void setForm(const css::uno::Reference<css::form::XForm>& r_xForm) { m_xForm = r_xForm; }

    void testGetFormController();
    void testIsFormDesignMode();
    void testSetFormDesignMode();

protected:
    ~XFormLayerAccess() {}

private:
    css::uno::Reference<css::form::XForm> m_xForm;
};

} // namespace apitest

#endif // INCLUDED_TEST_VIEW_XFORMLAYERACCESS_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab cinoptions=b1,g0,N-s cinkeys+=0=break: */
