#!/usr/bin/python

import sys
import re
import io

definitionSet = set()
definitionToSourceLocationMap = dict()
definitionToTypeMap = dict()
callSet = set()
readFromSet = set()
sourceLocationSet = set()
# things we need to exclude for reasons like :
# - it's a weird template thingy that confuses the plugin
exclusionSet = set([
    ])

# clang does not always use exactly the same numbers in the type-parameter vars it generates
# so I need to substitute them to ensure we can match correctly.
normalizeTypeParamsRegex = re.compile(r"type-parameter-\d+-\d+")
def normalizeTypeParams( line ):
    return normalizeTypeParamsRegex.sub("type-parameter-?-?", line)

# The parsing here is designed to avoid grabbing stuff which is mixed in from gbuild.
# I have not yet found a way of suppressing the gbuild output.
with io.open(sys.argv[1], "rb", buffering=1024*1024) as txt:
    for line in txt:
        if line.startswith("definition:\t"):
            idx1 = line.find("\t",12)
            idx2 = line.find("\t",idx1+1)
            idx3 = line.find("\t",idx2+1)
            funcInfo = (normalizeTypeParams(line[12:idx1]), line[idx1+1:idx2])
            definitionSet.add(funcInfo)
            definitionToTypeMap[funcInfo] = line[idx2+1:idx3].strip()
            definitionToSourceLocationMap[funcInfo] = line[idx3+1:].strip()
        elif line.startswith("touch:\t"):
            idx1 = line.find("\t",7)
            callInfo = (normalizeTypeParams(line[7:idx1]), line[idx1+1:].strip())
            callSet.add(callInfo)
        elif line.startswith("read:\t"):
            idx1 = line.find("\t",6)
            readInfo = (normalizeTypeParams(line[6:idx1]), line[idx1+1:].strip())
            readFromSet.add(readInfo)

# Invert the definitionToSourceLocationMap
# If we see more than one method at the same sourceLocation, it's being autogenerated as part of a template
# and we should just ignore
sourceLocationToDefinitionMap = {}
for k, v in definitionToSourceLocationMap.iteritems():
    sourceLocationToDefinitionMap[v] = sourceLocationToDefinitionMap.get(v, [])
    sourceLocationToDefinitionMap[v].append(k)
for k, definitions in sourceLocationToDefinitionMap.iteritems():
    if len(definitions) > 1:
        for d in definitions:
            definitionSet.remove(d)
    
untouchedSet = set()
for d in definitionSet:
    clazz = d[0] + " " + d[1]
    if clazz in exclusionSet:
        continue
    if d in callSet:
        continue
    srcLoc = definitionToSourceLocationMap[d];
    # ignore external source code
    if (srcLoc.startswith("external/")):
        continue
    # ignore build folder
    if (srcLoc.startswith("workdir/")):
        continue
    # ignore our stable/URE/UNO api
    if (srcLoc.startswith("include/com/")
        or srcLoc.startswith("include/cppu/")
        or srcLoc.startswith("include/cppuhelper/")
        or srcLoc.startswith("include/osl/")
        or srcLoc.startswith("include/rtl/")
        or srcLoc.startswith("include/sal/")
        or srcLoc.startswith("include/salhelper/")
        or srcLoc.startswith("include/systools/")
        or srcLoc.startswith("include/typelib/")
        or srcLoc.startswith("include/uno/")):
        continue
    # this is all representations of on-disk data structures
    if (srcLoc.startswith("sc/source/filter/inc/scflt.hxx")
        or srcLoc.startswith("sw/source/filter/ww8/")
        or srcLoc.startswith("vcl/source/filter/sgvmain.hxx")
        or srcLoc.startswith("vcl/source/filter/sgfbram.hxx")
        or srcLoc.startswith("vcl/inc/unx/XIM.h")
        or srcLoc.startswith("vcl/inc/unx/gtk/gloactiongroup.h")
        or srcLoc.startswith("include/svl/svdde.hxx")
        or srcLoc.startswith("lotuswordpro/source/filter/lwpsdwdrawheader.hxx")
        or srcLoc.startswith("svtools/source/dialogs/insdlg.cxx")):
        continue
    untouchedSet.add((clazz + " " + definitionToTypeMap[d], srcLoc))

writeonlySet = set()
for d in definitionSet:
    clazz = d[0] + " " + d[1]
    if d in readFromSet:
        continue
    srcLoc = definitionToSourceLocationMap[d];
    # ignore external source code
    if (srcLoc.startswith("external/")):
        continue
    # ignore build folder
    if (srcLoc.startswith("workdir/")):
        continue
    # ignore our stable/URE/UNO api
    if (srcLoc.startswith("include/com/")
        or srcLoc.startswith("include/cppu/")
        or srcLoc.startswith("include/cppuhelper/")
        or srcLoc.startswith("include/osl/")
        or srcLoc.startswith("include/rtl/")
        or srcLoc.startswith("include/sal/")
        or srcLoc.startswith("include/salhelper/")
        or srcLoc.startswith("include/systools/")
        or srcLoc.startswith("include/typelib/")
        or srcLoc.startswith("include/uno/")):
        continue
    # this is all representations of on-disk data structures
    if (srcLoc.startswith("sc/source/filter/inc/scflt.hxx")
        or srcLoc.startswith("sw/source/filter/ww8/")
        or srcLoc.startswith("vcl/source/filter/sgvmain.hxx")
        or srcLoc.startswith("vcl/source/filter/sgfbram.hxx")
        or srcLoc.startswith("vcl/inc/unx/XIM.h")
        or srcLoc.startswith("vcl/inc/unx/gtk/gloactiongroup.h")
        or srcLoc.startswith("include/svl/svdde.hxx")
        or srcLoc.startswith("lotuswordpro/source/filter/lwpsdwdrawheader.hxx")
        or srcLoc.startswith("svtools/source/dialogs/insdlg.cxx")):
        continue

    writeonlySet.add((clazz + " " + definitionToTypeMap[d], srcLoc))

# sort the results using a "natural order" so sequences like [item1,item2,item10] sort nicely
def natural_sort_key(s, _nsre=re.compile('([0-9]+)')):
    return [int(text) if text.isdigit() else text.lower()
            for text in re.split(_nsre, s)]

# sort results by name and line number
tmp1list = sorted(untouchedSet, key=lambda v: natural_sort_key(v[1]))
tmp2list = sorted(writeonlySet, key=lambda v: natural_sort_key(v[1]))

# print out the results
with open("unusedfields.untouched", "wt") as f:
    for t in tmp1list:
        f.write( t[1] + "\n" )
        f.write( "    " + t[0] + "\n" )
with open("unusedfields.writeonly", "wt") as f:
    for t in tmp2list:
        f.write( t[1] + "\n" )
        f.write( "    " + t[0] + "\n" )

    

# add an empty line at the end to make it easier for the unusedFieldsremove plugin to mmap() the output file 
print
        

