#! /usr/bin/env perl

# reads a list of dependency files from a file, opens and
# concatenates them, while eliding duplicate nop rules.
use File::Spec;

sub read_depfiles($)
{
    my $name = shift;
    my $depfh;
    my @files;
    open ($depfh, $name) || die "Can't open list of dependencies: $name: $!";
    while (<$depfh>) {
	push @files, split(/\s+/, $_);
    }
    close ($depfh);

#    print STDERR "dep files: " . join ("'", @files) . "\n";
    return @files;
}

my @depfiles = read_depfiles (shift @ARGV);

my %rules;
print "# concatenated, reduced dependencies generated by solenv/bin/concat-deps.pl\n";
print "# generated with \$(SRCDIR) = $ENV{SRCDIR}\n";

sub canonicalize_path($)
{
    my $line = shift;
    $line =~ /^(\s*)([^\s\n:]*)(.*\n?)$/;
    my $pre = $1;
    my $path = $2;
    my $post =$3;
    if (length($path) > 0 && index($path,$ENV{SRCDIR}) == 0) {
        $path = File::Spec->rel2abs($2);
        $path = "\$(SRCDIR)" . substr($path, length($ENV{SRCDIR}));
    }
    #print "## $pre$path$post";
    return "$pre$path$post";
}

for my $fname (@depfiles) {
    my $fileh;

    next if ($fname eq '');
    open ($fileh, $fname) || die "Can't open $fname: $!\n";

    my $last = '';
    while (<$fileh>) {
	my $line = canonicalize_path($_);
#        print "# $line";
	if ($line eq "\n") {
	    if ($last =~ /^(.*):\s*$/) {
		if (defined $rules{$1}) {
		    $last = '';
		    next;
		}
		$rules{$1} = 1;
	    }
	}
	print $last;
	$last = $line;
    }
    print "$last\n"; # in case of missing newline

    close ($fileh);
}
