local lang = {
  ["abort"] = "Abort",
  ["action"] = "Action",
  ["actions"] = "Actions",
  ["active_flows"] = "Active Flows",
  ["activities"] = "Activities",
  ["activity"] = "Activity",
  ["add"] = "Add",
  ["admin_status"] = "Admin",
  ["advanced"] = "Advanced",
  ["aggregation"] = "Aggregation",
  ["alias"] = "Alias",
  ["all"] = "All",
  ["allowed"] = "Allowed",
  ["and"] = "and",
  ["and_x_more"] = "and %{num} more",
  ["any"] = "any",
  ["app_name"] = "Application Name",
  ["application"] = "Application",
  ["applications"] = "Applications",
  ["apply"] = "Apply",
  ["arp"] = "ARP",
  ["as"] = "AS",
  ["as_number"] = "AS number",
  ["asn"] = "ASN",
  ["availability"] = "Availability",
  ["available"] = "Available",
  ["backup"] = "Backup",
  ["begin"] = "Begin",
  ["bind"] = "Bind",
  ["breakdown"] = "Breakdown",
  ["bridge"] = "Bridge",
  ["broadcast"] = "Broadcast",
  ["broadcast_domain"] = "Broadcast Domain",
  ["broadcast_traffic"] = "Broadcast Traffic",
  ["browse_config"] = "Browse a configuration file to import",
  ["busy"] = "Busy",
  ["bytes"] = "Bytes",
  ["cancel"] = "Cancel",
  ["categories"] = "Categories",
  ["category"] = "Category",
  ["change_number_of_rows"] = "Change the number of rows per page",
  ["chart"] = "Chart",
  ["click_to_expand"] = "Click to expand",
  ["client"] = "Client",
  ["client_to_server"] = "Client to Server",
  ["clone"] = "Clone",
  ["close"] = "Close",
  ["configure"] = "Configure",
  ["countries"] = "Countries",
  ["create"] = "Create",
  ["dark"] = "Dark",
  ["date_from"] = "Begin Date/Time:",
  ["date_to"] = "End Date/Time:",
  ["day"] = "Day",
  ["default"] = "Default",
  ["define"] = "Define",
  ["delete"] = "Delete",
  ["description"] = "Description",
  ["destination"] = "Destination",
  ["developer"] = "Developer",
  ["device_protocols_description"] = "In this page it is possible to configure the list of acceptable applications per device type and direction (device as client or server with respect to the application). By enabling the flow user script Device Application Not Allowed in the User Scripts configuration page, alerts are generated when an anomalous application is detected.",
  ["devices"] = "Devices",
  ["difference"] = "Difference",
  ["disable"] = "Disable",
  ["disabled"] = "Disabled",
  ["discarded"] = "Discarded",
  ["dismiss"] = "Dismiss",
  ["dns"] = "DNS",
  ["domain"] = "Domain",
  ["download"] = "Download",
  ["download_x"] = "%{what} download",
  ["downloaders"] = "Download Volume",
  ["drilldown"] = "Drilldown",
  ["dscp"] = "DSCP",
  ["dscp_dst2src"] = "Server DSCP",
  ["dscp_src2dst"] = "Client DSCP",
  ["duplexstatus"] = "Duplex Status",
  ["duration"] = "Duration",
  ["edit"] = "Edit",
  ["edit_configuration"] = "Edit Configuration",
  ["egress"] = "Egress",
  ["empty"] = "Empty",
  ["enable"] = "Enable",
  ["enable_them"] = "Enable Them",
  ["enabled"] = "Enabled",
  ["end"] = "End",
  ["enterpriseOnly"] = "This feature is only available in the ntopng Enterprise edition",
  ["error"] = "Error",
  ["error_no_search_results"] = "No results found. Please modify your search criteria.",
  ["error_not_granted"] = "Request not granted",
  ["error_rrd_cannot_complete_dump"] = "Cannot complete local hosts timeseries dump. Disk slow or too many local hosts?",
  ["error_rrd_low_resolution"] = "You are asking to fetch data at lower resolution than the one available on RRD, which will lead to invalid data.<br>If you still want data with such granularity, please tune <a href=\"%{prefs}\">Application/Networks Timeseries</a> preferences",
  ["errors"] = "Errors",
  ["expired_csrf"] = "Could not perform the requested action because the page expired. Please reload the page and perform the action again.",
  ["export"] = "Export",
  ["factory_reset"] = "Factory Reset",
  ["filter"] = "Filter",
  ["fingerprint_note"] = "Application name is set only if ntopng is configured to receive a eBPF feed via ZMQ",
  ["flow"] = "Flow",
  ["flow_alerts_search_criteria"] = "Flow Alerts Search Criteria",
  ["flow_dump_not_working"] = "Please check the service logs for more information, it could be there is some issue with the filesystem permissions or available space.",
  ["flow_dump_not_working_title"] = "Flows Dump is not working",
  ["flow_search_criteria"] = "Flow Search Criteria",
  ["flow_search_from_aggregated"] = "(Aggregated)",
  ["flow_search_results"] = "Flow Search Results",
  ["flows"] = "Flows",
  ["flush_periodicity_map_data"] = "Flush Data",
  ["flush_service_map_data"] = "Flush Data",
  ["forbidden"] = "Forbidden",
  ["free"] = "Free",
  ["frequency"] = "Frequency",
  ["from"] = "from",
  ["full"] = "Full",
  ["gateway"] = "Gateway",
  ["geolocation_unavailable"] = "Please follow these <a href='%{url}' target='%{target}'>instructions <i class='%{icon}'></i></a>.",
  ["geolocation_unavailable_title"] = "Running without Geolocation support",
  ["hassh_fingerprint"] = "HASSH Fingerprint",
  ["health"] = "Health",
  ["help"] = "Help",
  ["host"] = "Host %{host}",
  ["host_address"] = "Host Address",
  ["host_explorer"] = "Host Explorer",
  ["hosts"] = "Hosts",
  ["hour"] = "Hour",
  ["howto_multiselect"] = "To select multiple items hold <kbd>Ctrl</kbd> (or <kbd>Cmd</kbd> on Macs).",
  ["http"] = "HTTP",
  ["http_s"] = "HTTP(S)",
  ["https"] = "HTTPS",
  ["icmp"] = "ICMP",
  ["icmpv4"] = "ICMPv4",
  ["icmpv6"] = "ICMPv6",
  ["iface_download"] = "%{iface} download",
  ["iface_upload"] = "%{iface} upload",
  ["import"] = "Import",
  ["import_export_config"] = "Import/Export Configuration",
  ["incomingflows"] = "Active Incoming Flows",
  ["info"] = "Info",
  ["ingress"] = "Ingress",
  ["interface"] = "Interface",
  ["interface_ifname"] = "Interface %{ifname}",
  ["interfaces"] = "Interfaces",
  ["ip_address"] = "IP Address",
  ["ipv4"] = "IPv4",
  ["ipv6"] = "IPv6",
  ["ja3_fingerprint"] = "JA3 Fingerprint",
  ["key"] = "Key",
  ["language"] = "Language",
  ["last_seen"] = "Last Seen",
  ["layer_2"] = "Mac Addresses",
  ["legenda"] = "Legenda",
  ["light"] = "Light",
  ["local_hosts"] = "Local Hosts",
  ["local_traffic"] = "Local Traffic",
  ["lua_c_api"] = "Lua/C API",
  ["mac_address"] = "Mac Address",
  ["max_rate"] = "Max Rate",
  ["memory"] = "Memory",
  ["missing_x_parameter"] = "Missing \"%{param}\" parameter",
  ["model"] = "Model",
  ["month"] = "Month",
  ["mtu"] = "MTU",
  ["multicast"] = "Multicast",
  ["name"] = "Name",
  ["netmask"] = "Netmask",
  ["networks"] = "Networks",
  ["new"] = "New",
  ["next"] = "Next",
  ["no"] = "No",
  ["noTraffic"] = "No traffic has been reported for the specified date/time selection",
  ["no_data_available"] = "No Data Available",
  ["no_flows"] = "No Flows",
  ["no_ports"] = "No Ports",
  ["no_results_found"] = "No results found",
  ["no_talkers_for_the_host"] = "There are no talkers for the current host",
  ["not_admin"] = "Administrator privileges required",
  ["note_flow_search_allowed_networks"] = "Current user is only allowed to browse the following networks: %{nets}.",
  ["note_flow_search_allowed_networks_applications"] = "Hosts not belonging to any of the allowed networks will be hidden from the application talkers.",
  ["note_flow_search_allowed_networks_counter"] = "Counters in the flow search results are total but only flows with client and server in allowed networks will be shown.",
  ["note_flow_search_allowed_networks_ipv6"] = "Non-zero allowed IPv6 networks will cause all IPv6 flows from being shown.",
  ["note_flow_search_allowed_networks_talkers"] = "Hosts not belonging to any of the allowed networks will be hidden from the top talkers.",
  ["notes"] = "NOTES",
  ["num_different_ports"] = "%{num} ports. None doing %{threshold}%%+ of the traffic.",
  ["num_uses"] = "Num Uses",
  ["observations"] = "Observations",
  ["off"] = "Off",
  ["open_documentation"] = "Open in Documentation",
  ["operating_systems"] = "Operating Systems",
  ["optional_field"] = "(This field is optional)",
  ["os"] = "OS",
  ["other"] = "Other",
  ["others"] = "Others",
  ["outgoingflows"] = "Active Outgoing Flows",
  ["overview"] = "Overview",
  ["packets"] = "Packets",
  ["peers"] = "Peers",
  ["percentage"] = "Percentage",
  ["periodicity_map"] = "Periodicity Map",
  ["pkts"] = "Pkts",
  ["plugin_browser"] = "Plugin Viewer: %{plugin_name}",
  ["plugin_contents"] = "Plugin File",
  ["plugins"] = "Plugins",
  ["pollers"] = "Pollers",
  ["port"] = "Port",
  ["ports"] = "Ports",
  ["posted"] = "Posted on",
  ["previous"] = "Previous",
  ["protocol"] = "Protocol",
  ["protocol_categories"] = "Protocol Categories",
  ["protocols"] = "Protocols",
  ["purged_error_message"] = "Very likely it is expired and %{product} has purged it from memory. You can set purge idle timeout settings from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>.",
  ["push_notification"] = "Push Notification",
  ["quotas"] = "Quotas",
  ["ram_available"] = "Available",
  ["ram_total"] = "Total",
  ["ram_used"] = "Used",
  ["reason"] = "Reason",
  ["received"] = "Received",
  ["refresh"] = "Refresh",
  ["remote_hosts"] = "Remote Hosts",
  ["remote_networks"] = "Remote Networks",
  ["remote_probe_clock_drift"] = "Remote probe clock drift",
  ["remove"] = "Remove",
  ["request_failed_message"] = "The request has failed!",
  ["reset"] = "Reset",
  ["restore"] = "Restore",
  ["retry"] = "Retry",
  ["running"] = "Running",
  ["save"] = "Save",
  ["save_configuration"] = "Save Configuration",
  ["save_settings"] = "Save Settings",
  ["score"] = "Score",
  ["score_as_client"] = "Score As Client",
  ["score_as_server"] = "Score As Server",
  ["scripts"] = "Scripts",
  ["search"] = "Search",
  ["search_host"] = "Search",
  ["seen_since"] = "Seen Since",
  ["sent"] = "Sent",
  ["server"] = "Server",
  ["server_to_client"] = "Server to Client",
  ["service_map"] = "Service Map",
  ["settings"] = "Settings",
  ["showing_x_to_y_rows"] = "Showing %{x} to %{y} of %{tot} rows",
  ["similarity"] = "Similarity",
  ["speed"] = "Speed",
  ["ssh"] = "SSH",
  ["start"] = "Start",
  ["status"] = "Status",
  ["stop"] = "Stop",
  ["success"] = "Success",
  ["summary"] = "Summary",
  ["system"] = "System",
  ["system_alerts_status"] = "Alerts",
  ["system_interface"] = "System Interface",
  ["system_interfaces_status"] = "Interfaces",
  ["system_status"] = "System",
  ["talkers"] = "Talkers",
  ["tcp_flags"] = "TCP Flags",
  ["tcp_stats"] = "TCP Statistics",
  ["telemetry"] = "Telemetry",
  ["threshold"] = "Threshold",
  ["throughput"] = "Throughput",
  ["time"] = "Time",
  ["time_in"] = "in",
  ["timeframe"] = "Timeframe",
  ["tls"] = "TLS",
  ["tls_certificate"] = "TLS Certificate",
  ["today"] = "Today",
  ["toggle_dark_theme"] = "Toggle Dark Theme",
  ["too_many_flows"] = "Too many flows",
  ["too_many_hosts"] = "Too many hosts",
  ["tools"] = "Tools",
  ["total"] = "Total",
  ["total_incoming_alerted_flows"] = "Total Alerted Flows As Server",
  ["total_incoming_unreachable_flows"] = "Total Port Unreachable Flows As Server",
  ["total_outgoing_alerted_flows"] = "Total Alerted Flows As Client",
  ["total_outgoing_unreachable_flows"] = "Total Port Unreachable Flows As Client",
  ["total_retransmissions_rcvd"] = "Total Retransmissions Received",
  ["total_retransmissions_sent"] = "Total Retransmissions Sent",
  ["traffic"] = "Traffic",
  ["traffic_policy"] = "Traffic Policy",
  ["undo"] = "Undo",
  ["unknowers"] = "Unknown Traffic Volume",
  ["unknown"] = "Unknown",
  ["unlimited"] = "&infin;",
  ["uploaders"] = "Upload Volume",
  ["used_by"] = "Used by",
  ["values"] = "Values",
  ["version"] = "Your version is %{vers}.",
  ["via"] = "Via",
  ["views"] = "Views",
  ["vlan"] = "VLAN",
  ["vlan_id"] = "VLAN",
  ["volume"] = "Volume",
  ["volume_size"] = "Volume Size",
  ["warning"] = "Warning",
  ["week"] = "Week",
  ["welcome"] = "Welcome",
  ["welcome_to"] = "Welcome to %{product}",
  ["yes"] = "Yes",
  ["about"] = {
    ["about"] = "About",
    ["about_x"] = "About %{product}",
    ["active"] = "active",
    ["alert_defines"] = "Alert and Flow Status Definitions",
    ["alert_queries"] = "Queries",
    ["alerts_dropped"] = "Dropped",
    ["alerts_stored"] = "Stored",
    ["built_on"] = "Built on",
    ["callback_directories"] = "User Scripts Directories",
    ["configure_dhcp_range"] = "Configure DHCP range",
    ["contribute_to_project"] = "Contribute",
    ["copyright"] = "Copyright",
    ["cpu_load"] = "CPU Load",
    ["cpu_states"] = "CPU States",
    ["create_license"] = "We advise you create as well <code>ntopng.license</code> file (according to the instructions you received) to avoid loosing your license in case of redis cleanup",
    ["create_license_l"] = "Please be aware that you need also to create <code>/etc/ntopng.license</code> file as this file is used by the other companion applications.",
    ["data_directory"] = "Data",
    ["datadir_warning"] = "Please <A HREF=\"https://www.ntop.org/support/faq/migrate-the-data-directory-in-ntopng/\">migrate your data</A>",
    ["defs_directories"] = "Definitions Directories",
    ["dhcp_monitoring_title"] = "Monitoring DHCP Hosts",
    ["dhcp_range_missing_warning"] = "The <a href='%{url}'>%{name}</a> preference is ineffective. Please configure the <a href='%{dhcp_url}'>DHCP range</a> appropriately.",
    ["directories"] = "Directories",
    ["dropped_store_queries_alerts"] = "Queries/Stored/Dropped Alerts",
    ["flow_callbacks_directory"] = "Flow",
    ["forced_community_notification"] = "Community edition forced with --community. Remove this option to make license changes effective.",
    ["forced_community_notification_short"] = "Community edition forced with --community",
    ["host_callbacks_directory"] = "Host",
    ["host_identifier_warning"] = "This interface is monitoring DHCP hosts. Please consider changing the <a href='%{url}'>%{name}</a> preference to \"Mac Address\".",
    ["idle"] = "idle",
    ["interface_callbacks_directory"] = "Interface",
    ["iowait"] = "iowait",
    ["last_log"] = "Last Log Trace",
    ["licence"] = "License",
    ["licence_expires_in"] = "License expires in %{time}",
    ["licence_generation"] = "Click on the above URL to generate your professional version license, or <br>purchase a license at <a href=\"%{purchase_url}\">e-shop</a>. If you are no-profit, research or an education<br>institution please read <a href=\"%{universities_url}\">this</a>.",
    ["licence_status"] = "License",
    ["maintenance"] = "Maintenance: Until %{_until} [%{days_left} days left]",
    ["maintenance_expired"] = "%{product} maintenance expired",
    ["maxmind"] = "Includes support for <a href=\"%{maxmind_url}\">MaxMind <i class=\"fas fa-external-link-alt\"></i></a> and <a href='https://db-ip.com'>DB-IP <i class=\"fas fa-external-link-alt\"></i></a> Geolocation databases.",
    ["network_callbacks_directory"] = "Network",
    ["new_major_available"] = "A new %{product} stable version (v.%{version}) is available for <a href=\"%{url}\">download</a>: please upgrade.",
    ["ntop_blog"] = "ntop Blog",
    ["platform"] = "Platform",
    ["ram_memory"] = "RAM",
    ["readme_and_manual"] = "User's Guide",
    ["report_issue"] = "Report an Issue",
    ["runtime_status"] = "Runtime Status",
    ["save_licence"] = "Save Licence",
    ["scripts_directory"] = "Scripts",
    ["server_time"] = "Server Time",
    ["specify_licence"] = "Specify here your ntopng License",
    ["startup_line"] = "Startup Line",
    ["suggest_feature"] = "Suggest a Feature",
    ["system"] = "System",
    ["system_id"] = "System Id",
    ["telegram"] = "Help and News",
    ["telemetry_data_opt_out_msg"] = "Contribute to the project by sending encrypted, <a href=\"%{tel_url}\">anonymous telemetry data</a> to <a href=\"%{ntop_org}\">ntop.org</a>.",
    ["upgrade_to_professional"] = "Upgrade to Pro/Enterprise version",
    ["uptime"] = "Uptime",
    ["user_scripts"] = "User Scripts",
    ["version"] = "Version",
    ["you_have_too_many_flows"] = "Too many flows for %{product} leading to packet drops and high CPU load. Please tune -x/-X and restart %{product}",
    ["you_have_too_many_hosts"] = "Too many hosts for %{product} leading to packet drops and high CPU load. Please tune -x/-X and restart %{product}",
    ["you_need_to_sync_remote_probe_time"] = "You must synchronize the clock of ntopng and remote probe hosts as the <a href=\"%{url}\">clock drift</A> is too large and this will affect collected flow data.",
  },
  ["active_monitoring_stats"] = {
    ["active_monitoring"] = "Active Monitoring",
    ["active_monitoring_description"] = "Monitors the status and the response time of specific hosts",
    ["add_icmp"] = "Add ICMP Monitor",
    ["add_pool"] = "New Active Monitoring Pool",
    ["add_record"] = "Add Active Monitoring Record",
    ["alert_status"] = "Alert Status",
    ["alerted"] = "Alerted",
    ["am_note_http"] = "Measurements http and https retrieve a web page using HTTP and HTTPS",
    ["am_note_icmp"] = "Measurements icmp and icmp6 ping the host using ICMP and ICMP (IPv6)",
    ["app_connect_descr"] = "The \"App Connect\" time is the time took to complete the TLS handshake.",
    ["availability"] = "Availability",
    ["bad_action_param"] = "Bad \"action\" paramater",
    ["config_reset_confirm"] = "Do you really want to discard the current configuration and reset it to default?",
    ["confirm_delete"] = "Do you want really remove this record?",
    ["download_speed"] = "Download Speed",
    ["edit_record"] = "Edit Active Monitoring Record",
    ["empty_action"] = "Something went wrong (empty action). Reload the page and try again.",
    ["host_add_ok"] = "Host %{host} was successfully added!",
    ["host_delete_ok"] = "Host %{host} was successfully deleted!",
    ["host_edit_ok"] = "Host %{host} was successfully edited!",
    ["host_exists"] = "Host \"%{host}\" already exists",
    ["host_not_exists"] = "Host \"%{host}\" not found",
    ["icmp_continuous"] = "Continuous ICMP (IPv4)",
    ["icmp_continuous_v6"] = "Continuous ICMP (IPv6)",
    ["invalid_combination"] = "Invalid measurement/host combination",
    ["invalid_host"] = "Invalid host specified",
    ["jitter"] = "Mean RTT / Jitter",
    ["last_measurement"] = "Last Measurement",
    ["measurement"] = "Measurement",
    ["measurement_time"] = "Measurement Time",
    ["msec"] = "ms",
    ["no_updates_yet"] = "No updates yet",
    ["not_alerted"] = "Not Alerted",
    ["note3"] = "This plugin generates traffic towards the configured hosts in order to performe measurements.",
    ["note_alert"] = "An alert is triggered when the calculated measurement exceeds the threshold set.",
    ["note_availability"] = "The availability percentage shows the percentage of time that the measurement has been within the configured threshold in the last day.",
    ["note_periodicity_change"] = "Changing Periodicity causes old timeseries data to be deleted.",
    ["other_http_descr"] = "The sum of \"Name Lookup\" and \"Other\" is the total time took to complete the HTTP request.",
    ["other_https_descr"] = "The sum of \"App Connect\", \"Name Lookup\" and \"Other\" is the total time took to complete the HTTPS request.",
    ["pool"] = "Pool",
    ["rtt_vs_jitter"] = "Mean RTT / Jitter",
    ["speedtest"] = "Speedtest",
    ["upload_speed"] = "Upload Speed",
    ["validation"] = {
      ["abort_add"] = "Abort add Active Monitoring record?",
      ["abort_edit"] = "Abort edit Active Monitoring record?",
    },
  },
  ["activities_page"] = {
    ["host_activity"] = "Host Activity",
  },
  ["activity_descriptions"] = {
    ["5min"] = "Executes 5 minutes tasks. When using RRD, also writes hosts timeseries data.",
    ["daily"] = "Executes daily tasks.",
    ["dequeue_flows_for_hooks"] = "A critical activity which identifies idle hash table entries and purges them, executes user scripts on flows and exports flows.",
    ["discover"] = "Scans the network for devices. If not scan was requested/planned, this activity does nothing.",
    ["hourly"] = "Executes hourly tasks.",
    ["housekeeping"] = "Checks for alerts to store on the disk or to notify, performs n2disk extraction jobs, reloads category lists if needed.",
    ["minute"] = "Executes minute tasks and writes minute timeseries. When using InfluxDB, also writes hosts timeseries data.",
    ["second"] = "Writes the interface timeseries and other high frequency data.",
    ["stats_update"] = "Computes the throughput of the active traffic elements.",
    ["timeseries"] = "Checks for buffered timeseries points and exports them to InfluxDB.",
  },
  ["alert_messages"] = {
    ["a_new_device_has_connected"] = "New device <a href=\"%{url}\">%{device}</a> has connected to the network.",
    ["anomalous_tcp_flags"] = "%{entity} has %{sent_or_rcvd} too many TCP RST flags vs SYN [Ratio: %{ratio}%%]",
    ["attack_mitigation_via_snmp_failure"] = "Failure to set interface <a href=\"%{port_url}\">%{port}</a> admin status on SNMP device <a href=\"%{url}\">%{device}</a> to %{admin_down}: %{granularity} <b>%{metric}</b> crossed by %{entity} [%{value} %{op} %{threshold}]. Make sure the SNMP device has a (valid) write community configured.",
    ["attack_mitigation_via_snmp_success"] = "Interface <a href=\"%{port_url}\">%{port}</a> admin status on SNMP device <a href=\"%{url}\">%{device}</a> set to %{admin_down}: %{granularity} <b>%{metric}</b> crossed by %{entity} [%{value} %{op} %{threshold}]",
    ["broadcast_domain_info"] = "It is unlikely to see ARP traffic between those IPs as they are seemingly belonging to different broadcast domains. Check for hosts and networks configurations.",
    ["broadcast_domain_too_large"] = "ARP traffic from <a href=\"%{src_mac_url}\">%{src_mac}</a>/<a href=\"%{spa_url}\">%{spa}</a> to <a href=\"%{dst_mac_url}\">%{dst_mac}</a>/<a href=\"%{tpa_url}\">%{tpa}</a> detected.",
    ["device_has_connected"] = "The device <a href=\"%{url}\">%{device}</a> has connected to the network.",
    ["device_has_disconnected"] = "The device <a href=\"%{url}\">%{device}</a> has disconnected from the network.",
    ["flow_flood_attacker"] = "%{entity} is a flow flooder [%{value} &gt; %{threshold} flows sent]",
    ["flow_flood_victim"] = "%{entity} is under flow flood attack [%{value} &gt; %{threshold} flows received]",
    ["host_entity"] = "host %{entity_value}",
    ["host_log"] = "Log from <a href=\"%{url}\">%{host}</a> (%{facility}) %{line}",
    ["host_pool_has_connected"] = "The host pool <a href=\"%{url}\">%{pool}</a> has connected to the network.",
    ["host_pool_has_disconnected"] = "The host pool <a href=\"%{url}\">%{pool}</a> has disconnected from the network.",
    ["host_remote_to_remote"] = "Remote host <a href=\"%{url}\">%{ip}</a> %{mac} has contacted a remote host. Remote-to-remote flows available from the <a href=\"%{flow_alerts_url}\">flow alerts page</a>.",
    ["iface_alerts_dropped"] = "%{num_dropped} alerts dropped on interface <a href=\"%{url}\">%{iface}</a>.",
    ["influxdb_dropped_points"] = "Points dropped. Could not send them to \"%{influxdb}\".",
    ["influxdb_migration_msg"] = "You have a lot of local hosts. Please consider <a href='%{url}'>moving from RRD to InfluxDB</a> for timeseries storage to improve performance.",
    ["influxdb_partial_write"] = "This can be fixed by setting \"max-values-per-tag = 0\" in the InfluxDB server config.",
    ["influxdb_write_error"] = "There was an error while sending timeseries data to \"%{influxdb}\": %{err}",
    ["interface_entity"] = "interface %{entity_value}",
    ["ip_outside_dhcp_range_router_ip"] = "[Router: <a href=\"%{router_url}\">%{router_ip}</a>]",
    ["ip_outsite_dhcp_range"] = "Device <a href=\"%{client_url}\">%{client_mac}</a> got the IP address <a href=\"%{client_ip_url}\">%{client_ip}</a> which is outside the <a href=\"%{dhcp_url}\">configured DHCP range</a>. [Sender: <a href=\"%{sender_url}\">%{sender_mac}</a>]",
    ["lldp_arc_added"] = "New link added between SNMP devices <a href=\"%{url1}\">%{node1}</a> and <a href=\"%{url2}\">%{node2}</a>",
    ["lldp_arc_removed"] = "Removed link between between SNMP devices <a href=\"%{url1}\">%{node1}</a> and <a href=\"%{url2}\">%{node2}</a>",
    ["mac_ip_association_change"] = "IP %{ip} changed association from <a href=\"%{old_mac_url}\">%{old_mac}</a> to <a href=\"%{new_mac_url}\">%{new_mac}</a>",
    ["measurement_too_high_msg"] = "Measurement too high for %{host} %{numeric_ip} [%{am_value} %{unit} > %{threshold} %{unit}].",
    ["measurement_too_low_msg"] = "Measurement too low for %{host} %{numeric_ip} [%{am_value} %{unit} < %{threshold} %{unit}].",
    ["misbehaving_flows_ratio"] = "%{entity} has %{sent_or_rcvd} too many misbehaving flows vs total flows [Ratio: %{ratio}%%]",
    ["network_entity"] = "network %{entity_value}",
    ["nfq_flushed"] = "Interface <a href=\"%{url}\">%{name}</a> packets queue flushed. Queue %{pct}%% full with %{tot} packets and %{dropped} drops.",
    ["no_influxdb"] = "Please <A HREF=\"%{url}\">enable timeseries dump to InfluxDB</A> and then reload this page",
    ["ntopng_anomalous_termination"] = "Started after anomalous termination (<a href=\"%{url}\">bug report</a>)",
    ["ntopng_start"] = "Started",
    ["ntopng_stop"] = "Stopped",
    ["ntopng_update"] = "Started after software update",
    ["open_files_limit_too_small"] = "Ntopng detected that the maximum number of files MySQL can open is potentially too small. This can result in flow data loss due to errors such as [Out of resources when opening file './ntopng/flowsv6#P#p22.MYD' (Errcode: 24 - Too many open files)][23]. Make sure to increase open_files_limit or, if you just want to ignore this warning, disable the check from the preferences.",
    ["periodic_activity_not_executed"] = "Periodic activity \"%{script}\" is queued but has not been executed. No thread available for  execution.  [Pending since %{pending_since}]",
    ["ping_host_unreachable_v3"] = "Host %{host} %{numeric_ip} is unreachable.",
    ["potentially_dangerous_protocol_description"] = "This flow can be harmful for the network because an outdated or vulnerable protocol is in use.",
    ["proto_bytes_quotas"] = "%{proto} bytes",
    ["proto_time_quotas"] = "%{proto} time",
    ["remote_to_remote"] = "Remote %{entity} contacted a remote host",
    ["slow_periodic_activity"] = "Periodic activity \"%{script}\" running for too long [more than %{max_duration}] or executed too late (blocked in queue).",
    ["slow_purge"] = "<a href=\"%{url}\">Hash table idle entries</a> purging on %{iface} is too slow. This could lead to high memory utilization, data accuracy loss and missing alerts. [%{idle}%% &gt %{max_idle}%%]",
    ["speedtest_failed"] = "Speedtest execution failed",
    ["subject_quota_exceeded"] = "Host pool <a href=\"%{url}\">%{pool}</a> exceeded %{subject} quota [%{value} &gt; %{quota}]",
    ["syn_flood_attacker"] = "%{entity} is a SYN flooder [%{value} &gt; %{threshold} SYN sent]",
    ["syn_flood_victim"] = "%{entity} is under SYN flood attack [%{value} &gt; %{threshold} SYN received]",
    ["syn_scan_attacker"] = "%{entity} is a SYN Scan attacker [%{value} &gt; %{threshold} SYN sent]",
    ["syn_scan_victim"] = "%{entity} is under SYN Scan [%{value} &gt; %{threshold} SYN received]",
    ["test_failed"] = "Test Failed",
    ["threshold_crossed"] = "%{granularity} <b>%{metric}</b> crossed by %{entity} [%{value} %{op} %{threshold}]",
    ["too_many_drops"] = "%{iface} has too many dropped packets [&gt %{max_drops}%%]",
    ["too_many_flows"] = "%{iface} has too many flows. Please extend the %{option} command line option",
    ["too_many_hosts"] = "%{iface} has too many hosts. Please extend the %{option} command line option",
    ["x_alerts"] = "%{num} alerts",
  },
  ["alerts_dashboard"] = {
    ["active_flows_anomaly"] = "Active Flows Anomaly",
    ["alert"] = "Alert",
    ["alert_counts"] = "Counts",
    ["alert_duration"] = "Duration",
    ["alert_severity"] = "Severity",
    ["alert_snmp_device_reset_description"] = "SNMP device <a href=\"%{url}\">%{device}</a> has been restarted",
    ["alert_snmp_device_reset_title"] = "SNMP Device Restart",
    ["alert_snmp_interface_mac_changed_description"] = "MAC <a href=\"%{mac_url}\">%{mac}</a> seen on SNMP device <a href=\"%{url}\">%{device}</a> interface <a href=\"%{port_url}\">%{port}</a> previously seen on  SNMP device <a href=\"%{prev_device_url}\">%{prev_device}</a> interface <a href=\"%{prev_port_url}\">%{prev_port}</a>",
    ["alert_snmp_interface_mac_changed_title"] = "SNMP Interface MAC Changed",
    ["alert_type"] = "Type",
    ["alerts"] = "Alerts",
    ["alerts_dashboard"] = "Alerts Dashboard",
    ["alerts_ts"] = "Process Alerts Timeseries",
    ["alerts_ts_description"] = "Generate process alerts timeseries",
    ["all_hosts"] = "All Hosts",
    ["anomalous_tcp_flags"] = "Anomalous TCP Flags",
    ["attack_mitigation_snmp_description"] = "Set the host SNMP access port admin status to down when the client score exceeds the specified threshold",
    ["attack_mitigation_snmp_title"] = "Attack Mitigation via SNMP",
    ["blacklisted_country"] = "Blacklisted Country",
    ["blacklisted_country_descr"] = "Trigger an alert when hosts contact or are contacted by the specified countries",
    ["blacklisted_flow"] = "Blacklisted Flow",
    ["blocked_flow"] = "Flow Risk",
    ["broadcast_domain_too_large"] = "Broadcast domain",
    ["client_and_server_countries_blacklisted"] = "Client country %{cli_country} and server country %{srv_country} are blacklisted",
    ["client_country_blacklisted"] = "Client country %{country} is blacklisted",
    ["connection_issues"] = "TCP Issues",
    ["critical"] = "Critical",
    ["custom_period"] = "Custom Period",
    ["debug"] = "Debug",
    ["device_connection"] = "Device Connection",
    ["device_disconnection"] = "Device Disconnection",
    ["dns_anomaly"] = "DNS Anomaly",
    ["emergency"] = "Emergency",
    ["engaged_for_longest"] = "Past Alerts Engaged for Longest",
    ["error"] = "Error",
    ["experimental_checks"] = "Experimental",
    ["experimental_checks_description"] = "Enable experimental alert checks: TCP flags, anomalous flows ratio",
    ["external_alert"] = "External Alert",
    ["five_mins"] = "Last 5 Minutes",
    ["flow_alert_origins"] = "Flow Alert Origins",
    ["flow_alert_targets"] = "Flow Alert Targets",
    ["flow_logger"] = "Flow Logger",
    ["flow_logger_descr"] = "Logs new flows to console/file",
    ["flow_misbehaviour"] = "Flow Misbehaviour",
    ["flow_risk"] = "Flow Risk",
    ["flow_user_scripts_calls_drops_description"] = "%{num_drops} <a href='%{url}'>flow user scripts</a> calls were not invoked. Some misbehaving flows may go unnoticed.",
    ["flows_flood"] = "Flows Flood",
    ["ghost_network_detected"] = "Ghost Network Detected",
    ["ghost_network_detected_description"] = "Subnet %{network} does not belong to the <a href='%{url}'>%{entity} networks</a>.",
    ["ghost_networks"] = "Ghost Networks",
    ["ghost_networks_description"] = "Trigger an alert for unknown networks detected on the network interface.",
    ["host_log"] = "Host Log",
    ["host_pool_connection"] = "Host Pool Connection",
    ["host_pool_disconnection"] = "Host Pool Disconnection",
    ["host_score_description"] = "Compute the host score and trigger alerts when it exceeds the specified threshold.",
    ["icmp_anomaly"] = "ICMP Anomaly",
    ["iec104_error"] = "IEC104 Error",
    ["inactivity"] = "Inactivity",
    ["influxdb_dropped_points"] = "InfluxDB Dropped Points",
    ["influxdb_error"] = "InfluxDB Error",
    ["influxdb_export_failure"] = "InfluxDB Export Failure",
    ["influxdb_monitor"] = "InfluxDB monitor",
    ["influxdb_monitor_description"] = "Monitor the InfluxDB health",
    ["info"] = "Info",
    ["internal_issues"] = "Internal Issues",
    ["involving_msg"] = "Flow Alerts Involving",
    ["known_proto_on_non_std_port"] = "Known Application on Non-Standard Port",
    ["known_proto_on_non_std_port_full"] = "Known application %{app} detected on non-standard port %{port}",
    ["last_day"] = "Last Day",
    ["last_hour"] = "Last Hour",
    ["last_minute"] = "Last Minute",
    ["lateral_movement"] = "Lateral Movement",
    ["list_download_failed"] = "List Download Failed",
    ["list_download_succeeded"] = "List Download Succeeded",
    ["local_only"] = "Local Hosts Only",
    ["local_origin_remote_target"] = "Local Origin - Remote Target",
    ["login_failed"] = "Login Failed",
    ["mac_ip_association_change"] = "IP/MAC Change",
    ["malicious_signature_detected"] = "Possibly Malicious Signature",
    ["many_replies"] = "%{count} %{what} replies",
    ["many_requests"] = "%{count} %{what} requests",
    ["memory_ts"] = "Memory Timeseries",
    ["memory_ts_description"] = "Generate process memory timeseries",
    ["misbehaving_flows_ratio"] = "Too Many Misbehaving Flows",
    ["misconfigured_app"] = "Misconfigured App",
    ["misconfigured_dhcp_range"] = "Misconfigured DHCP Range",
    ["new_device"] = "New Device",
    ["nfq_flushed"] = "Packets Queue Flushed",
    ["no_alert"] = "No Alert",
    ["no_alerts"] = "No alerts",
    ["none"] = "None",
    ["not_engaged"] = "Not engaged",
    ["notice"] = "Notice",
    ["one_day"] = "Last Day",
    ["one_hour"] = "Last Hour",
    ["one_min"] = "Last Minute",
    ["one_reply"] = "%{count} %{what} reply",
    ["one_request"] = "%{count} %{what} request",
    ["out_of_x_total_packets"] = "out of %{tot} Packets",
    ["periodic_activity_not_executed"] = "Periodic Activity Not Executed",
    ["periodic_activity_not_executed_descr"] = "Trigger an alert when a periodic activity is queued for execution but is not getting executed as all the worker threads are busy.",
    ["ping_issues"] = "Ping",
    ["potentially_dangerous_protocol"] = "Potentially Dangerous Protocol",
    ["process"] = "Process",
    ["quota_exceeded"] = "Quota Exceeded",
    ["remote_only"] = "Remote Hosts Only",
    ["remote_origin_local_target"] = "Remote Origin - Local Target",
    ["remote_to_remote"] = "Remote to Remote",
    ["search_criteria"] = "Dashboard Settings",
    ["server_country_blacklisted"] = "Server country %{country} is blacklisted",
    ["slow_periodic_activity"] = "Slow Periodic Activity",
    ["slow_periodic_activity_descr"] = "Trigger an alert when a periodic activity is taking too long to execute.",
    ["slow_purge"] = "Slow Idle Purging",
    ["snmp_device_is_unresponsive"] = "SNMP device <a href=\"%{url}\">%{device}</a> is unresponsive",
    ["snmp_device_reset_script_description"] = "Trigger an alert when a restart for an SNMP device has been detected",
    ["snmp_interface_mac_changed_script_description"] = "Trigger an alert when a MAC has moved between interfaces or devices",
    ["snmp_interface_mac_changed_script_title"] = "SNMP Interface MAC Changed",
    ["snmp_interfaces_rsi"] = "SNMP Interfaces RSI",
    ["snmp_interfaces_rsi_descr"] = "Detect changes in the interfaces traffic and trigger alerts (experimental)",
    ["snmp_port_changed_duplex_status"] = "Interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> changed its duplex status to %{new_op}",
    ["snmp_port_changed_operational_status"] = "Interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> changed its status to %{new_op}",
    ["snmp_port_duplexstatus_change"] = "Interface Duplex Status Change",
    ["snmp_port_duplexstatus_change_description"] = "Trigger an alert when an interface duplex status changes",
    ["snmp_port_errors"] = "Interface Errors",
    ["snmp_port_errors_description"] = "Trigger an alert when an interface discard/error counters increase",
    ["snmp_port_errors_increased"] = "Discard/error counters increased on interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a>",
    ["snmp_port_load_threshold_exceeded"] = "Interface Load Threshold Exceeded",
    ["snmp_port_load_threshold_exceeded_message"] = "Load threshold exceeded on interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> [threshold: %{threshold}%%][IN load: %{in_load}%%][OUT load: %{out_load}%%]",
    ["snmp_port_status_change"] = "Interface Operational Status Change",
    ["snmp_port_status_change_description"] = "Trigger an alert when the operational state of an interface changes",
    ["starting_on"] = "starting on",
    ["submit"] = "Update Dashboard",
    ["suspicious_activity"] = "Suspicious Activity",
    ["suspicious_device_protocol"] = "Suspicious Device Protocol",
    ["suspicious_file_transfer"] = "Suspicious File Transfer",
    ["suspicious_file_transfer_url"] = "%{type_icon} Detected suspicious file transfer [%{url}]",
    ["tcp_syn_flood"] = "TCP SYN Flood",
    ["tcp_syn_scan"] = "TCP SYN Scan",
    ["threashold_cross"] = "Threshold Cross",
    ["too_low_replies_received"] = "%{entity} has sent %{requests} but received %{replies} [%{granularity} ratio: %{ratio}%%]",
    ["too_low_replies_sent"] = "%{entity} has received %{requests} but sent %{replies} [%{granularity} ratio: %{ratio}%%]",
    ["too_many_drops"] = "Packet Drops",
    ["too_many_flows"] = "Too Many Flows Alert",
    ["too_many_flows_description"] = "Trigger an alert when the number of active flows is too high",
    ["too_many_hosts"] = "Too Many Hosts Alert",
    ["too_many_hosts_description"] = "Trigger an alert when the number of active hosts is too high",
    ["total_alerts"] = "Total Alerts",
    ["trailing_msg"] = "Time Window",
    ["trailing_msg_compact"] = "Window",
    ["unresponsive_device"] = "Unresponsive Device",
    ["user_activity"] = "User Activity",
    ["user_scripts_calls_drops"] = "User Scripts Calls Dropped",
    ["warning"] = "Warning",
    ["web_mining"] = "Web Mining",
    ["x_lost"] = "%{lost} Lost",
    ["x_ooo"] = "%{ooo} Out-of-Order",
    ["x_retx"] = "%{retx} Retransmissions",
  },
  ["alerts_thresholds_config"] = {
    ["active_local_hosts"] = "Local Hosts Alert",
    ["active_local_hosts_threshold_descr"] = "Trigger an alert when the number of Active Local Hosts exceeds the threshold",
    ["activity_time"] = "Activity Time Alert",
    ["alert_active_description"] = "Trigger an alert when the Activity time delta exceeds the threshold",
    ["alert_bytes_description"] = "Trigger an alert when the Layer 2 bytes delta (sent + received) exceeds the threshold",
    ["alert_bytes_title"] = "Traffic Alert",
    ["alert_dns_description"] = "Trigger an alert when layer 2 Bytes delta (sent + received) for DNS traffic exceeds the threshold",
    ["alert_flows_description"] = "Trigger an alert when the Flows delta (as client + as server) exceeds the threshold",
    ["alert_flows_title"] = "Flows Alert",
    ["alert_idle_description"] = "Trigger an alert when the Idle time (time since last packet seen) exceeds the threshold",
    ["alert_network_egress_description"] = "Trigger an alert when the Egress Bytes delta exceeds the threshold",
    ["alert_network_ingress_description"] = "Trigger an alert when the Ingress Bytes delta exceeds the threshold",
    ["alert_network_inner_description"] = "Trigger an alert when the Inner Bytes delta exceeds the threshold",
    ["alert_p2p_description"] = "Trigger an alert when the Layer 2 bytes delta (sent + received) for P2P traffic exceeds the threshold",
    ["alert_packets_description"] = "Trigger an alert when the Packets delta (sent + received) exceeds the threshold",
    ["alert_packets_title"] = "Packets Alert",
    ["alert_slow_purge_threshold"] = "Idle Hash Table Entries Alert",
    ["alert_slow_purge_threshold_descr"] = "Trigger an alert when the percentage of idle entries in the hash table over the total number of entries exceeds the threshold",
    ["alert_throughput_description"] = "Trigger an alert when the Average throughput (sent + received) exceeds the threshold",
    ["common_thresholds_local_sources"] = "%{source} Common Configuration",
    ["daily"] = "Daily",
    ["dns_traffic"] = "DNS Traffic Alert",
    ["egress_traffic"] = "Egress Traffic Alert",
    ["every_5_minutes"] = "Every 5 Minutes",
    ["every_minute"] = "Every Minute",
    ["hourly"] = "Hourly",
    ["idle_time"] = "Idle Time Alert",
    ["ingress_traffic"] = "Ingress Traffic Alert",
    ["inner_traffic"] = "Inner Traffic Alert",
    ["note_add_custom_scripts"] = "%{product} looks for custom scripts in these <a href=\"%{url}\"> <i class=\"fas fa-folder\"></i> directories</a>.",
    ["note_checks_on_active_hosts"] = "Checks are only performed for active hosts.",
    ["note_consecutive_checks"] = "Consecutive checks are not necessarily performed on consecutive periods. For example, if an host goes idle, its thresholds will not be checked until it becomes active again.",
    ["note_control_threshold_checks_periods"] = "Callbacks listed in these tabs are executed periodically.",
    ["note_create_custom_scripts"] = "Documentation to create custom scripts for the execution of callbacks is available at the following <a href=\"%{url}\">link</a> <i class=\"fas fa-external-link-alt\"></i>.",
    ["note_thresholds_expressed_as_delta"] = "Some callbacks compute a delta. A delta is the difference of the same quantity between two consecutive executions.",
    ["notes"] = "NOTES",
    ["p2p_traffic"] = "P2P Traffic Alert",
    ["threshold_type"] = "Callback",
    ["thresholds_single_source"] = "%{source} %{alt_name} Configuration",
    ["throughput"] = "Throughput Alert",
  },
  ["arp_page"] = {
    ["arp_type"] = "ARP Type",
  },
  ["as_details"] = {
    ["as"] = "Autonomous System",
    ["as_parameter_missing_message"] = "Autonomous System parameter is missing (internal error?)",
    ["as_timeseries_enable_message"] = "AS timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
    ["no_available_data_for_as"] = "No available data for AS %{asn}.",
  },
  ["as_stats"] = {
    ["autonomous_systems"] = "Autonomous Systems",
  },
  ["blog_feed"] = {
    ["blog_updates"] = "Blog Updates",
    ["blog_updates_info"] = "Receive notification when a new blog is posted at: <a href='https://www.ntop.org/blog' target='_blank'>https://ntop.org/blog</a>",
    ["news_from_blog"] = "News from the <b>ntop Blog</b>",
    ["nothing_to_show"] = "Nothing to show here. Try tomorrow!",
  },
  ["capabilities"] = {
    ["active_monitoring"] = "Active Monitoring",
    ["developer"] = "Developer",
    ["flowdevices"] = "Flow Devices",
    ["notifications"] = "Notifications",
    ["pools"] = "Pools",
    ["preferences"] = "Preferences",
    ["snmp"] = "SNMP",
    ["user_scripts"] = "User Scripts",
  },
  ["categories_page"] = {
    ["search_application"] = "Search Application",
    ["target"] = "Target",
  },
  ["category_lists"] = {
    ["category_lists"] = "Category Lists",
    ["connection_time_out"] = "The server connection timeout out after %{duration} seconds",
    ["disable_some_list"] = "Please disable some lists in order to fix this.",
    ["download_succeeded"] = "List '%{name}' downloaded successfully",
    ["edit_list"] = "Edit Category List",
    ["enabled"] = "Enabled",
    ["error_occurred"] = "An error occurred while downloading <a href=\"%{url}\">list</a> '%{name}': %{err}",
    ["http_code"] = "[HTTP Code: %{err_code}]",
    ["last_update"] = "Last Update",
    ["list_will_be_updated"] = "The list '%{name}' will be updated within 30 seconds.",
    ["loading_stats"] = "Last reload (at %{when}): loaded %{num_hosts} domains, %{num_ips} IP addresses, %{num_ja3} JA3 signatures in %{duration} .",
    ["ready_for_update"] = "Ready for Update",
    ["server_returned_error"] = "The server returned an error",
    ["too_many_hosts_loaded"] = "Domain names limit reached (%{limit} domains)",
    ["too_many_ips_loaded"] = "IP addresses limit reached (%{limit} addresses)",
    ["too_many_ja3_loaded"] = "JA3 signatures limit reached (%{limit} signatures)",
    ["update_frequency"] = "Update Frequency",
    ["update_now"] = "Update Now",
  },
  ["conf_backup"] = {
    ["conf_backup"] = "Backup Configuration",
    ["conf_restore"] = "Restore Configuration",
  },
  ["config_scripts"] = {
    ["applied_to"] = "Applied to",
    ["config_apply"] = "Config Apply",
    ["config_clone"] = "Cloning Configuration",
    ["config_clone_message"] = "Type a name for the clonation",
    ["config_delete"] = "Deleting Config",
    ["config_delete_message"] = "Do you want really remove this configuration?",
    ["config_entities"] = "Configuration Entities",
    ["config_export"] = "Export Configuration",
    ["config_import"] = "Import Configuration",
    ["config_name"] = "Configuration Name",
    ["config_rename"] = "Configuration Rename",
    ["config_rename_message"] = "Type the new name for the configuration",
    ["config_reset"] = "Reset Configuration",
    ["config_reset_confirm"] = "Do you really want to delete ALL the configurations and reset the default configuration to its initial value?",
    ["config_search"] = "Search Config:",
    ["config_x"] = "Config %{product}",
    ["empty_target_message"] = "Select one or more targets!",
    ["empty_value_message"] = "The input box cannot be empty!",
    ["invalid_characters"] = "The name contains not valid characters!",
    ["invalid_file"] = "Not a valid configuration file",
    ["max_input_length"] = "The name can have only 16 characters maximum!",
    ["no_file"] = "No configuration file selected",
    ["no_pools_applied"] = "No pool",
    ["select_interface"] = "Select Interfaces",
    ["select_network"] = "Select Networks",
    ["type_targets"] = "Type targets",
    ["type_targets_example"] = "Type targets separated by a comma. i.e: 192.168.1.20,192.168.0.0/16",
    ["actions"] = {
      ["apply_to"] = "Apply to",
      ["clone"] = "Clone",
      ["delete"] = "Delete",
      ["edit"] = "Edit",
      ["rename"] = "Rename",
    },
    ["granularities"] = {
      ["flow"] = "Flows",
      ["host"] = "Hosts",
      ["interface"] = "Interfaces",
      ["network"] = "Networks",
      ["snmp_device"] = "SNMP Devices",
      ["syslog"] = "Syslog",
      ["system"] = "System",
    },
  },
  ["configsets"] = {
    ["bad_target"] = "Bad configuration target: \"%{target}\"",
    ["duplicate_target"] = "Target \"%{target}\" is assigned to both configuration \"%{confname1}\" and \"%{confname2}\"",
    ["error_exists"] = "The configuration name \"%{name}\" is already in use",
    ["unknown_id"] = "No configuration found with id %{confid}",
    ["unknown_user_script"] = "Unknown user script \"%{user_script}\"",
  },
  ["contacts_page"] = {
    ["client_address"] = "Client Address",
    ["client_contacts_initiator"] = "Client Contacts (Initiator)",
    ["contacts"] = "Contacts",
    ["no_client_contacts_so_far"] = "No client contacts so far",
    ["no_contacts_message"] = "No contacts for this host",
    ["no_server_contacts_so_far"] = "No server contacts so far",
    ["server_address"] = "Server Address",
    ["server_contacts_receiver"] = "Server Contacts (Receiver)",
  },
  ["containers_stats"] = {
    ["all_containers"] = "All Containers",
    ["all_pods"] = "All Pods",
    ["avg_rtt"] = "Avg RTT",
    ["avg_rtt_as_client"] = "Avg RTT as Client",
    ["avg_rtt_as_server"] = "Avg RTT as Server",
    ["avg_rtt_variance"] = "Avg RTT Variance",
    ["avg_rtt_variance_as_client"] = "Avg RTT Variance as Client",
    ["avg_rtt_variance_as_server"] = "Avg RTT Variance as Server",
    ["client_container"] = "Client Container",
    ["client_pod"] = "Client Pod",
    ["client_rtt"] = "Client RTT",
    ["container"] = "Container",
    ["containers"] = "Containers",
    ["containers_list"] = "Containers List",
    ["containers_of_pod"] = "Containers of Pod '%{pod}'",
    ["pod"] = "Pod",
    ["pods"] = "Pods",
    ["pods_list"] = "Pods List",
    ["server_container"] = "Server Container",
    ["server_pod"] = "Server Pod",
    ["server_rtt"] = "Server RTT",
  },
  ["country_details"] = {
    ["country"] = "Country",
    ["country_parameter_missing_message"] = "Country parameter is missing (internal error?)",
    ["no_available_stats_for_country"] = "No available stats for country %{country}",
  },
  ["custom_categories"] = {
    ["add"] = "Add",
    ["add_application"] = "Add Application",
    ["add_custom_app"] = "Add Custom Application",
    ["add_to_categories"] = "Add Host Rule",
    ["app_delete_error"] = "Cannot delete the \"%{app}\" application. Please restart %{product} to ensure that there are no pending changes.",
    ["app_deleted"] = "Application \"%{app}\" has been deleted. Please restart %{product} to apply the changes.",
    ["application_exists"] = "Application \"%{app}\" already exists!",
    ["application_name"] = "Application Name",
    ["application_not_exists"] = "Application \"%{app}\" does not exist!",
    ["apps_and_categories"] = "Applications and Categories",
    ["custom_host_category"] = "Custom Host Rule",
    ["custom_hosts"] = "Custom Rules",
    ["delete_app"] = "Delete Application",
    ["delete_app_confirm"] = "<b>WARNING</b>: Deleting an application is a destructive operation which can affect the historical data of the other custom applications defined. Do you really want to delete %{app}?",
    ["domain_names_substrings"] = "Domain names are interpreted as substring to be matched.<br>E.g. \"%{s1}\" will match \"%{s2}\" and \"%{s3}\"",
    ["each_host_separate_line"] = "Each rule must be put on a separate line",
    ["edit_custom_rules"] = "Edit Custom Rules",
    ["edit_hosts"] = "Edit Rules",
    ["example_port_range"] = "Port range examples: \"%{example1}\", \"%{example2}\"",
    ["host_domain_or_cidr"] = "Rules can be either domain names or IPv4 addresses/CIDR network addresses",
    ["host_domain_or_port"] = "Rules can be either domain names, IPv4 addresses or TCP/UDP port ranges",
    ["invalid_rule"] = "Invalid rule has been ignored: %{rule}",
    ["new_app_added"] = "Application \"%{app}\" has been configured. Please restart %{product} to start using it.",
    ["non_empty_list_required"] = "At least one rule must be specified.",
    ["option_needed"] = "Custom applications configuration is currently disabled as the <i>%{option}</i> parameter is missing from the configuration. Check out <a href=\"%{url}\">the documentation</a> for more details.",
    ["protos_reboot_necessary"] = "Application rules have been written. Please restart %{product} to apply them.",
    ["protos_unexpected_error"] = "Unexpected error while updating the applications rules. Check out the %{product} log for more details.",
    ["select_url_category"] = "Please select where the domain will be added:",
    ["similar_host_found"] = "a rule similar to \"%{host}\" is already contained into the %{category} category",
    ["the_following_is_a_list_of_hosts"] = "The following is a list of custom rules for the %{category} category",
    ["the_following_is_a_list_of_hosts_app"] = "The following is a list of custom rules for the %{application} application",
    ["the_following_url_will_be_added"] = "The following domain will be added:",
  },
  ["dashboard"] = {
    ["actual_traffic"] = "Actual Traffic",
    ["community_dashboard"] = "Community Dashboard",
    ["gateways_users"] = "Gateways and Users",
    ["lastday_app_traffic"] = "Top Application Traffic Last Day View",
    ["lastday_traffic"] = "Network Interfaces: Last Day View",
    ["realtime_app_traffic"] = "Realtime Top Application Traffic",
    ["realtime_traffic"] = "Network Interfaces: Realtime Traffic",
    ["slow_dashboard_message"] = "Too much latency in the %{product} response. Consider setting an higher <a href='%{url}'>Realtime Stats Refresh Rate</a>.",
    ["top_local_talkers"] = "Top Local Talkers",
    ["top_remote_destinations"] = "Top Remote Destinations",
    ["traffic_dashboard"] = "Traffic Dashboard",
  },
  ["datasources"] = {
    ["families"] = "Families",
    ["key"] = "Key",
    ["metrics"] = "Metrics",
    ["new_source"] = "New Source",
    ["origin"] = "Origin",
    ["retention"] = "Retention",
    ["schema"] = "Schema",
    ["scope"] = "Scope",
    ["select_family"] = "Select a family",
    ["select_metrics"] = "Select a metric",
    ["select_schema"] = "Select a schema",
    ["select_schema_first"] = "Select a schema first",
    ["select_series"] = "Select a series",
    ["series"] = "Series",
    ["source_exists"] = "There is already a source like this!",
  },
  ["db_explorer"] = {
    ["abort"] = "Abort",
    ["all"] = "all",
    ["app_between_talkers_pairs"] = "applications between pairs of talkers",
    ["app_flows_between"] = "%{app} application flows between %{peer1} and %{peer2}",
    ["app_talkers"] = "%{app} talkers",
    ["app_talkers_with"] = "%{app} talkers with %{peer}",
    ["application_flows"] = "Application flows",
    ["applications_between"] = "Applications between %{peer1} and %{peer2}",
    ["average_throughput"] = "Avg Thpt",
    ["client_server_breakdown"] = "Client vs Server Traffic Breakdown",
    ["client_server_host"] = "Client/Server Host",
    ["dns_query"] = "DNS Query",
    ["download_flows"] = "Download flows",
    ["download_flows_limit"] = "Maximum 1000 records.",
    ["empty_query_response"] = "Empty query response (database down or query killed/timed out?)",
    ["extract_pcap"] = "Extract pcap",
    ["filter_bpf"] = "Filter (BPF)",
    ["first_last_seen"] = "First / Last Seen",
    ["flow_peers"] = "Flow Peers",
    ["get_proto_talkers"] = "Get Talkers using this application",
    ["historical_data_explorer"] = "Historical Data Explorer",
    ["host_name"] = "Host Name",
    ["host_talkers"] = "%{host} talkers",
    ["hosts_talking_proto_with"] = "Hosts talking %{proto} with {host}",
    ["http_host"] = "HTTP Host",
    ["http_method"] = "HTTP Method",
    ["interface_name"] = "Instance Name",
    ["last_hour_flows"] = "Flows seen in the last hour",
    ["ms_client"] = "%{client} ms (client)",
    ["ms_server"] = "%{server} ms (server)",
    ["network_latency_breakdown"] = "Network Latency Breakdown",
    ["observation_period"] = "Observation Period",
    ["ok_request_sent"] = "OK, request sent",
    ["packet_rate"] = "Average Packet Rate",
    ["pcap_requests_and_status"] = "Pcap Requests and Statuses",
    ["pcaps"] = "Pcaps",
    ["protocol_flows_between"] = "%{proto} application flows between %{peer1} and %{peer2}",
    ["protocol_id"] = "Application id",
    ["query_in_progress"] = "Database query in progress, waiting to receive results...",
    ["request_failed"] = "Request failed",
    ["response_code"] = "Response Code",
    ["search_flows"] = "Search Flows",
    ["selected_saved"] = "Select saved",
    ["server_name"] = "Server Name",
    ["summary"] = "Summary",
    ["talkers_with_this_host"] = "Talkers with this host",
    ["task_id"] = "Task Id",
    ["this_flow_has_been_reset"] = "This flow has been reset and probably the server application is down",
    ["this_flow_is_active"] = "This flow is active",
    ["this_flow_is_completed"] = "This flow is completed and will soon expire",
    ["top_flows_ipv4"] = "Top IPv4 Flows [%{date_from} - %{date_to}]",
    ["top_flows_ipv6"] = "Top IPv6 Flows [%{date_from} - %{date_to}]",
    ["top_proto_ipv4_flows"] = "Top %{proto} IPv4 Flows",
    ["top_proto_ipv6_flows"] = "Top %{proto} IPv6 Flows",
    ["total_flows"] = "Total Flows",
    ["total_packets"] = "Total Packets",
    ["total_traffic"] = "Bytes Total",
    ["traffic_rate"] = "Average Traffic Rate",
    ["traffic_received"] = "Bytes Received",
    ["traffic_sent"] = "Bytes Sent",
    ["traffic_sent_to_cli"] = "Bytes Sent to Clients",
    ["traffic_sent_to_srv"] = "Bytes Sent to Servers",
    ["traffic_volume"] = "Traffic Volume",
    ["unable_to_find_flow"] = "Unable to find the specified flow",
    ["unsave"] = "Remove",
    ["vlan_id"] = "VLAN Id",
  },
  ["delete_data"] = {
    ["delete_active_interface_confirmation"] = "Are you sure you want to delete all the persistent data associated to %{ifname}?<br><br><b><b>NOTE</b>:</b> Data deletion will be performed upon %{product} restart. Restart %{product} to make the deletion effective.",
    ["delete_active_interface_data_failed"] = "Unable to delete active interface data.",
    ["delete_active_interface_data_ok"] = "Data for %{ifname} has successfully been marked for deletion. Restart %{product} to make the deletion effective.",
    ["delete_confirmation"] = "Are you sure you want to delete all persistent data for %{host}?",
    ["delete_failed"] = "Unable to delete data for %{host}.",
    ["delete_inactive_interfaces_confirmation"] = "The following interfaces are inactive:%{interfaces_list}Are you sure you want to delete all their persistent data?",
    ["delete_inactive_interfaces_data_failed"] = "Unable to delete inactive interfaces data.",
    ["delete_inactive_interfaces_data_ok"] = "Data for inactive interfaces successfully deleted.",
    ["delete_ok"] = "Data for %{host} has been successfully deleted.",
    ["msg_err_invalid_host"] = "The format of the specified host is not recognized.",
    ["msg_err_no_fs_data"] = "No persistent data found for the specified host.",
    ["msg_err_unable_to_delete_dir"] = "Unable to delete the data directory.",
    ["msg_err_unable_to_delete_ts_data"] = "Unable to delete timeseries data.",
    ["msg_err_unknown"] = "An unknown error occurred.",
    ["node_nindex_flows"] = "WARNING: nIndex is enabled for flows dump, historical flows information will not be deleted.",
    ["note_persistent_data"] = "All the persistent data is deleted. Data include traffic counters, timeseries, flows, alerts, and Redis caches.",
  },
  ["details"] = {
    ["additional_mac_address"] = "Additional MAC Address",
    ["address_resolution_protocol"] = "Address Resolution Protocol",
    ["ago"] = "ago",
    ["alerts"] = "Alerts",
    ["arp_replies"] = "ARP Replies",
    ["arp_requests"] = "ARP Requests",
    ["as_client"] = "As Client",
    ["as_server"] = "As Server",
    ["details"] = "Details",
    ["device_id"] = "Device ID",
    ["device_port"] = "Device Port",
    ["device_type"] = "Device Type",
    ["first_last_seen"] = "First / Last Seen",
    ["first_observed_on"] = "First Observed On",
    ["flow_snmp_localization"] = "Flow SNMP Localization",
    ["flows_dropped_by_bridge"] = "Flows Blocked due to Traffic Policies",
    ["flows_non_packet_iface"] = "Recently Active Flows / Total / Total Alerted",
    ["flows_packet_iface"] = "Flows: Active / Total / Alerted / Port Unreach",
    ["fragments"] = "Fragments",
    ["further_host_names_information"] = "Additional Host Names",
    ["goodput"] = "Goodput",
    ["host_pool"] = "Host Pool",
    ["host_purged"] = "This host is no longer active and it should have been purged from memory",
    ["host_snmp_localization"] = "SNMP Localization",
    ["input_device_port"] = "Device Input Port",
    ["keep_alive"] = "KeepAlive",
    ["label_blacklisted_host"] = "Blacklisted",
    ["label_dhcp_server"] = "DHCP Server",
    ["label_dns_server"] = "DNS Server",
    ["label_local_host"] = "Local",
    ["label_ntp_server"] = "NTP Server",
    ["label_private_ip"] = "Private",
    ["label_remote"] = "Remote",
    ["label_smtp_server"] = "SMTP Server",
    ["label_system_ip"] = "System IP",
    ["lost"] = "Lost",
    ["misbehaving_flows_reasons"] = "Mibehaving Flows Reasons",
    ["note"] = "NOTE",
    ["note_hosts_located_snmp_device"] = "Hosts are located in SNMP devices using the <A HREF=%{url}>Bridge MIB</A>.",
    ["out_of_order"] = "Out of Order",
    ["output_device_port"] = "Device Output Port",
    ["peers"] = "Peers: Active",
    ["rcvd"] = "Rcvd",
    ["retransmissions"] = "Retransmissions",
    ["router_access_point_mac_address"] = "(Router/AccessPoint) MAC Address",
    ["sent_vs_received_traffic_breakdown"] = "Sent vs Received Traffic Breakdown",
    ["show_hosts"] = "Show Hosts",
    ["source"] = "Source",
    ["source_id"] = "Source Id",
    ["tcp_packets_sent_analysis"] = "TCP Packets Sent Analysis",
    ["total_traffic"] = "Total Traffic",
    ["traffic_sent_received"] = "Traffic Sent / Received",
    ["vlan_id"] = "VLAN ID",
    ["whois_lookup"] = "Whois Lookup",
  },
  ["developer_section"] = {
    ["datasources_list"] = "Datasources",
    ["widgets_list"] = "Widgets",
  },
  ["device_protocols"] = {
    ["alert"] = "Trigger Alert",
    ["device_protocol_policy"] = "Device Application Policy",
    ["device_protocols"] = "Device Applications",
    ["devtype_as_proto_client"] = "%{devtype} as <i>%{proto}</i> client",
    ["devtype_as_proto_server"] = "%{devtype} as <i>%{proto}</i> server",
    ["filter_device_protocols"] = "%{filter} Device Applications",
    ["ok"] = "Acceptable",
  },
  ["device_types"] = {
    ["iot"] = "IoT",
    ["laptop"] = "Laptop",
    ["multimedia"] = "Multimedia",
    ["nas"] = "NAS",
    ["networking"] = "Router/Switch",
    ["phone"] = "Phone",
    ["printer"] = "Printer",
    ["tablet"] = "Tablet",
    ["tv"] = "TV",
    ["unknown"] = "Unknown",
    ["video"] = "Video",
    ["wifi"] = "Wireless Network",
    ["workstation"] = "Computer",
  },
  ["dhcp"] = {
    ["delete_range"] = "Delete DHCP Range",
    ["delete_range_confirm"] = "Do you really want to delete the configured DHCP range %{range} ?",
    ["dhcp"] = "DHCP",
    ["dhcp_alert_note"] = "An alert will be generated when an IP address is assigned outside the configured DHCP ranges",
    ["dhcp_configuration_note"] = "This page lists the configured DHCP ranges for this interface. These should match the actual DHCP server configuration in use",
    ["invalid_ip_address"] = "Invalid IP address",
    ["no_dhcp_ranges"] = "No DHCP ranges configured.",
  },
  ["discover"] = {
    ["device"] = "Device",
    ["discovered_devices"] = "Discovered %{manuf} %{sys} %{dev} Devices",
    ["err_unable_to_arp_discovery"] = "Unable to start ARP network discovery",
    ["error_no_discovery_cached"] = "No discovery data has been cached yet.",
    ["error_unable_to_decode_json"] = "Unable to decode cache JSON discovery data.",
    ["ghost_icon_descr"] = "The %{ghost_icon} icon highlights ghost hosts (i.e. they do not belong to the interface IP address network)",
    ["network_discovery"] = "Network Discovery",
    ["network_discovery_datetime"] = "Last Network Discovery",
    ["network_discovery_not_enabled"] = "Network discovery in progress",
    ["too_many_devices_descr"] = "Too many devices discovered. Results have been trimmed at %{max_devices} devices",
  },
  ["dns_page"] = {
    ["dns_breakdown"] = "DNS Breakdown",
    ["dns_query_sent_distribution"] = "DNS Query Sent Distribution",
    ["dns_query_sent_vs_rcvd_distribution"] = "DNS Query Sent vs Rcvd Distribution",
    ["error_replies"] = "Error Replies",
    ["note"] = "NOTE",
    ["note_dns_ratio"] = "Ideally the request vs reply DNS ratio should be 1 (one reply per request). When much lower than that then there are issues worth to be investigated as it means that the number of replies received is much lower than expected and this can indicate that we are using unresponsive DNS resolvers or that they are misconfigured (e.g. they have been move to another IP).",
    ["positive_replies"] = "Positive Replies",
    ["queries"] = "Queries",
    ["ratio"] = "Ratio",
    ["rcvd"] = "Rcvd",
    ["replies"] = "Replies",
    ["reply_breakdown"] = "Reply Breakdown",
    ["request_vs_reply"] = "Request vs Reply Ratio",
  },
  ["dscp_page"] = {
    ["statistics"] = "Precedence Classes",
    ["statistics_received"] = "Received",
    ["statistics_sent"] = "Sent",
  },
  ["email_alert_endpoint"] = {
    ["carbon_copy"] = "CC",
    ["email_recipient"] = "Email Recipient",
    ["email_sender"] = "Email Sender",
    ["smtp_password"] = "SMTP Password",
    ["smtp_server"] = "SMTP Server",
    ["smtp_username"] = "SMTP Username",
    ["validation"] = {
      ["empty_SMTP_server"] = "Please insert a IPv4/IPv6/Host address.",
      ["empty_email"] = "Please insert an email address.",
      ["invalid_SMTP_server"] = "Please type a valid IPv4/IPv6/Host address.",
      ["invalid_email"] = "Please type a valid email address (i.e. name@domain.com).",
    },
  },
  ["endpoint_notifications"] = {
    ["actions"] = "Actions",
    ["add_new_endpoint"] = "Add New Endpoint",
    ["add_new_recipient"] = "Add New Recipient",
    ["associated_to"] = "Bound To",
    ["associated_to_endpoints"] = "Bound to Endpoint",
    ["associated_to_recipients"] = "Bound to Recipient",
    ["create_endpoint_first"] = "Please create a notification endpoint first!",
    ["edit_endpoint"] = "Edit Endpoint",
    ["edit_endpoints"] = "Edit Endpoints",
    ["edit_recipient"] = "Edit Recipient",
    ["empty_endpoints"] = "No Endpoint defined.",
    ["empty_template"] = "This recipient has no paramaters to fill.",
    ["endpoint"] = "Endpoint",
    ["endpoint_config_already_existing"] = "There is already a config with that name!",
    ["endpoint_list"] = "Endpoints",
    ["endpoint_recipient_already_existing"] = "There is already a recipient with that name",
    ["enpoint_recipients_list"] = "Recipients",
    ["get_users_recipient_failed"] = "Sorry, but the recipient users loading has failed. Please try later.",
    ["name"] = "Name",
    ["notifications"] = "Notifications",
    ["num_drops"] = "Drops",
    ["num_uses"] = "Times Used",
    ["recipient_category"] = "Category Filter",
    ["recipient_list"] = "Recipients",
    ["recipient_name"] = "Name",
    ["recipient_select"] = "Endpoint",
    ["recipient_severity"] = "Minimum Severity",
    ["recipient_type"] = "Recipient List",
    ["recipient_users"] = "Pools using Recipient %{recipient}",
    ["remove_endpoint"] = "Delete Endpoint",
    ["remove_endpoint_message"] = "Do you really want to delete '%{endpoint}' notification endpoint? <span class='count'>%{recipients_count} recipient(s) will be <b>DELETED</b> as well.</span>",
    ["remove_recipient"] = "Delete Recipient",
    ["remove_recipient_message"] = "Do you really want to delete '%{recipient}' recipient?",
    ["select_type"] = "Select an Endpoint Type",
    ["server_error"] = "Something went wrong. Try later.",
    ["test_recipient"] = "Test Recipient",
    ["testing_recipient"] = "Testing the recipient",
    ["time_since_last_use"] = "Time Since Last Use",
    ["timed_out"] = "The recipient test has timed out!",
    ["type"] = "Type",
    ["used_by_recipients"] = "Used by Recipients",
    ["working_recipient"] = "Test successful!",
    ["zero_users_recipient"] = "There are no pools using this recipient. Add pools from the %{link} page.",
    ["factory_reset"] = {
      ["body"] = "Are you sure to reset the <b>%{reset_element}</b>?<br>Resetting to Factory Default <b>you will permentaly lose all the %{reset_element} configured</b> yet.",
      ["title"] = "Reset Configuration: %{reset_element}",
    },
    ["hints"] = {
      ["bind_pools"] = {
        ["body"] = "Last step! Bind recipients to pools to start delivering alerts to them.",
        ["title"] = "Bind Recipient",
      },
      ["create_endpoint"] = {
        ["action"] = "Create",
        ["body"] = "Create an <a target='_blank' href='%{link}'>endpoint</a> to start delivering alerts to the outside.",
        ["title"] = "Create an Endpoint",
      },
      ["create_recipients"] = {
        ["body"] = "Create new <a target='_blank' href='%{link}'>recipients</a> to start delivering alerts to them.",
        ["title"] = "Create Recipients",
      },
    },
    ["recipients"] = {
      ["cc"] = "CC",
      ["email_recipient"] = "Email Recipient",
    },
    ["severities"] = {
      ["alert"] = "Alert",
      ["critical"] = "Critical",
      ["debug"] = "Debug",
      ["emergency"] = "Emergency",
      ["error"] = "Error",
      ["info"] = "Info",
      ["notice"] = "Notice",
      ["warning"] = "Warning",
    },
    ["validation"] = {
      ["abort_add_endpoint"] = "Abort add of new endpoint?",
      ["abort_add_recipient"] = "Abort add of new endpoint recipient?",
      ["abort_edit_endpoint"] = "Abort edit of the endpoint?",
      ["abort_edit_recipient"] = "Abort edit of the endpoint recipient?",
    },
  },
  ["entity_thresholds"] = {
    ["flow_attacker_description"] = "Trigger an alert when the new client Flows/sec exceeds the threshold",
    ["flow_attacker_title"] = "Flow Flood Attacker Alert",
    ["flow_victim_description"] = "Trigger an alert when the new server Flows/sec exceeds the threshold",
    ["flow_victim_title"] = "Flow Flood Victim Alert",
    ["request_reply_ratio_description"] = "Trigger an alert when the number of replies vs requests ratio (on different applications) exceeds the threshold",
    ["request_reply_ratio_title"] = "Replies / Requests Ratio",
    ["syn_attacker_description"] = "Trigger an alert when the number of sent SYNs/sec exceeds the threshold",
    ["syn_attacker_title"] = "SYN Flood Attacker Alert",
    ["syn_scan_attacker_description"] = "Trigger an alert when the number of sent SYNs/min (with no response) exceeds the threshold",
    ["syn_scan_attacker_title"] = "SYN Scan Attacker Alert",
    ["syn_scan_victim_description"] = "Trigger an alert when the number of received SYNs/min (with no response) exceeds the threshold",
    ["syn_scan_victim_title"] = "SYN Scan Victim Alert",
    ["syn_victim_description"] = "Trigger an alert when the number of received SYNs/sec exceeds the threshold",
    ["syn_victim_title"] = "SYN Flood Victim Alert",
  },
  ["error_page"] = {
    ["go_back"] = "Go Back",
    ["greeting"] = "An error has been detected",
    ["presence"] = "You're not supposed to be here!",
  },
  ["event_exporters"] = {
    ["event_device_x"] = "Event Exporter %{device}",
    ["event_exporter_ip"] = "Event Exporter IP",
    ["event_exporters"] = "Event Exporters",
  },
  ["export_data"] = {
    ["export_json_data"] = "Export JSON Data",
    ["note_active_hosts"] = "Only active hosts are returned.",
    ["note_maximum_number"] = "The maximum number of downloadable hosts is 32,768.",
  },
  ["external_stats"] = {
    ["capture_drops"] = "Dropped Packets",
    ["capture_packets"] = "Captured Packets",
    ["signatures_failed"] = "Signatures Failed",
    ["signatures_loaded"] = "Signatures Loaded",
    ["title"] = "External Statistics",
  },
  ["field_units"] = {
    ["bytes"] = "Bytes",
    ["flow_sec"] = "Flows/sec",
    ["flows"] = "Flows",
    ["hosts"] = "Hosts",
    ["mbits"] = "Mbps",
    ["packets"] = "Packets",
    ["percentage"] = "%%",
    ["seconds"] = "Sec",
    ["syn_min"] = "SYNs/min",
    ["syn_sec"] = "SYNs/sec",
  },
  ["flow_alerts_explorer"] = {
    ["by_target_port"] = "By Target Port",
    ["flow_alert_origin"] = "Alert Origin",
    ["flow_alert_target"] = "Alert Target",
    ["label"] = "Flow Alerts Explorer",
    ["origins"] = "Origins",
    ["search"] = "Search Flow Alerts",
    ["summary_cli2srv"] = "Total Origin to Target Traffic",
    ["summary_n_origins"] = "Total Origins",
    ["summary_n_targets"] = "Total Targets",
    ["summary_srv2cli"] = "Total Target to Origin Traffic",
    ["summary_total"] = "Total Flow Alerts",
    ["targets"] = "Targets",
    ["type_alerts_by_type"] = "Flow Alerts By Type",
    ["type_explorer"] = "Type Explorer",
    ["visual_explorer"] = "Visual Explorer",
  },
  ["flow_callbacks"] = {
    ["application_detected"] = "Application Detected",
    ["callback"] = "User Script",
    ["callback_config"] = "Configuration",
    ["callback_elapsed_time"] = "Execution Time",
    ["callback_elapsed_time_avg"] = "Flows/sec",
    ["callback_enabled"] = "Enabled",
    ["callback_function"] = "Hook",
    ["callback_function_duration"] = "Duration",
    ["callback_function_duration_fmt_long"] = "%{num_calls} Calls in %{time} [%{speed} Calls/sec]",
    ["callback_function_duration_fmt_short"] = "%{time}",
    ["callback_function_num_flows"] = "Flows",
    ["callback_function_throughput"] = "Processing Speed",
    ["callback_latest_run"] = "Latest Run",
    ["dns_esclusion_list"] = "Exclusion List",
    ["dns_esclusion_list_example"] = "A list of subdomains to exclude from the invalid dns alert, separated by commas",
    ["idle"] = "Idle",
    ["last_calls_per_sec"] = "Last Calls/sec",
    ["last_duration"] = "Last Duration",
    ["last_num_calls"] = "Last Num Calls",
    ["no_callbacks_available"] = "No callbacks available.",
    ["no_callbacks_available_disabled_alerts"] = "No callbacks available. Callbacks require alerts to be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>",
    ["no_callbacks_defined"] = "No callbacks found",
    ["note_add_custom_scripts"] = "%{product} looks for custom scripts in these <a href=\"%{url}\"> <i class=\"fas fa-folder\"></i> directories</a>.",
    ["note_create_custom_scripts"] = "Documentation to create custom scripts for the execution of callbacks is available at the following <a href=\"%{url}\">link</a> <i class=\"fas fa-external-link-alt\"></i>.",
    ["note_flow_application_detected"] = "\"Application Detected\" callbacks are executed right after the detection of the application. This occurs within the first 12 packets of a flow for packet interfaces or immediately after a flow has been received for ZMQ interfaces.",
    ["note_flow_idle"] = "\"Idle\" callbacks are executed when a flow has terminated its activity and it has gone idle.",
    ["note_flow_lifecycle"] = "Callbacks are executed at certain moments in the lifecycle of a flow.",
    ["note_flow_periodic_update"] = "\"Periodic Update\" callbacks are executed periodically after a flow has been active for more than five minutes.",
    ["note_flow_staus_changed"] = "\"Status Changed\" callbacks are executed every time there is a status change in the flow. For example when connection issues such as retransmissions are seen.",
    ["note_scripts_list"] = "A full list of available %{product} scripts can be found in the <a href=\"%{url}\">scripts</a> page.",
    ["notes"] = "NOTES",
    ["periodic_update"] = "Periodic Update",
    ["status_changed"] = "Status Changed",
  },
  ["flow_callbacks_config"] = {
    ["blacklisted"] = "Blacklisted Flow",
    ["blacklisted_description"] = "Trigger an alert when a blacklisted host or domain is detected",
    ["data_exfiltration"] = "Data Exfiltration",
    ["data_exfiltration_description"] = "Trigger alerts when a possible data exfiltration activity is detected",
    ["dev_proto_not_allowed"] = "Device Application Not Allowed",
    ["dev_proto_not_allowed_description"] = "Trigger an alert when an unusual application is detected for a device. Rules can be configured <a href='%{url}'>here</a>",
    ["dev_proto_not_allowed_nedge_description"] = "Trigger an alert when a not allowed application is detected for a <i>Not Assigned</i> device. Policies can be configured <a href='%{url}'>here</a>",
    ["dns_data_exfiltration"] = "DNS Data Exfiltration",
    ["dns_data_exfiltration_description"] = "Trigger alerts when a DNS data exfiltration activity is detected",
    ["elephant_flows"] = "Elephant Flows",
    ["elephant_flows_description"] = "Trigger an alert when a flow exchanges more than the configured bytes volume. The Remote to Local direction indicates traffic received by a local host from a remote host.",
    ["ext_alert"] = "External Alert",
    ["ext_alert_description"] = "Receives flow alerts from external endpoints (e.g. Suricata)",
    ["flow_risk"] = "Flow Risk",
    ["flow_risk_description"] = "Trigger alerts on the basis of detected nDPI flow risks",
    ["flow_risk_list"] = "nDPI flow risks:",
    ["invalid_dns_query"] = "Invalid DNS Query",
    ["invalid_dns_query_description"] = "Trigger an alert when a possibly malicious DNS query is detected",
    ["long_lived"] = "Long Lived",
    ["long_lived_description"] = "Trigger an alert when a flow lasts more than the configured duration",
    ["malicious_signature"] = "Malicious Signature",
    ["malicious_signature_description"] = "Trigger an alert when a possibly malicious signature is detected",
    ["nedge_blocked"] = "Blocked Flows",
    ["nedge_blocked_description"] = "Trigger an alert when a flow is blocked due to the configured policies",
    ["no_input"] = "No configuration necessary",
    ["not_purged"] = "Not Purged",
    ["not_purged_description"] = "Detects bugs in the flow purge logic",
    ["old_tls_version"] = "Old TLS Version",
    ["old_tls_version_description"] = "Trigger an alert when an old (and possibly unsecure) TLS version is detected",
    ["potentially_dangerous_protocol"] = "Potentially dangerous protocol",
    ["potentially_dangerous_protocol_description"] = "Trigger an alert when a potentially dangerous protocol is detected",
    ["remote_to_remote"] = "Remote to Remote Flow",
    ["remote_to_remote_description"] = "Triggers an alert when a flow has remote hosts as client and server",
    ["score"] = "Flow Score",
    ["suspicious_countries"] = "Suspicious Countries",
    ["suspicious_countries_description"] = "Trigger an alert when at least one among the client and server is from a suspicious country",
    ["tcp_issues_generic"] = "TCP Retransmission Issues",
    ["tcp_issues_generic_description"] = "Detect TCP retransmissions, out of order and packet lost issues",
    ["tcp_issues_packets"] = "TCP Issues",
    ["tcp_issues_packets_description"] = "Detect TCP slow data exchange, low goodput and connection refused",
    ["tcp_probing"] = "TCP Probing",
    ["tcp_probing_description"] = "Trigger an alert when a possible probing attempt is detected",
    ["tls_cert_expired"] = "TLS Certificate Expired",
    ["tls_cert_expired_description"] = "Trigger an alert when an expired TLS certificate is detected",
    ["tls_cert_mismatch"] = "TLS Certificate Issues",
    ["tls_cert_mismatch_description"] = "Trigger an alert when a mismatched TLS certificate is detected",
    ["tls_cert_selfsigned"] = "TLS Certificate Self-signed",
    ["tls_cert_selfsigned_description"] = "Trigger an alert when an self-signed TLS certificate is detected",
    ["tls_unsafe_ciphers"] = "TLS Unsafe Ciphers",
    ["tls_unsafe_ciphers_description"] = "Trigger an alert when unsafe TLS ciphers are detected",
    ["udp_unidirectional"] = "Unidirectional UDP Flow",
    ["udp_unidirectional_description"] = "Trigger an alert when a unidirectional UDP flow is detected",
    ["web_mining"] = "Web Mining",
    ["web_mining_description"] = "Toggle alerts generated when traffic from/to hosts known to perform cryptocurrencies mining is detected",
  },
  ["flow_details"] = {
    ["acceptable_label"] = "Acceptable",
    ["actual_peak_throughput"] = "Actual / Peak Throughput",
    ["additional_flow_elements"] = "Additional Flow Elements",
    ["additional_flow_status"] = "Additional Flow Status",
    ["alerted_flows"] = "Alerted Flows",
    ["alerted_flows_severity"] = "Alerted Flows Severity",
    ["application_latency"] = "Application Latency",
    ["as_prev_next"] = "AS Prev / Next",
    ["as_src_dst"] = "AS Src / Dst",
    ["average_cpu_load"] = "Average CPU Load",
    ["bittorrent_hash"] = "BitTorrent hash",
    ["blacklisted_flow"] = "Client, server or domain is blacklisted",
    ["blacklisted_flow_detailed"] = "Blacklisted %{who}",
    ["c_ip_addresses"] = "C IP Addresses",
    ["call_canceled"] = "Call Canceled",
    ["call_completed"] = "Call Completed",
    ["call_error"] = "Call Error",
    ["call_id"] = "Call-ID",
    ["call_initiator"] = "Call Initiator",
    ["call_quality_indicators"] = "Call Quality Indicators",
    ["call_started"] = "Call Started",
    ["call_state"] = "Call State",
    ["called_party"] = "Called Party",
    ["cancel_bye_failure_reason_cause"] = "Cancel/Bye/Failure Reason Cause",
    ["certificates_not_match"] = "Certificates don't match",
    ["client_container_information"] = "Client Container Information",
    ["client_process_information"] = "Client Process Information",
    ["client_requested"] = "Client Requested",
    ["client_tls_supported_versions"] = "Client Supported TLS Protocols",
    ["computed_as_tcp_window_size_rtt"] = "Computed as TCP Window Size / RTT",
    ["container_id"] = "Container ID",
    ["could_not_add_host_to_category"] = "Could not add host \"%{host}\" to \"%{category}\".",
    ["data_exfiltration"] = "Data Exfiltration",
    ["desirable_label"] = "Desirable",
    ["dns_data_exfiltration"] = "DNS Data Exfiltration",
    ["dns_invalid_query"] = "Invalid DNS query",
    ["dns_query"] = "DNS Query",
    ["docker"] = "Docker",
    ["docker_name"] = "Name",
    ["drop_flow_traffic_btn"] = "Drop Flow Traffic",
    ["dropped_packets"] = "Dropped Packets",
    ["dtmf_tones_sent"] = "DTMF tones sent during the call",
    ["dump_flow_traffic"] = "Dump Flow Traffic",
    ["elephant_exceeded"] = "Exceeding %{vol}",
    ["elephant_flow"] = "Elephant Flow",
    ["elephant_flow_descr"] = "Elephant flows are those that transfer more than a certain configured amount of data. Administrators can configure elephant flows from the preferences.",
    ["elephant_flow_l2r"] = "Elephant Flow (Local to Remote Traffic)",
    ["elephant_flow_r2l"] = "Elephant Flow (Remote to Local Traffic)",
    ["entropy"] = "Entropy",
    ["error_and_higher"] = "Error and Higher",
    ["existing_rules_note"] = "Existing rules can be found at the <a href=\"%{url}\">%{name}</a> page.",
    ["external_alert"] = "Detected %{scope} alert: %{msg} [%{maker}]",
    ["first_last_flow_sequence"] = "First / Last Flow Sequence",
    ["flow_active_msg"] = "Flow is active.",
    ["flow_alerted"] = "Flow Alerted",
    ["flow_anomalies"] = "Detected Flow Risks",
    ["flow_blocked_by_bridge"] = "Flow blocked due to configured policies",
    ["flow_cannot_be_found_message"] = "This flow cannot be found.",
    ["flow_completed_msg"] = "Flow is closed.",
    ["flow_connecting_msg"] = "Flow is connecting.",
    ["flow_details"] = "Flow Details",
    ["flow_emitted"] = "Flow emitted when network interface was alerted",
    ["flow_marker"] = "Flow Marker",
    ["flow_peer_roles_inaccurate_msg"] = "Flow is active, however, the beginning of the flow has not been seen and peer roles (client/server) might be inaccurate",
    ["flow_peers_client_server"] = "Flow Peers [ Client / Server ]",
    ["flow_quota"] = "Flow Quota",
    ["flow_reset_by_resetter_msg"] = "Flow reset by the %{resetter}.",
    ["flow_reset_msg"] = "This flow has been reset",
    ["flow_score"] = "Flow Score Breakdown",
    ["flow_shapers"] = "Flow Shapers",
    ["flow_status"] = "Flow Status",
    ["flow_traffic_is_dropped"] = "Flow Traffic is Dropped",
    ["forward"] = "Forward",
    ["gsm_cell_identifier"] = "GSM Cell Identifier",
    ["gsm_cell_lac"] = "GSM Cell LAC (Location Area Code)",
    ["host_successfully_added_to_category"] = "Host \"%{host}\" successfully added to the <a href=\"%{url}\">%{category}</a> category. Only new flows will be affected by the rule.",
    ["http_method"] = "HTTP Method",
    ["icmp_info"] = "ICMP Info",
    ["ids_alert"] = "Detected %{scope} alert: %{msg} [%{maker}]",
    ["iec104_mask"] = "<A HREF='https://en.wikipedia.org/wiki/IEC_60870-5'>IEC 60870-5-104</A> <i class='fas fa-external-link-alt'></i> <A HREF=https://infosys.beckhoff.com/english.php?content=../content/1033/tcplclibiec870_5_104/html/tcplclibiec870_5_104_objref_overview.htm&id>TypeIDs</A> <i class='fas fa-external-link-alt'></i>",
    ["imsi"] = "IMSI (International mobile Subscriber Identity)",
    ["io_wait_time_percentage"] = "I/O Wait Time Percentage",
    ["ip_packet_analysis"] = "IP Packet Analysis",
    ["jitter"] = "Jitter",
    ["k8s"] = "Kubernetes",
    ["k8s_name"] = "Name",
    ["k8s_ns"] = "Namespace",
    ["k8s_pod"] = "Pod",
    ["known_proto_on_non_std_port"] = "Found known application on a non-standard port",
    ["longlived_exceeded"] = "Exceeding %{amount}",
    ["longlived_flow"] = "Long-Lived Flow",
    ["longlived_flow_descr"] = "Long-Lived flows are those that last more than a certain configured amount of time. Administrators can configure elephant flows from the preferences.",
    ["looks_like_idle_flow_message"] = "This looks like an <font color=red>idle flow</font> with periodic transmissions just to keep it alive.",
    ["lost_packets"] = "Lost Packets",
    ["low_goodput"] = "Low Goodput",
    ["malicious_ja3_signature"] = "Possibly Malicious %{cli_or_srv} Signature [JA3: <a href=\"%{url}\">%{signature}</a> %{icon}]",
    ["max_estimated_tcp_throughput"] = "Max (Estimated) TCP Throughput",
    ["max_packet_interarrival_time"] = "Max Packet Interarrival Time",
    ["mean_rtt"] = "Mean RTT",
    ["memory_actual_peak"] = "Memory Actual / Peak",
    ["mibehaving_flows"] = "Misbehaving Flows",
    ["normal"] = "Normal",
    ["not_purged"] = "This flow is no longer active and it should have been purged from memory.",
    ["not_recommended_label"] = "Not Recommended",
    ["notice_and_lower"] = "Notice and Lower",
    ["nsapi"] = "NSAPI",
    ["ongoing_call"] = "Ongoing Call",
    ["packet_inter_arrival_time"] = "Packet Inter-Arrival Time <br>[ Min / Avg / Max ]",
    ["payload_type"] = "Payload Type",
    ["potentially_dangerous_protocol"] = "Potentially Dangerous Protocol",
    ["process_information_report_warning"] = "Process information report is limited unless you use ntopng with <A HREF='%{url}'>nProbe</A> and the sprobe plugin",
    ["process_pid_name"] = "Process PID/Name",
    ["profile_name"] = "Profile Name",
    ["pseudo_mos"] = "(Pseudo) MOS",
    ["r_factor"] = "R-Factor",
    ["reach_connection_label"] = "Reach Connection",
    ["remote_to_remote"] = "Remote client and remote server",
    ["response_code"] = "Response Code",
    ["reverse"] = "Reverse",
    ["round_trip_time"] = "Min / Max RTT",
    ["rtp_codecs"] = "RTP Codecs",
    ["rtp_flow"] = "RTP Flow",
    ["rtp_protocol_information"] = "RTP Protocol Information",
    ["rtp_stream_peers"] = "RTP Stream Peers",
    ["rtp_transit_in_out"] = "RTP Transit IN / OUT",
    ["rtt_breakdown"] = "RTT Time Breakdown",
    ["rtt_distance"] = "Client/Server Estimated Distance",
    ["rtt_jitter"] = "RTT Jitter",
    ["rule_type"] = "Rule Type",
    ["sac_service_area_code"] = "SAC (Service Area Code)",
    ["score_category_network"] = "Network",
    ["score_category_security"] = "Security",
    ["server_container_information"] = "Server Container Information",
    ["server_name"] = "Server Name",
    ["server_process_information"] = "Server Process Information",
    ["sip_call_id"] = "SIP Call-ID",
    ["sip_protocol_information"] = "SIP Protocol Information",
    ["slow_application_header"] = "Slow Application Header",
    ["slow_data_exchange"] = "Slow Data Exchange",
    ["slow_tcp_connection"] = "Slow TCP Connection",
    ["son_of_father_process"] = "son of <a href ='%{url}'>%{proc_father_name} [pid: %{proc_father_pid}]</a>",
    ["ssh_signature"] = "SSH Signature",
    ["suspicious_client_device_protocol"] = "Client application \"%{proto}\" is not allowed by the configured <a href=\"%{url}\">%{devtype} application policy</a>",
    ["suspicious_device_protocol"] = "Suspicious Device Protocol",
    ["suspicious_server_device_protocol"] = "Server application \"%{proto}\" is not allowed by the configured <a href=\"%{url}\">%{devtype} application policy</a>",
    ["suspicious_tcp_probing"] = "Suspicious TCP Probing",
    ["suspicious_tcp_syn_probing"] = "Suspicious TCP SYN probing",
    ["sync_source_id"] = "Sync Source ID",
    ["tcp_connection_issues"] = "TCP Issues",
    ["tcp_connection_refused"] = "TCP connection refused",
    ["tcp_packet_analysis"] = "TCP Packet Analysis",
    ["tcp_severe_connection_issues"] = "Severe TCP Issues",
    ["throughput_trend"] = "Throughput Trend",
    ["tls_certificate"] = "TLS Certificate",
    ["tls_certificate_expired"] = "TLS Certificate Expired",
    ["tls_certificate_invalid"] = "TLS Certificate Invalid",
    ["tls_certificate_mismatch"] = "TLS Certificate Mismatch",
    ["tls_certificate_selfsigned"] = "TLS Certificate Self-signed",
    ["tls_certificate_validity"] = "TLS Certificate Validity",
    ["tls_old_protocol_version"] = "Obsolete TLS Protocol Version",
    ["tls_server_names"] = "Server Names",
    ["tls_unsafe_ciphers"] = "Unsafe TLS Ciphers",
    ["tos"] = "<A target='_blank' HREF='https://en.wikipedia.org/wiki/Differentiated_services'>DSCP</A> <i class='fas fa-external-link-alt'></i> / <A target='_blank' HREF='https://en.wikipedia.org/wiki/Explicit_Congestion_Notification'>ECN</A> <i class='fas fa-external-link-alt'></i> [ Client / Server ]",
    ["udp_unidirectional"] = "Unidirectional UDP Traffic",
    ["unknown_status"] = "Unknown status (%{status})",
    ["url"] = "URL",
    ["user_name"] = "User Name",
    ["vm_page_faults"] = "VM Page Faults",
    ["warning"] = "Warning",
    ["web_mining_detected"] = "The website is known for mining cryptocurrencies on client devices",
  },
  ["flow_devices"] = {
    ["active_sflow"] = "Active sFlow Devices",
    ["all_device_ports"] = "All %{device} Ports",
    ["all_flow_devices"] = "All Flow Devices",
    ["all_sflow_devices"] = "All sFlow Devices",
    ["duplex"] = "Duplex",
    ["enable_flow_ratio"] = "Enable Flow/SNMP Ratio",
    ["exporter_ip"] = "Flow Exporter IP",
    ["exporters"] = "Exporters",
    ["flow_device_x"] = "Flow Device %{device}",
    ["flow_exporter_devices"] = "Flow Exporter Devices",
    ["flow_ratio_snmp_instructions"] = "To enable the Flow/SNMP ratio, this flow device must support SNMP and must be <a href='%{href}'>added</a> to the SNMP devices.",
    ["flow_ratio_timeseries_instructions"] = "To enable the Flow/SNMP ratio, <b>SNMP and Flow Device timeseries</b> must be enabled.",
    ["full_duplex"] = "Full-Duplex",
    ["half_duplex"] = "Half-Duplex",
    ["in_errors"] = "In Errors",
    ["note_condition_1"] = "Device %{device} must support SNMP and must be configured in the <a href=\"%{url}\">SNMP</a> devices page",
    ["note_condition_2"] = "SNMP and flow devices timeseries must be enabled from the from the <A HREF=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</A>",
    ["note_snmp_device"] = "SNMP-related information is only shown when an SNMP device with the same IP of the Flow Exporter is found among the <a href=\"%{url}\">SNMP devices</a>.",
    ["note_zmq_fields1"] = "Flow devices are determined using ZMQ fields %%EXPORTER_IPV4_ADDRESS and %%NPROBE_IPV4_ADDRESS. When both fields are available, the former takes precedence over the latter",
    ["note_zmq_fields2"] = "Flow devices interfaces are determined using ZMQ fields %%INPUT_SNMP and %%OUTPUT_SNMP",
    ["note_zmq_fields3"] = "sFlow devices are determined using sFlow field deviceIP received via ZMQ (topic 'counter')",
    ["note_zmq_fields4"] = "sFlow devices interfaces are determined using field ifIndex received via ZMQ (topic 'counter')",
    ["out_errors"] = "Out Errors",
    ["promisc"] = "Promisc",
    ["ratio_not_ready"] = "Computing flow ratio...",
    ["remember_counter_ratio"] = "The Counters/SNMP Ratio can be enabled following these steps:",
    ["remember_ratio"] = "The Flow/SNMP Ratio can be enabled following these steps:",
    ["sflow_device_x"] = "sFlow Device %{device}",
    ["sflow_snmp_ratio"] = "Counters/SNMP Ratio",
    ["sflow_snmp_ratio_descr"] = "The Counters/SNMP Ratio is calculated by dividing the total interface traffic obtained using sFlow counter samples, by the total traffic of the same interface read via SNMP over the latest 30 minutes",
    ["snmp_description"] = "SNMP Description",
    ["snmp_devmodel"] = "SNMP Device Model",
    ["snmp_devname"] = "SNMP Device Name",
    ["snmp_ifindex"] = "SNMP Index",
    ["snmp_ifname"] = "SNMP Interface",
    ["snmp_location"] = "SNMP Location",
    ["snmp_no_device_found"] = "No matching SNMP device found",
    ["snmp_polling"] = "Flow/SNMP ratio needs at least 30 minutes of SNMP and flow data",
    ["snmp_ratio"] = "Flow/SNMP Ratio",
    ["snmp_ratio_descr"] = "The Flow/SNMP Ratio is calculated by dividing the total interface traffic obtained using flows, by the total traffic of the same interface read via SNMP. As in flow-based analysis non-IP and layer 2 headers are not accounted, <br>typical ratio values are between 0.8 and 0.9 (i.e. 0.9 means that 90%% of the received traffic as observed via SNMP has been reported in flows).<br>Ratio is computed using the traffic over the latest 5 minutes, as periodic SNMP walks are performed at 5-minute intervals. Ratio is only computed when the following conditions are met",
    ["this_page_contains_couters"] = "This page contains interface counters as they have been collected via sFlow. If SNMP is configured, you can also see the <A HREF=\"%{url}\">SNMP view</A> of this device",
    ["timeseries_descr"] = "Flow devices timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
  },
  ["flow_fields_description"] = {
    ["appl_latency_ms"] = "Application latency (msec), a.k.a. server response time",
    ["application_id"] = "Collected Application Id (Cisco or IXIA)",
    ["application_name"] = "Palo Alto App-Id",
    ["biflow_direction"] = "1=initiator, 2=reverseInitiator",
    ["bittorrent_hash"] = "BITTORRENT hash",
    ["client_nw_latency_ms"] = "Network RTT/2 client <-> nprobe (msec)",
    ["community_id"] = "Community ID",
    ["cumulative_icmp_type"] = "Cumulative OR of ICMP type packets",
    ["dhcp_client_ip"] = "DHCP assigned client IPv4 address",
    ["dhcp_client_mac"] = "MAC of the DHCP client",
    ["dhcp_client_name"] = "DHCP client name",
    ["dhcp_message_type"] = "DHCP message type",
    ["dhcp_remote_id"] = "DHCP agent remote Id",
    ["dhcp_subscriber_id"] = "DHCP subscriber Id",
    ["diameter_clr_cancel_type"] = "DIAMETER Cancellation Type",
    ["diameter_clr_flags"] = "DIAMETER CLR Flags",
    ["diameter_exp_res_result_code"] = "DIAMETER Response Experimental Result Code",
    ["diameter_exp_res_vendor_id"] = "DIAMETER Response Experimental Result Vendor Id",
    ["diameter_hop_by_hop_id"] = "DIAMETER Hop by Hop Identifier",
    ["diameter_req_msg_type"] = "DIAMETER Request Msg Type",
    ["diameter_req_origin_host"] = "DIAMETER Origin Host Request",
    ["diameter_req_user_name"] = "DIAMETER Request User Name",
    ["diameter_rsp_msg_type"] = "DIAMETER Response Msg Type",
    ["diameter_rsp_origin_host"] = "DIAMETER Origin Host Response",
    ["diameter_rsp_result_code"] = "DIAMETER Response Result Code",
    ["direction"] = "Flow direction [0=src->dst, 1=dst->src]",
    ["dns_num_answers"] = "DNS # of returned answers",
    ["dns_query"] = "DNS query",
    ["dns_query_id"] = "DNS query transaction Id",
    ["dns_query_type"] = "DNS query type (e.g. 1=A, 2=NS..)",
    ["dns_response"] = "DNS response(s)",
    ["dns_ret_code"] = "DNS return code (e.g. 0=no error)",
    ["dns_ttl_answer"] = "TTL of the first A record (if any)",
    ["dns_tx_id"] = "DNS Transaction ID",
    ["dot1q_dst_vlan"] = "Destination VLAN (outer VLAN in QinQ)",
    ["dot1q_src_vlan"] = "Source VLAN (outer VLAN in QinQ)",
    ["downstream_session_id"] = "Downstream session identifier (e.g. L2TP) or 0 if unknown",
    ["downstream_tunnel_id"] = "Downstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
    ["dst_as"] = "Destination BGP AS",
    ["dst_as_map"] = "Organization name for DST_AS",
    ["dst_as_path_1"] = "Dest AS path position 1",
    ["dst_as_path_10"] = "Dest AS path position 10",
    ["dst_as_path_2"] = "Dest AS path position 2",
    ["dst_as_path_3"] = "Dest AS path position 3",
    ["dst_as_path_4"] = "Dest AS path position 4",
    ["dst_as_path_5"] = "Dest AS path position 5",
    ["dst_as_path_6"] = "Dest AS path position 6",
    ["dst_as_path_7"] = "Dest AS path position 7",
    ["dst_as_path_8"] = "Dest AS path position 8",
    ["dst_as_path_9"] = "Dest AS path position 9",
    ["dst_father_proc_name"] = "Dst father process name",
    ["dst_father_proc_pid"] = "Dst father process PID",
    ["dst_fragments"] = "Num fragmented packets dst->src",
    ["dst_ip_city"] = "City where the dst IP is located",
    ["dst_ip_country"] = "Country where the dst IP is located",
    ["dst_ip_lat"] = "Latitude where the dst IP is located",
    ["dst_ip_long"] = "Longitude where the dst IP is located",
    ["dst_proc_actual_memory"] = "Dst process actual memory (bytes)",
    ["dst_proc_average_cpu_load"] = "Dst process avg load (%% * 100)",
    ["dst_proc_name"] = "Dst process name",
    ["dst_proc_num_page_faults"] = "Dst process num pagefaults",
    ["dst_proc_pctg_iowait"] = "Src process iowait time %% (%% * 100)",
    ["dst_proc_peak_memory"] = "Dst process peak memory (bytes)",
    ["dst_proc_pid"] = "Dst process PID",
    ["dst_proc_uid"] = "Dst process UID",
    ["dst_proc_user_name"] = "Dst process user name",
    ["dst_to_src_avg_throughput"] = "Dst to src average thpt (bps)",
    ["dst_to_src_max_throughput"] = "Dst to src max thpt (bps)",
    ["dst_to_src_min_throughput"] = "Dst to src min thpt (bps)",
    ["dst_tos"] = "TOS/DSCP (dst->src)",
    ["dst_vlan"] = "Destination VLAN (inner VLAN in QinQ)",
    ["duration_in"] = "Client to Server stream duration (msec)",
    ["duration_out"] = "Client to Server stream duration (msec)",
    ["engine_id"] = "Id of the flow switching engine",
    ["engine_type"] = "Flow switching engine",
    ["exporter_ipv4_address"] = "Flow exporter IPv4 Address",
    ["exporter_ipv6_address"] = "Flow exporter IPv6 Address",
    ["file_gaps"] = "File Gaps",
    ["file_id"] = "File ID",
    ["file_name"] = "File Name",
    ["file_size"] = "File Size",
    ["file_state"] = "File State",
    ["file_stored"] = "File Stored",
    ["firewall_event"] = "Firewall Event 0=ignore, 1=flow created, 2=flow deleted, 3=flow denied, 4=flow alert, 5=flow update",
    ["first_switched"] = "SysUptime (msec) of the first flow pkt",
    ["flow_active_timeout"] = "Activity timeout of flow cache entries",
    ["flow_duration_microseconds"] = "Flow duration (usec)",
    ["flow_duration_milliseconds"] = "Flow duration (msec)",
    ["flow_end_microseconds"] = "uSec (epoch) of the first flow packet",
    ["flow_end_milliseconds"] = "Msec (epoch) of the last flow packet",
    ["flow_end_reason"] = "Flow End Reason",
    ["flow_end_sec"] = "Seconds (epoch) of the last flow packet",
    ["flow_id"] = "Serial Flow Identifier",
    ["flow_inactive_timeout"] = "Inactivity timeout of flow cache entries",
    ["flow_proto_port"] = "L7 port that identifies the flow application or 0 if unknown",
    ["flow_server_name"] = "Flow server name (if known)",
    ["flow_start_microseconds"] = "uSec (epoch) of the first flow packet",
    ["flow_start_milliseconds"] = "Msec (epoch) of the first flow packet",
    ["flow_start_sec"] = "Seconds (epoch) of the first flow packet",
    ["flow_user_name"] = "Flow username of the tunnel (if known)",
    ["frame_length"] = "Original L2 frame length",
    ["ftp_command"] = "FTP client command",
    ["ftp_command_ret_code"] = "FTP client command return code",
    ["ftp_login"] = "FTP client login",
    ["ftp_password"] = "FTP client password",
    ["gtpv0_apn_name"] = "GTPv0 APN Name",
    ["gtpv0_end_user_ip"] = "GTPv0 End User IP Address",
    ["gtpv0_end_user_msisdn"] = "GTPv0 End User MSISDN",
    ["gtpv0_rai_cell_lac"] = "GTPv0 Cell Location Area Code",
    ["gtpv0_rai_cell_rac"] = "GTPv0 Cell Routing Area Code",
    ["gtpv0_rai_mcc"] = "GTPv0 Mobile Country Code",
    ["gtpv0_rai_mnc"] = "GTPv0 Mobile Network Code",
    ["gtpv0_req_msg_type"] = "GTPv0 Request Msg Type",
    ["gtpv0_response_cause"] = "GTPv0 Cause of Operation",
    ["gtpv0_rsp_msg_type"] = "GTPv0 Response Msg Type",
    ["gtpv0_tid"] = "GTPv0 Tunnel Identifier",
    ["gtpv1_apn_name"] = "GTPv1 APN Name",
    ["gtpv1_c2s_teid_ctrl"] = "GTPv1 Client->Server TunnelId Control",
    ["gtpv1_c2s_teid_data"] = "GTPv1 Client->Server TunnelId Data",
    ["gtpv1_end_user_imei"] = "GTPv1 End User IMEI",
    ["gtpv1_end_user_imsi"] = "GTPv1 End User IMSI",
    ["gtpv1_end_user_ip"] = "GTPv1 End User IP Address",
    ["gtpv1_end_user_msisdn"] = "GTPv1 End User MSISDN",
    ["gtpv1_rai_lac"] = "GTPv1 RAI Location Area Code",
    ["gtpv1_rai_mcc"] = "GTPv1 RAI Mobile Country Code",
    ["gtpv1_rai_mnc"] = "GTPv1 RAI Mobile Network Code",
    ["gtpv1_rai_rac"] = "GTPv1 RAI Routing Area Code",
    ["gtpv1_rat_type"] = "GTPv1 RAT Type",
    ["gtpv1_req_msg_type"] = "GTPv1 Request Msg Type",
    ["gtpv1_response_cause"] = "GTPv1 Cause of Operation",
    ["gtpv1_rsp_msg_type"] = "GTPv1 Response Msg Type",
    ["gtpv1_s2c_teid_ctrl"] = "GTPv1 Server->Client TunnelId Control",
    ["gtpv1_s2c_teid_data"] = "GTPv1 Server->Client TunnelId Data",
    ["gtpv1_uli_cell_ci"] = "GTPv1 ULI Cell CI",
    ["gtpv1_uli_cell_lac"] = "GTPv1 ULI Cell Location Area Code",
    ["gtpv1_uli_mcc"] = "GTPv1 ULI Mobile Country Code",
    ["gtpv1_uli_mnc"] = "GTPv1 ULI Mobile Network Code",
    ["gtpv1_uli_sac"] = "GTPv1 ULI SAC",
    ["gtpv2_apn_name"] = "GTPv2 APN Name",
    ["gtpv2_c2s_s1u_gtpu_ip"] = "GTPv2 Client->Svr S1U GTPU IP",
    ["gtpv2_c2s_s1u_gtpu_teid"] = "GTPv2 Client->Svr S1U GTPU TEID",
    ["gtpv2_c2s_s5_s8_gtpc_ip"] = "GTPv2 Client->Svr S5/S8 GTPC IP",
    ["gtpv2_c2s_s5_s8_gtpu_ip"] = "GTPv2 Client->Srv S5/S8 PGW GTPU IP",
    ["gtpv2_c2s_s5_s8_gtpu_teid"] = "GTPv2 Client->Srv S5/S8 PGW GTPU TEID",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_ip"] = "GTPv2 Client->Srv S5/S8 SGW GTPU IP",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_teid"] = "GTPv2 Client->Srv S5/S8 SGW GTPU TEID",
    ["gtpv2_end_user_imei"] = "GTPv2 End User IMEI",
    ["gtpv2_end_user_imsi"] = "GTPv2 End User IMSI",
    ["gtpv2_end_user_msisdn"] = "GTPv2 End User MSISDN",
    ["gtpv2_pdn_ip"] = "GTPV2 PDN IP Address",
    ["gtpv2_rat_type"] = "GTPv2 RAT Type",
    ["gtpv2_req_msg_type"] = "GTPv2 Request Msg Type",
    ["gtpv2_response_cause"] = "GTPv2 Cause of Operation",
    ["gtpv2_rsp_msg_type"] = "GTPv2 Response Msg Type",
    ["gtpv2_s2c_s1u_gtpu_ip"] = "GTPv2 Srv->Client S1U GTPU IP",
    ["gtpv2_s2c_s1u_gtpu_teid"] = "GTPv2 Srv->Client S1U GTPU TEID",
    ["gtpv2_s2c_s5_s8_gtpc_ip"] = "GTPv2 Svr->Client S5/S8 GTPC IP",
    ["gtpv2_s2c_s5_s8_gtpu_ip"] = "GTPv2 Srv->Client S5/S8 PGW GTPU IP",
    ["gtpv2_s2c_s5_s8_gtpu_teid"] = "GTPv2 Srv->Client S5/S8 PGW GTPU TEID",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_ip"] = "GTPv2 Srv->Client S5/S8 SGW GTPU IP",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_teid"] = "GTPv2 Srv->Client S5/S8 SGW GTPU TEID",
    ["gtpv2_s5_s8_gtpc_teid"] = "GTPv2 S5/S8 SGW GTPC TEIDs",
    ["gtpv2_uli_cell_id"] = "GTPv2 Cell Identifier",
    ["gtpv2_uli_cell_tac"] = "GTPv2 Tracking Area Code",
    ["gtpv2_uli_mcc"] = "GTPv2 Mobile Country Code",
    ["gtpv2_uli_mnc"] = "GTPv2 Mobile Network Code",
    ["http_host"] = "HTTP Host Name (IXIA Host Name)",
    ["http_length"] = "HTTP Content Length",
    ["http_method"] = "HTTP METHOD",
    ["http_mime"] = "HTTP Mime Type",
    ["http_protocol"] = "HTTP Protocol",
    ["http_referer"] = "HTTP Referer",
    ["http_ret_code"] = "HTTP return code (e.g. 200, 304...)",
    ["http_site"] = "HTTP server without host name",
    ["http_ua"] = "HTTP User Agent",
    ["http_url"] = "HTTP URL (IXIA URI)",
    ["http_via"] = "HTTP Via",
    ["http_x_forwarded_for"] = "HTTP X-Forwarded-For",
    ["icmp_ipv4_code"] = "ICMP Code",
    ["icmp_ipv4_type"] = "ICMP Type",
    ["icmp_type"] = "ICMP Type * 256 + ICMP code",
    ["imap_login"] = "Mail sender",
    ["in_bytes"] = "Incoming flow bytes (src->dst)",
    ["in_dst_mac"] = "Destination MAC Address",
    ["in_pkts"] = "Incoming flow packets (src->dst)",
    ["in_src_mac"] = "Source MAC Address",
    ["in_src_osi_sap"] = "OSI Source SAP (OSI Traffic Only)",
    ["ingress_vrfid"] = "Ingress VRF ID",
    ["input_snmp"] = "Input interface SNMP idx",
    ["ip_protocol_version"] = "[4=IPv4][6=IPv6]",
    ["ipfix_sampling_algorithm"] = "Sampling algorithm",
    ["ipv4_dst_addr"] = "IPv4 destination address",
    ["ipv4_dst_mask"] = "IPv4 dest subnet mask (/<bits>)",
    ["ipv4_next_hop"] = "IPv4 next hop address",
    ["ipv4_src_addr"] = "IPv4 source address",
    ["ipv4_src_mask"] = "IPv4 source subnet mask (/<bits>)",
    ["ipv6_dst_addr"] = "IPv6 destination address",
    ["ipv6_dst_mask"] = "IPv6 destination mask",
    ["ipv6_next_hop"] = "IPv6 next hop address",
    ["ipv6_src_addr"] = "IPv6 source address",
    ["ipv6_src_mask"] = "IPv6 source mask",
    ["l4_dst_port"] = "Layer 4 destination port",
    ["l4_dst_port_map"] = "Layer 4 destination port symbolic name",
    ["l4_src_port"] = "IPv4 source port",
    ["l4_src_port_map"] = "Layer 4 source port symbolic name",
    ["l4_srv_port"] = "Layer 4 server port",
    ["l4_srv_port_map"] = "Layer 4 server port symbolic name",
    ["l7_proto"] = "Layer 7 application (numeric)",
    ["l7_proto_name"] = "Layer 7 application name",
    ["last_switched"] = "SysUptime (msec) of the last flow pkt",
    ["longest_flow_pkt"] = "Longest packet (bytes) of the flow",
    ["max_ttl"] = "Max flow TTL",
    ["min_ttl"] = "Min flow TTL",
    ["mpls_label_1"] = "MPLS label at position 1",
    ["mpls_label_10"] = "MPLS label at position 10",
    ["mpls_label_2"] = "MPLS label at position 2",
    ["mpls_label_3"] = "MPLS label at position 3",
    ["mpls_label_4"] = "MPLS label at position 4",
    ["mpls_label_5"] = "MPLS label at position 5",
    ["mpls_label_6"] = "MPLS label at position 6",
    ["mpls_label_7"] = "MPLS label at position 7",
    ["mpls_label_8"] = "MPLS label at position 8",
    ["mpls_label_9"] = "MPLS label at position 9",
    ["mysql_appl_latency_usec"] = "MySQL request->response latecy (usec)",
    ["mysql_db"] = "MySQL database in use",
    ["mysql_query"] = "MySQL Query",
    ["mysql_response"] = "MySQL server response",
    ["mysql_server_version"] = "MySQL server version",
    ["mysql_username"] = "MySQL username",
    ["netbios_query_name"] = "NETBIOS Query Name",
    ["netbios_query_os"] = "NETBIOS Query OS",
    ["netbios_query_type"] = "NETBIOS Query Type",
    ["netbios_response"] = "NETBIOS Query Response",
    ["nprobe_ipv4_address"] = "IPv4 address of the host were nProbe runs",
    ["num_pkts_1024_to_1514_bytes"] = "# packets whose IP size > 1024 and <= 1514",
    ["num_pkts_128_to_256_bytes"] = "# packets whose IP size > 128 and <= 256",
    ["num_pkts_256_to_512_bytes"] = "# packets whose IP size > 256 and < 512",
    ["num_pkts_512_to_1024_bytes"] = "# packets whose IP size > 512 and < 1024",
    ["num_pkts_over_1514_bytes"] = "# packets whose IP size > 1514",
    ["num_pkts_ttl_128_160"] = "# packets with TTL > 128 and <= 160",
    ["num_pkts_ttl_160_192"] = "# packets with TTL > 160 and <= 192",
    ["num_pkts_ttl_192_224"] = "# packets with TTL > 192 and <= 224",
    ["num_pkts_ttl_224_255"] = "# packets with TTL > 224 and <= 255",
    ["num_pkts_ttl_2_5"] = "# packets with TTL > 1 and TTL <= 5",
    ["num_pkts_ttl_32_64"] = "# packets with TTL > 32 and <= 64",
    ["num_pkts_ttl_5_32"] = "# packets with TTL > 5 and TTL <= 32",
    ["num_pkts_ttl_64_96"] = "# packets with TTL > 64 and <= 96",
    ["num_pkts_ttl_96_128"] = "# packets with TTL > 96 and <= 128",
    ["num_pkts_ttl_eq_1"] = "# packets with TTL = 1",
    ["num_pkts_up_to_128_bytes"] = "# packets whose IP size <= 128",
    ["observation_point_id"] = "Observation point id",
    ["observation_point_type"] = "Observation point type",
    ["ooorder_in_pkts"] = "Number of out of order TCP flow packets (dst->src)",
    ["ooorder_out_pkts"] = "Number of out of order TCP flow packets (src->dst)",
    ["oracle_query"] = "Oracle Query",
    ["oracle_query_duration"] = "Oracle Query Duration (msec)",
    ["oracle_rsp_code"] = "Oracle Response Code",
    ["oracle_rsp_string"] = "Oracle Response String",
    ["oracle_username"] = "Oracle Username",
    ["out_bytes"] = "Outgoing flow bytes (dst->src) [Aliased to %%DST_TO_SRC_BYTES]",
    ["out_dst_mac"] = "Destination MAC Address, potentially modified by a middlebox function after the Observation Point",
    ["out_dst_osi_sap"] = "OSI Destination SAP (OSI Traffic Only)",
    ["out_pkts"] = "Outgoing flow packets (dst->src) [Aliased to %%DST_TO_SRC_PKTS]",
    ["out_src_mac"] = "Source MAC Address, potentially modified by a middlebox function after the Observation Point",
    ["output_snmp"] = "Output interface SNMP idx",
    ["packet_section_offset"] = "Packet section offset",
    ["packets_observed"] = "Tot number of packets seen",
    ["packets_selected"] = "Number of pkts selected for sampling",
    ["payload_hash"] = "Initial flow payload hash",
    ["plugin_name"] = "Plugin name used by this flow (if any)",
    ["pop_user"] = "POP3 user login",
    ["post_napt_dst_transport_port"] = "Post NAPT Destination Transport Port",
    ["post_napt_src_transport_port"] = "Post NAPT Source Transport Port",
    ["post_nat_dst_ipv4_addr"] = "Post NAT Destination IPv4 Address",
    ["post_nat_src_ipv4_addr"] = "Post NAT Source IPv4 Address",
    ["protocol"] = "IP protocol byte",
    ["protocol_map"] = "IP protocol name",
    ["radius_acct_in_octets"] = "RADIUS Accounting Input Octets",
    ["radius_acct_in_pkts"] = "RADIUS Accounting Input Packets",
    ["radius_acct_out_octets"] = "RADIUS Accounting Output Octets",
    ["radius_acct_out_pkts"] = "RADIUS Accounting Output Packets",
    ["radius_acct_session_id"] = "RADIUS Accounting Session Name",
    ["radius_acct_status_type"] = "RADIUS Accounting Status Type",
    ["radius_called_station_id"] = "RADIUS Called Station Id",
    ["radius_calling_station_id"] = "RADIUS Calling Station Id",
    ["radius_framed_ip_addr"] = "RADIUS Framed IP",
    ["radius_nas_identifier"] = "RADIUS NAS Identifier",
    ["radius_nas_ip_addr"] = "RADIUS NAS IP Address",
    ["radius_req_msg_type"] = "RADIUS Request Msg Type",
    ["radius_rsp_msg_type"] = "RADIUS Response Msg Type",
    ["radius_user_imei"] = "RADIUS User MSISDN (Extension)",
    ["radius_user_imsi"] = "RADIUS User IMSI (Extension)",
    ["radius_user_name"] = "RADIUS User Name (Access Only)",
    ["retransmitted_in_bytes"] = "Number of retransmitted TCP flow bytes (src->dst)",
    ["retransmitted_in_pkts"] = "Number of retransmitted TCP flow packets (src->dst)",
    ["retransmitted_out_bytes"] = "Number of retransmitted TCP flow bytes (dst->src)",
    ["retransmitted_out_pkts"] = "Number of retransmitted TCP flow packets (dst->src)",
    ["rtp_dtmf_tones"] = "DTMF tones sent (if any) during the call",
    ["rtp_first_seq"] = "First flow RTP Seq Number",
    ["rtp_first_ts"] = "First flow RTP timestamp",
    ["rtp_in_jitter"] = "RTP jitter (ms * 1000)",
    ["rtp_in_max_delta"] = "Max delta (ms*100) between consecutive pkts (src->dst)",
    ["rtp_in_mos"] = "RTP pseudo-MOS (value * 100) (src->dst)",
    ["rtp_in_payload_type"] = "RTP payload type",
    ["rtp_in_pkt_drop"] = "Packet discarded by Jitter Buffer (src->dst)",
    ["rtp_in_pkt_lost"] = "Packet lost in stream (src->dst)",
    ["rtp_in_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (src->dst)",
    ["rtp_in_transit"] = "RTP Transit (value * 100) (src->dst)",
    ["rtp_last_seq"] = "Last flow RTP Seq Number",
    ["rtp_last_ts"] = "Last flow RTP timestamp",
    ["rtp_mos"] = "RTP pseudo-MOS (value * 100) (average both directions)",
    ["rtp_out_jitter"] = "RTP jitter (ms * 1000)",
    ["rtp_out_max_delta"] = "Max delta (ms*100) between consecutive pkts (dst->src)",
    ["rtp_out_mos"] = "RTP pseudo-MOS (value * 100) (dst->src)",
    ["rtp_out_payload_type"] = "RTP payload type",
    ["rtp_out_pkt_drop"] = "Packet discarded by Jitter Buffer (dst->src)",
    ["rtp_out_pkt_lost"] = "Packet lost in stream (dst->src)",
    ["rtp_out_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (dst->src)",
    ["rtp_out_transit"] = "RTP Transit (value * 100) (dst->src)",
    ["rtp_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (average both directions)",
    ["rtp_rtt"] = "RTP Round Trip Time (ms)",
    ["rtp_sip_call_id"] = "SIP call-id corresponding to this RTP stream",
    ["rtp_ssrc"] = "RTP Sync Source ID",
    ["s1ap_cause_enb_to_mme"] = "S1AP Cause from ENB to MME",
    ["s1ap_detailed_cause_enb_to_mme"] = "S1AP Detailed Cause from ENB to MME",
    ["s1ap_enb_ue_s1ap_id"] = "S1AP ENB Identifier",
    ["s1ap_mme_ue_s1ap_id"] = "S1AP MME Identifier",
    ["s1ap_msg_emm_type_enb_to_mme"] = "S1AP EMM Message Type from ENB to MME",
    ["s1ap_msg_emm_type_mme_to_enb"] = "S1AP EMM Message Type from MME to ENB",
    ["s1ap_msg_esm_type_enb_to_mme"] = "S1AP ESM Message Type from ENB to MME",
    ["s1ap_msg_esm_type_mme_to_enb"] = "S1AP ESM Message Type from MME to ENB",
    ["sampled_packet_id"] = "Sampled packet id",
    ["sampled_packet_size"] = "Sampled packet size",
    ["sampling_algorithm"] = "Sampling type (deterministic/random)",
    ["sampling_interval"] = "Sampling rate",
    ["sampling_population"] = "Sampling population",
    ["sampling_size"] = "Number of packets to sample",
    ["selector_id"] = "Selector id",
    ["selector_name"] = "Sampler name",
    ["server_nw_latency_ms"] = "Network RTT/2 nprobe <-> server (msec)",
    ["shortest_flow_pkt"] = "Shortest packet (bytes) of the flow",
    ["sip_bye_ok_time"] = "SIP time (epoch) of BYE OK",
    ["sip_bye_time"] = "SIP time (epoch) of BYE",
    ["sip_c_ip"] = "SIP C IP adresses",
    ["sip_call_id"] = "SIP call-id",
    ["sip_call_state"] = "SIP Call State",
    ["sip_called_party"] = "SIP Called party",
    ["sip_calling_party"] = "SIP Call initiator",
    ["sip_cancel_ok_time"] = "SIP time (epoch) of CANCEL OK",
    ["sip_cancel_time"] = "SIP time (epoch) of CANCEL",
    ["sip_invite_failure_time"] = "SIP time (epoch) of INVITE FAILURE",
    ["sip_invite_ok_time"] = "SIP time (epoch) of INVITE OK",
    ["sip_invite_time"] = "SIP time (epoch) of INVITE",
    ["sip_reason_cause"] = "SIP Cancel/Bye/Failure reason cause",
    ["sip_response_code"] = "SIP failure response code",
    ["sip_ringing_time"] = "SIP time (epoch) of RINGING",
    ["sip_rtp_codecs"] = "SIP RTP codecs",
    ["sip_rtp_ipv4_dst_addr"] = "SIP RTP stream dest IP",
    ["sip_rtp_ipv4_src_addr"] = "SIP RTP stream source IP",
    ["sip_rtp_l4_dst_port"] = "SIP RTP stream dest port",
    ["sip_rtp_l4_src_port"] = "SIP RTP stream source port",
    ["sip_trying_time"] = "SIP time (epoch) of Trying",
    ["smtp_mail_from"] = "Mail sender",
    ["smtp_rcpt_to"] = "Mail recipient",
    ["src_as"] = "Source BGP AS",
    ["src_as_map"] = "Organization name for SRC_AS",
    ["src_as_path_1"] = "Src AS path position 1",
    ["src_as_path_10"] = "Src AS path position 10",
    ["src_as_path_2"] = "Src AS path position 2",
    ["src_as_path_3"] = "Src AS path position 3",
    ["src_as_path_4"] = "Src AS path position 4",
    ["src_as_path_5"] = "Src AS path position 5",
    ["src_as_path_6"] = "Src AS path position 6",
    ["src_as_path_7"] = "Src AS path position 7",
    ["src_as_path_8"] = "Src AS path position 8",
    ["src_as_path_9"] = "Src AS path position 9",
    ["src_father_proc_name"] = "Src father process name",
    ["src_father_proc_pid"] = "Src father process PID",
    ["src_fragments"] = "Num fragmented packets src->dst",
    ["src_ip_city"] = "City where the src IP is located",
    ["src_ip_country"] = "Country where the src IP is located",
    ["src_ip_lat"] = "Latitude where the src IP is located",
    ["src_ip_long"] = "Longitude where the src IP is located",
    ["src_proc_actual_memory"] = "Src process actual memory (bytes)",
    ["src_proc_average_cpu_load"] = "Src process avg load (%% * 100)",
    ["src_proc_name"] = "Src process name",
    ["src_proc_num_page_faults"] = "Src process num pagefaults",
    ["src_proc_pctg_iowait"] = "Src process iowait time %% (%% * 100)",
    ["src_proc_peak_memory"] = "Src process peak memory (bytes)",
    ["src_proc_pid"] = "Src process PID",
    ["src_proc_uid"] = "Src process UID",
    ["src_proc_user_name"] = "Src process user name",
    ["src_to_dst_avg_throughput"] = "Src to dst average thpt (bps)",
    ["src_to_dst_max_throughput"] = "Src to dst max thpt (bps)",
    ["src_to_dst_min_throughput"] = "Src to dst min thpt (bps)",
    ["src_tos"] = "TOS/DSCP (src->dst)",
    ["src_vlan"] = "Source VLAN (inner VLAN in QinQ)",
    ["ssdp_host"] = "SSDP Host",
    ["ssdp_method"] = "SSDP Method",
    ["ssdp_server"] = "SSDP Server",
    ["ssdp_type"] = "SSDP Type",
    ["ssdp_usn"] = "SSDP USN",
    ["suricata_app_proto"] = "Suricata Application Protocol",
    ["suricata_flow_id"] = "Suricata Flow ID",
    ["tcp_flags"] = "Cumulative of all flow TCP flags",
    ["tcp_win_max_in"] = "Max TCP Window (src->dst)",
    ["tcp_win_max_out"] = "Max TCP Window (dst->src)",
    ["tcp_win_min_in"] = "Min TCP Window (src->dst)",
    ["tcp_win_min_out"] = "Min TCP Window (dst->src)",
    ["tcp_win_mss_in"] = "TCP Max Segment Size (src->dst)",
    ["tcp_win_mss_out"] = "TCP Max Segment Size (dst->src)",
    ["tcp_win_scale_in"] = "TCP Window Scale (src->dst)",
    ["tcp_win_scale_out"] = "TCP Window Scale (dst->src)",
    ["tls_cert_after"] = "TLS Certificate After",
    ["tls_cert_dn"] = "TLS Certificate DN",
    ["tls_cert_not_before"] = "TLS Certificate Not Before",
    ["tls_cert_sha1"] = "TLS Certificate Fingerprint",
    ["tls_cert_sn"] = "TLS Certificate S/N",
    ["tls_cert_subject"] = "TLS Certificate Subject",
    ["tls_server_name"] = "TLS server name",
    ["tls_version"] = "TLS Version",
    ["total_bytes_exp"] = "Total bytes exported",
    ["total_flows_exp"] = "Total number of exported flows",
    ["total_pkts_exp"] = "Total flow packets exported",
    ["untunneled_ipv4_dst_addr"] = "Untunneled IPv4 destination address",
    ["untunneled_ipv4_src_addr"] = "Untunneled IPv4 source address",
    ["untunneled_ipv6_dst_addr"] = "Untunneled IPv6 destination address",
    ["untunneled_ipv6_src_addr"] = "Untunneled IPv6 source address",
    ["untunneled_l4_dst_port"] = "Untunneled IPv4 destination port",
    ["untunneled_l4_src_port"] = "Untunneled IPv4 source port",
    ["untunneled_protocol"] = "Untunneled IP protocol byte",
    ["upstream_session_id"] = "Upstream session identifier (e.g. L2TP) or 0 if unknown",
    ["upstream_tunnel_id"] = "Upstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
    ["user_name"] = "User Name",
  },
  ["flow_risk"] = {
    ["ndpi_binary_application_transfer"] = "Suspicious File Transfer",
    ["ndpi_dns_suspicious_traffic"] = "Suspicious DNS Traffic",
    ["ndpi_http_numeric_ip_host"] = "HTTP Numeric IP Host",
    ["ndpi_http_suspicious_header"] = "HTTP Suspicious Header",
    ["ndpi_http_suspicious_url"] = "HTTP Suspicious URL",
    ["ndpi_http_suspicious_user_agent"] = "HTTP Suspicious User-Agent",
    ["ndpi_known_protocol_on_non_standard_port"] = "Known Application on Non-Standard Port",
    ["ndpi_malformed_packet"] = "Malformed packet",
    ["ndpi_no_risk"] = "No risk",
    ["ndpi_smb_insecure_version"] = "SMB Insecure Version",
    ["ndpi_ssh_obsolete_client_version_or_cipher"] = "Obsolete SSH Client Version or Cipher",
    ["ndpi_ssh_obsolete_server_version_or_cipher"] = "Obsolete SSH Server Version or Cipher",
    ["ndpi_suspicious_dga_domain"] = "Suspicious DGA domain name",
    ["ndpi_tls_certificate_expired"] = "TLS Certificate Expired",
    ["ndpi_tls_certificate_mismatch"] = "TLS Certificate Mismatch",
    ["ndpi_tls_missing_sni"] = "Missing TLS SNI",
    ["ndpi_tls_not_carrying_https"] = "TLS (probably) not carrying HTTPS",
    ["ndpi_tls_obsolete_version"] = "Obsolete TLS Version",
    ["ndpi_tls_selfsigned_certificate"] = "TLS Certificate Self-signed",
    ["ndpi_tls_suspicious_esni_usage"] = "Suspicious TLS ESNI Usage",
    ["ndpi_tls_weak_cipher"] = "Weak TLS Cipher",
    ["ndpi_unsafe_protocol"] = "Unsafe Protocol",
    ["ndpi_url_possible_rce_injection"] = "Possible Remote Code Execution (RCE)",
    ["ndpi_url_possible_sql_injection"] = "Possible SQL Injection",
    ["ndpi_url_possible_xss"] = "Possible XSS",
  },
  ["flows_page"] = {
    ["active_flows"] = "Active %{filter} Flows",
    ["actual_throughput"] = "Actual Thpt",
    ["alerted"] = "Alerted",
    ["all_alerted"] = "All Alerted",
    ["all_ases"] = "All ASes",
    ["all_categories"] = "All Categories",
    ["all_devices"] = "All Flow Exporters",
    ["all_flows"] = "All Flows",
    ["all_hosts"] = "All Hosts",
    ["all_inIfIdx"] = "All Input Interfaces",
    ["all_ip_versions"] = "All Versions",
    ["all_l4_protocols"] = "All Protocols",
    ["all_misbehaving"] = "All Misbehaving",
    ["all_outIfIdx"] = "All Output Interfaces",
    ["all_proto"] = "All Applications",
    ["all_vlan_ids"] = "All VLANs",
    ["applications"] = "Applications",
    ["blocked"] = "Blocked",
    ["client_as"] = "Client AS",
    ["device_ip"] = "Flow Exporter",
    ["direction"] = "Direction",
    ["flow_exporters"] = "Flow Exporters",
    ["flow_status_severity"] = "Severity",
    ["flows"] = "%{filter} Flows",
    ["flows_as_client"] = "Flows As Client",
    ["flows_as_server"] = "Flows As Server",
    ["host"] = " [ Host %{host} ]",
    ["hosts"] = "Hosts",
    ["icmp_only"] = "ICMP Only",
    ["idle_flows_not_listed"] = "Idle flows not listed.",
    ["inIfIdx"] = "Input Interface",
    ["ip_version"] = "IP Version",
    ["ipv4_only"] = "IPv4 Only",
    ["ipv6_only"] = "IPv6 Only",
    ["l4_protocol"] = "Protocol",
    ["local_cli_remote_srv"] = "Local Client - Remote Server",
    ["local_only"] = "Local Only",
    ["local_srv_remote_cli"] = "Local Server - Remote Client",
    ["misbehaving"] = "Misbehaving",
    ["multicast"] = "Multicast/Broadcast",
    ["network"] = " [ Network %{network} ]",
    ["non_multicast"] = "Non-Multicast/Non-Broadcast",
    ["normal"] = "Normal",
    ["one_way_multicast"] = "One-Way Multicast/Broadcast",
    ["one_way_non_multicast"] = "One-Way Non-Multicast/Non-Broadcast",
    ["outIfIdx"] = "Output Interface",
    ["port"] = " [ Port %{port} ]",
    ["recently_active_flows"] = "Recently Active %{filter} Flows",
    ["remote_only"] = "Remote Only",
    ["server_as"] = "Server AS",
    ["sflow_devices"] = "sFlow Devices",
    ["source_id"] = "Source Id",
    ["tcp_only"] = "TCP Only",
    ["tcp_state"] = "TCP State",
    ["tcp_state_closed"] = "Closed",
    ["tcp_state_connecting"] = "Connecting",
    ["tcp_state_established"] = "Established",
    ["tcp_state_reset"] = "Reset",
    ["tcp_state_unknown"] = "Unknown",
    ["total_bytes"] = "Total Bytes",
    ["total_bytes_rcvd"] = "Total Bytes Received",
    ["total_bytes_sent"] = "Total Bytes Sent",
    ["total_bytes_unknown"] = "Total Unknown Applications Bytes",
    ["udp_only"] = "UDP Only",
    ["vlan"] = "VLAN",
  },
  ["geo_map"] = {
    ["browser_reported_home_map"] = "Browser reported home map location",
    ["configure_geo_ip"] = "Configure Geo IP",
    ["geo_ip"] = "Geo IP",
    ["geo_map"] = "Geo Map",
    ["geolocation_error"] = "Geolocation error",
    ["hosts_geomap"] = "Hosts GeoMap",
    ["latitude"] = "Latitude",
    ["longitude"] = "Longitude",
    ["note"] = "NOTE",
    ["note_active_flows"] = "Have active flows between peers with public IP addresses.",
    ["note_compiled_ntopng_with_geolocation"] = "Have compiled the software with geolocation and started with it.",
    ["note_google_maps_browser_api_key"] = "A Google Maps API Key is required, you can generate one from <a href='%{url_google}'>Google Cloud Platform Console</a>:<br>please create a new project and select Maps JavaScript API -> Create Credentials -> API key.<br>Once generated, the key can be submitted via the <a href='%{url_prefs}'><i class=\"fas fa-flask\"></i> Preferences</a>.",
    ["note_html_browser_geolocation"] = "HTML <A HREF=%{url}>browser geolocation</A> is used to place on map hosts based on unknown locations.",
    ["note_requirements_visualize_maps"] = "In order to visualize maps you must",
    ["note_working_internet_connection"] = "Have a working Internet connection.",
    ["unavailable_geolocation"] = "Geolocation not supported by your browser or disabled.",
    ["using_default_location"] = "Using default location.",
    ["warning_accuracy"] = "Geolocation accuracy depends on the geolocation database and may be approximated.",
  },
  ["graphs"] = {
    ["95_perc"] = "95th Perc",
    ["active_devices"] = "Active Devices",
    ["active_flows"] = "Active Flows",
    ["active_host_contacts"] = "Active Host Contacts",
    ["active_hosts"] = "Active Hosts",
    ["active_http_servers"] = "Active HTTP Servers",
    ["active_monitoring"] = "Active Monitoring",
    ["actual_memory"] = "Actual Memory",
    ["app_connect"] = "App Connect",
    ["arp_replies"] = "ARP Replies",
    ["arp_requests"] = "ARP Requests",
    ["arp_rqst_sent_rcvd_rpls"] = "ARP Sent Requests / Rcvd Repls",
    ["average"] = "Average",
    ["average_traffic"] = "Average Traffic/sec",
    ["avg"] = "Avg",
    ["binary_operators_note"] = "For more information about the EMA, SMA and RSI indicators check out the <a href=\"%{url}\">online documentation</a>.",
    ["blocked_flows"] = "Blocked Flows",
    ["bytes_sent_non_unicast"] = "Bytes Sent Non Unicast",
    ["bytes_sent_unicast"] = "Bytes Sent Unicast",
    ["custom"] = "Custom",
    ["discarded_probing_bytes"] = "Discarded Probing Traffic",
    ["discarded_probing_packets"] = "Discarded Probing Packets",
    ["dns_qry_rcvd_rsp_sent"] = "DNS Rcvd Queries / Sent Repls",
    ["dns_qry_sent_rsp_rcvd"] = "DNS Sent Queries / Rcvd Repls",
    ["download_chart_data"] = "Download the current chart data",
    ["dropped_flows"] = "Dropped Flows",
    ["dscp_classes"] = "DSCP Classes",
    ["dumped_flows"] = "Exported Flows",
    ["echo_reply_packets"] = "Echo Reply Packets",
    ["echo_request_packets"] = "Echo Request Packets",
    ["export_flows_as_txt"] = "Export flows as TXT file",
    ["flows_status_overview"] = "%{protocol} Flows Status Overview",
    ["flows_vs_local_hosts"] = "Active Flows vs Local Hosts",
    ["flows_vs_traffic"] = "Active Flows vs Traffic",
    ["get_permanent_link"] = "Get permanent link",
    ["graph_info"] = "Graph Info",
    ["host_unreachable_flows"] = "Total Host Unreachable Flows",
    ["http_stats"] = "HTTP Stats",
    ["influxdb_not_responding"] = "Query has been aborted as InfluxDB is not responding. Query timeout can be configured from the <a href=\"%{url}\">%{flask_icon} Preferences</a> .",
    ["last_ms"] = "Last ms",
    ["max"] = "Max",
    ["max_ms"] = "Max ms",
    ["max_rtt"] = "Max RTT Time",
    ["memory_vs_hosts_flows"] = "Process Memory vs Hosts/Flows",
    ["min_rtt"] = "Min RTT Time",
    ["minute_interface_top_stats"] = "Minute Interface Top Traffic Statistics",
    ["name_lookup"] = "Name Lookup",
    ["new_flows"] = "New Flows",
    ["note_ases_rcvd"] = "Traffic received the traffic received by the autonomous system.",
    ["note_ases_sent"] = "Traffic sent is the traffic sent by the autonomous system.",
    ["note_ases_traffic"] = "Traffic shown is sent and received by the autonomous system.",
    ["note_chart_zoom"] = "Click and drag on the chart to zoom in, double click to zoom out.",
    ["note_protocols_shown"] = "Applications not seen in the selected timeframe are not listed in the dropdown.",
    ["num_calls"] = "Num calls",
    ["num_ms_rtt"] = "RTT Time ms",
    ["num_nfq_drops"] = "Dropped Packets",
    ["num_nfq_pct"] = "Queue Fill %%",
    ["packet_drops"] = "Packet Drops",
    ["packets_vs_drops"] = "Packets vs Drops",
    ["peak_memory"] = "Peak Memory",
    ["percentile"] = "95th <a href=\"%{url}\">Percentile</a>",
    ["permanent_link"] = "Permanent Link",
    ["pkt_drops"] = "Pkt Drops",
    ["process_alerts"] = "Process Alerts",
    ["process_memory"] = "Process Memory",
    ["query_too_much_time"] = "The query is taking a long time to complete",
    ["query_too_slow"] = "The query has taken too much time to complete",
    ["query_was_aborted"] = "Query was aborted",
    ["raw_flows"] = "Raw Flows",
    ["raw_proto_flows"] = "Raw %{proto} Flows",
    ["red_line_unreachable"] = "A red line indicates the time the host has been unreachable.",
    ["reset_zoom"] = "Reset Zoom",
    ["right_axis_note"] = "(right axis)",
    ["tcp_finack_packets"] = "TCP FIN+ACK Packets",
    ["tcp_packets"] = "TCP Packets",
    ["tcp_packets_keep_alive"] = "TCP Packets KeepAlive",
    ["tcp_packets_lost"] = "TCP Packets Lost",
    ["tcp_packets_ooo"] = "TCP Packets Out-Of-Order",
    ["tcp_packets_retr"] = "TCP Retransmitted Packets",
    ["tcp_retr_ooo_lost"] = "TCP Retransmitted Out-Of-Order and Lost",
    ["tcp_rst_packets"] = "TCP RST Packets",
    ["tcp_rx_stats"] = "TCP RX Stats",
    ["tcp_syn_packets"] = "TCP SYN Packets",
    ["tcp_syn_vs_tcp_synack"] = "TCP SYN vs SYN+ACK Packets",
    ["tcp_synack_packets"] = "TCP SYN+ACK Packets",
    ["tcp_tx_stats"] = "TCP TX Stats",
    ["the_select_timeframe_too_small_top_talkers"] = "The selected timeframe is too small to determine the top talkers. Please select at least a 1 minute frame.",
    ["top_clients"] = "Top %{protocol} Clients",
    ["top_interfaces"] = "Top Interfaces",
    ["top_l7_contacts"] = "Top %{protocol} L7 Contacts",
    ["top_ndpi_categories"] = "Top Categories",
    ["top_ndpi_protocols"] = "Top Applications",
    ["top_profiles"] = "Top Profiles",
    ["top_receivers"] = "Top Receivers",
    ["top_senders"] = "Top Senders",
    ["top_servers"] = "Top %{protocol} Servers",
    ["top_user_scripts"] = "Top %{subdir} Scripts by Duration",
    ["tot_ms"] = "Total ms",
    ["total_alerted_flows"] = "Total Alerted Flows",
    ["total_unreachable_flows"] = "Total Port Unreachable Flows",
    ["traffic_txrx"] = "Traffic TX/RX",
    ["traffic_vs_errors"] = "Traffic vs Errors",
    ["trend"] = "Trend",
    ["udp_packets"] = "UDP Packets",
    ["udp_sent_unicast_vs_non_unicast"] = "UDP sent Unicast vs Non Unicast",
    ["unreachable_host"] = "Unreachable Host",
    ["zmq_flow_coll_drops"] = "Flow Collection Drops",
    ["zmq_flow_coll_udp_drops"] = "Collection Socket Drops",
    ["zmq_msg_rcvd_vs_drops"] = "Collected vs Dropped ZMQ Messages",
    ["zmq_received_flows"] = "Collected ZMQ Flows",
    ["metrics_prefixes"] = {
      ["broadcast_bytes"] = "Broadcast Bytes",
      ["drops"] = "Drops",
      ["num_devices"] = "Num Devices",
      ["num_flows"] = "Num Flows",
      ["num_hosts"] = "Num Hosts",
      ["num_http_hosts"] = "Num HTTP Hosts",
      ["num_ms_rtt"] = "RTT ms",
      ["packets"] = "Packets",
    },
    ["metrics_suffixes"] = {
      ["by_as"] = "%{metric} by AS",
      ["egress"] = "Egress",
      ["ingress"] = "Ingress",
      ["inner"] = "Inner",
      ["rcvd"] = "rcvd",
      ["sent"] = "sent",
    },
  },
  ["hash_table"] = {
    ["AggregatedFlowHash"] = "Aggregated Flows",
    ["AutonomousSystemHash"] = "Autonomous Systems",
    ["CountriesHash"] = "Countries",
    ["FlowHash"] = "Flows",
    ["HostHash"] = "Hosts",
    ["MacHash"] = "MACs",
    ["VlanHash"] = "VLANs",
  },
  ["host_config"] = {
    ["active_monitor_enable"] = "Active Monitoring is currently disabled. It can be enabled <a href=\"%{url}\">here</a>.",
    ["drop_all_host_traffic"] = "Drop All Host Traffic",
    ["hide_from_top"] = "Hide From Top Talkers",
    ["hide_host_from_top_descr"] = "Do not account host %{host} in top talkers computation",
    ["host_alias"] = "Host Alias",
    ["host_pool"] = "Host Pool",
    ["host_traffic_policy"] = "Host Traffic Policy",
    ["modify_host_pool_policy_btn"] = "Modify Host Pool Policy",
    ["trigger_alerts_for_host"] = "Trigger alerts for Host %{host}",
    ["trigger_host_alerts"] = "Trigger Host Alerts",
    ["unblock_host_traffic"] = "Unblock Host Traffic",
  },
  ["host_details"] = {
    ["active_alerted_flows"] = "Active Alerted Flows",
    ["blocked_traffic"] = "Blocked Traffic",
    ["client_score"] = "Client",
    ["disabled_flow_status_help"] = "Turn off flow alerts generation based on flow status",
    ["host"] = "Host",
    ["host_cannot_be_found_message"] = "Host %{host} cannot be found.",
    ["host_parameter_missing_message"] = "Host parameter is missing (internal error ?)",
    ["host_restore_in_progress"] = "Restoring host %{host}...",
    ["host_traffic_blocked_quota"] = "Some host traffic has been blocked by an exceeded quota",
    ["host_traffic_blocked_quota_and_shaper"] = "Some host traffic has been blocked by an exceeded quota and a blocking shaper",
    ["host_traffic_blocked_shaper"] = "Some host traffic has been blocked by a blocking shaper",
    ["inactive_host_x"] = "%{host} [Inactive]",
    ["list_of_general_purpose"] = "General purpose devices: %{list}",
    ["list_of_special_purpose"] = "Special purpose devices: %{list}",
    ["multiple_selection"] = "Multiple elements can be selected by pressing the CTRL key",
    ["reset_host_stats"] = "Reset Host Stats",
    ["reset_host_stats_confirm"] = "Do you really want to reset \"%{host}\" runtime stats?",
    ["reset_host_stats_note"] = "<b>NOTE</b>: historical charts for this host may have a gap after the reset.",
    ["reset_stats_in_progress"] = "Host statistics will be reset within 5 seconds",
    ["restore_from_cache_message_v1"] = "Host %{host} is inactive. Click <a href=%{js_code}> here</a> to restore it from cache.",
    ["server_score"] = "Server",
    ["snmp"] = "SNMP",
    ["status_ignore"] = "Disabled Flow Status Alerts",
    ["trace_debug_host_info"] = "Host:%{hostinfo}, Vlan: %{vlan}",
    ["trace_debug_host_ip"] = "Host:%{hostip}, Vlan: %{vlan}",
    ["trace_debug_restored_host_info"] = "Restored Host Info",
    ["unknown_device_type"] = "Unknown Device Type",
  },
  ["host_explorer_page"] = {
    ["alerted_flows"] = "Alerted Flows",
    ["all_flows"] = "All Flows",
    ["dns_queries"] = "DNS Queries vs Replies",
    ["syn_distribution"] = "SYN Distribution",
    ["syn_vs_rst"] = "SYN vs RST",
    ["syn_vs_synack"] = "SYN vs SYNACK",
    ["tcp_bytes_sent_vs_rcvd"] = "TCP Bytes Sent/Received",
    ["tcp_pkts_sent_vs_rcvd"] = "TCP Packets Sent/Received",
    ["unreach_flows"] = "Unreacheable Flows",
  },
  ["host_pools"] = {
    ["active_pool_members"] = "Active pool members",
    ["add_host_pool_member"] = "Add Host Pool Member",
    ["alias_or_manufacturer"] = "Alias / Manufacturer",
    ["and_associated_members"] = "its historical data and any associated members",
    ["cannot_delete_cp"] = "A pool cannot be deleted if there is any Captive Portal user associated",
    ["change_member_pool"] = "Change Member Pool",
    ["change_pool"] = "Switch Pool",
    ["children_safe"] = "Child Safe",
    ["cidr"] = "CIDR",
    ["click_here_host_pool"] = "Click here to go to the Host Pool page",
    ["config_export"] = "Export Configuration",
    ["config_import"] = "Import Configuration",
    ["config_import_message"] = "Note: host pools with the same name will be replaced.",
    ["confirm_delete_pool"] = "Do you really want to delete host pool",
    ["confirm_empty_pool"] = "Do you really want to remove all members from the host pool",
    ["confirm_remove_member"] = "Do you really want to remove member",
    ["confirm_reset_pool_quotas"] = "Do you really want to reset the \"%{pool}\" pool couters?",
    ["confirm_reset_quotas"] = "Do you really want to reset all the quotas counters?",
    ["create_new_quotas_here"] = "You can create new quotas <a href=\"%{url}\">here</a>.",
    ["create_pool_hint"] = "You can create new pools from the Manage Pools tab.",
    ["create_pools"] = "Manage Pools",
    ["delete_pool"] = "Delete Pool",
    ["duplicate_member"] = "Duplicate member address",
    ["duplicate_pool"] = "Duplicate pool name",
    ["edit_host_pool_member"] = "Edit members",
    ["edit_host_pools"] = "Edit Host Pools",
    ["empty_pool"] = "Empty Pool",
    ["enforce_quotas_per_pool_member"] = "Per-Member Quotas",
    ["enforce_shapers_per_pool_member"] = "Per-Member Shapers",
    ["from_pool"] = "from host pool",
    ["host_members"] = "Host Pool Members",
    ["host_pools"] = "Host Pools",
    ["invalid_member"] = "Invalid member address format",
    ["ip_address"] = "IP Address",
    ["ip_filter"] = "IPv4/IPv6",
    ["ipv4"] = "IPv4",
    ["ipv6"] = "IPv6",
    ["mac_address"] = "MAC Address",
    ["mac_filter"] = "MAC Address",
    ["manage_pools"] = "Manage Pool Membership",
    ["manufacturer_filter"] = "Manufacturer: %{manufacturer}",
    ["max_members_message"] = "With this version of ntopng you can only assign %{maxnum} members per host pool. Upgrade to the Enterprise version to remove this limit.",
    ["max_pools_message"] = "With this version of ntopng you can only create %{maxnum} host pools. Upgrade to the Enterprise version to remove this limit.",
    ["member_address"] = "Member Address",
    ["member_exists"] = "member \"%{member_name}\" not added. It is already assigned to pool \"%{member_pool}\".",
    ["member_filter"] = "Member: %{member}",
    ["member_type"] = "Member Type",
    ["members_limit_reached"] = "members limit reached",
    ["network"] = "Network",
    ["network_normalized"] = "network \"%{network}\" has a non-zero host identifier. Using \"%{network_normalized}\".",
    ["new_host_pool"] = "New Host Pool",
    ["new_pool"] = "New Pool",
    ["no_hosts_defined"] = "No host pool defined.",
    ["no_pools_defined"] = "No Host Pools defined.",
    ["per_member_quotas"] = "When the per-member quotas option is set, each host will have a separate quota count. When unset, all the hosts traffic will count as a whole to the quota limit",
    ["per_member_shapers"] = "When the per-member shapers option is set, each host will its own shapers. When unset, all the hosts belonging to the same pool will share the same shapers",
    ["pool"] = "Pool Name",
    ["pool_name"] = "Pool Name",
    ["pool_name_pattern_error"] = "Please enter only lowercase characters, numbers or underscore",
    ["remove_member"] = "Remove Member",
    ["remove_member_pool"] = "Are you really sure to remove the member: '%{member}' from the pool '%{pool}'?",
    ["reset_quotas"] = "Reset Quotas",
    ["search_member"] = "Search Member",
    ["select_host_pool"] = "Current <b>Host Pool</b>",
    ["select_member_type"] = "Select a member type",
    ["select_new_pool"] = "Select a new pool from the dropdown below to assign member \"%{member}\" to:",
    ["specify_member_address"] = "Please specify an IPv4/IPv6 address or network or a MAC address",
    ["specify_pool_name"] = "Specify a pool name",
    ["type_valid"] = "Type a valid %input",
    ["view"] = "View",
    ["validation"] = {
      ["abort_add_member"] = "Abort add new Host Pool Member?",
      ["abort_add_pool"] = "Abort add new pool?",
      ["abort_edit_pool"] = "Abort edit pool?",
    },
  },
  ["hosts_comparison"] = {
    ["hosts_parameter_missing_message"] = "Hosts parameter is missing (internal error ?)",
  },
  ["hosts_stats"] = {
    ["all"] = "All",
    ["all_hosts"] = "All Hosts",
    ["as_geolocation"] = "AS Geolocation",
    ["as_info"] = "AS Info",
    ["as_path"] = "AS Path",
    ["as_prefixes"] = "AS Prefixes",
    ["asn_title"] = "for AS %{asn}",
    ["bgp_updates"] = "BGP Updates",
    ["blacklisted"] = "Blacklisted",
    ["blacklisted_hosts_only"] = "Blacklisted Hosts Only",
    ["blocking_traffic_policy_popup_msg"] = "Host traffic is affected by a blocking Traffic Policy",
    ["broadcast_domain_hosts_only"] = "Broadcast Domain Hosts Only",
    ["country_title"] = "for Country %{country}",
    ["filter_hosts"] = "Filter Hosts",
    ["filtered"] = "Filtered",
    ["filtered_hosts_only"] = "Hosts With Blocked Traffic",
    ["host_pool"] = "Host Pool %{pool_name}",
    ["hosts"] = "Hosts",
    ["hosts_list"] = "Hosts List",
    ["hosts_page_title"] = "%{all} %{traffic_type} %{local_remote} %{protocol} %{network_cidr} %{network} %{ip_version} %{os} Hosts %{country_asn_or_mac} %{vlan}",
    ["idle_hosts_not_listed"] = "Idle hosts not listed.",
    ["in_network"] = "%{network}",
    ["ipver_title"] = "IPv%{version_num}",
    ["label_blacklisted_host"] = "Blacklisted",
    ["label_broadcast_domain_host"] = "Broadcast Domain",
    ["label_local_host"] = "Local",
    ["label_remote_host"] = "Remote",
    ["local"] = "Local",
    ["local_hosts_only"] = "Local Hosts Only",
    ["location"] = "Location",
    ["mac_title"] = "with Mac %{mac}",
    ["more_info_about_as_popup_msg"] = "More Information about AS",
    ["pool_title"] = "for Pool %{poolname}",
    ["remote"] = "Remote",
    ["remote_hosts_only"] = "Remote Hosts Only",
    ["source_id"] = "Source Id",
    ["traffic_type_all"] = "All Hosts",
    ["traffic_type_one_way"] = "One-Way Traffic",
    ["traffic_type_two_ways"] = "Bidirectional Traffic",
    ["user"] = "User %{pool_name}",
    ["user_title"] = "for User %{poolname}",
    ["vlan_title"] = "VLAN %{vlan}",
  },
  ["http_page"] = {
    ["distribution"] = "Distribution",
    ["http_queries"] = "HTTP Queries Sent",
    ["http_responses"] = "HTTP Responses Received",
    ["method"] = "Method",
    ["other_method"] = "Other Method",
    ["requests"] = "Requests",
    ["requests_served"] = "Requests Served",
    ["response_code"] = "Response code",
    ["response_code_1xx"] = "1xx (Informational)",
    ["response_code_2xx"] = "2xx (Success)",
    ["response_code_3xx"] = "3xx (Redirection)",
    ["response_code_4xx"] = "4xx (Client Error)",
    ["response_code_5xx"] = "5xx (Server Error)",
    ["responses"] = "Responses",
    ["traffic_received"] = "Traffic Received",
    ["traffic_sent"] = "Traffic Sent",
    ["virtual_hosts"] = "Virtual Hosts",
  },
  ["http_servers_stats"] = {
    ["actual_requests"] = "Actual Requests",
    ["bytes_received"] = "Bytes Received",
    ["bytes_sent"] = "Bytes Sent",
    ["http_server_ip"] = "HTTP Server IP",
    ["http_servers"] = "Server HTTP",
    ["http_virtual_host"] = "HTTP Virtual Host",
    ["local_http_servers"] = "Local HTTP Servers",
    ["total_requests"] = "Total Requests",
  },
  ["http_status_code"] = {
    ["bad_request"] = "The URL specified contains invalid/dangerous characters",
    ["enterprise_only"] = "Enterprise edition license required",
    ["forbidden"] = "Forbidden page",
    ["internal_error"] = "Internal server error",
    ["not_found"] = "The requested page cannot be found",
    ["pro_only"] = "Professional edition license required",
    ["shut_start"] = "Unable to serve requests at this time, possibly starting up or shutting down",
  },
  ["icmp_page"] = {
    ["icmp_code"] = "Code",
    ["icmp_message"] = "ICMP Message",
    ["icmp_port_unreachable_extra"] = "%{unreach_protocol} port %{unreach_port} unreachable on %{unreach_host}",
    ["icmp_type"] = "Type",
    ["last_rcvd_peer"] = "Last Rcvd Peer",
    ["last_sent_peer"] = "Last Sent Peer",
    ["packets_received"] = "Packets Received",
    ["packets_sent"] = "Packets Sent",
  },
  ["if_stats_config"] = {
    ["companion_interface"] = "Companion Interface",
    ["custom_name"] = "Custom Name",
    ["custom_name_popup_msg"] = "Specify an alias for the interface",
    ["discard_probing_traffic"] = "Discard Probing Traffic",
    ["dump_flows_to_database"] = "Dump Flows to Database",
    ["flows_only_interface"] = "Flows-Only Interface (requires restart)",
    ["hide_from_top_networks"] = "Hide from Top Networks",
    ["hide_from_top_networks_descr"] = "e.g. %{example}",
    ["interface_network_discovery"] = "Periodic Interface Network Discovery",
    ["interface_speed"] = "Interface Speed",
    ["interface_speed_measure_unit"] = "(Mbit/s)",
    ["interface_speed_popup_msg"] = "Specify the maximum interface speed",
    ["interface_top_talkers_creation"] = "Create Interface Top Talkers",
    ["is_mirrored_traffic"] = "Mirrored Traffic",
    ["referesh_rate_measure_unit"] = "(sec)",
    ["refresh_rate"] = "Realtime Stats Refresh Rate",
    ["refresh_rate_popup_msg"] = "Specify the stats refresh rate for the interface",
    ["scaling_factor"] = "Ingress Packets Sampling Rate",
    ["scaling_factor_popup_msg"] = "This should match your capture interface sampling rate",
    ["show_dyn_iface_traffic"] = "Duplicate Disaggregated Traffic",
    ["show_dyn_iface_traffic_note"] = "By enabling this option, traffic directed to dynamic or custom sub-interfaces is still shown in the master interface",
    ["trigger_interface_alerts"] = "Trigger Interface Alerts",
  },
  ["if_stats_networks"] = {
    ["note_ghost_bcast_domains"] = "The %{ghost_icon} highlights ghost broadcast domains (i.e. not belonging to any of the interface IP addresses networks).",
    ["note_iface_addresses"] = "IP addresses are read from the interface configuration.",
    ["note_iface_bcast_domains"] = "Broadcast domains are inferred by inspecting ARP traffic.",
  },
  ["if_stats_overview"] = {
    ["active"] = "Active",
    ["alert_events"] = "Alert Events",
    ["all_counters"] = "All Counters",
    ["blocked_flows"] = "Blocked Flows",
    ["bridged_traffic"] = "Bridged Traffic",
    ["buffer_full"] = "Buffer Full",
    ["collected_flows"] = "Collected Flows",
    ["collected_logs"] = "Collected Logs",
    ["conntrack_flow_entries"] = "Conntrack Flow Entries",
    ["direct_mode"] = "Direct Mode",
    ["discarded_probing_traffic"] = "Discarded Probing Traffic",
    ["dispatched_logs"] = "Dispatched Events",
    ["dropped_alerts_info"] = "Number of non-engaged alerts which could not be written to disk because of a full alerts queue.",
    ["dropped_flows"] = "Dropped Flows",
    ["dropped_packets"] = "Dropped Packets",
    ["drops_only"] = "Drops Only",
    ["dumped_files"] = "Dumped Files",
    ["dumped_packets"] = "Dumped Packets",
    ["egress_packets"] = "Egress Packets",
    ["export_disabled"] = "Flows Export Disabled in Runtime Preferences",
    ["exported_flows"] = "Exported Flows",
    ["family"] = "Family",
    ["flows_export_statistics"] = "Flows Export Statistics",
    ["handled_logs"] = "Detected Events",
    ["has_traffic_directions"] = "with RX/TX Directions",
    ["host_correlations"] = "Host Correlations",
    ["id"] = "Id",
    ["iface_switch_active_msg"] = "The selected interface <b>%{interface}</b> [ifid: %{ifid}] is now active",
    ["iface_switch_empty_session_msg"] = "Empty session",
    ["iface_switch_error_msg"] = "Error while switching interfaces",
    ["in_path_interface"] = "In-Path Interface (Bump in the Wire)",
    ["ingress_packets"] = "Ingress Packets",
    ["ingress_traffic"] = "Ingress Traffic",
    ["interface_ip"] = "Interface IP",
    ["interface_name"] = "Interface",
    ["interface_rx_updates"] = "Interface Updates",
    ["malformed_logs"] = "Malformed Logs",
    ["nf"] = "Netfilter",
    ["nf_enobufs"] = "No Buffer Space",
    ["nf_handle_packet_failed"] = "Queued Packets Handling Failures",
    ["nf_queue_dropped"] = "Dropped Packets (Queue Full)",
    ["nf_queue_pct"] = "Queue Fill Level",
    ["nf_queue_total"] = "Queued Packets",
    ["nf_queue_user_dropped"] = "Dropped Packets (Couldn't Send to Userspace)",
    ["note"] = "NOTE",
    ["note_drop_ifstats_dynamic"] = "Drops are available in the main interface",
    ["note_drops_sflow"] = "Drops are shown only for sFlow as NetFlow does not report them.<br><A HREF=https://www.ietf.org/rfc/rfc3176.txt>sFlow</A> drops count the number of times the sFlow agent detected that a packet marked to be sampled was dropped due to lack of resources. The drops counter reports the total number of drops detected since the agent was last reset. A high drop rate indicates that the management agent is unable to process samples as fast as they are being generated by hardware. Increasing the sFlow sampling rate will reduce the drop rate. Note: An agent that cannot detect drops will always report zero.",
    ["note_packets"] = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble (7 bytes), start of frame (1 byte), CRC (4 bytes), and <A HREF=\"http://en.wikipedia.org/wiki/Interframe_gap\">IFG</A> (12 bytes)]. Such overhead needs to be accounted to the interface traffic, but it is not added to the traffic being exchanged between IP addresses. This is because such data contributes to interface load, but it cannot be accounted in the traffic being exchanged by hosts, and thus expect little discrepancies between host and interface traffic values.",
    ["note_probe_zmq_drops_export_queue_full"] = "Remote probe has successfully processed these flows but is was unable to enqueue them for the export as the export queue was full.",
    ["note_probe_zmq_drops_flow_collection_drops"] = "nProbe-dropped collected flow packets (NetFlow v9) or dropped flows (NetFlow v5/IPFIX)",
    ["note_probe_zmq_drops_flow_collection_udp_socket_drops"] = "Dropped flow packets on the nProbe collection socket",
    ["note_probe_zmq_timeout_lifetime"] = "Flow lifetime duration as advertised by nProbe and the real lifetime computed on collected flows.",
    ["note_remote_probe_time"] = "Difference in seconds between ntopng time and remote nProbe time: ideally it should be close to zero. If too large please sync nProbe/ntopng time",
    ["paused"] = "Paused",
    ["probe_ip"] = "Probe IP",
    ["probe_throughput"] = "Probe Throughput",
    ["probe_timeout_idle"] = "Idle Timeout",
    ["probe_timeout_lifetime"] = "Lifetime Timeout",
    ["probe_zmq_drops_export_queue_full"] = "Queue Full Dropped Flows",
    ["probe_zmq_drops_flow_collection_drops"] = "Flow Collection Drops",
    ["probe_zmq_drops_flow_collection_udp_socket_drops"] = "Collection Socket Drops",
    ["probe_zmq_num_endpoints"] = "Active Probe ZMQ Endpoints",
    ["probe_zmq_num_flow_exports"] = "Exported Flows",
    ["public_probe_ip"] = "Public Probe IP",
    ["received_traffic"] = "Received Traffic",
    ["remote_flow_lifetime"] = "Flow Lifetime",
    ["remote_probe"] = "nProbe",
    ["remote_probe_collector_mode"] = "Collector Mode",
    ["remote_probe_time"] = "nProbe Time Drift",
    ["reset_counters"] = "Reset Counters",
    ["rrd_timeseries"] = "RRD Timeseries",
    ["send_error"] = "Send Error",
    ["sflow_counter_updates"] = "Counter Updates",
    ["shaped_filtered_packets"] = "Shaped/Filtered Packets",
    ["snmp"] = "SNMP",
    ["state"] = "State",
    ["syslog_statistics"] = "Syslog Collection Statistics",
    ["traffic_breakdown"] = "Traffic Breakdown",
    ["traffic_statistics"] = "Traffic Statistics",
    ["unhandled_flows"] = "Unhandled Flows",
    ["unhandled_logs"] = "Unsupported Events",
    ["zmq_avg_msg_flows"] = "Average Flows per Message",
    ["zmq_encryption_public_key"] = "ZMQ Encryption Public Key",
    ["zmq_encryption_public_key_note"] = "If you are using nProbe as flows exporter, please add --zmq-encryption-key '%{key}' to the nProbe configuration.",
    ["zmq_message_drops"] = "Dropped ZMQ Messages",
    ["zmq_message_rcvd"] = "Collected ZMQ Messages",
    ["zmq_rx_statistics"] = "ZMQ Statistics",
  },
  ["index_page"] = {
    ["applications"] = "Applications",
    ["asns"] = "ASNs",
    ["dashboard"] = "Dashboard",
    ["hosts"] = "Hosts",
    ["live_update"] = "Live update",
    ["minute"] = "Minute",
    ["never"] = "Never",
    ["no_packet_warning"] = "No packet has been received yet on interface %{ifname}.<p>Please wait %{countdown} seconds until this page reloads.",
    ["refresh"] = "Refresh",
    ["refresh_frequency"] = "Refresh frequency",
    ["refresh_graph_popup_msg"] = "Refresh graph",
    ["seconds"] = "Seconds",
    ["senders"] = "Senders",
    ["top_flow_talkers"] = "Top Flow Talkers",
  },
  ["internals"] = {
    ["alert_drops"] = "Alerts Drops",
    ["alert_drops_descr"] = "Some of the alerts generated by this script have been dropped.",
    ["all_hash_tables"] = "All Hash Tables",
    ["all_periodic_activities"] = "All Periodic Activities",
    ["all_user_script_targets"] = "All User Script Targets",
    ["any_periodic_activity_issue"] = "Activities with Issues",
    ["chart_script_duration"] = "%{script} Duration",
    ["chart_script_rrds"] = "%{script} TS Stats",
    ["degraded_performance"] = "Degraded Performance",
    ["duration"] = "Duration",
    ["flow_calls_stats"] = "flow.lua Calls Stats",
    ["flow_lua_duration"] = "flow.lua Duration",
    ["hash_entries"] = "Hash Entries",
    ["hash_table"] = "Hash Table",
    ["hash_table_utilization"] = "Hash Table Utilization",
    ["hash_tables"] = "Hash Tables",
    ["high_idle_entries"] = "High number of idle entries",
    ["iface_hash_tables"] = "%{iface} Hash Tables",
    ["iface_periodic_scripts"] = "%{iface} Periodic Activities",
    ["in_progress_since"] = "In Progress Since",
    ["last_duration_ms"] = "Last Duration",
    ["last_num_calls"] = "Last Num Calls",
    ["last_start_time"] = "Last Start",
    ["last_start_time_ago"] = "%{time} ago",
    ["lua"] = "Lua",
    ["max_duration_ms"] = "Max Duration",
    ["max_duration_secs"] = "Max Duration",
    ["missed_idle"] = "Missed Idle",
    ["missed_periodic_update"] = "Missed Periodic Update",
    ["missed_proto_detected"] = "Missed Proto Detected",
    ["num_calls"] = "%{script} Num Calls",
    ["num_calls_vs_duration"] = "Lua Calls vs Duration",
    ["num_drops"] = "Points Dropped",
    ["num_failed_enqueues"] = "Failed Enqueues",
    ["num_missed_calls"] = "Num Missed Calls",
    ["num_writes"] = "Points Written",
    ["pending_periodic_update"] = "Pending Periodic Update",
    ["pending_proto_detected"] = "Pending Proto Detected",
    ["periodic_activities"] = "Periodic Activities",
    ["periodic_activities_descr"] = "Hover the mouse on any of the listed activites to read its description.",
    ["periodic_activities_last_start_time_descr"] = "Last Start indicates when the periodic activity was started the last time.",
    ["periodic_activities_max_duration_secs_descr"] = "Max Duration indicates how long a script is allowed to execute.",
    ["periodic_activities_not_shown"] = "Only periodic activities which have been scheduled at least once are shown.",
    ["periodic_activities_periodicity_descr"] = "Frequency indicates how often a periodic activity is scheduled for execution.",
    ["periodic_activities_rrd_descr"] = "TS stands for Timeseries.",
    ["periodic_activities_tot_not_executed_descr"] = "Not Executed counts the number of times a periodic activity wasn't scheduled for execution, either because it was already running (running slow) or already scheduled (no thread was available to execute it).",
    ["periodic_activities_tot_running_slow_descr"] = "Running Slow counts the number of times a periodic activity was taking too long to complete.",
    ["periodic_activity"] = "Periodic Activity",
    ["periodic_activity_issues"] = "Issues",
    ["periodicity"] = "Periodicity",
    ["queue"] = "Queue",
    ["queued"] = "Queued",
    ["queues"] = "Queues",
    ["rrd_drops"] = "TS Drops",
    ["script_deadline_exceeded"] = "Running Slow",
    ["script_deadline_exceeded_descr"] = "The script has taken too long to complete",
    ["script_duration"] = "%{script} Duration",
    ["script_not_executed"] = "Not Executed",
    ["script_not_executed_descr"] = "The script has been scheduled but has not been executed yet",
    ["script_num_calls"] = "%{script} Num Calls",
    ["script_stats"] = "%{script} vs Total",
    ["sleeping"] = "Sleeping",
    ["state_active"] = "Entries in Active State",
    ["state_idle"] = "Entries in Idle State",
    ["state_idle_vs_active"] = "Idle vs Active Entries",
    ["status_description"] = "A periodic activity can be in one of the following statuses:",
    ["status_queued_descr"] = "The activity has been scheduled but it isn't running yet",
    ["status_running_descr"] = "The activity is currently in execution",
    ["status_sleeping_descr"] = "The activity has completed and waiting for the next schedulation",
    ["successful_calls"] = "Successful Calls",
    ["system_iface_periodic_scripts"] = "System Periodic Activities",
    ["time_exceeded"] = "Time Exceeded",
    ["time_usage"] = "Time Utilization",
    ["timeseries_queue_length"] = "TS Queue Length",
    ["timeseries_queued_points"] = "Queued Points",
    ["timeseries_writes"] = "TS Writes",
    ["tot_not_executed"] = "Not Executed",
    ["tot_running_slow"] = "Running Slow",
    ["total_duration"] = "Total %{subdir} Scripts Duration",
    ["total_flow_duration"] = "Total Duration",
    ["total_num_calls"] = "Total %{subdir} Scripts Num Calls",
    ["total_stats"] = "Total %{subdir} Scripts Stats",
    ["user_script"] = "User Script",
    ["user_script_target"] = "Target",
    ["user_scripts"] = "User Scripts",
    ["work_completion"] = "Completion",
  },
  ["live_capture"] = {
    ["active_live_captures"] = "Live Captures",
    ["note"] = "Capture live traffic for host %{hostinfo}. The stream will automatically stop after 1 minute or 100k packets.",
  },
  ["live_traffic"] = {
    ["error_generic"] = "Generic Error",
    ["error_not_found"] = "Not found",
    ["error_not_granted"] = "Request not granted",
    ["modal_vlan_tagged_with_bpf_confirmation"] = "This host is VLAN-tagged. The BPF filter submitted, to properly match packets, must contain VLAN 51. The VLAN can be specified in the filter as <br> <pre>vlan %{vlan} and <i>...rest of the filter...</i></pre>",
    ["modal_vlan_tagged_with_bpf_continue"] = "Continue",
    ["modal_vlan_tagged_with_bpf_title"] = "Host pcap Download",
  },
  ["local_flow_matrix"] = {
    ["error_no_local_hosts"] = "No local hosts can be found",
    ["local_flow_matrix"] = "Local Flow Matrix",
    ["local_hosts_active_flows_matrix"] = "Local Hosts Active Flows Matrix",
  },
  ["local_hosts_stats"] = {
    ["criteria"] = "Criteria",
    ["looking_glass"] = "Looking Glass",
  },
  ["locales"] = {
    ["cz"] = "Czech",
    ["de"] = "German",
    ["en"] = "English",
    ["it"] = "Italian",
    ["jp"] = "Japanese",
    ["pt"] = "Portuguese",
  },
  ["login"] = {
    ["add_captive_portal_user"] = "Add Captive Portal User",
    ["add_web_user"] = "Add Web User",
    ["auth_success"] = "Authentication Successful",
    ["blacklisted_ip_notice"] = "Too many failed authentication attempts. Please retry in 5 minutes.",
    ["change_password"] = "Change Password",
    ["confirm_password"] = "Confirm Password",
    ["device_label"] = "Device Label",
    ["donation"] = "If you find %{product} useful, please support us by making a small <A href=\"%{donation_url}\">donation</A>. Your funding will help to run and foster the development of this project. Thank you.",
    ["enter_credentials"] = "Please enter your credentials for accessing this network.",
    ["informative_captive_join"] = "Access the Internet",
    ["informative_captive_portal_tos"] = "I have read and agreeed the <a target='_blank' href='%{url}'>terms of service</a>.",
    ["internet_redirecting"] = "We're redirecting you to the Internet...",
    ["license"] = "%{product} is released under <a href=\"%{license_url}\">%{license}</a>.",
    ["logging_out"] = "Logging out...",
    ["login"] = "Login",
    ["logout"] = "Logout",
    ["logout_message"] = "Are you sure you want to logout?",
    ["logout_user_x"] = "Logout %{user}",
    ["must_change_password"] = "Default admin password must be changed. Please enter a new password below.",
    ["password"] = "Password",
    ["password_mismatch"] = "Passwords do not match",
    ["password_not_valid"] = "Please specify a different password",
    ["password_pattern_error"] = "Please enter at least 5 valid characters.",
    ["password_ph"] = "Password (default admin)",
    ["passwords_dont_match"] = "Passwords don't match.",
    ["unable_to_login"] = "Unable to login?",
    ["unsupported_browser"] = "Your browser is not supported.<br>Please consider using a recent Firefox or Chrome.",
    ["username"] = "Username",
    ["username_ph"] = "Username (default admin)",
    ["web_users"] = "Web Users",
    ["welcome_to"] = "Welcome to %{product}",
  },
  ["mac_details"] = {
    ["and_n_more_hosts"] = "<a href='%{host_url}'>%{host_label}</a> and <a href='%{url}'>%{num} more hosts</a>",
    ["and_one_more_host"] = "<a href='%{host_url}'>%{host_label}</a> and <a href='%{url}'>1 more host</a>",
    ["json_error_inactive"] = "JSON Error: inactive host purged or %{product} terminated?",
    ["mac"] = "Mac",
    ["mac_cannot_be_found_message"] = "Mac %{mac} cannot be found.",
    ["mac_host"] = "<a href='%{host_url}'>%{host_label}</a>",
    ["mac_parameter_missing_message"] = "Mac parameter is missing (internal error ?)",
    ["reset_mac_stats"] = "Reset Mac Stats",
    ["reset_mac_stats_note"] = "<b>NOTE</b>: historical charts for this mac address may have a gap after the reset.",
    ["reset_stats_in_progress"] = "Mac statistics will be reset within 5 seconds",
  },
  ["mac_stats"] = {
    ["all_devices"] = "All",
    ["all_layer_2_devices"] = "All Devices",
    ["all_manufacturers"] = "All Manufacturers",
    ["arp_total"] = "ARP",
    ["dev_layer_2_devices"] = "%{device_type} Devices",
    ["dhcp_only"] = "DHCP Only",
    ["filter_macs"] = "Filter Macs",
    ["idle_devices_not_listed"] = "Idle devices not listed.",
    ["layer_2_dev_devices"] = "%{device_type} Devices",
    ["layer_2_devices_with_manufacturer"] = "%{manufacturer} %{title}",
    ["layer_2_source_devices"] = "%{device_type} Devices",
    ["manufacturer"] = "Manufacturer",
    ["source_macs"] = "Source Only",
  },
  ["manage_configurations"] = {
    ["active_monitoring"] = "Active monitoring",
    ["after_reset_request"] = "<b>Restart</b> %{product} to make the configuration factory reset effective.",
    ["config_import"] = "Import <span class='item'>{{ type }}</span> Configuration",
    ["everything"] = "Entire %{product} configuration (includes users, preferences, and all configurations below)",
    ["manage_configuration"] = "Manage Configuration",
    ["manage_configurations"] = "Manage Configurations",
    ["notifications"] = "Endpoints and Recipients",
    ["pool_endpoint_recipients"] = "Pools (includes SNMP, active monitoring, user scripts, endpoints and recipients)",
    ["snmp"] = "SNMP",
    ["user_scripts"] = "User scripts",
    ["factory_reset"] = {
      ["body"] = "Reset configuration to factory. All custom changes will be lost.",
      ["title"] = "Reset <span class='selected-item'>%{reset_element}</span> Configuration",
    },
    ["import_modal"] = {
      ["all_title"] = "Import %{product} Configuration",
      ["title"] = "Import <span class='selected-item'>%{import_element}</span> Configuration",
    },
    ["messages"] = {
      ["import_success"] = "The selected configuration has been imported successfully!",
      ["reset_all_success"] = "Factory reset request issued successfully. Please <b>restart %{product}</b> to make the configuration factory reset effective.",
      ["reset_success"] = "The selected configuration has been reset successfully!",
    },
  },
  ["manage_data"] = {
    ["all_hosts"] = "All",
    ["delete"] = "Delete Host Data",
    ["delete_active_interface"] = "Delete Interface Data",
    ["delete_inactive_interfaces"] = "Delete Inactive Interfaces Data",
    ["delete_system_interface_data"] = "Delete System Interface Data",
    ["delete_tab"] = "Delete",
    ["export"] = "Export Host Data",
    ["export_tab"] = "Export",
    ["hosts"] = "Hosts",
    ["inactive_interfaces_data"] = "Inactive Interfaces",
    ["inactive_interfaces_description"] = "Manage data of <b>Inactive Interfaces</b>, you can delete cached info about these interfaces.<br><br>The button below is enabled when inactive interfaces are configured.",
    ["ip_or_mac_address"] = "IP or MAC Address or /24",
    ["local_hosts"] = "Local",
    ["mac_or_ip_required"] = "Please insert a valid IP or MAC Address",
    ["manage_data"] = "Manage Data",
    ["remote_hosts"] = "Remote",
    ["single"] = "Single",
    ["system_interface_data"] = "System Interface",
    ["system_interface_description"] = "Manage cached data of the <b>System Interface</b>, you can delete the data to free up some space.<br><br>The button below is enabled when there is no delete pending request.",
    ["system_interface_note"] = "System Interface Data includes all the data located under the \"System\" menu entry, for example CPU, InfluxDB and SNMP data.",
  },
  ["manage_users"] = {
    ["add_new_user"] = "Add New User",
    ["administrator"] = "Administrator",
    ["allow_pcap_download"] = "Allow pcap Download",
    ["allow_pcap_download_descr"] = "Allow the user to download live traffic and pcap's",
    ["allowed_interface"] = "Allowed Interface",
    ["allowed_networks"] = "Allowed Networks",
    ["allowed_networks_descr"] = "Comma separated list of networks this user can view. Example:",
    ["allowed_passwd_charset"] = "Allowed characters are ISO 8859-1 (latin1) upper and lower case letters, numbers and special symbols",
    ["any_interface"] = "Any Interface",
    ["authentication_lifetime"] = "Authentication Lifetime",
    ["change_user_password"] = "Change User Password",
    ["change_user_preferences"] = "Change User Preferences",
    ["confirm_delete_user"] = "Are you sure you want to delete %{user}?",
    ["enable_captive_portal"] = "<a href=\"%{url}\">Enabling the captive portal</a> allows you to define captive portal users",
    ["expires_after"] = "Expires after",
    ["group"] = "Group",
    ["host_pool_id"] = "Host Pool Id",
    ["manage"] = "Manage",
    ["manage_user_x"] = "Manage User %{user}",
    ["manage_users"] = "Users",
    ["new_password"] = "New Password",
    ["new_password_confirm"] = "Confirm New Password",
    ["no_host_pools"] = "No Host Pools defined. Please create one <a href='%{url}'>here</a>",
    ["non_privileged_user"] = "Non Privileged User",
    ["old_password"] = "Old Password",
    ["the_auth_can_be_perpetual"] = "The authentication can be perpetual or can expire after the specified time",
    ["the_host_pool_associated"] = "The host pool that will be associated to the user upon successful authentication",
    ["unlimited"] = "Unlimited",
    ["user_role"] = "User Role",
    ["web_captive_users"] = "Web/Captive Portal Users",
  },
  ["metrics"] = {
    ["days"] = "Days",
    ["hours"] = "Hours",
    ["mins"] = "Mins",
    ["minutes"] = "Minutes",
    ["secs"] = "Secs",
  },
  ["ndpi_categories"] = {
    ["Advertisement"] = "Advertisement",
    ["Allowed_Site"] = "Allowed Site",
    ["Antimalware"] = "Antimalware",
    ["Banned_Site"] = "Banned Site",
    ["Chat"] = "Chat",
    ["Cloud"] = "Cloud",
    ["Collaborative"] = "Collaborative",
    ["DataTransfer"] = "DataTransfer",
    ["Database"] = "Database",
    ["Download-FileTransfer-FileSharing"] = "Download-FileTransfer-FileSharing",
    ["Email"] = "Email",
    ["FileSharing"] = "FileSharing",
    ["Game"] = "Game",
    ["Malware"] = "Malware",
    ["Media"] = "Media",
    ["Mining"] = "Mining",
    ["Music"] = "Music",
    ["Network"] = "Network",
    ["Productivity"] = "Productivity",
    ["RPC"] = "RPC",
    ["RemoteAccess"] = "RemoteAccess",
    ["Shopping"] = "Shopping",
    ["Site_Unavailable"] = "Site Unavailable",
    ["SocialNetwork"] = "SocialNetwork",
    ["SoftwareUpdate"] = "SoftwareUpdate",
    ["Streaming"] = "Streaming",
    ["System"] = "System",
    ["Unspecified"] = "Unspecified",
    ["VPN"] = "VPN",
    ["Video"] = "Video",
    ["VoIP"] = "VoIP",
    ["Web"] = "Web",
  },
  ["ndpi_page"] = {
    ["custom_applications"] = "Custom Applications",
    ["live_flows_count"] = "Live Flows Count",
    ["note"] = "NOTE",
    ["note_historical_per_protocol_traffic"] = "Historical %{what} traffic data can be enabled via the <a href='%{url}'>%{flask_icon} Preferences</a>.",
    ["note_live_flows_chart"] = "This chart depicts only TCP connections.",
    ["note_possible_probing_alert"] = "An icon like %{icon} indicates a possible probing (or application server down) alert as the host has received traffic for a specific application without sending back any data. You can use <A HREF='%{url}'>historical reports</A> to drill-down this issue.",
    ["note_protocol_usage_time"] = "Application usage time is computed on discrete slot intervals.",
    ["num_contacted_services_as_client"] = "Client Contacted Services",
    ["num_contacted_services_as_client_descr"] = "(TLS, HTTP and DNS names)",
    ["overview"] = "%{what} Overview",
    ["rcvd"] = "Rcvd",
    ["received_only"] = "Received only",
    ["sent"] = "Sent",
    ["sent_only"] = "Sent only",
    ["total_since_startup"] = "Total (Since Startup)",
    ["unable_to_find_host"] = "Unable to find %{host_ip} (data expired ?)",
  },
  ["nedge"] = {
    ["a_member_address_is"] = "A member address is a rule to assign devices to a user. The following order applies:",
    ["a_zero_quota_is_unlimited"] = "A zero quota means unlimited traffic.",
    ["active_user"] = "Active User",
    ["add_gateway"] = "Add Gateway",
    ["add_member"] = "Add Member",
    ["add_port_forwarding_rule"] = "Add Port Forwarding Rule",
    ["add_routing_policy"] = "Add Routing Policy",
    ["add_some_gateways_first"] = "No gateways defined. Please define some gateways <a href=\"%{url}\">here</a>.",
    ["add_static_lease"] = "Add Static Lease",
    ["add_static_route"] = "Add Static Route",
    ["add_system_user"] = "Add System User",
    ["add_user_member"] = "Add User Member",
    ["applied_policy"] = "Applied Policy",
    ["apply_and_reboot"] = "Apply and Reboot",
    ["apply_and_restart_self"] = "Apply and Restart",
    ["apply_configuration"] = "Apply Configuration",
    ["apply_configuration_and_reboot"] = "You are going to apply the new configuration. Network interfaces will be reconfigured according to the specified settings and the system will be rebooted. Wrong settings can cause the system to lose IP connectivity. Only proceed if you are extremely confident settings are correct.",
    ["apply_configuration_and_restart_self"] = "You are going to apply the new configuration. This will cause %{product} to restart and can cause this web GUI to becomes unresponsive for a few seconds.",
    ["apply_the_initial_device_configuration"] = "Apply the initial device configuration.",
    ["authentication_gui_and_captive_portal"] = "The authentication methods apply both to the %{product} gui and the <a href=\"%{url}\">Captive Portal</a> access.",
    ["bandwidth_allocation"] = "Bandwidth Allocation",
    ["bind_to_any"] = "Any Interface",
    ["bind_to_lan"] = "LAN Interface",
    ["cannot_rename_gateway"] = "Cannot rename gateway.",
    ["cannot_rename_policy"] = "Cannot rename policy.",
    ["cannot_rename_static_route"] = "Cannot rename static route.",
    ["captive_portal_other_methods"] = "The Captive Portal uses the authentication methods defined in the <a href=\"%{url}\">Authentication preferences</a> (e.g. Radius).",
    ["categories_policies"] = "Category Policies",
    ["configure_routing_policies"] = "Configure Routing Policies",
    ["configured_members"] = "Configured Members",
    ["confirm_delete_gateway"] = "Do you really want to delete gateway \"%{gw}\" ?",
    ["confirm_delete_policy"] = "Do you really want to delete policy \"%{policy}\" ?",
    ["confirm_delete_port_forwarding_rule"] = "Do you really want to delete the specified rule?",
    ["confirm_delete_static_lease"] = "Do you really want to delete \"%{hostname}\" static lease?",
    ["confirm_delete_static_route"] = "Do you really want to delete static route \"%{sr}\" ?",
    ["confirm_remove_member_from_user"] = "Do you really want to remove the member %{member} from user %{user}?",
    ["could_not_add_port_forwarding"] = "Could not add the port forwarding rule",
    ["custom"] = "Custom",
    ["custom_datetime"] = "Current Time",
    ["custom_datetime_descr"] = "Manually sets the date and time of the system.",
    ["custom_policy"] = "Custom Policy",
    ["data_reset"] = "Data Reset",
    ["data_reset_msg"] = "Do you really want to reset all the device data? Data include stored timeseries, flows, alerts, Redis caches and host counters. Device configuration and system setup won't be affected by the reset.<br>This will cause %{product} to restart and can cause this web GUI to becomes unresponsive for a few seconds.",
    ["date_time"] = "Date and Time",
    ["default_categories"] = "Default Category Policies",
    ["default_categories_with_a_defined_policy"] = "Default Custom Category Policies",
    ["default_categories_with_a_defined_quota"] = "Default Quota Category Policies",
    ["default_categories_with_policy_x"] = "Default %{x} Category Policies",
    ["default_gateway"] = "Default Gateway",
    ["default_policy"] = "Default Policy",
    ["default_protocols"] = "Default Application Policies",
    ["default_protocols_with_a_defined_policy"] = "Default Custom Application Policies",
    ["default_protocols_with_a_defined_quota"] = "Default Quota Application Policies",
    ["default_protocols_with_policy_x"] = "Default %{x} Application Policies",
    ["default_shaper"] = "Pass",
    ["default_shaper_descr"] = "The Default bandwidth percentage of the interface speed.",
    ["delete_gateway"] = "Delete Gateway",
    ["delete_policy"] = "Delete Policy",
    ["delete_port_forwarding_rule"] = "Delete Port Forwarding Rule",
    ["delete_static_lease"] = "Delete Static Lease",
    ["delete_static_route"] = "Delete Static Route",
    ["device_protocol_policy_has_higher_priority"] = "Device Policies have higher priority than the Application Policies.",
    ["device_protocols_blocked_warning"] = "Traffic will <b>not</b> be blocked because %{device_protocols_policies} are disabled",
    ["device_protocols_policies"] = "Device Policies",
    ["dhcp_disabled_warning"] = "If no other DHCP server is available in your network then your clients won't be able to connect automatically.",
    ["dhcp_first_ip"] = "First IP address",
    ["dhcp_first_ip_descr"] = "The first IP address of the DHCP address pool",
    ["dhcp_last_ip"] = "Last IP address",
    ["dhcp_last_ip_descr"] = "The last IP address of the DHCP address pool",
    ["dhcp_leases"] = "DHCP Leases",
    ["dhcp_server"] = "DHCP Server",
    ["dhcp_server_description"] = "Enable the DHCP server.",
    ["dhcp_server_not_enabled"] = "The DHCP server is not enabled. You can enabled it <a href=\"%{url}\">here</a>.",
    ["dns_configuration"] = "DNS Configuration",
    ["dns_server_preset"] = "DNS Server Preset",
    ["dns_server_preset_descr"] = "You can select a featured DNS servers from the list or specify your custom DNS servers.",
    ["download_description"] = "The maximum download speed for the interface.",
    ["download_speed"] = "Download Speed",
    ["edit_gateway"] = "Edit Gateway",
    ["edit_quotas"] = "Edit Quotas",
    ["edit_routing_policy"] = "Edit Routing Policy",
    ["edit_static_route"] = "Edit Static Route",
    ["edit_user"] = "Edit User",
    ["edit_users"] = "Edit Users",
    ["enable_device_protocols_policies"] = "Device Applications Policies",
    ["enable_interface"] = "Enable Interface",
    ["enable_interface_descr"] = "Enable or disable the network interface.",
    ["enable_nat"] = "Enable NAT",
    ["enable_nat_descr"] = "If enabled, the clients IP addresses will be maqueraded with the IP address of the WAN interface.",
    ["enforce_global_dns"] = "Enforce Global DNS",
    ["enforce_global_dns_description"] = "Enable DNS forging to force the devices to use the specified global DNS.",
    ["enternal_port_overlap"] = "External port overlaps with port %{port} assigned to %{ip}",
    ["external_port"] = "External Port (WAN)",
    ["external_port_or_range"] = "External port or port range",
    ["factory_reset"] = "Factory Reset",
    ["factory_reset_msg"] = "Do you really want to reset the device to its factory configuration? Any configuration and data will be lost.",
    ["filter_policies"] = "Filter Policies",
    ["gateway"] = "Gateway",
    ["gateway_exists"] = "Gateway %{gw} already exists.",
    ["gateway_interface_descr"] = "Specify the network interface to use to determine the gateway IP address",
    ["gateway_name"] = "Gateway Name",
    ["gateway_type"] = "Mode",
    ["gateway_type_address_descr"] = "Specify the IP address of the gateway.",
    ["gateway_x"] = "Gateway %{gw}",
    ["gateways"] = "Gateways",
    ["gateways_status"] = "Gateways Status",
    ["global_dns"] = "Global DNS",
    ["global_shapers_rates"] = "Global Bandwidth Control",
    ["high_priority"] = "High Priority",
    ["higher_priority"] = "Higher Priority",
    ["hostname"] = "Hostname",
    ["hostname_lease_exists"] = "A static lease with hostname \"%{hostname}\" already exists.",
    ["interfaces_configuration"] = "Interfaces Configuration",
    ["internal_ip"] = "Internal IP (LAN)",
    ["internal_port"] = "Internal Port (LAN)",
    ["internal_port_number"] = "Internal port number",
    ["internal_port_overlap"] = "Internal port overlaps with %{internal_port} already mapped to external port %{external_port}",
    ["invalid_dhcp_range"] = "Invalid DHCP range. Ensure that the DHCP IP addresses are inside the LAN network range, otherwise your devices won't be able to surf the web.",
    ["invalid_port_range"] = "Invalid port range",
    ["ip_address_takes_preced"] = "An IP address takes precedence over a network address",
    ["ip_lease_exists"] = "A static lease with ip \"%{ip}\" already exists.",
    ["lan"] = "LAN",
    ["lan_ip_addr"] = "LAN IP Address",
    ["lan_ip_addr_descr"] = "Specify the LAN interface IP address.",
    ["lan_recovery_ip"] = "LAN Recovery IP",
    ["lan_recovery_ip_descr"] = "An additional IP address to reach the %{product} device on the LAN interface.",
    ["lan_recovery_warning"] = "Please ensure that this does not collide with any other defined network.",
    ["link_not_ready"] = "Link Not Ready",
    ["linkdown"] = "Link Down",
    ["low_priority"] = "Low Priority",
    ["lower_priority"] = "Lower Priority",
    ["mac_address_takes_preced"] = "A mac address takes precedence over an IP address",
    ["mac_lease_exists"] = "A static lease for mac \"%{mac}\" already exists.",
    ["max_bps_per_host"] = "Max %{bps} per Host",
    ["max_perc"] = "Max %{perc}%%",
    ["max_rrt"] = "Max RTT",
    ["max_rrt_description"] = "The maximum Round Trip Time toward the monitor address. If the measured RTT exceeds this value, the gateway is considered down.",
    ["maximum_enforced"] = "Maximum Enforced",
    ["maximum_enforced_descr"] = "If set to maximum enforced, the maximum bandwidth allocation will be enforced regardless of the available bandwidth.",
    ["member_address"] = "Member Address",
    ["member_exists"] = "Member %{member} not added, as it is already assigned to user %{existing_user}",
    ["members"] = "Members",
    ["members_for_user_x"] = "Members of User %{user}",
    ["min_perc"] = "Min %{perc}%%",
    ["minimum_guaranteed"] = "Minimum Guaranteed",
    ["minimum_guaranteed_descr"] = "If set to minimum guaranteed, only minimum bandwidth allocation will be guaranteed.",
    ["mode"] = "Mode",
    ["nedge"] = "nEdge",
    ["network_conf_dhcp"] = "DHCP",
    ["network_conf_iface_descr"] = "Specify the interface IP address mode.",
    ["network_conf_iface_gw"] = "IP address of the default gateway of the interface (e.g. 192.168.1.1).",
    ["network_conf_iface_ip"] = "IP address of the interface (e.g. 192.168.1.10).",
    ["network_conf_iface_nmask"] = "Network mask of the interface (e.g. 255.255.255.0).",
    ["network_conf_iface_title"] = "%{ifrole} Interface %{ifname}",
    ["network_conf_static"] = "Static",
    ["network_conf_vlan_trunk"] = "VLAN Trunk",
    ["no_gateways_defined"] = "No gateways defined.",
    ["no_interfaces_available"] = "No interfaces available.",
    ["no_routing_policies_defined"] = "No routing policies defined",
    ["no_rules"] = "No Rules",
    ["no_static_leases"] = "No Static Leases",
    ["no_static_routes_defined"] = "No static route defined.",
    ["ntp_sync"] = "NTP Synchronization",
    ["ntp_sync_descr"] = "Toggle the synchronization with an NTP server.",
    ["per_ip_rates"] = "Per Host Bandwidth Control",
    ["ping_address"] = "Monitor Address",
    ["ping_address_description"] = "The address to monitor to verify the gateway status.",
    ["please_fill_out_this_field"] = "Please fill out this field.",
    ["policy_due_to_source"] = "%{policy} due to %{source}",
    ["policy_name"] = "Policy Name",
    ["port_forwarding"] = "Port Forwarding",
    ["power_off"] = "Power Off",
    ["power_off_confirm"] = "Do you want to power off the device?",
    ["priority_x"] = "Priority %{x}",
    ["product_status"] = "%{product} Status",
    ["protocol_policy_has_higher_priority"] = "Application Policies have higher priority than the Category Policies.",
    ["protocols_policies"] = "Application Policies",
    ["reboot"] = "Reboot",
    ["reboot_corfirm"] = "Do you want to reboot the device?",
    ["remote_assistance"] = "Remote Assistance",
    ["remove_all_members"] = "Remove All Members",
    ["remove_all_members_confirm"] = "Do you really want to remove all the members of user %{user}?",
    ["reset_and_reboot"] = "Reset and Reboot",
    ["reset_and_restart_self"] = "Reset and Restart",
    ["restrict_weg_gui_access_description"] = "Restrict the access to this management web GUI to make it accessible only from the LAN interface (more secure) or from any interface of the system (less secure).",
    ["restrict_weg_gui_access_title"] = "Management Web GUI Access",
    ["router"] = "Router",
    ["router_mode_requires_enterprise"] = "Router mode is only available in the nedge Enterprise edition.",
    ["routing"] = "Routing",
    ["routing_policies"] = "Routing Policies",
    ["routing_policy"] = "Routing Policy",
    ["routing_policy_exists"] = "Routing policy \"%{policy}\" already exists.",
    ["safe_search_description"] = "Use the Child Safe DNS to block inappropriate content.",
    ["search_categories"] = "Search Categories",
    ["search_protocols"] = "Search Applications",
    ["security"] = "Security",
    ["set_the_device_mode"] = "Set the device operating mode.",
    ["setup_apply"] = "Apply",
    ["setup_config_edited_descr"] = "Apply changes to make the new configuration effective or discard to keep using the current one.",
    ["setup_config_edited_title"] = "System configuration edited!",
    ["setup_discard"] = "Discard",
    ["setup_mode"] = "Operating Mode",
    ["setup_network"] = "Network",
    ["shapers"] = "Bandwidth Control",
    ["single_port_router"] = "Single Port Router",
    ["slow_pass_shaper_descr"] = "The Slow Pass bandwidth percentage of the interface speed.",
    ["slower_pass_shaper_descr"] = "The Slower Pass bandwidth percentage of the interface speed.",
    ["specify_a_protocol"] = "Specify an Application",
    ["static_dhcp_leases"] = "DHCP Server Static Leases",
    ["static_route_address_descr"] = "Specify the destination for the static route.",
    ["static_route_exists"] = "Static route %{sr} already exists.",
    ["static_route_is_local_descr"] = "Specify whether this is a static route to a local network. All hosts in a static route to a local network are treated as local hosts.",
    ["static_route_is_local_title"] = "Local Network Static Route",
    ["static_route_name"] = "Static Route Name",
    ["static_route_netmask_descr"] = "Specify the netmask to apply to the destination for the static route.",
    ["static_route_via_descr"] = "Specify the IP address to use as next hop for the static route.",
    ["static_route_x"] = "Static route %{sr}",
    ["static_routes"] = "Static Routes",
    ["static_routes_in_policies"] = "Static routes are applied to (and take precedence over) any of the defined <a href=\"%{url}\">Routing Policies</a>.",
    ["status_activate"] = "Activate",
    ["status_connected"] = "Connected",
    ["status_connecting"] = "Connecting",
    ["status_deactivate"] = "Deactivate",
    ["status_disabled"] = "Disabled",
    ["status_disconnected"] = "Disconnected",
    ["status_down"] = "Down",
    ["status_failed"] = "Failed",
    ["status_inactive"] = "Inactive",
    ["status_unreachable"] = "Unreachable",
    ["status_up"] = "Up",
    ["system_setup"] = "System Setup",
    ["system_users"] = "System Users",
    ["test_policies"] = "Test Policies",
    ["test_policies_page_description"] = "This page can be used to verify which will be the policies applied on the %{user} devices based on the current configuration.",
    ["the_fallback_policy"] = "The <a href=\"%{url}\">Fallback Policy</a> is applied when both the user and the global policy for a given application and its corresponding category are set to \"Default\".",
    ["the_not_assigned_user_contains"] = "The \"Not Assigned\" user can be used to define policies for devices which are not assigned to any user.",
    ["the_primary_dns_server"] = "The Primary DNS server",
    ["the_secondary_dns_server"] = "The Secondary DNS server",
    ["timezone"] = "Time Zone",
    ["timezone_descr"] = "Sets the time zone of the system.",
    ["upload_description"] = "The maximum upload speed for the interface.",
    ["upload_speed"] = "Upload Speed",
    ["user"] = "User",
    ["user_categories"] = "Category Policies for User %{user}",
    ["user_categories_with_a_defined_policy"] = "Custom Category Policies for User %{user}",
    ["user_categories_with_a_defined_quota"] = "Quota Category Policies for User %{user}",
    ["user_categories_with_policy_x"] = "%{x} Category Policies for User %{user}",
    ["user_category_policies"] = "User Category Policies",
    ["user_device_protocols"] = "Application Policies for %{user} Devices",
    ["user_protocols"] = "Application Policies for User %{user}",
    ["user_protocols_with_a_defined_policy"] = "Custom Application Policies for User %{user}",
    ["user_protocols_with_a_defined_quota"] = "Quota Application Policies for User %{user}",
    ["user_protocols_with_policy_x"] = "%{x} Application Policies for User %{user}",
    ["users_list"] = "Users List",
    ["view_quotas"] = "View Quotas",
    ["wan"] = "WAN",
    ["wan_interface"] = "WAN Interface",
    ["with_quota"] = "With Quota",
    ["x_shaper_per_host_descr"] = "The %{shaper} maximum per-host bandwidth allocation. 0 for unlimited.",
    ["you_can_assign_routing_policy"] = "You can assign routing policies to <a href=\"%{url}\">Users</a>.",
    ["you_can_assign_shapers_to_users_protocols"] = "You can assign bandwidth policies to <a href=\"%{url}\">Users</a> specific applications or set them globally as a <a href=\"%{url2}\">Fallback Policy</a>.",
    ["you_can_set_static_dhcp_lease_here"] = "You can configure static DHCP leases <a href=\"%{url}\">here</a>.",
    ["you_can_use_gateways_in_policies"] = "You can specify gateways priorities in <a href=\"%{url}\">Routing Policies</a>.",
    ["policy_source_labels"] = {
      ["policy_source_category"] = "Category Policy",
      ["policy_source_default"] = "Unknown",
      ["policy_source_device_protocol"] = "Device Application Policy",
      ["policy_source_pool"] = "Default Policy",
      ["policy_source_protocol"] = "Application Policy",
    },
  },
  ["network_alert_config"] = {
    ["trigger_alerts_for_network"] = "Trigger alerts for Network %{network}",
    ["trigger_network_alerts"] = "Trigger Network Alerts",
  },
  ["network_details"] = {
    ["network"] = "Network",
    ["network_alias"] = "Network Alias",
    ["network_parameter_missing_message"] = "Network parameter is missing (internal error?)",
    ["no_available_stats_for_network"] = "No available stats for network %{network}",
  },
  ["network_stats"] = {
    ["network_list"] = "Network List",
    ["network_name"] = "Network Name",
    ["networks"] = "Networks",
    ["networks_traffic_with_ipver"] = "%{networks} with IPv%{ipver} traffic",
    ["note_broader_network"] = "The broader network will not include hosts defined in smaller networks.",
    ["note_overlapping_networks"] = "<b>NOTE</b>: In case you have defined overlapping networks:",
    ["note_see_both_network_entries"] = "You will see both network entries in the above table.",
  },
  ["nindex"] = {
    ["max_results"] = "Max Results",
    ["run_query"] = "Run query",
    ["select_note"] = "Use * for all fields or a comma-separated list of fields (<field1>,<field2>,...)",
    ["time_range"] = "Time Range",
    ["where_note"] = "Use &lt;field&gt; &lt;operator&gt; &lt;value&gt; conditions, where &lt;operator&gt; could be &lt;, &gt;, =, !=. AND/OR operators are also allowed to combine conditions. Please use quotes for string fields (e.g. INFO='www.ntop.org')",
  },
  ["os_stats"] = {
    ["hosts_by_operating_system"] = "Hosts by Operating System",
  },
  ["packets_page"] = {
    ["arp_distribution"] = "ARP Distribution",
    ["ip_version_distribution"] = "IP Version Distribution",
    ["lost"] = "Lost",
    ["out_of_order"] = "Out of Order",
    ["received_distribution"] = "Received Distribution",
    ["retransmissions"] = "Retransmissions",
    ["sent_distribution"] = "Sent Distribution",
    ["sent_vs_rcvd_distribution"] = "Sent vs Rcvd Distribution",
    ["size_distribution"] = "Size Distribution",
    ["tcp_flags_distribution"] = "TCP Flags Distribution",
    ["tcp_flags_vs_arp_distribution"] = "TCP Flags / ARP Distribution",
    ["tcp_packets_analysis"] = "TCP Packets Analysis",
    ["version_vs_flags_distribution"] = "IP version vs TCP Flags Distribution",
  },
  ["peers_page"] = {
    ["host"] = "Host",
    ["no_active_flows_message"] = "No active flows have been observed for the specified host",
    ["top_peer_protocol"] = "Top Peer Applications",
    ["top_peers_for_host"] = "Top %{hostkey} Peers",
    ["traffic_volume"] = "Traffic Volume",
  },
  ["periodic_activities_descr"] = {
    ["5min.lua"] = "Iterates active hosts and writes their timeseries. Executes user scripts with 5 minutes granularity.",
    ["daily.lua"] = "Performs old data cleanup. Executes user scripts with daily granularity.",
    ["dequeue_flows_for_hooks.lua"] = "Handles the in-memory lifecycle of flows, hosts and other hash entries. Executes flow user scripts. Dumps flows to database.",
    ["discover.lua"] = "Runs requested and periodic network discoveries.",
    ["hourly.lua"] = "Executes user scripts with hourly granularity",
    ["housekeeping.lua"] = "Checks n2disk extraction jobs. Checks and reloads lists.",
    ["minute.lua"] = "Writes extended interface timeseries such applications. Writes timeseries for user scripts, pods, containers.  Executes user scripts with minute granularity.",
    ["notifications.lua"] = "Processes alert notifications, dispatching them to configured recipients.",
    ["periodic_user_scripts.lua"] = "Executes periodic user scripts.",
    ["second.lua"] = "Writes fundamental interface timeseries such as total traffic.",
    ["stats_update.lua"] = "Updates system stats (e.g., CPU load).",
    ["timeseries.lua"] = "Writes timeseries data to InfluxDB. Has no effect when InfluxDB is not used.",
  },
  ["please_wait_page"] = {
    ["command"] = "Command",
    ["database"] = "Database",
    ["host"] = "Host",
    ["id"] = "Id",
    ["info"] = "Info",
    ["operations_on_database_msg"] = "Operations currently performed on the database are the following: ",
    ["state"] = "State",
    ["time"] = "Time",
    ["user"] = "User",
    ["waiting_for_db_msg"] = "Database schema migration in progress, waiting for database <b>%{dbname}</b> to become operational. You will be redirected as soon as the database is ready. Depending on the size of the existing database, this operation can take a long time. Migrations are performed only once and only during major version upgrades. If in doubt, please contact the developers at <a href='mailto:info@ntop.org'>info@ntop.org</a>.",
  },
  ["plugins_overview"] = {
    ["action_view"] = "Open the user script source in the code editor",
    ["alert_key"] = "Alert Key",
    ["edition_only"] = "%{edition} Only",
    ["filters"] = "Filters",
    ["hooks"] = "Hooks",
    ["loaded_plugins"] = "Loaded Plugins",
    ["plugin"] = "Plugin",
    ["reload_plugins"] = "Reload Plugins",
    ["script"] = "Script",
    ["source_location"] = "Source Location",
    ["status_key"] = "Status Key",
    ["type"] = "Type",
  },
  ["policy_presets"] = {
    ["business"] = "Business",
    ["business_description"] = "A preset for business company employees",
    ["child"] = "Child",
    ["child_description"] = "A preset for children. Blocks social networks and limits game time",
    ["default"] = "Default",
    ["guests"] = "Guests",
    ["guests_description"] = "A preset for guests. Only basic navigation allowed",
    ["no_obfuscation"] = "No Obfuscation",
    ["no_obfuscation_description"] = "A preset to prevent traffic obfuscation",
    ["walled_garden"] = "Walled Garden",
    ["walled_garden_description"] = "Blocks VPN and Social Networks",
  },
  ["pool_details"] = {
    ["host_pool"] = "Host Pool",
    ["host_pool_timeseries_enable_message"] = "Host Pool timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
    ["no_available_data_for_host_pool_message"] = "No available data for Host Pool '%{pool_name}'.",
    ["pool_parameter_missing_message"] = "Parameter is missing (internal error ?)",
  },
  ["pool_stats"] = {
    ["host_pool_list"] = "Host Pool List",
  },
  ["pools"] = {
    ["config_import"] = "Import Configuration",
    ["config_import_message"] = "<b>Note</b>: pools with the same name will be replaced.",
    ["configuration"] = "User Scripts Configuration",
    ["edit_host_pool"] = "Edit Host Pool",
    ["edit_pools"] = "Edit Pools",
    ["edit_recipients"] = "Edit recipients",
    ["family"] = "Family",
    ["id"] = "ID",
    ["insert_name"] = "i.e. MyPool",
    ["members"] = "Members",
    ["name"] = "Name",
    ["name_requirements"] = "The name must be longer than 1 character and it can't be empty.",
    ["no_recipients"] = "No recipients configured for the above pool.",
    ["not_assigned"] = "Not Assigned",
    ["pool"] = "Pool",
    ["pools"] = "Pools",
    ["recipients"] = "Recipients",
    ["remove_pool"] = "Are you really sure to delete '%{pool}' pool?",
    ["select_config"] = "Select a User Scripts Configuration",
    ["some_recipients"] = "${recipients} recipient(s) configured for the above pool.",
    ["unbounded_members"] = "All unbound",
    ["pool_name"] = {
      ["active_monitoring"] = "Active Monitoring",
      ["flow"] = "Flow",
      ["host"] = "Host",
      ["host_pool"] = "Host Pool",
      ["interface"] = "Interface",
      ["local_network"] = "Local Network",
      ["mac"] = "Device",
      ["snmp_device"] = "SNMP Device",
      ["system"] = "System",
    },
    ["pool_names"] = {
      ["active_monitoring"] = "Active Monitoring",
      ["all"] = "All",
      ["flow"] = "Flows",
      ["host"] = "Hosts",
      ["host_pool"] = "Host Pool",
      ["interface"] = "Interfaces",
      ["local_network"] = "Local Networks",
      ["mac"] = "Devices",
      ["snmp_device"] = "SNMP Devices",
      ["system"] = "System",
    },
    ["pool_names_suffix"] = {
      ["active_monitoring"] = "Active Monitoring Pool",
      ["interface"] = "Interface Pool",
      ["local_network"] = "Local Network Pool",
      ["snmp"] = "SNMP Pool",
    },
  },
  ["port_details"] = {
    ["active_flows_for_host_and_port"] = "Active Flows for %{host}:%{port}",
    ["active_flows_on_port"] = "Active Flows on Port %{port}",
    ["active_flows_on_port_symbolic"] = "Active Flows on Port %{port} [%{symbolic_port}]",
    ["l4_port"] = "L4 Port",
  },
  ["ports_page"] = {
    ["client_ports"] = "Client Ports",
    ["num_contacted_ports"] = "Total Unique Port Contacts",
    ["num_contacted_ports_as_client"] = "Remote Contacted Ports (as Client)",
    ["num_host_contacted_ports_as_server"] = "Local Contacted Ports (as Server)",
    ["server_ports"] = "Server Ports",
  },
  ["prefs"] = {
    ["active_local_host_cache_interval_description"] = "Interval between consecutive active local hosts cache dumps. Default: 1 hour.",
    ["active_local_host_cache_interval_title"] = "Active Local Host Cache Interval",
    ["admin_group_description"] = "Group name to which user has to belong in order to authenticate as an administrator.",
    ["admin_group_title"] = "LDAP Admin Group",
    ["alert_entity"] = "Alert Entity",
    ["alerts_notifications"] = "Endpoints",
    ["alerts_retention"] = "Alerts Retention",
    ["alerts_settings"] = "Alerts Settings",
    ["all"] = "All",
    ["auth_methods_order"] = "The authentication methods check order is the same as the listing order above, e.g. if both LDAP and local auth are enabled, LDAP will be checked first and, if authentication fails, local auth will be checked next.",
    ["authentication"] = "Authentication",
    ["authentication_duration"] = "Authentication Duration",
    ["authentication_duration_descr"] = "Amount of time before the session of an authenticated user is terminated and re-authentication is necessary. Changes will affect newly-created sessions only.",
    ["authentication_duration_title"] = "Authenticated Session Duration",
    ["authentication_midnight_expiration_descr"] = "Toggles the termination of sessions at midnight, forcing all authenticated users to re-authenticate after midnight.",
    ["authentication_midnight_expiration_title"] = "Authenticated Session Termination at Midnight",
    ["behaviour"] = "Traffic Behaviour",
    ["bind_dn_description"] = "Bind Distinguished Name of LDAP server. Example:",
    ["bind_dn_title"] = "LDAP Bind DN",
    ["bind_pwd_description"] = "Bind password used for authenticating with the LDAP server.",
    ["bind_pwd_title"] = "LDAP Bind Authentication Password",
    ["both"] = "Both",
    ["cache_settings"] = "Cache Settings",
    ["captive_portal_url_description"] = "The URL your clients will be redirected to after a successful captive portal authentication.",
    ["captive_portal_url_title"] = "Redirection URL",
    ["client_x509_auth"] = "HTTPS Client Authentication",
    ["client_x509_auth_descr"] = "Toggle the authentication of clients on the basis of their X.509 certificate. When the client X.509 Common Name (CN) equals one of the %{product} users, then the client is authenticated as the %{product} user. Changes to this setting requires a %{product} restart.",
    ["client_x509_auth_title"] = "Client X.509 Certificate Authentication",
    ["could_not_contact_influxdb"] = "Could not contact the InfluxDB database: %{msg}",
    ["data_retention"] = "Data Retention",
    ["data_retention_descr"] = "Number of days to keep dumped flows, historical timeseries and top-talkers for. Default: 30 days.",
    ["default_snmp_community_description"] = "The default SNMP community is used when trying to walk the SNMP MIB of a selected local host that has not been configured through the SNMP devices page.",
    ["default_snmp_community_title"] = "Default SNMP Community",
    ["default_snmp_proto_version_description"] = "The default SNMP protocol version.",
    ["default_snmp_proto_version_title"] = "Default SNMP Version",
    ["default_snmp_timeout_description"] = "SNMP agent response timeout (seconds).",
    ["default_snmp_timeout_title"] = "SNMP Agent Response Timeout",
    ["device_identifier"] = "Device Identifier",
    ["device_identifier_descr"] = "Usually devices are identified by MAC address. However, if devices are behind a router, IP identification is desiderable instead.",
    ["disable_alerts_generation_description"] = "Toggle the overall generation of alerts.",
    ["disable_alerts_generation_title"] = "Enable Alerts",
    ["dns"] = "DNS",
    ["dns_service"] = "Service",
    ["dump_settings"] = "Flows Dump Settings",
    ["dynamic_interfaces_creation_description"] = "ntopng can use a criterion to disaggregate incoming traffic. When a disaggregation criterion is selected, ntopng will use the criterion value to divert incoming traffic to dynamically-created interfaces. For example, when the 'VLAN Id' criterion is selected, a dynamic interface will be created for each VLAN Id observed, and the incoming traffic will be diverted to one dynamic interface depending the VLAN Id value. ",
    ["dynamic_interfaces_creation_note_0"] = "'VLAN Id' disaggregation is supported both for physical interfaces as well as for flows received over ZMQ. The other disaggregation criteria are only supported for ZMQ flows and will be ineffective for physical interfaces.",
    ["dynamic_interfaces_creation_note_1"] = "Criterion changes will not affect existing interfaces. <b>A restart of ntopng is required for the change to have effect</b>.",
    ["dynamic_interfaces_creation_note_2"] = "When using the 'Ingress Interface' criterion on non-sflow devices, %%INPUT_SNMP must appear into the nprobe template.",
    ["dynamic_interfaces_creation_note_3"] = "'Interface' disaggregation criterion adds any flow to two dynamic interfaces. The value of %%INPUT_SNMP is used to select the first dynamic interface, whereas the value of %%OUTPUT_SNMP is used to select the second.",
    ["dynamic_interfaces_creation_note_4"] = "A custom traffic disaggregation by means of BPF-like filters is also available by disabling Dynamic Traffic Disaggregation (set it to 'None') through the Custom Traffic Disaggregation tab.",
    ["dynamic_interfaces_creation_title"] = "Dynamic Traffic Disaggregation",
    ["dynamic_network_interfaces"] = "Dynamic Network Interfaces",
    ["elasticsearch_notification"] = "Elasticsearch Notification",
    ["elasticsearch_send_error"] = "Cannot connect to Elasticsearch. [Response code: %{code}][Response: %{resp}].",
    ["elasticsearch_sent_successfully"] = "Elasticsearch connection is working.",
    ["elasticsearch_unable_to_send_alerts"] = "Unable to send alerts to the Elasticsearch",
    ["elasticsearch_unsupported_version"] = "Unsupported Elasticsearch version %{version}. Need at least version 7.",
    ["elephant_flow_local_to_remote_bytes_description"] = "The amount of data a flow can upload before being considered an Elephant Flow.",
    ["elephant_flow_local_to_remote_bytes_title"] = "Elephant Flows Threshold (Local To Remote)",
    ["elephant_flow_remote_to_local_bytes_description"] = "The amount of data a flow can download before being considered an Elephant Flow.",
    ["elephant_flow_remote_to_local_bytes_title"] = "Elephant Flows Threshold (Remote To Local)",
    ["email_notification"] = "Email Notification",
    ["email_notification_password_description"] = "The SMTP server password for authentication (optional).",
    ["email_notification_password_title"] = "Password",
    ["email_notification_recipient_description"] = "The recipient email address.",
    ["email_notification_recipient_title"] = "Recipient",
    ["email_notification_sender_description"] = "The sender email address.",
    ["email_notification_sender_title"] = "Sender",
    ["email_notification_server_description"] = "The SMTP server to deliver the email. As an example, if you are using GMail you need to specify smtps://smtp.gmail.com:465. Please note that GMail also requires the <a href='https://myaccount.google.com/lesssecureapps'>Access for less secure apps</a> to be enabled.",
    ["email_notification_server_title"] = "SMTP Server",
    ["email_notification_username_description"] = "The SMTP server username for authentication (optional).",
    ["email_notification_username_title"] = "Username",
    ["email_send_error"] = "Email send error: %{msg}. Please see the <a href='%{url}'>online documentation</a>.",
    ["email_sent_successfully"] = "Email sent successfully",
    ["errors"] = "Errors",
    ["errors_and_warnings"] = "Errors and Warnings",
    ["ewma_alpha_percent_description"] = "Exponentially Weighted Moving Average (EWMA) alpha coefficient, expressed as a percentage. Used to estimate Autonomous Systems round-trip time.",
    ["ewma_alpha_percent_title"] = "EWMA alpha coefficient (percent)",
    ["expert_view"] = "Expert View",
    ["featured_dns_description"] = "The following is a list of secure DNS servers. You can use them as a global DNS servers or as as Child Safe provider.",
    ["featured_dns_title"] = "Featured DNS Servers",
    ["flow_interface"] = "Interface",
    ["flow_max_idle_description"] = "Inactivity time after which a flow is considered idle. Only effective for packet interfaces. For ZMQ interfaces the timeout is determined automatically. Default: 1 min.",
    ["flow_max_idle_title"] = "Flow Idle Timeout",
    ["flows_dump"] = "Flows Dump",
    ["flows_dump_limited_days"] = "The Flow dump is limited to %{days} days in this ntopng version. Upgrade to the enterprise version to remove this limit.",
    ["global_dns_description"] = "A DNS server to redirect the clients DNS requests to for non Child Safe host pools. If empty, the redirection is disabled and the default DNS is used.",
    ["global_dns_title"] = "Global Primary DNS",
    ["gui"] = "User Interface",
    ["host_mask"] = "Mask Host IP Addresses",
    ["housekeeping_frequency_description"] = "Some host statistics such as throughputs are updated periodically. This timeout regulates how often %{product} will update these statistics. Larger values are less computationally intensive and tend to average out minor variations. Smaller values are more computationally intensive and tend to highlight minor variations. Values in the order of few seconds are safe. Only effective for packet interfaces. For ZMQ interfaces the timeout is determined automatically. Default: 5 seconds.",
    ["housekeeping_frequency_title"] = "Hosts Statistics Update Frequency",
    ["http_auth"] = "HTTP Authentication",
    ["http_auth_server_description"] = "The URL of the HTTP server to use to authenticate users.",
    ["http_auth_server_title"] = "HTTP Server",
    ["idle_timeout_settings"] = "Idle Timeout Settings",
    ["ignored_interfaces_description"] = "When 'Ingress Interface' is selected as disaggregation criterion, do not add to a dynamic interface any flow having its %%INPUT_SNMP in this list. When 'Interface' disaggregation is selected, do not add to the first (second) dynamic interface any flow having its %%INPUT_SNMP (%%OUTPUT_SNMP) in this list. Specify one or more comma-separated SNMP interface ids. Changes require %{product} restart.",
    ["ignored_interfaces_title"] = "Ignored interfaces",
    ["incompatible_influxdb_version_found"] = "Incompatible InfluxDB version: required \"%{required}\", found \"%{found}\". Please install an updated version from the <a href='%{url}'>official site</a>.",
    ["influxdb_auth_description"] = "Enable InfluxDB authentication.",
    ["influxdb_auth_title"] = "InfluxDB Authentication",
    ["influxdb_create_error"] = "Could not create \"%{db}\" database: %{msg}",
    ["influxdb_dbname_description"] = "The database to use for timeseries storage. Existing data will not be migrated.",
    ["influxdb_dbname_title"] = "InfluxDB Database",
    ["influxdb_password_description"] = "The password to authenticate with the InfluxDB database.",
    ["influxdb_query_timeout_description"] = "Maximum duration in seconds for the InfluxDB queries. Queries exeeding this duration will be aborted.",
    ["influxdb_query_timeout_title"] = "Query Timeout",
    ["influxdb_retention_error"] = "Could not set retention policy on database \"%{db}\": %{msg}",
    ["influxdb_storage_note"] = "<b>NOTE</b>: data will be purged at intervals of %{interval}, which corresponds to the InfluxDB <a href='%{url}'>shard duration</a>.",
    ["influxdb_url_description"] = "The URL pointing to a running InfluxDB instance.",
    ["influxdb_url_title"] = "InfluxDB URL",
    ["influxdb_username_description"] = "The username to authenticate with the InfluxDB database.",
    ["ingress_flow_interface"] = "Ingress Interface",
    ["ingress_vrf_id"] = "Ingress VRF Id",
    ["interfaces_timeseries"] = "Interfaces Timeseries",
    ["internal_log"] = "Internal Log",
    ["is_influxdb_running"] = "Is InfluxDB running?",
    ["l2_devices_timeseries"] = "Devices Timeseries",
    ["ldap_authentication"] = "LDAP Authentication",
    ["ldap_server_address_description"] = "IP address and port of LDAP server (e.g. ldaps://localhost:636). Default: \"ldap://localhost:389\".",
    ["ldap_server_address_title"] = "LDAP Server Address",
    ["license"] = "License",
    ["local_auth"] = "Local Authentication",
    ["local_host_cache_duration_description"] = "Time after which a cached local host is deleted from the cache. Default: 1 hour.",
    ["local_host_cache_duration_title"] = "Local Hosts Cache Duration",
    ["local_host_mask"] = "Mask Local Hosts",
    ["local_host_max_idle_description"] = "Inactivity time after which a local host is considered idle (sec). Idle local hosts are dumped to a cache so their counters can be restored in case they become active again. Counters include, but are not limited to, packets and bytes total and per Layer-7 application. Default: 5 min.",
    ["local_host_max_idle_title"] = "Local Host Idle Timeout",
    ["local_hosts_cache_settings"] = "Local Hosts Cache Settings",
    ["local_hosts_timeseries"] = "Local Hosts Timeseries",
    ["logging"] = "Logging",
    ["longlived_flow_duration_description"] = "The minimum duration for a flow to be considered a Long-Lived Flow.",
    ["longlived_flow_duration_title"] = "Long-Lived Flows Duration",
    ["max_num_alerts_per_entity_description"] = "The maximum number of alerts per alarmable entity. Alarmable entities are hosts, networks, interfaces. Alerts are checked periodically and, in case the actual number of alerts exceeds the maximum number for a given entity, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number. Default: 1024.",
    ["max_num_alerts_per_entity_title"] = "Maximum Number of Alerts per Entity",
    ["max_num_bytes_per_tiny_flow_description"] = "The maximum number of bytes a flow must have to be considered a tiny flow. Default: 64.",
    ["max_num_bytes_per_tiny_flow_title"] = "Maximum Number of Bytes per Tiny Flow",
    ["max_num_flow_alerts_description"] = "The maximum number of flow alerts. Alerts are checked periodically and, in case the actual number of flow alerts exceeds the configured maximum number, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number. Default: 16384.",
    ["max_num_flow_alerts_title"] = "Maximum Number of Flow Alerts",
    ["max_num_packets_per_tiny_flow_description"] = "The maximum number of packets a flow must have to be considered a tiny flow. Default: 3.",
    ["max_num_packets_per_tiny_flow_title"] = "Maximum Number of Packets per Tiny Flow",
    ["max_ui_strlen_description"] = "Shorten strings longer than the specified maximum number of characters.",
    ["max_ui_strlen_title"] = "Maximum Displayed String Length",
    ["mgmt_acl_description"] = "A comma-separated list of IPv4 networks. Each network must be explicitly allowed or disallowed with a leading \"+\" or \"-\" sign, respectively. The longest-match principle is used with overlapping networks. Examples: \"+127.0.0.0/8\" makes the interface accessible only from localhost, \"+0.0.0.0/0,-192.168.0.0/16\", makes the interface accessible for everybody except 192.168.0.0/16. Must restart %{product} for changes to have effect.",
    ["mgmt_acl_title"] = "Access Control List",
    ["misc"] = "Misc",
    ["multiple_ldap_account_type_description"] = "Choose your account type",
    ["multiple_ldap_account_type_title"] = "LDAP Accounts Type",
    ["multiple_timeseries_database_description"] = "The driver used for storing and retrieving timeseries data.",
    ["multiple_timeseries_database_title"] = "Timeseries Driver",
    ["mysql"] = "MySQL",
    ["n2disk_license_description"] = "Continuous traffic recording requires a n2disk license, purchase one at <a href=\"%{purchase_url}\">e-shop</a>. If you are no-profit, research or an education institution please read <a href=\"%{universities_url}\">this</a>. ",
    ["n2disk_license_description_enterprise_l"] = "ntopng Enterprise L already unlocks n2disk 1G, thus no additional license is required in that case.",
    ["n2disk_license_systemid"] = "SystemID: %{systemid}",
    ["n2disk_license_title"] = "n2disk License Key",
    ["n2disk_license_version"] = "n2disk version: %{version}",
    ["n2n_supernode_description"] = "The address of the <a href=\"%{url}\">n2n</a> <i class=\"fas fa-external-link-alt\"></i> supernode. Set up your own supernode in order to have a fully private remote access.<br><b>NOTE</b>: this change will have affect only after Remote Assistance restart.",
    ["n2n_supernode_title"] = "Supernode",
    ["network_discovery"] = "Network Discovery",
    ["network_discovery_interval_description"] = "Interval between consecutive discoveries of networks. Default: 15 min.",
    ["network_discovery_interval_title"] = "Active Network Discovery Interval",
    ["network_interfaces"] = "Network Interfaces",
    ["no_host_mask"] = "Don't Mask Hosts",
    ["non_local_host_max_idle_description"] = "Inactivity time after which a remote host is considered idle. Default: 1 min.",
    ["non_local_host_max_idle_title"] = "Remote Host Idle Timeout",
    ["none"] = "None",
    ["note_timeseries_resolution_disabled"] = "<b>NOTE</b>: this is disabled because \"%{pref}\" is not set to the default value.",
    ["note_update_frequency_disabled"] = "<b>NOTE</b>: this is disabled because of the \"%{pref}\" requirements.",
    ["other_timeseries"] = "Other Timeseries",
    ["per_category"] = "Per Category",
    ["per_protocol"] = "Per Application",
    ["policy_target_type"] = "Policy Target Type",
    ["policy_target_type_description"] = "Specify what kind of policy target you wish to apply.",
    ["posix"] = "Posix",
    ["preferences"] = "Preferences",
    ["primary_dns"] = "Primary DNS",
    ["probe_ip_address"] = "Probe IP",
    ["probe_ip_and_ingress_iface_idx"] = "Probe IP + Ingress Interface",
    ["protocols"] = "Applications",
    ["radius_admin_group_description"] = "The user is authenticated as admin when the value for the Filter-Id Attribute-Value pair returned by RADIUS matches the one specified in this field. When there is no match, the user is authenticated as unprivileged.",
    ["radius_admin_group_title"] = "RADIUS Admin Filter-Id",
    ["radius_auth"] = "RADIUS Authentication",
    ["radius_secret_descroption"] = "The shared secret to authenticate with the RADIUS server.",
    ["radius_secret_title"] = "RADIUS Secret",
    ["radius_server_description"] = "Host and port of the RADIUS server (e.g. %{example}).",
    ["radius_server_title"] = "RADIUS Server Address",
    ["recording"] = "Traffic Recording",
    ["remote_host_mask"] = "Mask Remote Hosts",
    ["report"] = "Report",
    ["restart_needed"] = "Please restart %{product} in order to apply the changes",
    ["runtime_prefs"] = "Runtime Preferences",
    ["safe_search_dns_description"] = "The DNS server to be used to perform <a href='%{url}'>Child Safe</a> queries.<br>Child Safe can be enabled for individual host pools from the host pools configuration page. Default: 208.67.222.123.",
    ["safe_search_dns_title"] = "Child Safe DNS",
    ["samaccount"] = "sAMAccount",
    ["search_path_description"] = "Root path used to search the users.",
    ["search_path_title"] = "LDAP Search Path",
    ["search_preferences"] = "Search Preferences",
    ["secondary_dns"] = "Secondary DNS",
    ["secondary_dns_description"] = "A fallback DNS server to use when the global primary DNS server is not available.",
    ["secondary_dns_title"] = "Global Secondary DNS",
    ["security_alerts"] = "Security Alerts",
    ["send_test_elasticsearch"] = "Test Connection",
    ["send_test_mail"] = "Send Test Email",
    ["send_test_slack"] = "Send Test Message",
    ["send_test_webhook"] = "Send Test Message",
    ["sender_username_description"] = "Set the username of the sender of slack notifications",
    ["sender_username_title"] = "Notification Sender Username",
    ["simple_view"] = "Simple View",
    ["slack_channel"] = "Slack Channel",
    ["slack_channel_names"] = "Channel Names",
    ["slack_channel_names_descr"] = "Configure the Slack channels where each alert will be sent. Channels must exist in order to correcly display the alert.",
    ["slack_integration"] = "Slack Integration",
    ["slack_notification_severity_preference_description"] = "Errors (errors only), Errors and Warnings (errors and warnings, no info), All (every kind of alerts will be notified).",
    ["slack_notification_severity_preference_title"] = "Notification Severity",
    ["slack_send_error"] = "Slack message send error.",
    ["slack_sent_successfully"] = "A Slack message has been sent to the #%{channel} channel.",
    ["slack_webhook_description"] = "Send your notification to this slack URL",
    ["slack_webhook_title"] = "Notification Webhook",
    ["snmp"] = "SNMP",
    ["snmp_alerts"] = "SNMP Alerts",
    ["snmp_port_load_threshold_description"] = "Set a threshold (as percentage of the port speed) to trigger alerts when the port load exceeds the specified limit (on a 5-min average).",
    ["snmp_port_load_threshold_title"] = "Interface Load Threshold Alerts",
    ["snmp_timeseries_config_link"] = "SNMP timeseries can be enabled from the <a href=\"%{url}\">SNMP section</a>.",
    ["stats_reset"] = "Stats Reset",
    ["status_alerts"] = "Status Alerts",
    ["successfully_connected_influxdb"] = "Successfully initialized database \"%{db}\" on InfluxDB(%{version})",
    ["syslog_alert_format_description"] = "Chose the syslog alerts output format.",
    ["syslog_alert_format_json"] = "JSON",
    ["syslog_alert_format_plaintext"] = "Plain Text",
    ["syslog_alert_format_title"] = "Syslog Alerts Format",
    ["syslog_notification"] = "Syslog Notification",
    ["syslog_sent_successfully"] = "A message has been logged",
    ["system_probes_timeseries"] = "Probes Timeseries",
    ["telemetry"] = "Telemetry",
    ["telemetry_contribute"] = "Contribute",
    ["telemetry_do_not_contribute"] = "Do not contribute",
    ["telemetry_email_description"] = "Provide an email address if you want to be contacted by the ntop team in case anomalies in the telemetry data are detected. ntop will not be able to identify you if you do not provide this address.",
    ["telemetry_email_title"] = "Contact",
    ["timeseries"] = "Timeseries",
    ["timeseries_database"] = "Timeseries Database",
    ["timeseries_resolution_resolution_description_2"] = "The interval between consecutive timeseries data points for local hosts",
    ["timeseries_resolution_resolution_title"] = "Timeseries Resolution",
    ["toggle_access_log_description"] = "Toggle the creation of HTTP access log in the data dump directory. Settings will have effect at next %{product} startup.",
    ["toggle_access_log_title"] = "Enable HTTP Access Log",
    ["toggle_active_local_host_cache_enabled_description"] = "Toggle the creation of cache entries for active local hosts. Caching active local hosts periodically can be useful to protect host counters against failures (e.g., power losses). This is particularly important for local hosts that seldomly go idle as it guarantees that their counters will be cached after the specified time interval.",
    ["toggle_active_local_host_cache_enabled_title"] = "Active Local Hosts Cache",
    ["toggle_alert_syslog_description"] = "Toggle alerts logging to system syslog.",
    ["toggle_alert_syslog_title"] = "Toggle Syslog Notification",
    ["toggle_alerts_notifications_description"] = "Toggle the reporting of alert to third-party endpoints.",
    ["toggle_alerts_notifications_title"] = "Alerts to Third-Party Endpoints",
    ["toggle_asn_rrds_description"] = "Toggle the creation of bytes and application timeseries for autonomous systems.",
    ["toggle_asn_rrds_title"] = "Autonomous Systems",
    ["toggle_autologout_description"] = "Toggle the automatic logout of web interface users with expired sessions.",
    ["toggle_autologout_title"] = "Auto Logout",
    ["toggle_autoupdates_description"] = "Toggle overnight automatic %{product} updates. Please note that %{product} is automatically restarted after a successfull update.",
    ["toggle_autoupdates_title"] = "Automatic Updates",
    ["toggle_behaviour_analysis_description"] = "Enable host and interface behaviour traffic analysis. Restart is required in order this preference to have effect.",
    ["toggle_behaviour_analysis_title"] = "Enable Traffic Behaviour Analysis",
    ["toggle_captive_portal_description"] = "Enable the web captive portal for authenticating network users.",
    ["toggle_captive_portal_title"] = "Captive Portal",
    ["toggle_country_rrds_description"] = "Toggle the creation of bytes timeseries for countries.",
    ["toggle_country_rrds_title"] = "Countries",
    ["toggle_dst_with_post_nat_dst_description"] = "Replace IPv4 destination addresses (%%IPV4_DST_ADDR) and ports (%%L4_DST_PORT) with their post-nat values (%%POST_NAT_DST_IPV4_ADDR and %%POST_NAPT_DST_TRANSPORT_PORT).",
    ["toggle_dst_with_post_nat_dst_title"] = "Use Post-Nat Destination IPv4 Addresses and Ports",
    ["toggle_elasticsearch_notification_description"] = "Toggle alerts notifications to Elasticsearch.",
    ["toggle_elasticsearch_notification_title"] = "Toggle Elasticsearch Notification",
    ["toggle_elephant_flows_alerts_description"] = "Toggle alerts generated when an elephant flow has been detected. This is useful to detect unwanted behaviours (e.g. data exfiltration).",
    ["toggle_elephant_flows_alerts_title"] = "Elephant Flows Alerts",
    ["toggle_email_notification_description"] = "Toggle alerts notifications via email.",
    ["toggle_email_notification_title"] = "Toggle Email Notification",
    ["toggle_enable_runtime_flows_dump_description"] = "Toggle the dump of flows towards the configured database.",
    ["toggle_enable_runtime_flows_dump_title"] = "Flows Dump",
    ["toggle_flow_rrds_description"] = "Toggle the creation of bytes timeseries for each port of the remote device as received through ZMQ (e.g. sFlow/NetFlow/SNMP).<br>For non sFlow devices, %%INPUT_SNMP and %%OUTPUT_SNMP must appear into the nprobe template.",
    ["toggle_flow_rrds_title"] = "Flow Devices",
    ["toggle_host_mask_description"] = "For privacy reasons it might be necessary to mask hosts IP addresses. For instance if you are an ISP you are not supposed to know which local addresses are accessing remote hosts.",
    ["toggle_host_mask_title"] = "Mask Host IP Addresses",
    ["toggle_host_pools_log_description"] = "Toggle the creation of logs related to host pools. Logs include associations and disassociations of hosts to their host pools.",
    ["toggle_host_pools_log_title"] = "Enable Host Pool Events Log",
    ["toggle_host_tskey_description"] = "The key to use for data and timeseries dump for the hosts in the local broadcast domain. In a DHCP network it's usually desiderable to choose 'Mac Address'.",
    ["toggle_host_tskey_title"] = "Local Broadcast Domain Hosts Identifier",
    ["toggle_http_auth"] = "Toggle HTTP Authentication",
    ["toggle_http_auth_descr"] = "Toggle gui authentication via an HTTP authenticator.",
    ["toggle_ids_alert_description"] = "Toggle alerts generated by Intrusion Detection Systems. See the Suricata integration through syslog.",
    ["toggle_ids_alert_title"] = "IDS Alerts",
    ["toggle_informative_captive_portal_description"] = "Do not authenticate users. Show only an informative page before letting users access the Internet.",
    ["toggle_informative_captive_portal_title"] = "Informative",
    ["toggle_internals_rrds_description"] = "Toggle the creation of <a href=\"%{url}\">internals</a> timeseries, e.g., hash tables entries, periodic activities duration and number of timeseries points written, plugins duration and number of calls.",
    ["toggle_internals_rrds_title"] = "Internals",
    ["toggle_ldap_anonymous_bind_description"] = "Enable anonymous binding.",
    ["toggle_ldap_anonymous_bind_title"] = "LDAP Anonymous Binding",
    ["toggle_ldap_auth"] = "Toggle LDAP Authentication",
    ["toggle_ldap_auth_descr"] = "Toggle gui authentication via LDAP.",
    ["toggle_ldap_referrals_description"] = "Specifies if the client should automatically follow referrals returned by LDAP servers.",
    ["toggle_ldap_referrals_title"] = "Follow Referrals",
    ["toggle_local_auth"] = "Toggle Local Authentication",
    ["toggle_local_auth_descr"] = "Toggle gui authentication according to %{product} defined users.",
    ["toggle_local_host_cache_enabled_description"] = "Toggle the creation of cache entries for idle local hosts. Cached local hosts counters are restored automatically to their previous values  upon detection of additional host traffic.",
    ["toggle_local_host_cache_enabled_title"] = "Idle Local Hosts Cache",
    ["toggle_local_hosts_one_way_ts_description"] = "Toggle the creation of timeseries for one-way traffic. One-way traffic is often generated by remote hosts performing probing, so it is advisable to keep this disabled.",
    ["toggle_local_hosts_one_way_ts_title"] = "One-Way Traffic Timeseries",
    ["toggle_local_hosts_ts_creation_description"] = "Enable full host timeseries creation (full), limit it to bytes and score (light), or turn it off.",
    ["toggle_local_hosts_ts_creation_title"] = "Host Timeseries",
    ["toggle_log_to_file_description"] = "Toggle the creation of ntopng.log in the data dump directory instead of using syslog. Settings will have effect at next %{product} startup.",
    ["toggle_log_to_file_title"] = "Enable Trace Log",
    ["toggle_logging_level_description"] = "Choose the runtime logging level.",
    ["toggle_logging_level_title"] = "Log level",
    ["toggle_longlived_flows_alerts_description"] = "Toggle alerts generated when a long-lived flow has been detected. This is useful to detect unwanted behaviours (e.g. data exfiltration).",
    ["toggle_longlived_flows_alerts_title"] = "Long-Lived Flows Alerts",
    ["toggle_midnight_stats_reset_description"] = "Toggle the automatic stats reset at midnight. This includes Hosts and Mac addresses stats.",
    ["toggle_midnight_stats_reset_title"] = "Midnight Stats Reset",
    ["toggle_mysql_check_open_files_limit_description"] = "Enable MySQL alerts generations due to periodic checks of MySQL open_files_limit.<br>The open_files_limit check is useful to detect when the number of open MySQL files is high, which could lead to database insertion errors.",
    ["toggle_mysql_check_open_files_limit_title"] = "Enable MySQL alerts",
    ["toggle_ndpi_flows_rrds_description"] = "Toggle the creation of timeseries for the number of total flows per Layer-7 application.",
    ["toggle_ndpi_flows_rrds_title"] = "Layer-7 Total Flows",
    ["toggle_ndpi_timeseries_creation_description"] = "Toggle the creation of Layer-7 application timeseries. Creating a timeseries per application requires more disk space and extra I/O and, in general, it is not needed.",
    ["toggle_ndpi_timeseries_creation_title"] = "Layer-7 Applications",
    ["toggle_network_discovery_description"] = "Toggle the periodic discovery of network devices using multiple techniques that include ARP scan, MDNS and SSDP.<p><b><b>NOTE</b>:</b> discovery can be <u>only</u> enabled on physical interfaces  (i.e. no ZMQ) where we can send/receive traffic to the network (i.e. read-only interfaces such as those connected to port mirrors won't work). ",
    ["toggle_network_discovery_title"] = "Active Network Discovery",
    ["toggle_pools_rrds_description"] = "Toggle the creation of bytes and applications timeseries for defined host pools.",
    ["toggle_pools_rrds_title"] = "Host Pools",
    ["toggle_radius_auth"] = "Toggle RADIUS Authentication",
    ["toggle_radius_auth_descr"] = "Toggle gui authentication via a RADIUS server.",
    ["toggle_send_telemetry_data_description"] = "Contribute to the project by sending encrypted, <a href=\"%{url}\">anonymous telemetry data</a> to <a href=\"%{ntop_org}\">ntop.org</a>. Data only involves the status of %{product} (e.g., uptime, status, crash reports). Nothing regarding the monitored traffic will ever be sent.",
    ["toggle_send_telemetry_data_title"] = "Telemetry Data",
    ["toggle_shaping_directions_description"] = "Enable this option to be able to set different shaping policies for ingress and egress traffic.",
    ["toggle_shaping_directions_title"] = "Split Shaping Directions",
    ["toggle_slack_notification_description"] = "Toggle alerts notifications via slack. See integration instructions <a href='%{url}'>here</a>.",
    ["toggle_slack_notification_title"] = "Toggle <a href=\"%{url}\">Slack</a> Notification",
    ["toggle_snmp_alerts_port_duplexstatus_change_description"] = "Toggle alerts generated when an interface duplex status changes",
    ["toggle_snmp_alerts_port_duplexstatus_change_title"] = "Interface Duplex Status Change Alerts",
    ["toggle_snmp_alerts_port_errors_description"] = "Toggle alerts generated when the discards or errors counters on an interface increase",
    ["toggle_snmp_alerts_port_errors_title"] = "Interface Discards/Errors Alerts",
    ["toggle_snmp_alerts_port_status_change_description"] = "Toggle alerts generated when an interface operational state changes",
    ["toggle_snmp_alerts_port_status_change_title"] = "Interface Operational Status Change Alerts",
    ["toggle_snmp_debug_description"] = "Toggle the debugging of SNMP devices. Enabling this will print extra information out to the ntopng logs.",
    ["toggle_snmp_debug_title"] = "SNMP Debug",
    ["toggle_snmp_port_admin_status_description"] = "Toggle interface admin status. Toggle is immediate but actual status shown is refreshed during the next poll.",
    ["toggle_snmp_port_admin_status_title"] = "Interface Admin Status",
    ["toggle_snmp_rrds_description"] = "Toggle the creation of bytes timeseries for each port of the SNMP devices. For each device port will be created a timeseries with ingress/egress bytes.",
    ["toggle_snmp_rrds_title"] = "SNMP Devices Timeseries",
    ["toggle_src_and_dst_using_ports_description"] = "Determine source and destination of received flows using port numbers. The lower port number is assumed to be the destination port. The higher port number is assumed to be the source port. The rationale is that, in general, sources use ephemeral ports to connect to well-known destination ports, and ephemeral ports are in general greater than the well-known ones. When this option is enabled, source and destination will be swapped if the destination port is found to be greater than the source port.",
    ["toggle_src_and_dst_using_ports_title"] = "Use Port Numbers to Determine Source and Destination",
    ["toggle_src_with_post_nat_src_description"] = "Replace IPv4 source addresses (%%IPV4_SRC_ADDR) and ports (%%L4_SRC_PORT) with their post-nat values (%%POST_NAT_SRC_IPV4_ADDR and %%POST_NAPT_SRC_TRANSPORT_PORT).",
    ["toggle_src_with_post_nat_src_title"] = "Use Post-Nat Source IPv4 Addresses and Ports",
    ["toggle_system_probes_timeseries_description"] = "Toggle the creation of timeseries for system probes such as the Active Monitoring and the Redis monitor.",
    ["toggle_system_probes_timeseries_title"] = "Probes",
    ["toggle_theme_description"] = "Toggle betweens themes.",
    ["toggle_theme_title"] = "Theme",
    ["toggle_thpt_content_description"] = "Select the throughput unit to be displayed in traffic reports.",
    ["toggle_thpt_content_title"] = "Throughput Unit",
    ["toggle_tiny_flows_dump_description"] = "Toggle the dump of tiny flows, that are flows with few packets or bytes. Reduces flow cardinality in databases, speeds-up inserts and searches. Tuning tiny flows can help to limit flow cardinality while not reducing visibility on dumped information.",
    ["toggle_tiny_flows_dump_title"] = "Tiny Flows Dump",
    ["toggle_top_sites_description"] = "Toggle the creation of top visited web sites for local hosts. Top sites are created using an <a href=\"%{url}\">heuristic</a> that maintain no more than 20 sites per local host. The heuristic fully operates in memory and does not require any interaction with the disk. Top sites are cleared every 5 minutes. An historical archive of top visited web sites can be created, for each local host, by periodically polling the JSON <i class=\"fas fa-download fa-sm\"></i> download link accessible from the host details page.",
    ["toggle_top_sites_title"] = "Top HTTP Sites",
    ["toggle_traffic_rrd_creation_description"] = "Toggle the creation of bytes and packets timeseries.",
    ["toggle_traffic_rrd_creation_title"] = "Traffic",
    ["toggle_users_rrds_description"] = "Toggle the creation of bytes and applications timeseries for defined users.",
    ["toggle_users_rrds_title"] = "Users",
    ["toggle_vlan_rrds_description"] = "Toggle the creation of bytes and applications timeseries for VLANs.",
    ["toggle_vlan_rrds_title"] = "VLANs",
    ["toggle_webhook_notification_description"] = "Toggle alerts notifications via webhook (HTTP).",
    ["toggle_webhook_notification_title"] = "Toggle Webhook Notification",
    ["topk_heuristic_precision_description"] = "Use an heuristic when aggregating historical top hosts, countries, etc, to build traffic reports. Useful when building reports over long-periods.",
    ["topk_heuristic_precision_title"] = "Top-K Heuristic",
    ["traffic_bridging"] = "Traffic Bridging",
    ["traffic_shaping"] = "Traffic Shaping",
    ["ts_resolution_note2"] = "Lowering the resolution can create gaps in the existing data. It is advisable to <a target=_blank href=\"%{url}\">delete the database</a> %{external_icon}.",
    ["updates"] = "Updates",
    ["user_authentication"] = "User Authentication",
    ["user_group_description"] = "Group name to which user has to belong in order to authenticate as unprivileged user.",
    ["user_group_title"] = "LDAP User Group",
    ["vlan"] = "VLAN Id",
    ["web_user_interface"] = "Web User Interface",
    ["webhook_notification"] = "Webhook Notification",
    ["webhook_notification_severity_preference_description"] = "Errors (errors only), Errors and Warnings (errors and warnings, no info), All (every kind of alerts will be notified).",
    ["webhook_notification_severity_preference_title"] = "Notification Severity",
    ["webhook_password_description"] = "The password to be used in case of HTTP authentication (optional).",
    ["webhook_send_error"] = "Error sending message to the webhook.",
    ["webhook_sent_successfully"] = "A message has been sent to the webhook",
    ["webhook_sharedsecret_description"] = "Set a (user-defined) secret to be validated by the receiver (optional).",
    ["webhook_sharedsecret_title"] = "Shared Secret",
    ["webhook_url_description"] = "Send notification to this URL in JSON format.",
    ["webhook_url_title"] = "Notification URL",
    ["webhook_username_description"] = "The username to be used in case of HTTP authentication (optional).",
    ["zmq_interfaces"] = "ZMQ Interfaces",
  },
  ["processes_stats"] = {
    ["active_processes_title"] = "Active Processes: Realtime View",
    ["active_since"] = "Active Since",
    ["flows_count"] = "Flows Count",
    ["legend"] = "Legend",
    ["lines"] = "Lines",
    ["missing_pid_name_message"] = "Missing pid name",
    ["no_traffic_detected"] = "No traffic detected for this process, flow process expired, or process terminated.",
    ["processes_timeline_title"] = "Processes Timeline",
    ["stack"] = "Stack",
    ["timeline"] = "Timeline",
    ["top_hosts"] = "Top Hosts",
    ["top_hosts_traffic"] = "Top Hosts Traffic",
    ["traffic_rcvd"] = "Traffic Rcvd",
    ["traffic_sent"] = "Traffic Sent",
    ["type"] = "Type",
  },
  ["queue"] = {
    ["activeFlowsToDump"] = "Active flows dump",
    ["hookFlowEnd"] = "flowEnd flow user script hook",
    ["hookPeriodicUpdate"] = "periodicUpdate flow user script hook",
    ["hookProtocolDetected"] = "protocolDetected flow user script hook",
    ["idleFlowsToDump"] = "Idle flows dump",
  },
  ["queue_description"] = {
    ["activeFlowsToDump"] = "Queue holding active flows waiting to be dumped",
    ["hookFlowEnd"] = "Idle flows enqueued waiting to have their flowEnd user script hook executed",
    ["hookPeriodicUpdate"] = "Active flows waiting to have their periodicUpdate user script hook",
    ["hookProtocolDetected"] = "New flows waiting to have their protocolDetected user script hook executed",
    ["idleFlowsToDump"] = "Queue holding idle flows waiting to be dumped",
  },
  ["remote_assistance"] = {
    ["accept_and_enable"] = "Accept and Enable",
    ["admin_access"] = "Temporary Admin Access",
    ["admin_access_descr"] = "Create a temporary admin password for remote assistance GUI access.",
    ["admin_access_key_descr"] = "The temporary admin password is <b>%{pwd}</b>",
    ["ask_admin"] = "Ask the network administrator permission before doing this.",
    ["check_out_the_preferences"] = "More remote assistance parameters can be tuned from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Remote Assistance Preferences</a>.",
    ["connection_script"] = "Connection Script",
    ["connection_script_descr"] = "Download the connection script and provide it to the support team to let them connect to this ntopng instance. The script will work on systems where the n2n package is installed.",
    ["enable_remote_assistance"] = "Enable Remote Assistance",
    ["gui_access_restricted_info"] = "GUI access is restricted by a configured <a href='%{url_acl}'>ACL</a> or cli options (%{cli_options}). Remote admin access may be blocked.",
    ["product_remote_assistance"] = "%{product} Remote Assistance",
    ["remember_disable"] = "Remember to disable the remote assistance when not needed.",
    ["remote_assistance"] = "Remote Assistance",
    ["remote_ip_msg"] = "This %{product} instance will be accessible from remote at IP address %{ip}",
    ["tos_notice"] = "By clicking \"%{button}\" you will provide remote access to your host and guarantee that your network security policies allow this. ntop is not responsible for any damage, security violation or vulnerability caused by enabling remote assistance.",
    ["will_create_virtual_network"] = "When enabled, the remote assistance will create an encrypted virtual network to connect remotely to your device.",
  },
  ["report"] = {
    ["application_breakdown"] = "Application Breakdown",
    ["applications"] = "Applications",
    ["begin_date_time"] = "Begin Date/Time",
    ["date"] = "%{month}-%{day}-%{year}",
    ["end_date_time"] = "End Date/Time",
    ["filter_report"] = "Filter Report",
    ["generate"] = "Generate",
    ["invalid_begin"] = "Invalid Begin",
    ["invalid_begin_date"] = "Invalid Begin Date",
    ["invalid_begin_end"] = "Invalid Begin/End",
    ["invalid_to"] = "Invalid To",
    ["local_networks"] = "Local Networks",
    ["local_remote"] = "Local/Remote",
    ["network_interface"] = "Network Interface",
    ["period"] = "Interval",
    ["please_check_format"] = "please check its format",
    ["please_choose_valid"] = "please choose a valid begin/end date and time",
    ["please_choose_valid_date_and_time"] = "please choose a valid date and time",
    ["receivers"] = "Receivers",
    ["remote_local"] = "remote/local",
    ["report_for_subject"] = "Report - %{num_min} - for %{subject} starting %{dt}",
    ["reports_professional_only"] = "Reports are only available in the Professional version",
    ["senders"] = "Senders",
    ["starting"] = "Starting",
    ["submit_filter"] = "Submit Filter",
    ["symbolic_host_name_at_visualization"] = "Symbolic host names are resolved during the visualization.",
    ["toggle_all"] = "Toggle All",
    ["top_asn"] = "Top ASN",
    ["top_countries"] = "Top Countries",
    ["top_local_hosts"] = "Top Local Hosts",
    ["top_local_os"] = "Top Local OS",
    ["top_networks"] = "Top Networks",
    ["top_non_local_os"] = "Top Non-Local OS",
    ["top_remote_hosts"] = "Top Remote Hosts",
    ["top_talkers"] = "Top Talkers",
    ["total_traffic"] = "Total Traffic",
    ["traffic_report"] = "Traffic Report",
    ["use_server_timezone"] = "Use Server Timezone",
  },
  ["rest_consts"] = {
    ["ADD_POOL_FAILED"] = "Unable to add a pool with the submitted params",
    ["BAD_CONTENT"] = "Bad content",
    ["BAD_FORMAT"] = "Bad format",
    ["BIND_POOL_MEMBER_ALREADY_BOUND"] = "Unable to bind member which is already bound to another pool",
    ["BIND_POOL_MEMBER_FAILED"] = "Unable to bind the sumbitted member to the pool",
    ["CONFIGURATION_FILE_MISMATCH"] = "The uploaded file is not a valid configuration file!",
    ["DELETE_POOL_FAILED"] = "Unable to delete a pool with the submitted params",
    ["EDIT_POOL_FAILED"] = "Unable to edit a pool with the submitted params",
    ["INTERNAL_ERROR"] = "Internal error",
    ["INVALID_ARGUMENTS"] = "Invalid arguments",
    ["INVALID_HOST"] = "Invalid host",
    ["INVALID_INTERFACE"] = "Invalid interface",
    ["NAME_RESOLUTION_FAILED"] = "Unable to resolve the host name to an IP address",
    ["NOT_FOUND"] = "Not found",
    ["NOT_GRANTED"] = "Not authorized",
    ["NO_SNMP_DEVICE_DISCOVERED"] = "No SNMP device discovered",
    ["OK"] = "Success",
    ["PARTIAL_IMPORT"] = "The configuration has been imported successfully, but some elements were already present and haven't be replaced.",
    ["POOL_ADDED_SUCCESSFULLY"] = "Pool added successfully",
    ["POOL_DELETED_SUCCESSFULLY"] = "Pool deleted successfully",
    ["POOL_EDITED_SUCCESSFULLY"] = "Pool edited successfully",
    ["POOL_MEMBER_BOUND_SUCCESSFULLY"] = "Pool member bound successfully",
    ["POOL_NOT_FOUND"] = "Pool not found",
    ["SNMP_DEVICE_ADDED_SUCCESSFULLY"] = "SNMP device added successfully",
    ["SNMP_DEVICE_ALREADY_ADDED"] = "SNMP device already added",
    ["SNMP_DEVICE_DELETED_SUCCESSFULLY"] = "SNMP device deleted successfully",
    ["SNMP_DEVICE_EDITED_SUCCESSFULLY"] = "SNMP device edited successfully",
    ["SNMP_DEVICE_INTERFACE_STATUS_CHANGE_FAILED"] = "SNMP device interface status change has failed",
    ["SNMP_DEVICE_UNREACHABLE"] = "No answer from the SNMP device",
  },
  ["restart"] = {
    ["confirm"] = "Do you want to restart %{product} now?",
    ["restart"] = "Restart",
    ["restart_now"] = "Restart now",
    ["restart_product"] = "Restart %{product}",
    ["restart_required"] = "Restart Required",
    ["restarting"] = "Restarting %{product}... (this should take a few seconds)",
  },
  ["scripts_list"] = {
    ["all"] = "All",
    ["are_you_sure"] = "Your edits are not saved yet! Do you really want to close this dialog?",
    ["attention"] = "Attention",
    ["back_scripts_page"] = "Back to Scripts",
    ["blacklisted_country"] = "Please write country code values separated by comma. (i.e.: IT,FR,DE,UK)",
    ["config"] = "Config",
    ["filter_dropdown"] = "Filter Categories",
    ["items_list_comma"] = "Special characters are not allowed except for ,",
    ["missing_configset"] = "The requested config set was not found!",
    ["previous_page"] = "Click here to return to the previous page!",
    ["reset_default"] = "Reset to Factory Value",
    ["script_search"] = "Search Script:",
    ["scripts_x"] = "Scripts %{subdir} - %{config}",
    ["select_operator"] = "Please select an operator!",
    ["template_not_found"] = "The template was not found!",
    ["actions"] = {
      ["edit"] = "Edit",
      ["edit_script"] = "Edit Script",
      ["view"] = "View",
      ["view_src_script"] = "View Source Script",
    },
    ["templates"] = {
      ["blacklisted_country_list"] = "Blacklisted Countries list",
      ["elephant_flows_l2r"] = "Elephant Flows Threshold (Local To Remote)",
      ["elephant_flows_r2l"] = "Elephant Flows Threshold (Remote To Local)",
      ["excluded_applications"] = "Excluded applications and categories",
      ["flow_duration_threshold"] = "Flow Duration Threshold",
      ["template_not_implemented"] = "The template  was not implemented yet!",
    },
  },
  ["severity_groups"] = {
    ["group_error_or_higher"] = "Error or Higher",
    ["group_none"] = "None",
    ["group_notice_or_lower"] = "Notice or Lower",
    ["group_warning"] = "Warning",
  },
  ["sflows_stats"] = {
    ["active_flows"] = "Active Flows",
    ["client_peer"] = "Client Peer",
    ["client_process"] = "Client Process",
    ["server_peer"] = "Server Peer",
    ["server_process"] = "Server Process",
    ["total_bytes"] = "Total Bytes",
  },
  ["shaping"] = {
    ["applied_to"] = "Applied to",
    ["bandwidth_manager"] = "Bandwidth Manager",
    ["confirm_delete_all_policies"] = "Do you really want ot delete all the \"%{pool_name}\" pool policies",
    ["confirm_delete_policy"] = "Do you really want to delete",
    ["confirm_delete_shaper"] = "Do you really want to delete shaper ",
    ["daily_time"] = "Daily Time (Current / Quota)",
    ["daily_time_quota"] = "Daily Time Quota",
    ["daily_traffic"] = "Daily Traffic (Current / Quota)",
    ["daily_traffic_quota"] = "Daily Traffic Quota",
    ["delete_all_policies"] = "Delete all Policies",
    ["delete_policy"] = "Delete Policy",
    ["delete_shaper"] = "Delete Shaper",
    ["for_dropping_all_traffic"] = "for dropping all traffic",
    ["for_no_shaping"] = "for no shaping",
    ["initial_clone_protocols"] = "Initial application rules will be cloned",
    ["initial_empty_protocols"] = "Initial applications rules will be empty",
    ["manage_policies"] = "Manage Policies",
    ["no_quota_applied"] = "No Quota",
    ["no_quota_data"] = "No quota set",
    ["no_quota_traffic"] = "No quota related traffic so far",
    ["no_shapers_available"] = "No shapers available",
    ["note_default_pool_config"] = "Policies and quotas only apply to user-defined host pools. Select a different pool or create a new one <a href='%{url}'>here</a>.",
    ["note_drop_core"] = "Dropping some core protocols can have side effects on other protocols. For instance if you block DNS,<br>symbolic host names are no longer resolved, and thus only communication with numeric IPs work.",
    ["note_quota_unlimited"] = "Set Traffic and Time Quota to 0 for unlimited traffic.",
    ["note_target_type"] = "You can modify what to show into the Target column via the Policy Target Type field in the <a href=\"%{url}\">Traffic Bridging preferences</a> expert view.",
    ["note_traffic_categories"] = "You can configure the Categories from the <a href=\"%{url}\">applications page</a>.",
    ["notes"] = "NOTES",
    ["policy_from_pool"] = "policy from pool",
    ["protocol_families"] = "Application Families",
    ["protocol_policy"] = "Traffic Policy",
    ["protocols"] = "Applications",
    ["protocols_policies"] = "Applications Policies",
    ["see_quotas_here"] = "Visit the host pool <a href='%{url}'>quotas page</a> for the full overview of the active host pool quotas.",
    ["select_to_clone"] = "Select an existing network to clone the application rules from",
    ["set_max_rate_to"] = "Set max rate to",
    ["shaper0_message"] = "Shaper 0 is the default shaper used for local hosts that have no shaper defined",
    ["shaper_id"] = "Shaper Id",
    ["shapers_in_use_message"] = "Shapers can be deleted only if they are not applied to any network",
    ["traffic_from"] = "Traffic from",
    ["traffic_to"] = "Traffic to",
  },
  ["show_alerts"] = {
    ["1_day"] = "1 Day",
    ["1_hour"] = "1 Hour",
    ["1_month"] = "1 Month",
    ["1_week"] = "1 Week",
    ["1_year"] = "1 Year",
    ["30_min"] = "30 Minutes",
    ["5_min"] = "5 Minutes",
    ["6_months"] = "6 Months",
    ["alarmable"] = "Alarmable",
    ["alert_actions"] = "Actions",
    ["alert_count"] = "Count",
    ["alert_counts"] = "Counts",
    ["alert_datetime"] = "Date/Time",
    ["alert_description"] = "Description",
    ["alert_duration"] = "Duration",
    ["alert_severity"] = "Severity",
    ["alert_type"] = "Alert Type",
    ["alerts"] = "Alerts",
    ["alerts_are_disabled_message"] = "Alerts are disabled. Please check the preferences page to enable them.",
    ["alerts_queries"] = "Alerts Queries",
    ["alerts_to_purge"] = "Alerts to Purge",
    ["confirm_delete_alert"] = "Do you really want to delete the specified alert",
    ["confirm_release_alert"] = "Do you really want to release the specified alert?",
    ["daily"] = "Daily",
    ["delete_alert"] = "Delete Alert",
    ["delete_alerts_configuration"] = "Delete Configuration",
    ["delete_all"] = "Delete All",
    ["delete_config_btn"] = "Delete %{conf}s Common Configuration",
    ["delete_config_message"] = "Do you really want to delete the common %{granularity} configuration of %{conf}s",
    ["detected_alerts"] = "Detected Alerts",
    ["disable_alerts"] = "Disable",
    ["disable_alerts_message"] = "Do you really want to disable \"%{type}\" alerts on %{entity_value}?",
    ["disable_alerts_title"] = "Disable Alerts",
    ["disabled_alerts"] = "Disabled Alerts",
    ["dropped_alerts"] = "Dropped Alerts",
    ["enable_alerts"] = "Enable",
    ["enable_alerts_message"] = "Do you really want to enable \"%{type}\" alerts on %{entity_value}?",
    ["enable_alerts_title"] = "Enable Alerts",
    ["engaged"] = "Engaged",
    ["engaged_alerts"] = "Engaged Alerts",
    ["explorer"] = "Explore",
    ["five_minutes"] = "Five minutes",
    ["flow_alerts"] = "Flow Alerts",
    ["flow_user_scripts_drops_descr"] = "Trigger an alert when some <a href='%{url}'>Flows user scripts</a> are not executed.",
    ["flow_user_scripts_drops_title"] = "Flows User Scripts Drops Alert",
    ["flush_data"] = "Flush Data",
    ["host_delete_config_btn"] = "Delete Host %{host} Configuration",
    ["host_delete_config_confirm"] = "Do you really want to delete the %{granularity} configuration for host",
    ["hourly"] = "Hourly",
    ["iface_delete_config_btn"] = "Delete Interface %{iface} Configuration",
    ["iface_delete_config_confirm"] = "Do you really want to delete the %{granularity} configuration for interface",
    ["iface_engaged_dropped_alerts"] = "Engaged vs Dropped alerts",
    ["in_the_selected_time_frame"] = "in the selected time period",
    ["interface_drops_threshold"] = "Interface Packets Drops Alert",
    ["interface_drops_threshold_descr"] = "The maximum percentage of dropped packets over the total number of interface observed packets",
    ["last_day"] = "Last Day",
    ["last_hour"] = "Last Hour",
    ["last_minute"] = "Last Minute",
    ["minute"] = "Minute",
    ["network_delete_config_btn"] = "Delete Network %{network} Configuration",
    ["network_delete_config_confirm"] = "Do you really want to delete the %{granularity} configuration for network",
    ["no_recorded_alerts_message"] = "No recorded alerts",
    ["num_ignored_alerts"] = "Ignored Alerts",
    ["older_1_day_ago"] = " older than 1 day ago",
    ["older_1_hour_ago"] = "older than 1 hour ago",
    ["older_1_month_ago"] = "older than 1 month ago",
    ["older_1_week_ago"] = "older than 1 week ago",
    ["older_1_year_ago"] = "older than 1 year ago",
    ["older_30_minutes_ago"] = "older than 30 minutes ago",
    ["older_5_minutes_ago"] = "older than 5 minutes ago",
    ["older_6_months_ago"] = "older than 6 months ago",
    ["older_than"] = "older than",
    ["past"] = "Past",
    ["past_alerts"] = "Past Alerts",
    ["past_flow"] = "Past Flow",
    ["purge_all_alerts"] = "Purge All Alerts",
    ["purge_num_alerts"] = "Purge [%{num_alerts} alerts]",
    ["purge_subj_alerts"] = "Purge %{subj} Alerts",
    ["purge_subj_alerts_confirm"] = "Do you really want to purge all the %{subj} alerts?",
    ["release_alert"] = "Release Alert",
    ["release_alert_action"] = "Release",
    ["reset_alert_database"] = "Flush Alerts Data",
    ["reset_alert_database_message"] = "This action will remove any alerts related data, including<ul><li>Runtime alerts status</li><li>Persistent alerts SQLite storage</li></ul>Please go to the User Scripts settings if you want to reset also the alerts configuration.<br><br>Do you really want to proceed",
    ["startup"] = "Startup",
    ["stored_alerts"] = "Stored Alerts",
    ["trigger_alert_descr"] = "Enable alerts triggering on this alarmable",
    ["trigger_host_alert_descr"] = "Trigger alerts generated by %{host}",
    ["trigger_iface_alert_descr"] = "Trigger alerts generated by %{iface}",
    ["trigger_network_alert_descr"] = "Trigger alerts generated by %{network}",
  },
  ["sites_page"] = {
    ["contacts"] = "Contacts",
    ["current_sites"] = "Current Sites",
    ["last_5_minutes_sites"] = "Last 5 Minute Sites",
    ["sites"] = "Sites",
    ["top_sites_not_enabled_message"] = "To keep track of visited sites, enable the creation of top visited web sites for local hosts from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>.",
    ["top_sites_not_seen"] = "Current local host has not visited any website yet.",
    ["top_visited_sites"] = "Top Visited Sites",
  },
  ["slack_alert_endpoint"] = {
    ["notification_webhook"] = "Notification Webhook",
    ["sender_username"] = "Sender Username",
  },
  ["snmp"] = {
    ["AlertDescription"] = "Alert Description",
    ["ConsoleDisplayBufferText"] = "Display Text",
    ["GeneralSerialNumber"] = "Serial Number",
    ["InputCurrentLevel"] = "Current Level",
    ["InputDimUnit"] = "Dim Unit",
    ["InputMaxCapacity"] = "Max Capacity",
    ["InputMediaDimFeedDirDeclared"] = "InputMediaDimFeedDirDeclared",
    ["InputMediaDimXFeedDirDeclared"] = "InputMediaDimXFeedDirDeclared",
    ["InputName"] = "InputName",
    ["MarkerColorantValue"] = "Marker Colorant",
    ["MarkerLifeCount"] = "Marker Life Count",
    ["MarkerSuppliesDescription"] = "Marker Supplies Description",
    ["MarkerSuppliesLevel"] = "Marker Supplies Level",
    ["MarkerSuppliesMaxCapacity"] = "Marker Supplies Max Capacity",
    ["PrinterCurrentStatus"] = "Current Status",
    ["PrinterOperationalStatus"] = "Operational Status",
    ["absolute_stats"] = "Stats Since Boot",
    ["actual_stats"] = "Stats Since Last Poll",
    ["add_device"] = "Add",
    ["add_devices"] = "Add Devices",
    ["add_snmp_devices"] = "Add SNMP Device(s)",
    ["alert_topology"] = "There are no nodes to show!",
    ["alerted_interfaces"] = "Interfaces With Errors",
    ["all_interfaces"] = "All Interfaces",
    ["all_snmp_interface_types"] = "All Types",
    ["all_snmp_statuses"] = "All Statuses",
    ["and_one_more_interface"] = "and <a href='%{url}'>1 more interface</a>",
    ["authentication_passphrase"] = "Authentication PassPhrase",
    ["authentication_protocol"] = "Authentication Protocol",
    ["bound_interface_description"] = "Binding a network interface to an SNMP interface is useful to compare network traffic monitored by ntopng with that reported by SNMP",
    ["caching_in_progress"] = "Device SNMP walk in progress. This may take up to 5 minutes. The page will refresh periodically.",
    ["contact"] = "Contact",
    ["cpuIdle"] = "CPU Idle",
    ["cpuSystem"] = "CPU System",
    ["cpuUser"] = "CPU User",
    ["delete_all_devices"] = "Delete All",
    ["delete_unresponsive_devices"] = "Delete Unresponsive",
    ["device_example"] = "Example: %{example}",
    ["device_ip"] = "Device IP",
    ["device_model"] = "Device Model",
    ["device_polling"] = "Device Polling",
    ["device_polling_desc"] = "Perform periodic SNMP walks to collect device data, including device interfaces traffic and status.",
    ["device_responsiveness"] = "Device Filter",
    ["device_status"] = "Device Status",
    ["devices_added"] = "Device(s) Added",
    ["disable_port_monitor"] = "Disable Port Monitor",
    ["discover_devices"] = "Discover Devices",
    ["edit_device"] = "Edit",
    ["edit_snmp_devices"] = "Edit SNMP Device",
    ["enable_port_monitor"] = "Enable Port Monitor",
    ["errors_filter"] = "Errors Filter",
    ["ifName"] = "Interface Name",
    ["ifindex"] = "Index",
    ["in_bytes"] = "In Bytes",
    ["in_discards"] = "In Discards",
    ["in_errors"] = "In Errors",
    ["interface_device"] = "Interface %{interface} [ %{device} ]",
    ["interfaces_with_discards"] = "Interfaces With Discards",
    ["interfaces_with_errors"] = "Interfaces With Errors",
    ["interfaces_with_errors_or_discards"] = "Interfaces With Errors/Discards",
    ["last_change"] = "Last Change",
    ["lldpRemChassisId"] = "Remote Device",
    ["lldpRemPortDesc"] = "Remote Port Description",
    ["lldpRemPortId"] = "Remote Port Identifier",
    ["lldpRemSysDesc"] = "Remote System Description",
    ["lldpRemSysName"] = "Remote System Name",
    ["lldp_topology_changed"] = "LLDP Topology changed",
    ["lldp_topology_changed_description"] = "Detects changes in the SNMP network topology and triggers alerts",
    ["lldp_topology_changed_title"] = "LLDP Topology Monitor",
    ["low_port_speed"] = "Low port speed",
    ["memAvailReal"] = "Available Memory",
    ["memTotalReal"] = "Total Memory",
    ["memTotalSwap"] = "Total Swap",
    ["multiple_macs_non_trunk"] = "Multiple MACs on non-trunk port",
    ["no_answer"] = "No answer from host %{host}: please check that SNMP is up and the community is set to the correct value",
    ["no_host_discovered"] = "No host discovered in %{host}/%{cidr}",
    ["no_polling_yet"] = "Never polled",
    ["none"] = "None",
    ["note"] = "NOTE",
    ["object_id"] = "ObjectID",
    ["out_bytes"] = "Out Bytes",
    ["per_interface_settings"] = "These settings only affect interface \"%{iface}\". Check out <a href=\"%{url}\">%{global}</a> for a global configuration.",
    ["port_macs"] = "Mac Addresses",
    ["port_macs_short"] = "MACs",
    ["privacy_passphrase"] = "Privacy PassPhrase",
    ["privacy_protocol"] = "Privacy Protocol",
    ["prune_unresponsive_snmp_devices"] = "Remove Unresponsive SNMP Devices",
    ["prune_unresponsive_snmp_devices_confirm"] = "Do you really want to delete all unresponsive SNMP devices?",
    ["remove_all_snmp_devices"] = "Remove All SNMP Devices",
    ["remove_all_snmp_devices_confirm"] = "Do you really want to delete all the SNMP devices?",
    ["remove_snmp_device"] = "Remove SNMP Device",
    ["remove_snmp_device_confirm"] = "Do you really want to delete the SNMP device",
    ["responsiveness_all"] = "All Devices",
    ["responsiveness_responsive"] = "Responsive Devices",
    ["responsiveness_unresponsive"] = "Unresponsive Devices",
    ["select_pool"] = "Select a pool",
    ["snmp_all_interfaces"] = "All Interfaces",
    ["snmp_also_seen_on"] = "Also seen on",
    ["snmp_and_n_more_interfaces"] = "and <a href='%{url}'>%{count} more interfaces</a>",
    ["snmp_authnopriv"] = "Auth. w/o Privacy",
    ["snmp_authpriv"] = "Auth. with Privacy",
    ["snmp_community"] = "Community",
    ["snmp_device"] = "SNMP Device",
    ["snmp_device_does_not_respond"] = "The SNMP device does not respond.",
    ["snmp_device_last_poll"] = "Time Since Last Poll",
    ["snmp_device_last_poll_duration"] = "Last Poll Duration",
    ["snmp_device_polling_disabled"] = "Periodic device polling is disabled. Information shown may be missing or outdated. Polling can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>.",
    ["snmp_device_x"] = "%{device} (%{ip})",
    ["snmp_devices"] = "SNMP Devices",
    ["snmp_error_unable_to_set_interface_admin_status"] = "Unable to toggle the admin status. Make sure the SNMP device has a (valid) write community configured.",
    ["snmp_host"] = "Host",
    ["snmp_interface"] = "SNMP Interface",
    ["snmp_interface_type"] = "Interface Type",
    ["snmp_interface_x"] = "Interface: %{interface}",
    ["snmp_interfaces"] = "Interfaces",
    ["snmp_last_poll_errors"] = "Interfaces with Errors (lLast Poll)",
    ["snmp_level"] = "Security Level",
    ["snmp_lldp_descr"] = "Device topology information is available when the <A HREF=\"https://en.wikipedia.org/wiki/Link_Layer_Discovery_Protocol\">LLDP</A> protocol is enabled on the monitored devices and readeable via SNMP.",
    ["snmp_lldp_node_color"] = "The node color represents the device model.",
    ["snmp_lldp_zoom_descr"] = "Click on a node to explore the device, use the mouse wheel to zoom, drag clicking on an empty area.",
    ["snmp_monitor_disable_confirm"] = "Do you really want to disable port status monitoring on SNMP device %{device}?",
    ["snmp_monitor_enable_confirm"] = "Do you really want to enable port status monitoring on SNMP device %{device}? Alerts will be generated whenever a port changes state.",
    ["snmp_netsnmp"] = "CPU/Memory",
    ["snmp_noauthnopriv"] = "None",
    ["snmp_note_bridge_mib"] = "Periodic SNMP walks on the Bridge MIB are performed to populate the table.",
    ["snmp_note_bridge_mib_status"] = "Shown status is the dot1qTpFdbStatus Bridge MIB status associated to the mac address.",
    ["snmp_note_periodic_interfaces_polling"] = "Periodic SNMP walks are performed to update interfaces at regular 5-minute intervals.",
    ["snmp_note_thpt_calc"] = "The throughput accounts for the total traffic (in + out) over the two most recent consecutive SNMP walks.",
    ["snmp_note_thpt_span"] = "The two most recent consecutive SNMP walks were perfrormed at %{last} and %{prev}.",
    ["snmp_pool"] = "Pool",
    ["snmp_port_monitor"] = "SNMP Port Monitor",
    ["snmp_printer"] = "Printer",
    ["snmp_read_community"] = "Read Community",
    ["snmp_timeseries_descr"] = "SNMP devices timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
    ["snmp_topology"] = "Topology",
    ["snmp_username"] = "Username",
    ["snmp_version"] = "SNMP Version",
    ["snmp_write_community"] = "Write Community",
    ["stats_since"] = "Stats Since",
    ["status_dormant"] = "Dormant",
    ["status_down"] = "Down",
    ["status_lowerlayerdown"] = "Lower Layer Down",
    ["status_notpresent"] = "Not Present",
    ["status_unknown"] = "Unknown",
    ["status_up"] = "Up",
    ["status_up_in_use"] = "Up (in use)",
    ["testing"] = "Testing",
    ["tp_fbd_status_invalid"] = "invalid",
    ["tp_fbd_status_learned"] = "learned",
    ["tp_fbd_status_mgmt"] = "mgmt",
    ["tp_fbd_status_other"] = "other",
    ["tp_fbd_status_self"] = "self",
    ["trunk"] = "trunk",
    ["unable_to_delete_snmp_device"] = "Unable to delete SNMP device %{device}",
    ["unresponsive_device"] = "The SNMP walk is too slow. Displayed data may be outdated or missing. Check network connectivity and device responsiveness. A new scan attempt will be performed in 15 minutes.",
    ["view_device"] = "View Device",
    ["descriptions"] = {
      ["add_pool"] = "New SNMP Pool",
      ["authentication_passphrase"] = "SNMPv3 authentication passphrase",
      ["authentication_protocol"] = "SNMPv3 authentication protocol",
      ["host"] = "SNMP agent IP address",
      ["level"] = "SNMPv3 security level",
      ["pool"] = "SNMP Pool to bind",
      ["privacy_passphrase"] = "SNMPv3 encryption passphrase",
      ["privacy_protocol"] = "SNMPv3 encryption protocol",
      ["read_community"] = "SNMP v1/v2c read-only community",
      ["username"] = "SNMPv3 authentication username",
      ["version"] = "SNMP protocol version",
      ["write_community"] = "SNMP v1/v2c write community",
    },
    ["validation"] = {
      ["abort_add_snmp_devices"] = "Abort add new SNMP Device?",
      ["abort_edit_snmp_devices"] = "Abort edit SNMP Device?",
      ["invalid_host"] = "Please type an IPv4 address, or a IPv6 address.",
      ["read_community_empty"] = "The Read Community cannot be left empty.",
    },
  },
  ["snmp_page"] = {
    ["guide_snmp_page_message"] = "Visit page <a href='%{url}'> SNMP</a> to add this host to the list of configured SNMP devices.",
    ["not_configured_as_snmp_device_message"] = "Host %{host_ip} has not been configured as an SNMP device.",
    ["showing_snmp_mib_info_default_community_message"] = "Showing SNMP MIB information retrieved using the default community '%{community}'",
    ["snmp_device_not_found"] = "SNMP device \"%{host}\" cannot be found: perhaps it has been removed from the list of configured SNMP devices ?",
    ["trying_to_retrive_message"] = "Trying to retrieve host SNMP MIB using the default community '%{community}'",
    ["unable_to_retrive_snmp_default_community_message"] = "Unable to retrieve host SNMP MIB using the default community '%{community}'.",
  },
  ["snmp_ratio_errors"] = {
    ["flowdevice_timeseries_not_existing"] = "Not available.",
    ["flowdevice_timeseries_query_failed"] = "Timeseries unreadable",
    ["nan_ratio"] = "Ratio is not a number.",
    ["negative_ratio"] = "Negative ratio.",
    ["ok"] = "OK",
    ["snmp_timeseries_not_enabled"] = "Timeseries disabled.",
    ["snmp_timeseries_not_existing"] = "Not available.",
    ["snmp_timeseries_query_failed"] = "Timeseries unreadable.",
    ["snmp_timeseries_zero_total"] = "No data.",
    ["timeseries_start_time_mismatch"] = "Timeseries not aligned.",
  },
  ["sprobe_page"] = {
    ["active_memory"] = "Active memory",
    ["latency"] = "Latency",
    ["processes"] = "Processes",
    ["processes_traffic_tree"] = "Processes Traffic Tree",
    ["show_more_info"] = "Mouse over to show the process information or double click to show more information.",
    ["system_interactions"] = "System Interactions",
    ["top_processes"] = "Top Processes",
    ["top_users"] = "Top Users",
    ["tree"] = "Tree",
    ["users"] = "Users",
  },
  ["sub_interfaces"] = {
    ["add_sub_if"] = "Add Sub-Interface",
    ["add_sub_if_success"] = "Sub-Interface created successfully. A restart of ntopng is required for the change to have effect.",
    ["collection_filter_description"] = "NetFlow fields can also be used, including INPUT_SNMP, OUTPUT_SNMP, SRC_VLAN, DST_VLAN. Non-numeric values should be provided with single quotes.",
    ["confirm_delete"] = "Are you sure you want to delete %{name}?",
    ["delete"] = "Delete Sub-Interface",
    ["disaggregation"] = "Custom Traffic Disaggregation",
    ["filter_description"] = "An extended nBPF format is supported. In addition to the standard BPF syntax, it is possible to use special keyworks like <i>local</i> and <i>remote</i> (combined with <i>src</i> and <i>dst</i> qualifiers).",
    ["filter_examples"] = "Filter examples",
    ["invalid_xnbpf"] = "Invalid nBPF filter",
    ["note"] = "ntopng can use BPF-like filters to disaggregate incoming traffic, diverting it to logical sub-interfaces. The same traffic can be diverted to multiple interfaces in case of overlapping in the filters.",
    ["sub_if_name"] = "Sub-Interface Name",
    ["traffic_filter_nbpf"] = "Traffic Filter (nBPF Format)",
    ["traffic_filter_xnbpf"] = "Traffic Filter (Extended nBPF Format)",
  },
  ["syslog"] = {
    ["add"] = "Add Log Producer",
    ["bad_action_param"] = "Bad \"action\" paramater",
    ["confirm_delete"] = "Do you really want to remove this producer?",
    ["edit"] = "Edit Log Producer",
    ["empty_action"] = "Something went wrong (empty action). Reload the page and try again.",
    ["host_add_ok"] = "Host %{host} was successfully added!",
    ["host_delete_ok"] = "Host %{host} was successfully deleted!",
    ["host_edit_ok"] = "Host %{host} was successfully edited!",
    ["host_exists"] = "Host \"%{host}\" already exists",
    ["host_not_exists"] = "Host \"%{host}\" not found",
    ["ip_or_device"] = "IP or Device Name",
    ["ip_or_device_note"] = "The Log Producer IP should match the IP or the Device Name as it appears in the syslog message. Example:<br />Thu Apr 10 16:30:00 2020;<strong>10.0.0.1</strong>; <181>Thu Apr 10 16:30:00 <strong>sslvpn-device-01</strong> logserver: ...",
    ["producer_host"] = "Log Producer IP",
    ["producer_type"] = "Log Producer Type",
    ["producers"] = "Syslog Log Producers",
  },
  ["syslog_alert_endpoint"] = {
    ["content"] = "Content",
    ["syslog_alert_format"] = "Format",
    ["text"] = "Text",
  },
  ["system_alerts_stats"] = {
    ["internal_alerts_queue"] = "Internal Queue",
    ["notes_enq_deq"] = "'Fill Level' is the fraction of queued alerts, with reference to the queue size. 'Dropped' is the fraction of alerts dropped due to queue full, with reference to the total number of alerts",
    ["notes_internal_alerts_queue"] = "The Internal Queue is used in combination with SQLite to handle alerts generated in the core and show them inside the UI",
    ["queues_status"] = "Fill Level / Dropped",
  },
  ["system_interfaces_stats"] = {
    ["local_hosts"] = "Local Hosts",
    ["remote_hosts"] = "Remote Hosts",
  },
  ["system_stats"] = {
    ["cpu_states_monitor"] = "CPU States Monitor",
    ["cpu_states_monitor_description"] = "Monitors the states of the CPU (e.g., user, system, idle and iowait)",
    ["disk_monitor"] = "Disk Monitor",
    ["disk_monitor_description"] = "Monitors free disk space",
    ["dropped_points"] = "Dropped Points",
    ["export_failures"] = "Failed Exports",
    ["export_retries"] = "Retried Exports",
    ["exported_points"] = "Total Points",
    ["exported_vs_dropped_points"] = "Total vs Dropped Points",
    ["exports"] = "Total Exports",
    ["exports_label"] = "Exports",
    ["health"] = "Health",
    ["high_series_cardinality"] = "An high cardinality can cause database slowdowns",
    ["infludb_retried_vs_failed_exports"] = "Retried/Failed exports",
    ["influxdb_health_green"] = "OK",
    ["influxdb_health_green_descr"] = "Export to InfluxDB is working OK.",
    ["influxdb_health_red"] = "Failing to export",
    ["influxdb_health_red_descr"] = "InfluxDB unreachable or too slow, unable to keep up with it. Dropping points.",
    ["influxdb_health_yellow"] = "Temporarily unable to export",
    ["influxdb_health_yellow_descr"] = "Currently unable to export to InfluxDB. Retry in progress.",
    ["influxdb_note_docs"] = "Documentation with detailed descriptions of all the fields shown is available in the ntopng <a target='_blank' href='%{url}'>User's guide</a>.",
    ["influxdb_storage"] = "Storage (%{dbname})",
    ["last_ip"] = "Last IP",
    ["series_cardinality"] = "Series Cardinality",
    ["short_desc_influxdb_cardinality"] = "An indication of how challenging is for InfluxDB to handle written points.",
    ["short_desc_influxdb_dropped_points"] = "Total number of points dropped due to InfluxDB write failures.",
    ["short_desc_influxdb_exported_points"] = "Total number of points successfully written into InfluxDB.",
    ["short_desc_influxdb_exports"] = "Total number of successful writes into InfluxDB.",
    ["short_desc_influxdb_health"] = "Current InfluxDB export health.",
    ["short_desc_influxdb_ram_memory"] = "Total memory InfluxDB has obtained from the operating system.",
    ["short_desc_influxdb_storage_utilization"] = "Total disk space used by InfluxDB.",
    ["value"] = "Value",
    ["write_througput"] = "Write Througput",
    ["redis"] = {
      ["command_hits"] = "%{cmd} Calls",
      ["commands"] = "Commands",
      ["redis_health_green"] = "OK",
      ["redis_health_green_descr"] = "Redis is working OK.",
      ["redis_health_red"] = "Persistence Issues",
      ["redis_health_red_descr"] = "Redis is unable to persist data. Expect %{product} to malfunction.",
      ["redis_keys"] = "Database Keys",
      ["redis_monitor"] = "Redis Monitor",
      ["redis_monitor_description"] = "Monitor the Redis health",
      ["short_desc_redis_health"] = "Current Redis health.",
      ["short_desc_redis_keys"] = "Total keys in the Redis database.",
      ["short_desc_redis_ram_memory"] = "Total memory Redis has obtained from the operating system.",
      ["top_redis_commands"] = "Top Commands Calls",
      ["tot_calls"] = "Total Calls",
    },
  },
  ["telemetry_page"] = {
    ["crash_report"] = "Crash Report",
    ["crash_report_descr"] = "A crash report is sent upon %{product} anomalous termination. Crash report contains %{product} information such as version, build architecture, operating system and startup options. Nothing regarding the monitored traffic is ever sent. Following is an example of a crash report:",
    ["last_data_sent"] = "Last Data Sent",
    ["send_telemetry_data"] = "Contribute by sending telemetry data",
    ["telemetry_data"] = "Telemetry Data",
    ["telemetry_data_change_preference"] = "<a href='%{url}'>change</a>",
    ["telemetry_data_no_consent"] = "No preference expressed",
  },
  ["top_hosts"] = {
    ["note"] = "<b>Note</b><br>This page will refresh every few seconds to report top hosts activities.<p>When a host makes traffic a vertical bar is displayed so that you can see the most active hosts.",
    ["top_hosts_local"] = "Top Hosts (Local)",
  },
  ["topk_heuristic"] = {
    ["precision"] = {
      ["aggressive"] = "Aggressive",
      ["disabled"] = "Disabled",
      ["less_accurate"] = "Less Accurate",
      ["more_accurate"] = "More Accurate",
    },
  },
  ["traffic_page"] = {
    ["flow_distribution"] = "Flow Distribution",
    ["flow_duration"] = "Total Flow Duration",
    ["flow_frequency"] = "New Flow Creation Frequency",
    ["hosts_contacts_cardinality"] = "Total Unique Hosts Contacts",
    ["l4_proto_overview"] = "Protocol Overview",
    ["no_traffic_observed_message"] = "No traffic has been observed for the specified host",
    ["num_contacted_hosts_as_client"] = "Hosts Contacted (as Client)",
    ["num_host_contacts_as_server"] = "Hosts Contacts (as Server)",
    ["rcvd"] = "Rcvd",
  },
  ["traffic_profiles"] = {
    ["advanced_filter_examples"] = "Advanced Filters Examples",
    ["all_profiles"] = "All Profiles",
    ["confirm_delete_profile"] = "Do you really want to delete the profile",
    ["delete_profile"] = "Delete Profile",
    ["destination_network"] = "Destination network",
    ["duplicate_profile"] = "Duplicate profile name",
    ["edit_traffic_profiles"] = "Traffic Profiles",
    ["enter_profile_filter"] = "Enter the profile filter",
    ["enter_profile_name"] = "Enter a profile name",
    ["facebook_traffic"] = "Facebook",
    ["host_http_https"] = "Host HTTP/HTTPS",
    ["host_traffic"] = "Host",
    ["http_traffic"] = "HTTP",
    ["invalid_bpf"] = "Invalid BPF filter",
    ["max_profiles_num"] = "With this version of ntopng you can only create %{maxnum} profiles. Upgrade to the Enterprise version to remove this limit",
    ["no_profiles"] = "No profiles set",
    ["note"] = "Note",
    ["note_0"] = "Traffic profile names allow alpha-numeric characters, spaces, and underscores",
    ["note_1"] = "Traffic profiles are applied to flows. Each flow can have up to one profile, thus in case of multiple profile matches, only the first one is selected",
    ["profile_name"] = "Profile Name",
    ["see_ndpi_protos"] = "(use %{option} to print all nDPI supported protocols)",
    ["simple_filter_examples"] = "Simple Filters Examples",
    ["source_ethernet"] = "Source MAC address",
    ["traffic_between"] = "Traffic between hosts",
    ["traffic_filter_bpf"] = "Traffic Filter (nBPF Format)",
    ["traffic_from_to"] = "Traffic from an host to another",
    ["traffic_profiles"] = "Traffic Profiles",
  },
  ["traffic_recording"] = {
    ["about_to_extract"] = "About to extract traffic from <b>%{date_begin}</b> to <b>%{date_end}</b>",
    ["active_since"] = "Active Since",
    ["archive"] = "Archive",
    ["completed"] = "Completed",
    ["continuous_recording"] = "Continuous Traffic Recording",
    ["continuous_recording_and_flows"] = "Continuous Traffic Recording and Flow Visibility",
    ["delete_all_jobs"] = "Delete All Jobs",
    ["delete_all_jobs_confirm"] = "Do you really want to delete all the extraction jobs? Active jobs will be stopped.",
    ["delete_job"] = "Delete Job",
    ["delete_job_confirm"] = "Do you really want to delete Job %{job_id} and the related Pcap files?",
    ["disabled"] = "Disabled",
    ["disk_space"] = "Max Disk Space",
    ["disk_space_note"] = "Maximum disk space used for recorded traffic on disk.",
    ["disk_space_note_in_use"] = "%{in_use} GB are already in use by this instance.",
    ["download"] = "Download",
    ["download_nth_pcap"] = "Download Pcap #{0}",
    ["dump_window"] = "Dump Window",
    ["edit_filter"] = "Edit Filter",
    ["err_alloc"] = "memory allocation error",
    ["err_filter"] = "unsupported filter",
    ["err_open"] = "unable to open dump",
    ["err_stuck"] = "stuck or interrupted",
    ["err_unknown"] = "unexpected error",
    ["ext_interface"] = "External Interface",
    ["extract_action"] = "Extract",
    ["extract_now"] = "Extract now",
    ["extracted_bytes"] = "Extracted Bytes",
    ["extracted_packets"] = "Extracted Packets",
    ["extraction_scheduled"] = "A new extraction job has been scheduled, please check the %{page} page to download the pcap as soon as the file is ready. The job ID for this extraction is ",
    ["failed"] = "Failed",
    ["failure"] = "Failure",
    ["failure_note"] = "Please check the log trace and try restarting the service.",
    ["filter_bpf"] = "Filter (nBPF Format)",
    ["filter_examples"] = "Filter Examples",
    ["global_settings_note"] = "Global settings (e.g. the license key) can be configured from the <a href=\"%{url}\">Traffic Recording preferences</a>.",
    ["invalid_bpf"] = "Invalid filter",
    ["job_date_time"] = "Job Creation Date/Time",
    ["job_id"] = "Job ID",
    ["jobs"] = "Jobs",
    ["logs"] = "Traffic Recording Logs",
    ["max_extracted_pcap_bytes_description"] = "Maximum size for pcap files extracted from recorded data. In case of extractions exceeding this size, the output will be split into multiple files.",
    ["max_extracted_pcap_bytes_title"] = "Max Extracted File Size",
    ["missing_data_msg"] = "Traffic recording has been stopped or restarted. Some data may be missing.",
    ["missing_parameters"] = "Mandatory parameters are missing",
    ["msg_err_missing_timeline"] = "Unable to determine the timeline of the currently running n2disk. Extractions can only be performed when n2disk is up-to-date and run with option --timeline-dir.",
    ["msg_err_timeline_path_not_existing"] = "Timeline path not found in the system.",
    ["msg_err_unable_to_access_timeline"] = "Unable to read recorded data. Insufficient permissions. Make sure the user running ntopng is in the same group of the user running n2disk.",
    ["msg_err_unknown"] = "Unknown status.",
    ["msg_external_providers_detected"] = "External traffic recording providers detected. ntopng can automatically bind this interface to an external provider. You can let ntopng take care of the recording using this page, or you can <a href=\"%{url}\"><i class=\"fas fa-cog\"></i> configure</a> an external traffic recording provider.",
    ["msg_ok"] = "Ready to extract",
    ["multiple_extracted_files"] = "Traffic extraction generated multiple pcap files of %{mb} MB, it is possible to change this limit from Preferences. Click on the links below to download the pcap files.",
    ["no_data_in_interval"] = "There is no (or partial) pcap data on disk for the selected time interval. Please note that pcap data is dumped every minute (latest minute is not available) and old data is deleted (please check the current dump window in the <A HREF=\"%{page}\">status page</A>). Please try selecting a different time interval.",
    ["no_file"] = "No files dumped yet",
    ["no_recorded_data"] = "No recorded data in the specified time frame. Traffic recorder needs some time to write recent data.",
    ["not_found"] = "File not found",
    ["not_granted"] = "Request not granted",
    ["note_dump"] = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble, start of frame, CRC, IFG]. Such overhead is accounted to the interface traffic, but it is not added to the traffic being dumped on disk. For this reason the number of bytes in this page may differ from those reported in the interface chart.",
    ["packet_dumps"] = "Packet Dumps",
    ["pcap_download"] = "Extract pcap",
    ["pcap_download_message"] = "Start the extraction and check the %{page} page to download the pcap as soon as the file is ready.",
    ["processing"] = "Processing",
    ["queue_as_job"] = "Queue as a Job",
    ["recording"] = "Recording",
    ["restart"] = "Restart",
    ["restart_service"] = "Restart the service",
    ["settings"] = "Settings",
    ["start_extraction"] = "Start Extraction",
    ["stop_job"] = "Stop Job",
    ["stop_job_confirm"] = "Do you really want to stop Job %{job_id}?",
    ["stopped"] = "Stopped",
    ["storage"] = "Storage",
    ["storage_dir"] = "Storage Directory",
    ["storage_directory_config"] = "The Storage Directory path can be changed by specifing the <i>%{option}</i> option into the %{product} configuration file.",
    ["storage_utilization"] = "Storage Utilization",
    ["storage_utilization_pcap"] = "pcap Storage Utilization",
    ["traffic_extraction_jobs"] = "Traffic Extraction Jobs",
    ["traffic_extractions"] = "Extractions",
    ["traffic_on_disk"] = "Traffic On Disk",
    ["traffic_recording"] = "Traffic Recording",
    ["traffic_recording_provider"] = "Traffic Recording Provider",
    ["traffic_recording_settings"] = "Traffic Recording Settings",
    ["traffic_recording_status"] = "Traffic Recording Status",
    ["unsupported_fields"] = "Note that the selected chart provides a view of the traffic not fully supported by the extraction tool, extracted traffic will contain more traffic than expected.",
    ["waiting"] = "Waiting",
    ["waiting_nospace"] = "Waiting (No Space On Disk)",
  },
  ["traffic_report"] = {
    ["current_day"] = "Current Day",
    ["current_month"] = "Current Month",
    ["current_week"] = "Current Week",
    ["daily"] = "Daily",
    ["header_daily"] = "Daily report",
    ["header_monthly"] = "Monthly report",
    ["header_weekly"] = "Weekly report",
    ["monthly"] = "Monthly",
    ["previous_day"] = "Previous Day",
    ["previous_month"] = "Previous Month",
    ["previous_week"] = "Previous Week",
    ["weekly"] = "Weekly",
  },
  ["tree_map"] = {
    ["hosts_treemap"] = "Hosts Tree Map",
  },
  ["unknown_devices"] = {
    ["active_only"] = "Active Only",
    ["all_devices"] = "All Devices",
    ["assign_device_pool"] = "Assign Device to a Pool",
    ["assign_pool"] = "Assign To Pool",
    ["device_name"] = "Device Name",
    ["devices_only_note"] = "A device is considered unassigned if there are no pool members defined with such MAC address. IP-based member addresses do not apply here.",
    ["filter_devices"] = "Filter Devices",
    ["first_seen"] = "First Seen",
    ["inactive_only"] = "Inactive Only",
    ["last_seen"] = "Last Seen",
    ["no_pools"] = "An host pool must be created in order to assign unknown devices to.",
    ["select_pool"] = "Please select an host pool from the dropdown below to assign '%{mac}' to:",
    ["unassigned_devices"] = "Unassigned Host Pool Devices",
  },
  ["updates"] = {
    ["available"] = "New",
    ["check"] = "Check for updates",
    ["checking"] = "Checking for updates..",
    ["install"] = "Install update",
    ["install_confirm"] = "Do you want to update and restart ntopng now?",
    ["installing"] = "Installing update..",
    ["maintenance_expired"] = "Please note that maintenance for this product has expired, you need to renew the license after the upgrade.",
    ["no_updates"] = "No updates available",
    ["update_failure_message"] = "Something went wrong during the update, please retry or try manually",
  },
  ["user_activity"] = {
    ["add_ntopng_user"] = "User '%{user}' added new user %{new_user}.",
    ["add_pool"] = "User '%{user}' created new pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["alerts_deleted"] = "User '%{user}' purged '%{status}' alerts.",
    ["bind_pool_member"] = "User '%{user}' added member %{member} to pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["changed_preference"] = "User '%{user}' changed settings for %{pref}.",
    ["delete_ntopng_user"] = "User '%{user}' deleted user %{old_user}.",
    ["delete_pool"] = "User '%{user}' deleted pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["deleted_all_interfaces_data"] = "User '%{user}' deleted data for all interfaces.",
    ["deleted_host_data"] = "User '%{user}' deleted data for host %{host} on interface %{ifname}.",
    ["deleted_inactive_interfaces_data"] = "User '%{user}' deleted data for all inactive interfaces.",
    ["deleted_interface_data"] = "User '%{user}' deleted data for interface %{ifname}.",
    ["deleted_network_data"] = "User '%{user}' deleted data for network %{network} on interface %{ifname}.",
    ["disabled_preference"] = "User '%{user}' disabled preference %{pref}.",
    ["edit_pool"] = "User '%{user}' edited pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["enabled_preference"] = "User '%{user}' enabled preference %{pref}.",
    ["exported_data"] = "User '%{user}' exported JSON data for '%{mode}' hosts.",
    ["exported_data_host"] = "User '%{user}' exported JSON data for '%{mode}' host %{host}.",
    ["file_downloaded"] = "User '%{user}' downloaded file '%{file}'.",
    ["flows_downloaded"] = "User '%{user}' downloaded flows data from %{from} to %{to}.",
    ["host_json_downloaded"] = "User '%{user}' downloaded JSON data for host %{host}.",
    ["live_capture"] = "User '%{user}' captured live traffic on interface %{ifname}.",
    ["live_capture_host"] = "User '%{user}' captured live traffic for host %{host} on interface %{ifname}.",
    ["live_capture_host_with_filter"] = "User '%{user}' captured live traffic for host %{host} matching filter '%{filter}' on interface %{ifname}.",
    ["live_capture_with_filter"] = "User '%{user}' captured live traffic matching filter '%{filter}' on interface %{ifname}.",
    ["live_extraction"] = "User '%{user}' downloaded traffic from interface %{ifname} from %{from} to %{to}.",
    ["live_extraction_with_filter"] = "User '%{user}' downloaded traffic from interface %{ifname} from %{from} to %{to} matching filter '%{filter}'.",
    ["login_not_authorized"] = "Login denied for user '%{user}'.",
    ["login_successful"] = "User '%{user}' logged in.",
    ["password_changed"] = "Password for user '%{pwd_user}' changed by '%{user}' with ip '%{ip}'.",
    ["recording_disabled"] = "User '%{user}' disabled Traffic Recording on interface %{ifname}.",
    ["recording_enabled"] = "User '%{user}' enabled Traffic Recording on interface %{ifname}.",
    ["remote_assistance_disabled"] = "User '%{user}' disabled Remote Assistance.",
    ["remote_assistance_enabled"] = "User '%{user}' enabled Remote Assistance.",
    ["set_host_alias"] = "User '%{user}' set alias for host %{host} to %{alias}.",
    ["set_pool_config"] = "User '%{user}' imported pool configuration.",
    ["set_scripts_config"] = "User '%{user}' imported user scripts configuration.",
    ["snmp_device_added"] = "User '%{user}' added SNMP device %{ip}.",
    ["snmp_device_deleted"] = "User '%{user}' deleted SNMP device %{ip}.",
    ["unknown_activity"] = "User '%{user}' did some unknown activity (%{scope}), please report this.",
    ["unknown_activity_function"] = "User '%{user}' did some unknown activity (%{name}), please report this.",
    ["user_added"] = "User '%{add_user}' added by '%{user}'.",
    ["user_deleted"] = "User '%{del_user}' deleted by '%{user}'.",
  },
  ["user_info"] = {
    ["missing_user_name_message"] = "Missing user name",
    ["processes"] = "Processes",
    ["processes_overview"] = "Processes Overview",
    ["top_l4_protocols"] = "Top Protocols",
    ["top_l7_protocols"] = "Top Applications",
  },
  ["user_scripts"] = {
    ["categories"] = "Categories",
    ["category"] = "Category",
    ["category_internals"] = "Internals",
    ["category_internals_descr"] = "Internal functionalitis of %{product} (e.g., memory management and host and flows lifecycles)",
    ["category_network"] = "Network",
    ["category_network_descr"] = "Network behaviors and anomalies (e.g., traffic above a certain threshold, TCP not working as expected)",
    ["category_other"] = "Other",
    ["category_other_descr"] = "Default category for uncategorized scripts or for those that cannot be included in any of the other categories",
    ["category_security"] = "Security",
    ["category_security_descr"] = "Security behaviors and anomalies (e.g, contacts from or to a blacklisted host, TCP and UDP scans)",
    ["category_system"] = "System",
    ["category_system_descr"] = "Functionalities of the system on top of which %{product} is running (e.g, disk space full, load too high)",
    ["disable_all"] = "Disable All",
    ["disable_all_message"] = "Disable all user scripts for the current configuration.",
    ["disable_all_user_scripts"] = "Disable All User Scripts",
    ["elephant_flows_descr"] = "> %{l2r_bytes} (L2R), > %{r2l_bytes} (R2L)",
    ["exceptions"] = "Exceptions: %{exceptions}",
    ["long_lived_flows_descr"] = "> %{duration}",
    ["note_apply_to_default"] = "The <b>Default</b> configuration is also 'Applied to' any pool which is not included in any other configuration.",
    ["note_configsets"] = "User scripts are configured and enabled/disabled on a per-configuration basis. Multiple configurations can be created and each configuration can be 'Applied To' multiple pools.",
    ["note_what_are_user_scripts"] = "<a href=\"%{user_scripts_url}\">User scripts</a> %{user_scripts_external} are executed periodically or when a certain event occurs. ",
    ["stop_recording_after"] = "Stop recording after %{duration}",
    ["hint"] = {
      ["body"] = "Configure unexpected <a href='%{link_DHCP}' target='_about'>DHCP</a>, <a href='%{link_SMTP}' target='_about'>SMTP</a>, <a href='%{link_DNS}' target='_about'>DNS</a>, <a href='%{link_NTP}' target='_about'>NTP</a> servers.",
      ["title"] = "Unexpected Servers",
    },
  },
  ["users"] = {
    ["add_new_user"] = "Add New User",
    ["add_user"] = "Add User",
    ["assigned_devices"] = "Assigned Devices",
    ["cat_protocols"] = "%{cat} Applications",
    ["categories"] = "Categories",
    ["client_policy"] = "Device As Client",
    ["confirm_delete_user"] = "Do you really want to delete user \"%{user}\"?",
    ["delete_user"] = "Delete User",
    ["delete_user_error"] = "Could not delete the user. Please check out the program log for more details.",
    ["devices"] = "Devices",
    ["edit"] = "Edit",
    ["edit_global_policies"] = "Edit Default Policies",
    ["fallback_policy"] = "Fallback Policy",
    ["full_name"] = "Full Name",
    ["global"] = "Global",
    ["global_policies"] = "Default Policies",
    ["no_users"] = "No users",
    ["num_protocols"] = "Num Applications",
    ["policy"] = "Policy",
    ["protocols"] = "Applications",
    ["reset_to_defaults"] = "Reset To Defaults",
    ["reset_to_defaults_confirm"] = "Do you really want to reset the device type \"%{devtype}\" policies to to the defaults?",
    ["server_policy"] = "Device As Server",
    ["settings"] = "Settings",
    ["total_daily_time_quota"] = "Total Daily Time Quota",
    ["total_daily_traffic_quota"] = "Total Daily Traffic Quota",
    ["unchanged"] = "Unchanged",
    ["user_exists"] = "User \"%{user}\" already exists",
    ["user_x"] = "User: %{user}",
    ["users"] = "Users",
    ["shapers"] = {
      ["default"] = "Default",
      ["drop"] = "Drop",
      ["pass"] = "Pass",
      ["slow"] = "Slow Pass",
      ["slower"] = "Slower Pass",
    },
  },
  ["validation"] = {
    ["FAILED_HTTP_REQUEST"] = "The request failed, please try later.",
    ["empty_name"] = "Please insert a name.",
    ["invalid_input"] = "Please respect the input pattern.",
    ["missing_field"] = "Please fill the input.",
  },
  ["vlan_details"] = {
    ["no_available_stats_for_vlan_message"] = "No available stats for VLAN %{vlan_id}. Please wait a few minutes to allow %{product} to harvest new statistics.",
    ["vlan_id_parameter_missing_or_invalid_message"] = "Vlan_Id parameter is missing or is not valid",
  },
  ["vlan_stats"] = {
    ["vlan_id"] = "VLAN ID",
    ["vlans"] = "VLANs",
  },
  ["webhook_alert_endpoint"] = {
    ["password"] = "Password",
    ["shared_secret"] = "Shared Secret",
    ["url"] = "URL",
    ["username"] = "Username",
  },
}

return lang
