"""Generated message classes for sddc version v1alpha1.

Software Defined Datacenter
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'sddc'


class AddNodesRequest(_messages.Message):
  r"""Request for adding nodes to the given cluster until the target count is
  reached.

  Fields:
    nodeCount: Required. Number of desired bare metal nodes in this cluster.
  """

  nodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class AttributeValue(_messages.Message):
  r"""The allowed types for [VALUE] in a `[KEY]:[VALUE]` attribute.

  Fields:
    boolValue: A Boolean value represented by `true` or `false`.
    intValue: A 64-bit signed integer.
    stringValue: A string up to 256 bytes long.
  """

  boolValue = _messages.BooleanField(1)
  intValue = _messages.IntegerField(2)
  stringValue = _messages.MessageField('TruncatableString', 3)


class Attributes(_messages.Message):
  r"""A set of attributes, each in the format `[KEY]:[VALUE]`.

  Messages:
    AttributeMapValue: The set of attributes. Each attribute's key can be up
      to 128 bytes long. The value can be a string up to 256 bytes, a signed
      64-bit integer, or the Boolean values `true` and `false`. For example:
      "/instance_id": "my-instance" "/http/user_agent": ""
      "/http/request_bytes": 300 "abc.com/myattribute": true

  Fields:
    attributeMap: The set of attributes. Each attribute's key can be up to 128
      bytes long. The value can be a string up to 256 bytes, a signed 64-bit
      integer, or the Boolean values `true` and `false`. For example:
      "/instance_id": "my-instance" "/http/user_agent": ""
      "/http/request_bytes": 300 "abc.com/myattribute": true
    droppedAttributesCount: The number of attributes that were discarded.
      Attributes can be discarded because their keys are too long or because
      there are too many attributes. If this value is 0 then all attributes
      are valid.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributeMapValue(_messages.Message):
    r"""The set of attributes. Each attribute's key can be up to 128 bytes
    long. The value can be a string up to 256 bytes, a signed 64-bit integer,
    or the Boolean values `true` and `false`. For example: "/instance_id":
    "my-instance" "/http/user_agent": "" "/http/request_bytes": 300
    "abc.com/myattribute": true

    Messages:
      AdditionalProperty: An additional property for a AttributeMapValue
        object.

    Fields:
      additionalProperties: Additional properties of type AttributeMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributeMapValue object.

      Fields:
        key: Name of the additional property.
        value: A AttributeValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AttributeValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributeMap = _messages.MessageField('AttributeMapValue', 1)
  droppedAttributesCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    ignoreChildExemptions: A boolean attribute.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  ignoreChildExemptions = _messages.BooleanField(2)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 3)


class AuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: A read of admin (meta) data.
      ADMIN_WRITE: A write of admin (meta) data.
      DATA_READ: A read of standard data.
      DATA_WRITE: A write of standard data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class BillingView(_messages.Message):
  r"""Message for reporting billing requests through Eventstream.

  Fields:
    reportRequests: Billing requests to be reported for
      cloud.eventstream.v2.ResourceEvent Each request contains billing
      operations to be reported under a service name. See go/billing-view-
      construction for documentation on constructing billing view report
      requests.
  """

  reportRequests = _messages.MessageField('ReportRequest', 1, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    bindingId: A client-specified ID for this binding. Expected to be globally
      unique to support the internal bindings-by-ID API.
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  bindingId = _messages.StringField(1)
  condition = _messages.MessageField('Expr', 2)
  members = _messages.StringField(3, repeated=True)
  role = _messages.StringField(4)


class CloudAuditOptions(_messages.Message):
  r"""Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.

  Fields:
    authorizationLoggingOptions: Information used by the Cloud Audit Logging
      pipeline.
    logName: The log_name to populate in the Cloud Audit Record.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    r"""The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  authorizationLoggingOptions = _messages.MessageField('AuthorizationLoggingOptions', 1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)


class Cluster(_messages.Message):
  r"""A cluster in a cluater group. Cluster is a regional resource.

  Enums:
    StateValueValuesEnum: Output only. State of the resource.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    createTime: Output only. Creation time of the resource.
    defaultZone: Required. Default zone to host nodes.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    management: If the resource to be created a management cluster or not.
      There can only be one management cluster in an SDDC and it has to be the
      first one.
    name: Output only. The resource name of this Cluster. Resource names are
      schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/clusters/my-cluster`
    nodeCount: Required. Number of bare metal nodes in this cluster.
    nodeType: Required. The baremetal node type used to create a VMWare
      cluster. The only supported value is c1-highmem-72-metal.
    nodes: Output only. Nodes in the cluster.
    state: Output only. State of the resource.
    status: Output only. Deprecated. Use state instead. Status of the
      resource.
    updateTime: Output only. Update time of the resource.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the resource.

    Values:
      STATE_UNSPECIFIED: The default value. This value should never be used.
      ACTIVE: The cluster is ready.
      CREATING: The cluster is being created.
      UPDATING: The cluster is being updated.
      DELETING: The cluster is being deleted.
      FAILED: The cluster has experienced an issue and might be unusable.
      PENDING: The cluster has pending operation.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    UPDATING = 3
    DELETING = 4
    FAILED = 5
    PENDING = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  defaultZone = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  management = _messages.BooleanField(4)
  name = _messages.StringField(5)
  nodeCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  nodeType = _messages.StringField(7)
  nodes = _messages.MessageField('Node', 8, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  status = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class ClusterGroup(_messages.Message):
  r"""A cluster group resource. ClusterGroup is a regional resource.

  Enums:
    StateValueValuesEnum: State of the resource.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    createTime: Output only. Creation time of the resource.
    description: The description of this resource.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    name: Output only. The resource name of this ClusterGroup. Resource names
      are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-group`
    networkConfig: NetworkConfig passed in the param.
    nsx: Output only. Nsx information.
    state: State of the resource.
    status: Output only. Deprecated. Use state instead. Status of the
      resource.
    updateTime: Output only. Update time of the resource.
    vcenter: Output only. vCenter information.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the resource.

    Values:
      STATE_UNSPECIFIED: The default value. This value should never be used.
      ACTIVE: The cluster group is ready.
      CREATING: The cluster group is being created.
      DELETING: The cluster group is being deleted.
      UPDATING: The cluster group is being updated.
      FAILED: The cluster group has experienced an issue and might be
        unusable.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    UPDATING = 4
    FAILED = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  networkConfig = _messages.MessageField('NetworkConfig', 5)
  nsx = _messages.MessageField('Nsx', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  status = _messages.StringField(8)
  updateTime = _messages.StringField(9)
  vcenter = _messages.MessageField('Vcenter', 10)


class ClusterGroupBackup(_messages.Message):
  r"""Backup resource of the ClusterGroup.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    clusterGroupId: Identity of the ClusterGroup of which this resource is a
      backup.
    createTime: Output only. Creation time of the resource.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    name: Output only. The resource name of this ClusterGroupBackup. Resource
      names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroupBackups/my-
      backup`
    updateTime: Output only. Update time of the resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterGroupId = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    values: The objects of the condition.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext
        (go/security-realms). When used with IN, the condition indicates "any
        of the request's realms match one of the given values; with NOT_IN,
        "none of the realms match any of the given values". Note that a value
        can be: - 'self' (i.e., allow connections from clients that are in the
        same security realm) - 'self:metro' (i.e., clients that are in the
        same metro) - 'self:cloud-region' (i.e., allow connections from
        clients that are in the same cloud region) - 'guardians' (i.e., allow
        connections from its guardian realms. See go/security-realms-
        glossary#guardian for more information.) - a realm (e.g., 'campus-
        abc') - a realm group (e.g., 'realms-for-borg-cell-xx', see: go/realm-
        groups) A match is determined by a realm group membership check
        performed by a RealmAclRep object (go/realm-acl-howto). It is not
        permitted to grant access based on the *absence* of a realm, so realm
        conditions can only be used in a "positive" context (e.g., ALLOW/IN or
        DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        security.credentials.JustificationType, e.g. "MANUAL_STRING". It is
        not permitted to grant access based on the *absence* of a
        justification, so justification conditions can only be used in a
        "positive" context (e.g., ALLOW/IN or DENY/NOT_IN). Multiple
        justifications, e.g., a Buganizer ID and a manually-entered reason,
        are normal and supported.
      CREDENTIALS_TYPE: What type of credentials have been supplied with this
        request. String values should match enum names from
        security_loas_l2.CredentialsType - currently, only
        CREDS_TYPE_EMERGENCY is supported. It is not permitted to grant access
        based on the *absence* of a credentials type, so the conditions can
        only be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
      CREDS_ASSERTION: EXPERIMENTAL -- DO NOT USE. The conditions can only be
        used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5
    CREDENTIALS_TYPE = 6
    CREDS_ASSERTION = 7

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  values = _messages.StringField(5, repeated=True)


class CounterOptions(_messages.Message):
  r"""Increment a streamz counter with the specified metric and field names.
  Metric names should start with a '/', generally be lowercase-only, and end
  in "_count". Field names should not contain an initial slash. The actual
  exported metric names will have "/iam/policy" prepended. Field names
  correspond to IAM request parameters and field values are their respective
  values. Supported field names: - "authority", which is "[token]" if
  IAMContext.token is present, otherwise the value of
  IAMContext.authority_selector if present, and otherwise a representation of
  IAMContext.principal; or - "iam_principal", a representation of
  IAMContext.principal even if a token or authority selector is present; or -
  "" (empty string), resulting in a counter with no fields. Examples: counter
  { metric: "/debug_access_count" field: "iam_principal" } ==> increment
  counter /iam/policy/debug_access_count {iam_principal=[value of
  IAMContext.principal]}

  Fields:
    customFields: Custom fields.
    field: The field value to attribute.
    metric: The metric to update.
  """

  customFields = _messages.MessageField('CustomField', 1, repeated=True)
  field = _messages.StringField(2)
  metric = _messages.StringField(3)


class CustomField(_messages.Message):
  r"""Custom fields. These can be used to create a counter with arbitrary
  field/value pairs. See: go/rpcsp-custom-fields.

  Fields:
    name: Name is the field name.
    value: Value is the field value. It is important that in contrast to the
      CounterOptions.field, the value here is a constant that is not derived
      from the IAMContext.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  r"""Write a Data Access (Gin) log

  Enums:
    LogModeValueValuesEnum:

  Fields:
    logMode: A LogModeValueValuesEnum attribute.
  """

  class LogModeValueValuesEnum(_messages.Enum):
    r"""LogModeValueValuesEnum enum type.

    Values:
      LOG_MODE_UNSPECIFIED: Client is not required to write a partial Gin log
        immediately after the authorization check. If client chooses to write
        one and it fails, client may either fail open (allow the operation to
        continue) or fail closed (handle as a DENY outcome).
      LOG_FAIL_CLOSED: The application's operation in the context of which
        this authorization check is being made may only be performed if it is
        successfully logged to Gin. For instance, the authorization library
        may satisfy this obligation by emitting a partial log entry at
        authorization check time and only returning ALLOW to the application
        if it succeeds. If a matching Rule has this directive, but the client
        has not indicated that it will honor such requirements, then the IAM
        check will result in authorization failure by setting
        CheckPolicyResponse.success=false.
    """
    LOG_MODE_UNSPECIFIED = 0
    LOG_FAIL_CLOSED = 1

  logMode = _messages.EnumField('LogModeValueValuesEnum', 1)


class Distribution(_messages.Message):
  r"""Distribution represents a frequency distribution of double-valued sample
  points. It contains the size of the population of sample points plus
  additional optional information: - the arithmetic mean of the samples - the
  minimum and maximum of the samples - the sum-squared-deviation of the
  samples, used to compute variance - a histogram of the values of the sample
  points

  Fields:
    bucketCounts: The number of samples in each histogram bucket.
      `bucket_counts` are optional. If present, they must sum to the `count`
      value. The buckets are defined below in `bucket_option`. There are N
      buckets. `bucket_counts[0]` is the number of samples in the underflow
      bucket. `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of
      samples in each of the finite buckets. And `bucket_counts[N] is the
      number of samples in the overflow bucket. See the comments of
      `bucket_option` below for more details. Any suffix of trailing zeros may
      be omitted.
    count: The total number of samples in the distribution. Must be >= 0.
    exemplars: Example points. Must be in increasing order of `value` field.
    explicitBuckets: Buckets with arbitrary user-provided width.
    exponentialBuckets: Buckets with exponentially growing width.
    linearBuckets: Buckets with constant width.
    maximum: The maximum of the population of values. Ignored if `count` is
      zero.
    mean: The arithmetic mean of the samples in the distribution. If `count`
      is zero then this field must be zero.
    minimum: The minimum of the population of values. Ignored if `count` is
      zero.
    sumOfSquaredDeviation: The sum of squared deviations from the mean:
      Sum[i=1..count]((x_i - mean)^2) where each x_i is a sample values. If
      `count` is zero then this field must be zero, otherwise validation of
      the request fails.
  """

  bucketCounts = _messages.IntegerField(1, repeated=True)
  count = _messages.IntegerField(2)
  exemplars = _messages.MessageField('Exemplar', 3, repeated=True)
  explicitBuckets = _messages.MessageField('ExplicitBuckets', 4)
  exponentialBuckets = _messages.MessageField('ExponentialBuckets', 5)
  linearBuckets = _messages.MessageField('LinearBuckets', 6)
  maximum = _messages.FloatField(7)
  mean = _messages.FloatField(8)
  minimum = _messages.FloatField(9)
  sumOfSquaredDeviation = _messages.FloatField(10)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Exemplar(_messages.Message):
  r"""Exemplars are example points that may be used to annotate aggregated
  distribution values. They are metadata that gives information about a
  particular value added to a Distribution bucket, such as a trace ID that was
  active when a value was added. They may contain further information, such as
  a example values and timestamps, origin, etc.

  Messages:
    AttachmentsValueListEntry: A AttachmentsValueListEntry object.

  Fields:
    attachments: Contextual information about the example value. Examples are:
      Trace: type.googleapis.com/google.monitoring.v3.SpanContext Literal
      string: type.googleapis.com/google.protobuf.StringValue Labels dropped
      during aggregation:
      type.googleapis.com/google.monitoring.v3.DroppedLabels There may be only
      a single attachment of any given message type in a single exemplar, and
      this is enforced by the system.
    timestamp: The observation (sampling) time of the above value.
    value: Value of the exemplar point. This value determines to which bucket
      the exemplar belongs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttachmentsValueListEntry(_messages.Message):
    r"""A AttachmentsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        AttachmentsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttachmentsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attachments = _messages.MessageField('AttachmentsValueListEntry', 1, repeated=True)
  timestamp = _messages.StringField(2)
  value = _messages.FloatField(3)


class ExplicitBuckets(_messages.Message):
  r"""Describing buckets with arbitrary user-provided width.

  Fields:
    bounds: 'bound' is a list of strictly increasing boundaries between
      buckets. Note that a list of length N-1 defines N buckets because of
      fenceposting. See comments on `bucket_options` for details. The i'th
      finite bucket covers the interval [bound[i-1], bound[i]) where i ranges
      from 1 to bound_size() - 1. Note that there are no finite buckets at all
      if 'bound' only contains a single element; in that special case the
      single bound defines the boundary between the underflow and overflow
      buckets. bucket number lower bound upper bound i == 0 (underflow) -inf
      bound[i] 0 < i < bound_size() bound[i-1] bound[i] i == bound_size()
      (overflow) bound[i-1] +inf
  """

  bounds = _messages.FloatField(1, repeated=True)


class ExponentialBuckets(_messages.Message):
  r"""Describing buckets with exponentially growing width.

  Fields:
    growthFactor: The i'th exponential bucket covers the interval [scale *
      growth_factor^(i-1), scale * growth_factor^i) where i ranges from 1 to
      num_finite_buckets inclusive. Must be larger than 1.0.
    numFiniteBuckets: The number of finite buckets. With the underflow and
      overflow buckets, the total number of buckets is `num_finite_buckets` +
      2. See comments on `bucket_options` for details.
    scale: The i'th exponential bucket covers the interval [scale *
      growth_factor^(i-1), scale * growth_factor^i) where i ranges from 1 to
      num_finite_buckets inclusive. Must be > 0.
  """

  growthFactor = _messages.FloatField(1)
  numFiniteBuckets = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  scale = _messages.FloatField(3)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class HttpRequest(_messages.Message):
  r"""A common proto for logging HTTP requests. Only contains semantics
  defined by the HTTP specification. Product-specific logging information MUST
  be defined in a separate message.

  Fields:
    cacheFillBytes: The number of HTTP response bytes inserted into cache. Set
      only when a cache fill was attempted.
    cacheHit: Whether or not an entity was served from cache (with or without
      validation).
    cacheLookup: Whether or not a cache lookup was attempted.
    cacheValidatedWithOriginServer: Whether or not the response was validated
      with the origin server before being served from cache. This field is
      only meaningful if `cache_hit` is True.
    latency: The request processing latency on the server, from the time the
      request was received until the response was sent.
    protocol: Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2",
      "websocket"
    referer: The referer URL of the request, as defined in [HTTP/1.1 Header
      Field
      Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
    remoteIp: The IP address (IPv4 or IPv6) of the client that issued the HTTP
      request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
    requestMethod: The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`,
      `"POST"`.
    requestSize: The size of the HTTP request message in bytes, including the
      request headers and the request body.
    requestUrl: The scheme (http, https), the host name, the path, and the
      query portion of the URL that was requested. Example:
      `"http://example.com/some/info?color=red"`.
    responseSize: The size of the HTTP response message sent back to the
      client, in bytes, including the response headers and the response body.
    serverIp: The IP address (IPv4 or IPv6) of the origin server that the
      request was sent to.
    status: The response code indicating the status of the response. Examples:
      200, 404.
    userAgent: The user agent sent by the client. Example: `"Mozilla/4.0
      (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
  """

  cacheFillBytes = _messages.IntegerField(1)
  cacheHit = _messages.BooleanField(2)
  cacheLookup = _messages.BooleanField(3)
  cacheValidatedWithOriginServer = _messages.BooleanField(4)
  latency = _messages.StringField(5)
  protocol = _messages.StringField(6)
  referer = _messages.StringField(7)
  remoteIp = _messages.StringField(8)
  requestMethod = _messages.StringField(9)
  requestSize = _messages.IntegerField(10)
  requestUrl = _messages.StringField(11)
  responseSize = _messages.IntegerField(12)
  serverIp = _messages.StringField(13)
  status = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  userAgent = _messages.StringField(15)


class IpAddress(_messages.Message):
  r"""An IpAddress resource in a ClusterGroup.

  Enums:
    StateValueValuesEnum: Output only. State of the resource.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    createTime: Output only. The create time of the resource.
    externalIp: Output only. The external IP of an workload VM.
    internalIp: The internal IP of an workload VM.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    name: Output only. The resource name of this IpAddress. Resource names are
      schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/ipAddresses/my-ip`
    state: Output only. State of the resource.
    updateTime: Output only. The update time of the resource.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the resource.

    Values:
      STATE_UNSPECIFIED: The default value. This value should never be used.
      ACTIVE: The IpAddress is ready.
      CREATING: The IpAddress is being created.
      UPDATING: The IpAddress is being updated.
      DELETING: The IpAddress is being deleted.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    UPDATING = 3
    DELETING = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  externalIp = _messages.StringField(2)
  internalIp = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class LinearBuckets(_messages.Message):
  r"""Describing buckets with constant width.

  Fields:
    numFiniteBuckets: The number of finite buckets. With the underflow and
      overflow buckets, the total number of buckets is `num_finite_buckets` +
      2. See comments on `bucket_options` for details.
    offset: The i'th linear bucket covers the interval [offset + (i-1) *
      width, offset + i * width) where i ranges from 1 to num_finite_buckets,
      inclusive.
    width: The i'th linear bucket covers the interval [offset + (i-1) * width,
      offset + i * width) where i ranges from 1 to num_finite_buckets,
      inclusive. Must be strictly positive.
  """

  numFiniteBuckets = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  offset = _messages.FloatField(2)
  width = _messages.FloatField(3)


class ListClusterGroupBackupsResponse(_messages.Message):
  r"""A ListClusterGroupBackupsResponse object.

  Fields:
    clusterGroupBackups: A list of SDDC cluster group backups.
    nextPageToken: A token, which can be send as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: List of Locations that could not be reached.
  """

  clusterGroupBackups = _messages.MessageField('ClusterGroupBackup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListClusterGroupsResponse(_messages.Message):
  r"""A ListClusterGroupsResponse object.

  Fields:
    clusterGroups: A list of SDDC cluster groups.
    nextPageToken: A token, which can be send as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: List of Locations that could not be reached.
  """

  clusterGroups = _messages.MessageField('ClusterGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListClustersResponse(_messages.Message):
  r"""A ListClustersResponse object.

  Fields:
    clusters: A list of SDDC clusters.
    nextPageToken: A token, which can be send as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: List of Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListIpAddressesResponse(_messages.Message):
  r"""The response of listing IpAddresses in a given ClusterGroup.

  Fields:
    ipAddresses: A list of IpAddresses.
    nextPageToken: A token, which can be send as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  ipAddresses = _messages.MessageField('IpAddress', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListPrivateCloudsResponse(_messages.Message):
  r"""A response with a list of zero or more private clouds in a region.

  Fields:
    nextPageToken: A token, which can be send as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    privateClouds: A list of SDDC private clouds.
    unreachable: List of Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  privateClouds = _messages.MessageField('PrivateCloud', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LogConfig(_messages.Message):
  r"""Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class LogEntry(_messages.Message):
  r"""An individual log entry.

  Enums:
    SeverityValueValuesEnum: The severity of the log entry. The default value
      is `LogSeverity.DEFAULT`.

  Messages:
    LabelsValue: A set of user-defined (key, value) data that provides
      additional information about the log entry.
    ProtoPayloadValue: The log entry payload, represented as a protocol buffer
      that is expressed as a JSON object. The only accepted type currently is
      AuditLog.
    StructPayloadValue: The log entry payload, represented as a structure that
      is expressed as a JSON object.

  Fields:
    httpRequest: Optional. Information about the HTTP request associated with
      this log entry, if applicable.
    insertId: A unique ID for the log entry used for deduplication. If
      omitted, the implementation will generate one based on operation_id.
    labels: A set of user-defined (key, value) data that provides additional
      information about the log entry.
    name: Required. The log to which this log entry belongs. Examples:
      `"syslog"`, `"book_log"`.
    operation: Optional. Information about an operation associated with the
      log entry, if applicable.
    protoPayload: The log entry payload, represented as a protocol buffer that
      is expressed as a JSON object. The only accepted type currently is
      AuditLog.
    severity: The severity of the log entry. The default value is
      `LogSeverity.DEFAULT`.
    sourceLocation: Optional. Source code location information associated with
      the log entry, if any.
    structPayload: The log entry payload, represented as a structure that is
      expressed as a JSON object.
    textPayload: The log entry payload, represented as a Unicode string
      (UTF-8).
    timestamp: The time the event described by the log entry occurred. If
      omitted, defaults to operation start time.
    trace: Optional. Resource name of the trace associated with the log entry,
      if any. If this field contains a relative resource name, you can assume
      the name is relative to `//tracing.googleapis.com`. Example:
      `projects/my-projectid/traces/06796866738c859f2f19b7cfb3214824`
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the log entry. The default value is
    `LogSeverity.DEFAULT`.

    Values:
      DEFAULT: (0) The log entry has no assigned severity level.
      DEBUG: (100) Debug or trace information.
      INFO: (200) Routine information, such as ongoing status or performance.
      NOTICE: (300) Normal but significant events, such as start up, shut
        down, or a configuration change.
      WARNING: (400) Warning events might cause problems.
      ERROR: (500) Error events are likely to cause problems.
      CRITICAL: (600) Critical events cause more severe problems or outages.
      ALERT: (700) A person must take an action immediately.
      EMERGENCY: (800) One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""A set of user-defined (key, value) data that provides additional
    information about the log entry.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProtoPayloadValue(_messages.Message):
    r"""The log entry payload, represented as a protocol buffer that is
    expressed as a JSON object. The only accepted type currently is AuditLog.

    Messages:
      AdditionalProperty: An additional property for a ProtoPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProtoPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StructPayloadValue(_messages.Message):
    r"""The log entry payload, represented as a structure that is expressed as
    a JSON object.

    Messages:
      AdditionalProperty: An additional property for a StructPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StructPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  httpRequest = _messages.MessageField('HttpRequest', 1)
  insertId = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  operation = _messages.MessageField('LogEntryOperation', 5)
  protoPayload = _messages.MessageField('ProtoPayloadValue', 6)
  severity = _messages.EnumField('SeverityValueValuesEnum', 7)
  sourceLocation = _messages.MessageField('LogEntrySourceLocation', 8)
  structPayload = _messages.MessageField('StructPayloadValue', 9)
  textPayload = _messages.StringField(10)
  timestamp = _messages.StringField(11)
  trace = _messages.StringField(12)


class LogEntryOperation(_messages.Message):
  r"""Additional information about a potentially long-running operation with
  which a log entry is associated.

  Fields:
    first: Optional. Set this to True if this is the first log entry in the
      operation.
    id: Optional. An arbitrary operation identifier. Log entries with the same
      identifier are assumed to be part of the same operation.
    last: Optional. Set this to True if this is the last log entry in the
      operation.
    producer: Optional. An arbitrary producer identifier. The combination of
      `id` and `producer` must be globally unique. Examples for `producer`:
      `"MyDivision.MyBigCompany.com"`, `"github.com/MyProject/MyApplication"`.
  """

  first = _messages.BooleanField(1)
  id = _messages.StringField(2)
  last = _messages.BooleanField(3)
  producer = _messages.StringField(4)


class LogEntrySourceLocation(_messages.Message):
  r"""Additional information about the source code location that produced the
  log entry.

  Fields:
    file: Optional. Source file name. Depending on the runtime environment,
      this might be a simple name or a fully-qualified name.
    function: Optional. Human-readable name of the function or method being
      invoked, with optional context such as the class or package name. This
      information may be used in contexts such as the logs viewer, where a
      file and line number are less meaningful. The format can vary by
      language. For example: `qual.if.ied.Class.method` (Java),
      `dir/package.func` (Go), `function` (Python).
    line: Optional. Line within the source file. 1-based; 0 indicates no line
      number available.
  """

  file = _messages.StringField(1)
  function = _messages.StringField(2)
  line = _messages.IntegerField(3)


class MetricValue(_messages.Message):
  r"""Represents a single metric value.

  Messages:
    LabelsValue: The labels describing the metric value. See comments on
      google.api.servicecontrol.v1.Operation.labels for the overriding
      relationship. Note that this map must not contain monitored resource
      labels.

  Fields:
    boolValue: A boolean value.
    distributionValue: A distribution value.
    doubleValue: A double precision floating point value.
    endTime: The end of the time period over which this metric value's
      measurement applies. If not specified,
      google.api.servicecontrol.v1.Operation.end_time will be used.
    int64Value: A signed 64-bit integer value.
    labels: The labels describing the metric value. See comments on
      google.api.servicecontrol.v1.Operation.labels for the overriding
      relationship. Note that this map must not contain monitored resource
      labels.
    moneyValue: A money value.
    startTime: The start of the time period over which this metric value's
      measurement applies. The time period has different semantics for
      different metric types (cumulative, delta, and gauge). See the metric
      definition documentation in the service configuration for details. If
      not specified, google.api.servicecontrol.v1.Operation.start_time will be
      used.
    stringValue: A text string value.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels describing the metric value. See comments on
    google.api.servicecontrol.v1.Operation.labels for the overriding
    relationship. Note that this map must not contain monitored resource
    labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  boolValue = _messages.BooleanField(1)
  distributionValue = _messages.MessageField('Distribution', 2)
  doubleValue = _messages.FloatField(3)
  endTime = _messages.StringField(4)
  int64Value = _messages.IntegerField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  moneyValue = _messages.MessageField('Money', 7)
  startTime = _messages.StringField(8)
  stringValue = _messages.StringField(9)


class MetricValueSet(_messages.Message):
  r"""Represents a set of metric values in the same metric. Each metric value
  in the set should have a unique combination of start time, end time, and
  label values.

  Fields:
    metricName: The metric name defined in the service configuration.
    metricValues: The values in this metric.
  """

  metricName = _messages.StringField(1)
  metricValues = _messages.MessageField('MetricValue', 2, repeated=True)


class Money(_messages.Message):
  r"""Represents an amount of money with its currency type.

  Fields:
    currencyCode: The three-letter currency code defined in ISO 4217.
    nanos: Number of nano (10^-9) units of the amount. The value must be
      between -999,999,999 and +999,999,999 inclusive. If `units` is positive,
      `nanos` must be positive or zero. If `units` is zero, `nanos` can be
      positive, zero, or negative. If `units` is negative, `nanos` must be
      negative or zero. For example $-1.75 is represented as `units`=-1 and
      `nanos`=-750,000,000.
    units: The whole units of the amount. For example if `currencyCode` is
      `"USD"`, then 1 unit is one US dollar.
  """

  currencyCode = _messages.StringField(1)
  nanos = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  units = _messages.IntegerField(3)


class NetworkConfig(_messages.Message):
  r"""Network configuration in the consumer project with which the peering has
  to be done.

  Fields:
    externalIpAccess: controls if vCenter and NSX can be accessed via
      internet. - FQDNs will resolve to the allocated external IPs for sddc
      domain but remains mapping to the internal ip within consumer subnets. -
      NAT will be set up on NSX for external ip ingress traffic. - users need
      to manually configure NSX firewall to allow HTTPs traffic.
    managementCidr: Management CIDR used by VMWare management applicances.
    network: name of the network in the consumer project with which the tenant
      project will be peered. In the case of shared VPC where the network
      lives inside another project the network should should be provided in
      the form of /project/{host_project_id}/global/networks/{network}
    workloadCidr: Workload CIDR used by VMWare workload VMs.
  """

  externalIpAccess = _messages.BooleanField(1)
  managementCidr = _messages.StringField(2)
  network = _messages.StringField(3)
  workloadCidr = _messages.StringField(4)


class Node(_messages.Message):
  r"""A node in a cluster.

  Fields:
    createTime: Output only. Creation time of the node.
    nodeId: Output only. User-provided id of the node.
    type: Output only. Type of the node.
    updateTime: Output only. Update time of the node.
  """

  createTime = _messages.StringField(1)
  nodeId = _messages.StringField(2)
  type = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class Nsx(_messages.Message):
  r"""Nsx description of a cluster group

  Fields:
    clientUrl: NSX client URL.
    externalIp: NSX external address when access is enabled.
    initialPassword: NSX initial password.
    initialUsername: NSX initial username.
    internalIp: NSX internal address.
    serverExplorerUrl: NSX server explorer URL.
  """

  clientUrl = _messages.StringField(1)
  externalIp = _messages.StringField(2)
  initialPassword = _messages.StringField(3)
  initialUsername = _messages.StringField(4)
  internalIp = _messages.StringField(5)
  serverExplorerUrl = _messages.StringField(6)


class Operation(_messages.Message):
  r"""Represents information regarding an operation.

  Enums:
    ImportanceValueValuesEnum: DO NOT USE. This is an experimental field.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.
    LabelsValue: Labels describing the operation. Only the following labels
      are allowed: - Labels describing monitored resources as defined in the
      service configuration. - Default labels of metric values. When
      specified, labels defined in the metric value override these default. -
      The following labels defined by Google Cloud Platform: -
      `cloud.googleapis.com/location` describing the location where the
      operation happened, - `servicecontrol.googleapis.com/user_agent`
      describing the user agent of the API request, -
      `servicecontrol.googleapis.com/service_agent` describing the service
      used to handle the API request (e.g. ESP), -
      `servicecontrol.googleapis.com/platform` describing the platform where
      the API is served, such as App Engine, Compute Engine, or Kubernetes
      Engine.
    UserLabelsValue: User defined labels for the resource that this operation
      is associated with. Only a combination of 1000 user labels per consumer
      project are allowed.

  Fields:
    consumerId: Identity of the consumer who is using the service. This field
      should be filled in for the operations initiated by a consumer, but not
      for service-initiated operations that are not related to a specific
      consumer. - This can be in one of the following formats: -
      project:PROJECT_ID, - project`_`number:PROJECT_NUMBER, -
      projects/PROJECT_ID or PROJECT_NUMBER, - folders/FOLDER_NUMBER, -
      organizations/ORGANIZATION_NUMBER, - api`_`key:API_KEY.
    endTime: End time of the operation. Required when the operation is used in
      ServiceController.Report, but optional when the operation is used in
      ServiceController.Check.
    extensions: Unimplemented.
    importance: DO NOT USE. This is an experimental field.
    labels: Labels describing the operation. Only the following labels are
      allowed: - Labels describing monitored resources as defined in the
      service configuration. - Default labels of metric values. When
      specified, labels defined in the metric value override these default. -
      The following labels defined by Google Cloud Platform: -
      `cloud.googleapis.com/location` describing the location where the
      operation happened, - `servicecontrol.googleapis.com/user_agent`
      describing the user agent of the API request, -
      `servicecontrol.googleapis.com/service_agent` describing the service
      used to handle the API request (e.g. ESP), -
      `servicecontrol.googleapis.com/platform` describing the platform where
      the API is served, such as App Engine, Compute Engine, or Kubernetes
      Engine.
    logEntries: Represents information to be logged.
    metricValueSets: Represents information about this operation. Each
      MetricValueSet corresponds to a metric defined in the service
      configuration. The data type used in the MetricValueSet must agree with
      the data type specified in the metric definition. Within a single
      operation, it is not allowed to have more than one MetricValue instances
      that have the same metric names and identical label value combinations.
      If a request has such duplicated MetricValue instances, the entire
      request is rejected with an invalid argument error.
    operationId: Identity of the operation. This must be unique within the
      scope of the service that generated the operation. If the service calls
      Check() and Report() on the same operation, the two calls should carry
      the same id. UUID version 4 is recommended, though not required. In
      scenarios where an operation is computed from existing information and
      an idempotent id is desirable for deduplication purpose, UUID version 5
      is recommended. See RFC 4122 for details.
    operationName: Fully qualified name of the operation. Reserved for future
      use.
    quotaProperties: Represents the properties needed for quota check.
      Applicable only if this operation is for a quota check request. If this
      is not specified, no quota check will be performed.
    resources: The resources that are involved in the operation. The maximum
      supported number of entries in this field is 100.
    startTime: Required. Start time of the operation.
    traceSpans: Unimplemented. A list of Cloud Trace spans. The span names
      shall contain the id of the destination project which can be either the
      produce or the consumer project.
    userLabels: User defined labels for the resource that this operation is
      associated with. Only a combination of 1000 user labels per consumer
      project are allowed.
  """

  class ImportanceValueValuesEnum(_messages.Enum):
    r"""DO NOT USE. This is an experimental field.

    Values:
      LOW: The API implementation may cache and aggregate the data. The data
        may be lost when rare and unexpected system failures occur.
      HIGH: The API implementation doesn't cache and aggregate the data. If
        the method returns successfully, it's guaranteed that the data has
        been persisted in durable storage.
      DEBUG: In addition to the behavior described in HIGH, DEBUG enables
        additional validation logic that is only useful during the onboarding
        process. This is only available to Google internal services and the
        service must be allowlisted by chemist-dev@google.com in order to use
        this level.
    """
    LOW = 0
    HIGH = 1
    DEBUG = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels describing the operation. Only the following labels are
    allowed: - Labels describing monitored resources as defined in the service
    configuration. - Default labels of metric values. When specified, labels
    defined in the metric value override these default. - The following labels
    defined by Google Cloud Platform: - `cloud.googleapis.com/location`
    describing the location where the operation happened, -
    `servicecontrol.googleapis.com/user_agent` describing the user agent of
    the API request, - `servicecontrol.googleapis.com/service_agent`
    describing the service used to handle the API request (e.g. ESP), -
    `servicecontrol.googleapis.com/platform` describing the platform where the
    API is served, such as App Engine, Compute Engine, or Kubernetes Engine.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""User defined labels for the resource that this operation is associated
    with. Only a combination of 1000 user labels per consumer project are
    allowed.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerId = _messages.StringField(1)
  endTime = _messages.StringField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)
  importance = _messages.EnumField('ImportanceValueValuesEnum', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  logEntries = _messages.MessageField('LogEntry', 6, repeated=True)
  metricValueSets = _messages.MessageField('MetricValueSet', 7, repeated=True)
  operationId = _messages.StringField(8)
  operationName = _messages.StringField(9)
  quotaProperties = _messages.MessageField('QuotaProperties', 10)
  resources = _messages.MessageField('ResourceInfo', 11, repeated=True)
  startTime = _messages.StringField(12)
  traceSpans = _messages.MessageField('TraceSpan', 13, repeated=True)
  userLabels = _messages.MessageField('UserLabelsValue', 14)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    details: Output only. Human-readable status of the operation, if any.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  details = _messages.StringField(3)
  endTime = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging
      will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class PrivateCloud(_messages.Message):
  r"""A private cloud resource. PrivateCloud is a regional resource.

  Enums:
    StateValueValuesEnum: State of the resource.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    createTime: Output only. Creation time of the resource.
    description: The description of this resource.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    name: Output only. The resource name of this PrivateCloud. Resource names
      are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/privateClouds/my-cloud`
    networkConfig: NetworkConfig passed in the param.
    nsx: Output only. Nsx information.
    state: State of the resource.
    updateTime: Output only. Update time of the resource.
    vcenter: Output only. vCenter information.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the resource.

    Values:
      STATE_UNSPECIFIED: The default value. This value should never be used.
      ACTIVE: The private cloud is ready.
      CREATING: The private cloud is being created.
      DELETING: The private cloud is being deleted.
      UPDATING: The private cloud is being updated.
      FAILED: The private cloud has experienced an issue and might be
        unusable.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    UPDATING = 4
    FAILED = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  networkConfig = _messages.MessageField('NetworkConfig', 5)
  nsx = _messages.MessageField('Nsx', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  updateTime = _messages.StringField(8)
  vcenter = _messages.MessageField('Vcenter', 9)


class QuotaProperties(_messages.Message):
  r"""Represents the properties needed for quota operations.

  Enums:
    QuotaModeValueValuesEnum: Quota mode for this operation.

  Fields:
    quotaMode: Quota mode for this operation.
  """

  class QuotaModeValueValuesEnum(_messages.Enum):
    r"""Quota mode for this operation.

    Values:
      ACQUIRE: Decreases available quota by the cost specified for the
        operation. If cost is higher than available quota, operation fails and
        returns error.
      ACQUIRE_BEST_EFFORT: Decreases available quota by the cost specified for
        the operation. If cost is higher than available quota, operation does
        not fail and available quota goes down to zero but it returns error.
      CHECK: Does not change any available quota. Only checks if there is
        enough quota. No lock is placed on the checked tokens neither.
      RELEASE: Increases available quota by the operation cost specified for
        the operation.
    """
    ACQUIRE = 0
    ACQUIRE_BEST_EFFORT = 1
    CHECK = 2
    RELEASE = 3

  quotaMode = _messages.EnumField('QuotaModeValueValuesEnum', 1)


class RemoveNodesRequest(_messages.Message):
  r"""Request for removing nodes from the given cluster until the target count
  is reached.

  Fields:
    nodeCount: Required. Number of desired bare metal nodes in this cluster.
  """

  nodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ReportRequest(_messages.Message):
  r"""Request message for the Report method.

  Fields:
    operations: Operations to be reported. Typically the service should report
      one operation per request. Putting multiple operations into a single
      request is allowed, but should be used only when multiple operations are
      natually available at the time of the report. There is no limit on the
      number of operations in the same ReportRequest, however the
      ReportRequest size should be no larger than 1MB. See
      ReportResponse.report_errors for partial failure behavior.
    serviceConfigId: Specifies which version of service config should be used
      to process the request. If unspecified or no matching version can be
      found, the latest one will be used.
    serviceName: The service name as specified in its service configuration.
      For example, `"pubsub.googleapis.com"`. See
      [google.api.Service](https://cloud.google.com/service-
      management/reference/rpc/google.api#google.api.Service) for the
      definition of a service name.
  """

  operations = _messages.MessageField('Operation', 1, repeated=True)
  serviceConfigId = _messages.StringField(2)
  serviceName = _messages.StringField(3)


class ResetCloudAdminCredentialsRequest(_messages.Message):
  r"""Request for resetting vCenter or NSX CloudAdmin accounts.

  Fields:
    resetNsxCloudadmin: Required. If true, reset the NSX cloudadmin account.
    resetVcenterCloudadmin: Required. If true, reset the vCenter cloudadmin
      account.
  """

  resetNsxCloudadmin = _messages.BooleanField(1)
  resetVcenterCloudadmin = _messages.BooleanField(2)


class ResourceInfo(_messages.Message):
  r"""Describes a resource associated with this operation.

  Fields:
    resourceContainer: The identifier of the parent of this resource instance.
      Must be in one of the following formats: - `projects/` - `folders/` -
      `organizations/`
    resourceLocation: The location of the resource. If not empty, the resource
      will be checked against location policy. The value must be a valid zone,
      region or multiregion. For example: "europe-west4" or "northamerica-
      northeast1-a"
    resourceName: Name of the resource. This is used for auditing purposes.
  """

  resourceContainer = _messages.StringField(1)
  resourceLocation = _messages.StringField(2)
  resourceName = _messages.StringField(3)


class Rule(_messages.Message):
  r"""A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met. All conditions must
      pass for the rule to match.
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries can be found at in the Local IAM documentation
      (see go/local-iam#features).
    permissions: A permission is a string of form '..' (e.g.,
      'storage.buckets.list'). A value of '*' matches all permissions, and a
      verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class SddcProjectsLocationsClusterGroupBackupsCreateRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupBackupsCreateRequest object.

  Fields:
    clusterGroupBackup: A ClusterGroupBackup resource to be passed as the
      request body.
    clusterGroupBackupId: Required. The user-provided id of the
      ClusterGroupBackup to be created. This id must be unique among
      ClusterGroupBackups within the parent and will become the final token in
      the name URI.
    parent: Required. The location(region) and project where the new
      ClusterGroupBackup will be created. For example: `projects/my-
      project/locations/us-central1`
    requestId: UUID of this invocation for idempotent operation.
  """

  clusterGroupBackup = _messages.MessageField('ClusterGroupBackup', 1)
  clusterGroupBackupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class SddcProjectsLocationsClusterGroupBackupsDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupBackupsDeleteRequest object.

  Fields:
    name: Required. The resource name of the ClusterGroupBackup to be deleted.
    requestId: UUID of this invocation for idempotent operation.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class SddcProjectsLocationsClusterGroupBackupsGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupBackupsGetRequest object.

  Fields:
    name: Required. The resource name of the ClusterGroupBackup to retrieve.
      Resource names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroupBackups/my-
      backup`
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupBackupsListRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupBackupsListRequest object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of clusterGroupBackups to return. The service
      may return fewer than this value.
    pageToken: A page token, received from a previous
      `ListClusterGroupBackupsRequest` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `ListClusterGroupBackupsRequest` must match the call that provided the
      page token.
    parent: Required. The location and project which will be queried for data
      centers. For example: `projects/my-project/locations/us-central1`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsClusterGroupsClustersAddNodesRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersAddNodesRequest object.

  Fields:
    addNodesRequest: A AddNodesRequest resource to be passed as the request
      body.
    cluster: Required. The resource name of the Cluster to perform add nodes.
      Resource names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/clusters/my-cluster`
  """

  addNodesRequest = _messages.MessageField('AddNodesRequest', 1)
  cluster = _messages.StringField(2, required=True)


class SddcProjectsLocationsClusterGroupsClustersCreateRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. The user-provided id of the new Cluster. This id must
      be unique among Clusters within the parent and will become the final
      token in the name URI.
    managementCluster: Required. Deprecated. Use the management property in
      the Cluster resource. Whether the cluster is the management cluster.
    parent: Required. The ClusterGroup in where the new Cluster will be
      created. For example: `projects/my-project/locations/us-
      central1/clusterGroups/my-group`
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  managementCluster = _messages.BooleanField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsClusterGroupsClustersDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersDeleteRequest object.

  Fields:
    name: Required. The resource name of the Cluster to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupsClustersGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersGetRequest object.

  Fields:
    name: Required. The resource name of the Cluster to retrieve. Resource
      names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/clusters/my-cluster`
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupsClustersListRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersListRequest object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of clusters to return. The service may return
      fewer than this value.
    pageToken: A page token, received from a previous `ListClustersRequest`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListClustersRequest` must match the call
      that provided the page token.
    parent: Required. The project, location and cluster group which will be
      queried for clusters. For example: `projects/my-project/locations/us-
      central1/clusterGroups/my-group`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsClusterGroupsClustersPatchRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Output only. The resource name of this Cluster. Resource names are
      schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/clusters/my-cluster`
    updateMask: Mask of fields to update. At least one path must be supplied
      in this field. The elements of the repeated paths field may only include
      these fields: "labels"
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SddcProjectsLocationsClusterGroupsClustersRemoveNodesRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsClustersRemoveNodesRequest object.

  Fields:
    cluster: Required. The resource name of the Cluster to perform remove
      nodes. Resource names are schemeless URI's that follow the conventions
      in https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/clusters/my-cluster`
    removeNodesRequest: A RemoveNodesRequest resource to be passed as the
      request body.
  """

  cluster = _messages.StringField(1, required=True)
  removeNodesRequest = _messages.MessageField('RemoveNodesRequest', 2)


class SddcProjectsLocationsClusterGroupsCreateRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsCreateRequest object.

  Fields:
    clusterGroup: A ClusterGroup resource to be passed as the request body.
    clusterGroupId: Required. The user-provided id of the ClusterGroup to be
      created. This id must be unique among ClusterGroups within the parent
      and will become the final token in the name URI.
    parent: Required. The location(region) and project where the new
      ClusterGroup will be created. For example: `projects/my-
      project/locations/us-central1`
  """

  clusterGroup = _messages.MessageField('ClusterGroup', 1)
  clusterGroupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SddcProjectsLocationsClusterGroupsDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsDeleteRequest object.

  Fields:
    name: Required. The resource name of the ClusterGroup to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupsGetIamPolicyRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class SddcProjectsLocationsClusterGroupsGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsGetRequest object.

  Fields:
    name: Required. The resource name of the ClusterGroup to retrieve.
      Resource names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-group`
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupsIpAddressesCreateRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsIpAddressesCreateRequest object.

  Fields:
    ipAddress: A IpAddress resource to be passed as the request body.
    ipAddressId: Required. The user-provided ID of the IpAddress to be
      created. This id must be unique among IpAddresses within the parent and
      will become the final token in the name URI.
    parent: Required. The ClusterGroup or PrivateCloud in which the IpAddress
      will be created. For example: `projects/my-project/locations/us-
      central1/clusterGroups/my-group`
  """

  ipAddress = _messages.MessageField('IpAddress', 1)
  ipAddressId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SddcProjectsLocationsClusterGroupsIpAddressesDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsIpAddressesDeleteRequest object.

  Fields:
    name: Required. The resource name of the ClusterGroupBackup to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupsIpAddressesGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsIpAddressesGetRequest object.

  Fields:
    name: Required. The resource name of the IpAddress to retrieve. Resource
      names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/ipAddresses/my-ip`
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsClusterGroupsIpAddressesListRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsIpAddressesListRequest object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of IpAddresses to return. The service may
      return fewer than this value.
    pageToken: A page token, received from a previous `ListIpAddressesRequest`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListIpAddressesRequest` must match the
      call that provided the page token.
    parent: Required. The parent ClusterGroup or PrivateCloud of which the
      IpAddresses belong to. For example: `projects/my-project/locations/us-
      central1/clusterGroups/my-group`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsClusterGroupsListRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsListRequest object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of clusterGroups to return. The service may
      return fewer than this value.
    pageToken: A page token, received from a previous
      `ListClusterGroupsRequest` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListClusterGroupsRequest` must match the call that provided the page
      token.
    parent: Required. The location and project which will be queried for data
      centers. For example: `projects/my-project/locations/us-central1`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsClusterGroupsPatchRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsPatchRequest object.

  Fields:
    clusterGroup: A ClusterGroup resource to be passed as the request body.
    name: Output only. The resource name of this ClusterGroup. Resource names
      are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-group`
    updateMask: Mask of fields to update. At least one path must be supplied
      in this field. The elements of the repeated paths field may only include
      these fields: "description" "labels" "network_config.external_ip_access"
  """

  clusterGroup = _messages.MessageField('ClusterGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SddcProjectsLocationsClusterGroupsResetCloudAdminCredentialsRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsResetCloudAdminCredentialsRequest
  object.

  Fields:
    clusterGroup: Required. The resource name of the cluster group to reset
      the cloudadmin password on. For example, `projects/my-
      project/locations/us-central1/clusterGroups/my-group`
    resetCloudAdminCredentialsRequest: A ResetCloudAdminCredentialsRequest
      resource to be passed as the request body.
  """

  clusterGroup = _messages.StringField(1, required=True)
  resetCloudAdminCredentialsRequest = _messages.MessageField('ResetCloudAdminCredentialsRequest', 2)


class SddcProjectsLocationsClusterGroupsSetIamPolicyRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class SddcProjectsLocationsClusterGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A SddcProjectsLocationsClusterGroupsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class SddcProjectsLocationsGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsListRequest(_messages.Message):
  r"""A SddcProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class SddcProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A SddcProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class SddcProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A SddcProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SddcProjectsLocationsPrivateCloudsCreateRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsCreateRequest object.

  Fields:
    parent: Required. The location(region) and project where the new
      PrivateCloud will be created. For example: `projects/my-
      project/locations/us-central1`
    privateCloud: A PrivateCloud resource to be passed as the request body.
    privateCloudId: Required. The user-provided id of the PrivateCloud to be
      created. This id must be unique among PrivateClouds within the parent
      and will become the final token in the name URI.
  """

  parent = _messages.StringField(1, required=True)
  privateCloud = _messages.MessageField('PrivateCloud', 2)
  privateCloudId = _messages.StringField(3)


class SddcProjectsLocationsPrivateCloudsDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsDeleteRequest object.

  Fields:
    name: Required. The resource name of the PrivateCloud to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsPrivateCloudsGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsGetRequest object.

  Fields:
    name: Required. The resource name of the PrivateCloud to retrieve.
      Resource names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/privateClouds/my-cloud`
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsPrivateCloudsIpAddressesCreateRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsIpAddressesCreateRequest object.

  Fields:
    ipAddress: A IpAddress resource to be passed as the request body.
    ipAddressId: Required. The user-provided ID of the IpAddress to be
      created. This id must be unique among IpAddresses within the parent and
      will become the final token in the name URI.
    parent: Required. The ClusterGroup or PrivateCloud in which the IpAddress
      will be created. For example: `projects/my-project/locations/us-
      central1/clusterGroups/my-group`
  """

  ipAddress = _messages.MessageField('IpAddress', 1)
  ipAddressId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SddcProjectsLocationsPrivateCloudsIpAddressesDeleteRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsIpAddressesDeleteRequest object.

  Fields:
    name: Required. The resource name of the ClusterGroupBackup to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsPrivateCloudsIpAddressesGetRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsIpAddressesGetRequest object.

  Fields:
    name: Required. The resource name of the IpAddress to retrieve. Resource
      names are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/clusterGroups/my-
      group/ipAddresses/my-ip`
  """

  name = _messages.StringField(1, required=True)


class SddcProjectsLocationsPrivateCloudsIpAddressesListRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsIpAddressesListRequest object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of IpAddresses to return. The service may
      return fewer than this value.
    pageToken: A page token, received from a previous `ListIpAddressesRequest`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListIpAddressesRequest` must match the
      call that provided the page token.
    parent: Required. The parent ClusterGroup or PrivateCloud of which the
      IpAddresses belong to. For example: `projects/my-project/locations/us-
      central1/clusterGroups/my-group`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsPrivateCloudsListRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsListRequest object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of privateClouds to return. The service may
      return fewer than this value.
    pageToken: A page token, received from a previous
      `ListPrivateCloudsRequest` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListPrivateCloudsRequest` must match the call that provided the page
      token.
    parent: Required. The location and project which will be queried for data
      centers. For example: `projects/my-project/locations/us-central1`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SddcProjectsLocationsPrivateCloudsPatchRequest(_messages.Message):
  r"""A SddcProjectsLocationsPrivateCloudsPatchRequest object.

  Fields:
    name: Output only. The resource name of this PrivateCloud. Resource names
      are schemeless URI's that follow the conventions in
      https://cloud.google.com/apis/design/resource_names For example,
      `projects/my-project/locations/us-central1/privateClouds/my-cloud`
    privateCloud: A PrivateCloud resource to be passed as the request body.
    updateMask: Mask of fields to update. At least one path must be supplied
      in this field. The elements of the repeated paths field may only include
      these fields: "description" "labels" "network_config.external_ip_access"
  """

  name = _messages.StringField(1, required=True)
  privateCloud = _messages.MessageField('PrivateCloud', 2)
  updateMask = _messages.StringField(3)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TraceSpan(_messages.Message):
  r"""A span represents a single operation within a trace. Spans can be nested
  to form a trace tree. Often, a trace contains a root span that describes the
  end-to-end latency, and one or more subspans for its sub-operations. A trace
  can also contain multiple root spans, or none at all. Spans do not need to
  be contiguous-there may be gaps or overlaps between spans in a trace.

  Enums:
    SpanKindValueValuesEnum: Distinguishes between spans generated in a
      particular context. For example, two spans with the same name may be
      distinguished using `CLIENT` (caller) and `SERVER` (callee) to identify
      an RPC call.

  Fields:
    attributes: A set of attributes on the span. You can have up to 32
      attributes per span.
    childSpanCount: An optional number of child spans that were generated
      while this span was active. If set, allows implementation to detect
      missing child spans.
    displayName: A description of the span's operation (up to 128 bytes).
      Stackdriver Trace displays the description in the Google Cloud Platform
      Console. For example, the display name can be a qualified method name or
      a file name and a line number where the operation is called. A best
      practice is to use the same display name within an application and at
      the same call point. This makes it easier to correlate spans in
      different traces.
    endTime: The end time of the span. On the client side, this is the time
      kept by the local machine where the span execution ends. On the server
      side, this is the time when the server application handler stops
      running.
    name: The resource name of the span in the following format:
      projects/[PROJECT_ID]/traces/[TRACE_ID]/spans/SPAN_ID is a unique
      identifier for a trace within a project; it is a 32-character
      hexadecimal encoding of a 16-byte array. [SPAN_ID] is a unique
      identifier for a span within a trace; it is a 16-character hexadecimal
      encoding of an 8-byte array.
    parentSpanId: The [SPAN_ID] of this span's parent span. If this is a root
      span, then this field must be empty.
    sameProcessAsParentSpan: (Optional) Set this parameter to indicate whether
      this span is in the same process as its parent. If you do not set this
      parameter, Stackdriver Trace is unable to take advantage of this helpful
      information.
    spanId: The [SPAN_ID] portion of the span's resource name.
    spanKind: Distinguishes between spans generated in a particular context.
      For example, two spans with the same name may be distinguished using
      `CLIENT` (caller) and `SERVER` (callee) to identify an RPC call.
    startTime: The start time of the span. On the client side, this is the
      time kept by the local machine where the span execution starts. On the
      server side, this is the time when the server's application handler
      starts running.
    status: An optional final status for this span.
  """

  class SpanKindValueValuesEnum(_messages.Enum):
    r"""Distinguishes between spans generated in a particular context. For
    example, two spans with the same name may be distinguished using `CLIENT`
    (caller) and `SERVER` (callee) to identify an RPC call.

    Values:
      SPAN_KIND_UNSPECIFIED: Unspecified. Do NOT use as default.
        Implementations MAY assume SpanKind.INTERNAL to be default.
      INTERNAL: Indicates that the span is used internally. Default value.
      SERVER: Indicates that the span covers server-side handling of an RPC or
        other remote network request.
      CLIENT: Indicates that the span covers the client-side wrapper around an
        RPC or other remote request.
      PRODUCER: Indicates that the span describes producer sending a message
        to a broker. Unlike client and server, there is no direct critical
        path latency relationship between producer and consumer spans (e.g.
        publishing a message to a pubsub service).
      CONSUMER: Indicates that the span describes consumer receiving a message
        from a broker. Unlike client and server, there is no direct critical
        path latency relationship between producer and consumer spans (e.g.
        receiving a message from a pubsub service subscription).
    """
    SPAN_KIND_UNSPECIFIED = 0
    INTERNAL = 1
    SERVER = 2
    CLIENT = 3
    PRODUCER = 4
    CONSUMER = 5

  attributes = _messages.MessageField('Attributes', 1)
  childSpanCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  displayName = _messages.MessageField('TruncatableString', 3)
  endTime = _messages.StringField(4)
  name = _messages.StringField(5)
  parentSpanId = _messages.StringField(6)
  sameProcessAsParentSpan = _messages.BooleanField(7)
  spanId = _messages.StringField(8)
  spanKind = _messages.EnumField('SpanKindValueValuesEnum', 9)
  startTime = _messages.StringField(10)
  status = _messages.MessageField('GoogleRpcStatus', 11)


class TruncatableString(_messages.Message):
  r"""Represents a string that might be shortened to a specified length.

  Fields:
    truncatedByteCount: The number of bytes removed from the original string.
      If this value is 0, then the string was not shortened.
    value: The shortened string. For example, if the original string is 500
      bytes long and the limit of the string is 128 bytes, then `value`
      contains the first 128 bytes of the 500-byte string. Truncation always
      happens on a UTF8 character boundary. If there are multi-byte characters
      in the string, then the length of the shortened string might be less
      than the size limit.
  """

  truncatedByteCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  value = _messages.StringField(2)


class Vcenter(_messages.Message):
  r"""vCenter description of a cluster group

  Fields:
    clientUrl: vCenter client URL.
    externalIp: vCenter external address when access is enabled.
    initialPassword: vCenter initial password.
    initialUsername: vCenter initial username.
    internalIp: vCenter internal address.
    serverExplorerUrl: vCenter server explorer URL.
  """

  clientUrl = _messages.StringField(1)
  externalIp = _messages.StringField(2)
  initialPassword = _messages.StringField(3)
  initialUsername = _messages.StringField(4)
  internalIp = _messages.StringField(5)
  serverExplorerUrl = _messages.StringField(6)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
