#!/usr/bin/env python

"""
Copyright (c) 2014-2018 Miroslav Stampar (@stamparm)
See the file 'LICENSE' for copying permission
"""

import re

from core.common import retrieve_content

__url__ = "https://lists.malwarepatrol.net/cgi/getfile?receipt=f1417692233&product=8&list=dansguardian"
__check__ = "Malware Patrol"
__info__ = "malware"
__reference__ = "malwarepatrol.net"

def fetch():
    retval = {}
    content = retrieve_content(__url__)

    if __check__ in content:
        for line in content.split('\n'):
            line = line.strip()
            if not line or line.startswith('#'):
                continue
            if '://' in line:
                line = re.search(r"://(.*)", line).group(1)
            line = line.rstrip('/')
            if '/' in line:
                retval[line] = (__info__, __reference__)
            elif re.search(r"\A\d+\.\d+\.\d+\.\d+\Z", line):
                retval[line] = ("potential malware site", __reference__)
            else:
                retval[line] = (__info__, __reference__)

    return retval
