"""Generated message classes for gameservices version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'gameservices'


class AllocationPolicy(_messages.Message):
  r"""An allocation policy resource.

  Messages:
    LabelsValue: The labels associated with the allocation policy. Each label
      is a key-value pair.

  Fields:
    clusterSelectors: The cluster labels are used to identify the clusters
      that a policy is applied to.
    createTime: Output only. The creation time.
    labels: The labels associated with the allocation policy. Each label is a
      key-value pair.
    name: The resource name of the allocation policy, using the form:  `projec
      ts/{project_id}/locations/{location}/allocationPolicies/{allocation_poli
      cy_id}`. For example, `projects/my-
      project/locations/{location}/allocationPolicies/my-policy`.
    priority: Required. The priority of the policy for allocation. A smaller
      value indicates a higher priority.
    schedules: The event schedules - If specified, the policy is time based
      and when the schedule is effective overrides the default policy.
    updateTime: Output only. The last-modified time.
    weight: The relative weight of the policy based on its priority - If there
      are multiple policies with the same priority, the probability of using a
      policy is based on its weight.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with the allocation policy. Each label is a key-
    value pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterSelectors = _messages.MessageField('LabelSelector', 1, repeated=True)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  priority = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  schedules = _messages.MessageField('Schedule', 6, repeated=True)
  updateTime = _messages.StringField(7)
  weight = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: A read of admin (meta) data.
      ADMIN_WRITE: A write of admin (meta) data.
      DATA_READ: A read of standard data.
      DATA_WRITE: A write of standard data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudAuditOptions(_messages.Message):
  r"""Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.

  Fields:
    authorizationLoggingOptions: Information used by the Cloud Audit Logging
      pipeline.
    logName: The log_name to populate in the Cloud Audit Record.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    r"""The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  authorizationLoggingOptions = _messages.MessageField('AuthorizationLoggingOptions', 1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)


class ClusterPercentageSelector(_messages.Message):
  r"""The percentage of game servers running this game server template in the
  selected clusters.

  Fields:
    clusterSelector: Labels used to identify the clusters to which this game
      server template applies.
    percent: The percentage of game servers running this game server
      depolyment. The percentage is applied to game server clusters which
      contain all of the labels in the cluster selector field.
  """

  clusterSelector = _messages.MessageField('LabelSelector', 1)
  percent = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ClusterRolloutTarget(_messages.Message):
  r"""The rollout target of a cluster, i.e. the percentage of game servers
  running stable_game_server_template and new_game_server_template.

  Fields:
    cluster: The cluster name.
    newPercent: The desired percentage of game servers that run
      new_game_server_template.
    realm: The realm name.
    stablePercent: The desired percentage of game servers that run
      stable_game_server_template.
  """

  cluster = _messages.StringField(1)
  newPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  realm = _messages.StringField(3)
  stablePercent = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class CommitRolloutRequest(_messages.Message):
  r"""Request message for GameServerDeploymentsService.CommitRollout."""


class Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    values: The objects of the condition.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext (go
        /security-realms). When used with IN, the condition indicates "any of
        the request's realms match one of the given values; with NOT_IN, "none
        of the realms match any of the given values". Note that a value can
        be:  - 'self' (i.e., allow connections from clients that are in the
        same  security realm)  - a realm (e.g., 'campus-abc')  - a realm group
        (e.g., 'realms-for-borg-cell-xx', see: go/realm-groups) A match is
        determined by a realm group membership check performed by a
        RealmAclRep object (go/realm-acl-howto). It is not permitted to grant
        access based on the *absence* of a realm, so realm conditions can only
        be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        tech.iam.JustificationType, e.g. "MANUAL_STRING". It is not permitted
        to grant access based on the *absence* of a justification, so
        justification conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).  Multiple justifications, e.g., a
        Buganizer ID and a manually-entered reason, are normal and supported.
      CREDENTIALS_TYPE: What type of credentials have been supplied with this
        request. String values should match enum names from
        security_loas_l2.CredentialsType - currently, only
        CREDS_TYPE_EMERGENCY is supported. It is not permitted to grant access
        based on the *absence* of a credentials type, so the conditions can
        only be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5
    CREDENTIALS_TYPE = 6

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  values = _messages.StringField(5, repeated=True)


class CounterOptions(_messages.Message):
  r"""Increment a streamz counter with the specified metric and field names.
  Metric names should start with a '/', generally be lowercase-only, and end
  in "_count". Field names should not contain an initial slash. The actual
  exported metric names will have "/iam/policy" prepended.  Field names
  correspond to IAM request parameters and field values are their respective
  values.  Supported field names:    - "authority", which is "[token]" if
  IAMContext.token is present,      otherwise the value of
  IAMContext.authority_selector if present, and      otherwise a
  representation of IAMContext.principal; or    - "iam_principal", a
  representation of IAMContext.principal even if a      token or authority
  selector is present; or    - "" (empty string), resulting in a counter with
  no fields.  Examples:   counter { metric: "/debug_access_count"  field:
  "iam_principal" }   ==> increment counter
  /iam/policy/backend_debug_access_count
  {iam_principal=[value of IAMContext.principal]}  At this time we do not
  support multiple field names (though this may be supported in the future).

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  r"""Write a Data Access (Gin) log

  Enums:
    LogModeValueValuesEnum: Whether Gin logging should happen in a fail-closed
      manner at the caller. This is relevant only in the LocalIAM
      implementation, for now.

  Fields:
    logMode: Whether Gin logging should happen in a fail-closed manner at the
      caller. This is relevant only in the LocalIAM implementation, for now.
  """

  class LogModeValueValuesEnum(_messages.Enum):
    r"""Whether Gin logging should happen in a fail-closed manner at the
    caller. This is relevant only in the LocalIAM implementation, for now.

    Values:
      LOG_MODE_UNSPECIFIED: Client is not required to write a partial Gin log
        immediately after the authorization check. If client chooses to write
        one and it fails, client may either fail open (allow the operation to
        continue) or fail closed (handle as a DENY outcome).
      LOG_FAIL_CLOSED: The application's operation in the context of which
        this authorization check is being made may only be performed if it is
        successfully logged to Gin. For instance, the authorization library
        may satisfy this obligation by emitting a partial log entry at
        authorization check time and only returning ALLOW to the application
        if it succeeds.  If a matching Rule has this directive, but the client
        has not indicated that it will honor such requirements, then the IAM
        check will result in authorization failure by setting
        CheckPolicyResponse.success=false.
    """
    LOG_MODE_UNSPECIFIED = 0
    LOG_FAIL_CLOSED = 1

  logMode = _messages.EnumField('LogModeValueValuesEnum', 1)


class DeploymentTarget(_messages.Message):
  r"""The rollout target of the deployment, e.g. the target percentage of game
  servers running stable_game_server_template and new_game_server_template in
  clusters.

  Fields:
    clusters: A ClusterRolloutTarget attribute.
  """

  clusters = _messages.MessageField('ClusterRolloutTarget', 1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FleetAutoscalerSettings(_messages.Message):
  r"""Fleet autoscaling parameters.

  Fields:
    bufferSizeAbsolute: The size of a buffer of ready game server instances in
      absolute number. As game server instances get allocated or terminated,
      the fleet will be scaled up and down so that this buffer is maintained.
    bufferSizePercentage: The size of a buffer of ready game server instances
      in percentage. As game server instances get allocated or terminated, the
      fleet will be scaled up and down so that this buffer is maintained.
    maxReplicas: The maximum fleet size.
    minReplicas: The minimum fleet size.
  """

  bufferSizeAbsolute = _messages.IntegerField(1)
  bufferSizePercentage = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  maxReplicas = _messages.IntegerField(3)
  minReplicas = _messages.IntegerField(4)


class GameServerCluster(_messages.Message):
  r"""A game server cluster resource.

  Messages:
    LabelsValue: The labels associated with this game server cluster. Each
      label is a key-value pair.

  Fields:
    connectionInfo: Game server cluster connection information. This
      information is used to manage game server clusters.
    createTime: Output only. The creation time.
    labels: The labels associated with this game server cluster. Each label is
      a key-value pair.
    name: The resource name of the game server cluster, using the form:  `proj
      ects/{project_id}/locations/{location}/realms/{realm_id}/gameServerClust
      ers/{cluster_id}`. For example,  `projects/my-
      project/locations/{location}/realms/zanzibar/gameServerClusters/my-
      onprem-cluster`.
    updateTime: Output only. The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this game server cluster. Each label is a
    key-value pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  connectionInfo = _messages.MessageField('GameServerClusterConnectionInfo', 1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GameServerClusterConnectionInfo(_messages.Message):
  r"""Game server cluster connection information.

  Fields:
    gkeName: This is the gkeName where the game server cluster is installed.
      It must the format "projects/*/locations/*/clusters/*". For example,
      "projects/my-project/locations/us-central1/clusters/test".
    namespace: Namespace designated on the game server cluster where the game
      server instances will be created. The namespace existence will be
      validated during creation.
  """

  gkeName = _messages.StringField(1)
  namespace = _messages.StringField(2)


class GameServerDeployment(_messages.Message):
  r"""A game server deployment resource.

  Messages:
    LabelsValue: The labels associated with this game server deployment. Each
      label is a key-value pair.

  Fields:
    createTime: Output only. The creation time.
    labels: The labels associated with this game server deployment. Each label
      is a key-value pair.
    name: The resource name of the game server deployment, using the form:  `p
      rojects/{project_id}/locations/{location}/gameServerDeployments/{deploym
      ent_id}`. For example,  `projects/my-
      project/locations/{location}/gameServerDeployments/my-deployment`.
    newGameServerTemplate: The GameServerTemplate whose rollout is ongoing.
    stableGameServerTemplate: Output only. The GameServerTemplate whose
      rollout was completed.
    updateTime: Output only. The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this game server deployment. Each label is
    a key-value pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  newGameServerTemplate = _messages.MessageField('GameServerTemplate', 4)
  stableGameServerTemplate = _messages.MessageField('GameServerTemplate', 5)
  updateTime = _messages.StringField(6)


class GameServerTemplate(_messages.Message):
  r"""The game server spec sent to Agones and the rollout target.

  Fields:
    clusterPercentageSelectors: Output only. The percentage of game servers
      running this game server template in the selected clusters.
    description: The description of the game server template.
    spec: The game server spec, which is sent to Agones.
    templateId: The ID of the game server template, specified by the user.
  """

  clusterPercentageSelectors = _messages.MessageField('ClusterPercentageSelector', 1, repeated=True)
  description = _messages.StringField(2)
  spec = _messages.StringField(3)
  templateId = _messages.StringField(4)


class GameservicesProjectsLocationsAllocationPoliciesCreateRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsAllocationPoliciesCreateRequest object.

  Fields:
    allocationPolicy: A AllocationPolicy resource to be passed as the request
      body.
    allocationPolicyId: Required. The ID of the allocation policy resource to
      be created.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
  """

  allocationPolicy = _messages.MessageField('AllocationPolicy', 1)
  allocationPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GameservicesProjectsLocationsAllocationPoliciesDeleteRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsAllocationPoliciesDeleteRequest object.

  Fields:
    name: Required. The name of the allocation policy to delete, using the
      form:  `projects/{project_id}/locations/{location}/allocationPolicies/{a
      llocation_policy_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsAllocationPoliciesGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsAllocationPoliciesGetRequest object.

  Fields:
    name: Required. The name of the allocation policy to retrieve, using the
      form:  `projects/{project_id}/locations/{location}/allocationPolicies/{a
      llocation_policy_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsAllocationPoliciesListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsAllocationPoliciesListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: Optional. The maximum number of items to return.  If
      unspecified, server will pick an appropriate default. Server may return
      fewer items than requested. A caller should only rely on response's
      next_page_token to determine if there are more AllocationPolicies left
      to be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      List request, if any.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GameservicesProjectsLocationsAllocationPoliciesPatchRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsAllocationPoliciesPatchRequest object.

  Fields:
    allocationPolicy: A AllocationPolicy resource to be passed as the request
      body.
    name: The resource name of the allocation policy, using the form:  `projec
      ts/{project_id}/locations/{location}/allocationPolicies/{allocation_poli
      cy_id}`. For example, `projects/my-
      project/locations/{location}/allocationPolicies/my-policy`.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. For the `FieldMask` definition, see  https:
      //developers.google.com/protocol-buffers //
      /docs/reference/google.protobuf#fieldmask
  """

  allocationPolicy = _messages.MessageField('AllocationPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GameservicesProjectsLocationsGameServerDeploymentsCommitRolloutRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsCommitRolloutRequest
  object.

  Fields:
    commitRolloutRequest: A CommitRolloutRequest resource to be passed as the
      request body.
    name: Required. The name of the game server deployment, using the form:  `
      projects/{project_id}/locations/{location}/gameServerDeployments/{deploy
      ment_id}`
  """

  commitRolloutRequest = _messages.MessageField('CommitRolloutRequest', 1)
  name = _messages.StringField(2, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsCreateRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsCreateRequest
  object.

  Fields:
    deploymentId: Required. The ID of the game server deployment resource to
      be created.
    gameServerDeployment: A GameServerDeployment resource to be passed as the
      request body.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
  """

  deploymentId = _messages.StringField(1)
  gameServerDeployment = _messages.MessageField('GameServerDeployment', 2)
  parent = _messages.StringField(3, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsDeleteRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsDeleteRequest
  object.

  Fields:
    name: Required. The name of the game server deployment to delete, using
      the form:  `projects/{project_id}/locations/{location}/gameServerDeploym
      ents/{deployment_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsGetDeploymentTargetRequest(_messages.Message):
  r"""A
  GameservicesProjectsLocationsGameServerDeploymentsGetDeploymentTargetRequest
  object.

  Fields:
    name: Required. The name of the game server deployment, using the form:  `
      projects/{project_id}/locations/{location}/gameServerDeployments/{deploy
      ment_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsGetIamPolicyRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsGetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsGetRequest object.

  Fields:
    name: Required. The name of the game server deployment to retrieve, using
      the form:  `projects/{project_id}/locations/{location}/gameServerDeploym
      ents/{deployment_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: Optional. The maximum number of items to return.  If
      unspecified, server will pick an appropriate default. Server may return
      fewer items than requested. A caller should only rely on response's
      next_page_token to determine if there are more GameServerDeployments
      left to be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      List request, if any.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GameservicesProjectsLocationsGameServerDeploymentsPatchRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsPatchRequest object.

  Fields:
    gameServerDeployment: A GameServerDeployment resource to be passed as the
      request body.
    name: The resource name of the game server deployment, using the form:  `p
      rojects/{project_id}/locations/{location}/gameServerDeployments/{deploym
      ent_id}`. For example,  `projects/my-
      project/locations/{location}/gameServerDeployments/my-deployment`.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. For the `FieldMask` definition, see  https:
      //developers.google.com/protocol-buffers //
      /docs/reference/google.protobuf#fieldmask
  """

  gameServerDeployment = _messages.MessageField('GameServerDeployment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GameservicesProjectsLocationsGameServerDeploymentsRevertRolloutRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsRevertRolloutRequest
  object.

  Fields:
    name: Required. The name of the game server deployment to deploy, using
      the form:  `projects/{project_id}/locations/{location}/gameServerDeploym
      ents/{deployment_id}`
    revertRolloutRequest: A RevertRolloutRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  revertRolloutRequest = _messages.MessageField('RevertRolloutRequest', 2)


class GameservicesProjectsLocationsGameServerDeploymentsSetIamPolicyRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GameservicesProjectsLocationsGameServerDeploymentsSetRolloutTargetRequest(_messages.Message):
  r"""A
  GameservicesProjectsLocationsGameServerDeploymentsSetRolloutTargetRequest
  object.

  Fields:
    name: Required. The name of the game server deployment, using the form:  `
      projects/{project_id}/locations/{location}/gameServerDeployments/{deploy
      ment_id}`
    setRolloutTargetRequest: A SetRolloutTargetRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  setRolloutTargetRequest = _messages.MessageField('SetRolloutTargetRequest', 2)


class GameservicesProjectsLocationsGameServerDeploymentsStartRolloutRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGameServerDeploymentsStartRolloutRequest
  object.

  Fields:
    name: Required. The name of the game server deployment, using the form:  `
      projects/{project_id}/locations/{location}/gameServerDeployments/{deploy
      ment_id}`
    startRolloutRequest: A StartRolloutRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  startRolloutRequest = _messages.MessageField('StartRolloutRequest', 2)


class GameservicesProjectsLocationsGameServerDeploymentsTestIamPermissionsRequest(_messages.Message):
  r"""A
  GameservicesProjectsLocationsGameServerDeploymentsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GameservicesProjectsLocationsGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GameservicesProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GameservicesProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GameservicesProjectsLocationsRealmsCreateRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsCreateRequest object.

  Fields:
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
    realm: A Realm resource to be passed as the request body.
    realmId: Required. The ID of the realm resource to be created.
  """

  parent = _messages.StringField(1, required=True)
  realm = _messages.MessageField('Realm', 2)
  realmId = _messages.StringField(3)


class GameservicesProjectsLocationsRealmsDeleteRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsDeleteRequest object.

  Fields:
    name: Required. The name of the realm to delete, using the form:
      `projects/{project_id}/locations/{location}/realms/{realm_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsRealmsGameServerClustersCreateRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsGameServerClustersCreateRequest
  object.

  Fields:
    gameServerCluster: A GameServerCluster resource to be passed as the
      request body.
    gameServerClusterId: Required. The ID of the game server cluster resource
      to be created.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}/realms/{realm-id}`.
  """

  gameServerCluster = _messages.MessageField('GameServerCluster', 1)
  gameServerClusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GameservicesProjectsLocationsRealmsGameServerClustersDeleteRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsGameServerClustersDeleteRequest
  object.

  Fields:
    name: Required. The name of the game server cluster to delete, using the
      form:  `projects/{project_id}/locations/{location}/gameServerClusters/{c
      luster_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsRealmsGameServerClustersGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsGameServerClustersGetRequest
  object.

  Fields:
    name: Required. The name of the game server cluster to retrieve, using the
      form:  `projects/{project_id}/locations/{location}/realms/{realm-
      id}/gameServerClusters/{cluster_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsRealmsGameServerClustersListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsGameServerClustersListRequest
  object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: Optional. The maximum number of items to return.  If
      unspecified, server will pick an appropriate default. Server may return
      fewer items than requested. A caller should only rely on response's
      next_page_token to determine if there are more GameServerClusters left
      to be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      List request, if any.
    parent: Required. The parent resource name, using the form:
      "projects/{project_id}/locations/{location}/realms/{realm-id}".
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GameservicesProjectsLocationsRealmsGameServerClustersPatchRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsGameServerClustersPatchRequest
  object.

  Fields:
    gameServerCluster: A GameServerCluster resource to be passed as the
      request body.
    name: The resource name of the game server cluster, using the form:  `proj
      ects/{project_id}/locations/{location}/realms/{realm_id}/gameServerClust
      ers/{cluster_id}`. For example,  `projects/my-
      project/locations/{location}/realms/zanzibar/gameServerClusters/my-
      onprem-cluster`.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. For the `FieldMask` definition, see  https:
      //developers.google.com/protocol-buffers //
      /docs/reference/google.protobuf#fieldmask
  """

  gameServerCluster = _messages.MessageField('GameServerCluster', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GameservicesProjectsLocationsRealmsGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsGetRequest object.

  Fields:
    name: Required. The name of the realm to retrieve, using the form:
      `projects/{project_id}/locations/{location}/realms/{realm_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsRealmsListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: Optional. The maximum number of items to return.  If
      unspecified, server will pick an appropriate default. Server may return
      fewer items than requested. A caller should only rely on response's
      next_page_token to determine if there are more Realms left to be
      queried.
    pageToken: Optional. The next_page_token value returned from a previous
      List request, if any.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GameservicesProjectsLocationsRealmsPatchRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsRealmsPatchRequest object.

  Fields:
    name: The resource name of the realm, using the form:
      `projects/{project_id}/locations/{location}/realms/{realm_id}`. For
      example, `projects/my-project/locations/{location}/realms/my-realm`.
    realm: A Realm resource to be passed as the request body.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see  https: //developers.google.com/protocol-
      buffers // /docs/reference/google.protobuf#fieldmask
  """

  name = _messages.StringField(1, required=True)
  realm = _messages.MessageField('Realm', 2)
  updateMask = _messages.StringField(3)


class GameservicesProjectsLocationsScalingPoliciesCreateRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsScalingPoliciesCreateRequest object.

  Fields:
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
    scalingPolicy: A ScalingPolicy resource to be passed as the request body.
    scalingPolicyId: Required. The ID of the scaling policy resource to be
      created.
  """

  parent = _messages.StringField(1, required=True)
  scalingPolicy = _messages.MessageField('ScalingPolicy', 2)
  scalingPolicyId = _messages.StringField(3)


class GameservicesProjectsLocationsScalingPoliciesDeleteRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsScalingPoliciesDeleteRequest object.

  Fields:
    name: Required. The name of the scaling policy to delete, using the form:
      `projects/{project_id}/locations/{location}/scalingPolicies/{scaling_pol
      icy_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsScalingPoliciesGetRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsScalingPoliciesGetRequest object.

  Fields:
    name: Required. The name of the scaling policy to retrieve, using the
      form:  `projects/{project_id}/locations/{location}/scalingPolicies/{scal
      ing_policy_id}`
  """

  name = _messages.StringField(1, required=True)


class GameservicesProjectsLocationsScalingPoliciesListRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsScalingPoliciesListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: / Optional. The maximum number of items to return.  If
      unspecified, server will pick an appropriate default. Server may return
      fewer items than requested. A caller should only rely on response's
      next_page_token to determine if there are more ScalingPolicies left to
      be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      List request, if any.
    parent: Required. The parent resource name, using the form:
      `projects/{project_id}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GameservicesProjectsLocationsScalingPoliciesPatchRequest(_messages.Message):
  r"""A GameservicesProjectsLocationsScalingPoliciesPatchRequest object.

  Fields:
    name: The resource name of the scaling policy, using the form:  `projects/
      {project_id}/locations/{location}/scalingPolicies/{scaling_policy_id}`.
      For example, `projects/my-project/locations/{location}/scalingPolicies
      /my-policy`.
    scalingPolicy: A ScalingPolicy resource to be passed as the request body.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. For the `FieldMask` definition, see  https:
      //developers.google.com/protocol-buffers //
      /docs/reference/google.protobuf#fieldmask
  """

  name = _messages.StringField(1, required=True)
  scalingPolicy = _messages.MessageField('ScalingPolicy', 2)
  updateMask = _messages.StringField(3)


class LabelSelector(_messages.Message):
  r"""The label selector, used to group labels on the resources.

  Messages:
    LabelsValue: A LabelsValue object.

  Fields:
    labels: A LabelsValue attribute.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""A LabelsValue object.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)


class ListAllocationPoliciesResponse(_messages.Message):
  r"""Response message for AllocationPoliciesService.ListAllocationPolicies.

  Fields:
    allocationPolicies: The list of allocation policies.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  allocationPolicies = _messages.MessageField('AllocationPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGameServerClustersResponse(_messages.Message):
  r"""Response message for GameServerClustersService.ListGameServerClusters.

  Fields:
    gameServerClusters: The list of game server clusters.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  gameServerClusters = _messages.MessageField('GameServerCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGameServerDeploymentsResponse(_messages.Message):
  r"""Response message for
  GameServerDeploymentsService.ListGameServerDeployments.

  Fields:
    gameServerDeployments: The list of game server delpoyments.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  gameServerDeployments = _messages.MessageField('GameServerDeployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRealmsResponse(_messages.Message):
  r"""Response message for RealmsService.ListRealms.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    realms: The list of realms
  """

  nextPageToken = _messages.StringField(1)
  realms = _messages.MessageField('Realm', 2, repeated=True)


class ListScalingPoliciesResponse(_messages.Message):
  r"""Response message for ScalingPoliciesService.ListScalingPolicies.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    scalingPolicies: The list of scaling policies.
  """

  nextPageToken = _messages.StringField(1)
  scalingPolicies = _messages.MessageField('ScalingPolicy', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LogConfig(_messages.Message):
  r"""Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied.   Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is   granted.
      Logging will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Realm(_messages.Message):
  r"""A Realm resource.

  Messages:
    LabelsValue: The labels associated with this realm. Each label is a key-
      value pair.

  Fields:
    createTime: Output only. The creation time.
    labels: The labels associated with this realm. Each label is a key-value
      pair.
    name: The resource name of the realm, using the form:
      `projects/{project_id}/locations/{location}/realms/{realm_id}`. For
      example, `projects/my-project/locations/{location}/realms/my-realm`.
    timeZone: Time zone where all realm-specific policies are evaluated. The
      value of this field must be from the IANA time zone database:
      https://www.iana.org/time-zones. If not specified, UTC is assumed by
      default.
    updateTime: Output only. The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this realm. Each label is a key-value pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  timeZone = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class RevertRolloutRequest(_messages.Message):
  r"""Request message for GameServerDeploymentsService.RevertRollout."""


class Rule(_messages.Message):
  r"""A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met. All conditions must
      pass for the rule to match.
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries can be found at in the Local IAM documentation
      (see go/local-iam#features).
    permissions: A permission is a string of form '<service>.<resource
      type>.<verb>' (e.g., 'storage.buckets.list'). A value of '*' matches all
      permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches
      all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class ScalingPolicy(_messages.Message):
  r"""A scaling policy resource.

  Messages:
    LabelsValue: The labels associated with this scaling policy. Each label is
      a key-value pair.

  Fields:
    clusterSelectors: Labels used to identify the clusters to which this
      scaling policy applies. A cluster is subject to this scaling policy if
      its labels match any of the cluster selector entries.
    createTime: Output only. The creation time.
    fleetAutoscalerSettings: Fleet autoscaler parameters.
    gameServerDeployment: The game server deployment for this scaling policy.
      For example,  "projects/my-
      project/locations/{location}/gameServerDeployments/my-deployment".
    labels: The labels associated with this scaling policy. Each label is a
      key-value pair.
    name: The resource name of the scaling policy, using the form:  `projects/
      {project_id}/locations/{location}/scalingPolicies/{scaling_policy_id}`.
      For example, `projects/my-project/locations/{location}/scalingPolicies
      /my-policy`.
    priority: Required. The priority of the policy. A smaller value indicates
      a higher priority.
    schedules: The schedules to which this scaling policy applies.
    updateTime: Output only. The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this scaling policy. Each label is a key-
    value pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterSelectors = _messages.MessageField('LabelSelector', 1, repeated=True)
  createTime = _messages.StringField(2)
  fleetAutoscalerSettings = _messages.MessageField('FleetAutoscalerSettings', 3)
  gameServerDeployment = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  priority = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  schedules = _messages.MessageField('Schedule', 8, repeated=True)
  updateTime = _messages.StringField(9)


class Schedule(_messages.Message):
  r"""The schedule of an event - the event can be recurring or one time.  The
  event's time span is specified by start_time and end_time. If the scheduled
  event's timespan is larger than the cron_spec + cron_job_duration the event
  will be recurring. If cron_spec + cron_job_duration is only specified, the
  event is effective starting at the local time specified by cron_spec and is
  recurrent.    start_time|-------[cron job]-------[cron job]-------[cron
  job]---|end_time   cron job: cron spec start time + duration

  Fields:
    cronJobDuration: The duration for the cron job event. The duration of the
      event is effective after the cron job's start time.
    cronSpec: The cron definition of the scheduled event. See
      https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time
      as defined by the realm.
    endTime: The end time of the event.
    startTime: The start time of the event.
  """

  cronJobDuration = _messages.StringField(1)
  cronSpec = _messages.StringField(2)
  endTime = _messages.StringField(3)
  startTime = _messages.StringField(4)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SetRolloutTargetRequest(_messages.Message):
  r"""Request message for GameServerDeploymentsService.SetRolloutTarget.

  Fields:
    clusterPercentageSelector: Required. The percentage of game servers that
      should run the new game server template in the specified clusters.
      Default is 0.
  """

  clusterPercentageSelector = _messages.MessageField('ClusterPercentageSelector', 1, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StartRolloutRequest(_messages.Message):
  r"""Request message for GameServerDeploymentsService.StartRollout.

  Fields:
    newGameServerTemplate: Required. The game server template for the new
      rollout.
  """

  newGameServerTemplate = _messages.MessageField('GameServerTemplate', 1)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
