require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SOUNDCARD_H_)) {
    eval 'sub _SYS_SOUNDCARD_H_ () {1;}' unless defined(&_SYS_SOUNDCARD_H_);
    eval 'sub SOUND_VERSION () {301;}' unless defined(&SOUND_VERSION);
    eval 'sub VOXWARE () {1;}' unless defined(&VOXWARE);
    eval 'sub SNDCARD_ADLIB () {1;}' unless defined(&SNDCARD_ADLIB);
    eval 'sub SNDCARD_SB () {2;}' unless defined(&SNDCARD_SB);
    eval 'sub SNDCARD_PAS () {3;}' unless defined(&SNDCARD_PAS);
    eval 'sub SNDCARD_GUS () {4;}' unless defined(&SNDCARD_GUS);
    eval 'sub SNDCARD_MPU401 () {5;}' unless defined(&SNDCARD_MPU401);
    eval 'sub SNDCARD_SB16 () {6;}' unless defined(&SNDCARD_SB16);
    eval 'sub SNDCARD_SB16MIDI () {7;}' unless defined(&SNDCARD_SB16MIDI);
    eval 'sub SNDCARD_UART6850 () {8;}' unless defined(&SNDCARD_UART6850);
    eval 'sub SNDCARD_GUS16 () {9;}' unless defined(&SNDCARD_GUS16);
    eval 'sub SNDCARD_MSS () {10;}' unless defined(&SNDCARD_MSS);
    eval 'sub SNDCARD_PSS () {11;}' unless defined(&SNDCARD_PSS);
    eval 'sub SNDCARD_SSCAPE () {12;}' unless defined(&SNDCARD_SSCAPE);
    eval 'sub SNDCARD_PSS_MPU () {13;}' unless defined(&SNDCARD_PSS_MPU);
    eval 'sub SNDCARD_PSS_MSS () {14;}' unless defined(&SNDCARD_PSS_MSS);
    eval 'sub SNDCARD_SSCAPE_MSS () {15;}' unless defined(&SNDCARD_SSCAPE_MSS);
    eval 'sub SNDCARD_TRXPRO () {16;}' unless defined(&SNDCARD_TRXPRO);
    eval 'sub SNDCARD_TRXPRO_SB () {17;}' unless defined(&SNDCARD_TRXPRO_SB);
    eval 'sub SNDCARD_TRXPRO_MPU () {18;}' unless defined(&SNDCARD_TRXPRO_MPU);
    eval 'sub SNDCARD_MAD16 () {19;}' unless defined(&SNDCARD_MAD16);
    eval 'sub SNDCARD_MAD16_MPU () {20;}' unless defined(&SNDCARD_MAD16_MPU);
    eval 'sub SNDCARD_CS4232 () {21;}' unless defined(&SNDCARD_CS4232);
    eval 'sub SNDCARD_CS4232_MPU () {22;}' unless defined(&SNDCARD_CS4232_MPU);
    eval 'sub SNDCARD_MAUI () {23;}' unless defined(&SNDCARD_MAUI);
    eval 'sub SNDCARD_PSEUDO_MSS () {24;}' unless defined(&SNDCARD_PSEUDO_MSS);
    eval 'sub SNDCARD_AWE32 () {25;}' unless defined(&SNDCARD_AWE32);
    eval 'sub SNDCARD_NSS () {26;}' unless defined(&SNDCARD_NSS);
    eval 'sub SNDCARD_UART16550 () {27;}' unless defined(&SNDCARD_UART16550);
    eval 'sub SNDCARD_OPL () {28;}' unless defined(&SNDCARD_OPL);
    require 'sys/types.ph';
    require 'machine/endian.ph';
    unless(defined(&_IOWR)) {
	require 'sys/ioccom.ph';
    }
    eval 'sub AIONWRITE () { &_IOR(ord(\'A\'), 10, \'int\');}' unless defined(&AIONWRITE);
    eval 'sub AIOGSIZE () { &_IOR(ord(\'A\'), 11, \'struct snd_size\');}' unless defined(&AIOGSIZE);
    eval 'sub AIOSSIZE () { &_IOWR(ord(\'A\'), 11, \'struct snd_size\');}' unless defined(&AIOSSIZE);
    eval 'sub AFMT_QUERY () {0x;}' unless defined(&AFMT_QUERY);
    eval 'sub AFMT_MU_LAW () {0x1;}' unless defined(&AFMT_MU_LAW);
    eval 'sub AFMT_A_LAW () {0x2;}' unless defined(&AFMT_A_LAW);
    eval 'sub AFMT_IMA_ADPCM () {0x4;}' unless defined(&AFMT_IMA_ADPCM);
    eval 'sub AFMT_U8 () {0x8;}' unless defined(&AFMT_U8);
    eval 'sub AFMT_S16_LE () {0x10;}' unless defined(&AFMT_S16_LE);
    eval 'sub AFMT_S16_BE () {0x20;}' unless defined(&AFMT_S16_BE);
    eval 'sub AFMT_S8 () {0x40;}' unless defined(&AFMT_S8);
    eval 'sub AFMT_U16_LE () {0x80;}' unless defined(&AFMT_U16_LE);
    eval 'sub AFMT_U16_BE () {0x100;}' unless defined(&AFMT_U16_BE);
    eval 'sub AFMT_MPEG () {0x200;}' unless defined(&AFMT_MPEG);
    eval 'sub AFMT_AC3 () {0x400;}' unless defined(&AFMT_AC3);
    eval 'sub AFMT_S32_LE () {0x1000;}' unless defined(&AFMT_S32_LE);
    eval 'sub AFMT_S32_BE () {0x2000;}' unless defined(&AFMT_S32_BE);
    eval 'sub AFMT_U32_LE () {0x4000;}' unless defined(&AFMT_U32_LE);
    eval 'sub AFMT_U32_BE () {0x8000;}' unless defined(&AFMT_U32_BE);
    eval 'sub AFMT_S24_LE () {0x10000;}' unless defined(&AFMT_S24_LE);
    eval 'sub AFMT_S24_BE () {0x20000;}' unless defined(&AFMT_S24_BE);
    eval 'sub AFMT_U24_LE () {0x40000;}' unless defined(&AFMT_U24_LE);
    eval 'sub AFMT_U24_BE () {0x80000;}' unless defined(&AFMT_U24_BE);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	eval 'sub AFMT_S16_NE () { &AFMT_S16_LE;}' unless defined(&AFMT_S16_NE);
	eval 'sub AFMT_S24_NE () { &AFMT_S24_LE;}' unless defined(&AFMT_S24_NE);
	eval 'sub AFMT_S32_NE () { &AFMT_S32_LE;}' unless defined(&AFMT_S32_NE);
	eval 'sub AFMT_U16_NE () { &AFMT_U16_LE;}' unless defined(&AFMT_U16_NE);
	eval 'sub AFMT_U24_NE () { &AFMT_U24_LE;}' unless defined(&AFMT_U24_NE);
	eval 'sub AFMT_U32_NE () { &AFMT_U32_LE;}' unless defined(&AFMT_U32_NE);
	eval 'sub AFMT_S16_OE () { &AFMT_S16_BE;}' unless defined(&AFMT_S16_OE);
	eval 'sub AFMT_S24_OE () { &AFMT_S24_BE;}' unless defined(&AFMT_S24_OE);
	eval 'sub AFMT_S32_OE () { &AFMT_S32_BE;}' unless defined(&AFMT_S32_OE);
	eval 'sub AFMT_U16_OE () { &AFMT_U16_BE;}' unless defined(&AFMT_U16_OE);
	eval 'sub AFMT_U24_OE () { &AFMT_U24_BE;}' unless defined(&AFMT_U24_OE);
	eval 'sub AFMT_U32_OE () { &AFMT_U32_BE;}' unless defined(&AFMT_U32_OE);
    } else {
	eval 'sub AFMT_S16_OE () { &AFMT_S16_LE;}' unless defined(&AFMT_S16_OE);
	eval 'sub AFMT_S24_OE () { &AFMT_S24_LE;}' unless defined(&AFMT_S24_OE);
	eval 'sub AFMT_S32_OE () { &AFMT_S32_LE;}' unless defined(&AFMT_S32_OE);
	eval 'sub AFMT_U16_OE () { &AFMT_U16_LE;}' unless defined(&AFMT_U16_OE);
	eval 'sub AFMT_U24_OE () { &AFMT_U24_LE;}' unless defined(&AFMT_U24_OE);
	eval 'sub AFMT_U32_OE () { &AFMT_U32_LE;}' unless defined(&AFMT_U32_OE);
	eval 'sub AFMT_S16_NE () { &AFMT_S16_BE;}' unless defined(&AFMT_S16_NE);
	eval 'sub AFMT_S24_NE () { &AFMT_S24_BE;}' unless defined(&AFMT_S24_NE);
	eval 'sub AFMT_S32_NE () { &AFMT_S32_BE;}' unless defined(&AFMT_S32_NE);
	eval 'sub AFMT_U16_NE () { &AFMT_U16_BE;}' unless defined(&AFMT_U16_NE);
	eval 'sub AFMT_U24_NE () { &AFMT_U24_BE;}' unless defined(&AFMT_U24_NE);
	eval 'sub AFMT_U32_NE () { &AFMT_U32_BE;}' unless defined(&AFMT_U32_NE);
    }
    eval 'sub AFMT_STEREO () {0x10000000;}' unless defined(&AFMT_STEREO);
    eval 'sub AFMT_WEIRD () {0x20000000;}' unless defined(&AFMT_WEIRD);
    eval 'sub AFMT_FULLDUPLEX () {0x80000000;}' unless defined(&AFMT_FULLDUPLEX);
    eval 'sub AIOGFMT () { &_IOR(ord(\'f\'), 12,  &snd_chan_param);}' unless defined(&AIOGFMT);
    eval 'sub AIOSFMT () { &_IOWR(ord(\'f\'), 12,  &snd_chan_param);}' unless defined(&AIOSFMT);
    eval 'sub AIOGMIX () { &_IOWR(ord(\'A\'), 13,  &snd_mix_param);}' unless defined(&AIOGMIX);
    eval 'sub AIOSMIX () { &_IOWR(ord(\'A\'), 14,  &snd_mix_param);}' unless defined(&AIOSMIX);
    eval 'sub AIOSYNC_PLAY () {0x1;}' unless defined(&AIOSYNC_PLAY);
    eval 'sub AIOSYNC_CAPTURE () {0x2;}' unless defined(&AIOSYNC_CAPTURE);
    eval 'sub AIOSTOP () { &_IOWR (ord(\'A\'), 15, \'int\');}' unless defined(&AIOSTOP);
    eval 'sub AIOSYNC_SIGNAL () {0x100;}' unless defined(&AIOSYNC_SIGNAL);
    eval 'sub AIOSYNC_SELECT () {0x200;}' unless defined(&AIOSYNC_SELECT);
    eval 'sub AIOSYNC_READY () {0x400;}' unless defined(&AIOSYNC_READY);
    eval 'sub AIOSYNC_FREE () {0x800;}' unless defined(&AIOSYNC_FREE);
    eval 'sub AIOSYNC () { &_IOWR (ord(\'A\'), 15,  &snd_sync_parm);}' unless defined(&AIOSYNC);
    eval 'sub AIOGCAP () { &_IOWR(ord(\'A\'), 15,  &snd_capabilities);}' unless defined(&AIOGCAP);
    eval 'sub SNDCTL_SEQ_RESET () { &_IO (ord(\'Q\'), 0);}' unless defined(&SNDCTL_SEQ_RESET);
    eval 'sub SNDCTL_SEQ_SYNC () { &_IO (ord(\'Q\'), 1);}' unless defined(&SNDCTL_SEQ_SYNC);
    eval 'sub SNDCTL_SYNTH_INFO () { &_IOWR(ord(\'Q\'), 2, \'struct synth_info\');}' unless defined(&SNDCTL_SYNTH_INFO);
    eval 'sub SNDCTL_SEQ_CTRLRATE () { &_IOWR(ord(\'Q\'), 3, \'int\');}' unless defined(&SNDCTL_SEQ_CTRLRATE);
    eval 'sub SNDCTL_SEQ_GETOUTCOUNT () { &_IOR (ord(\'Q\'), 4, \'int\');}' unless defined(&SNDCTL_SEQ_GETOUTCOUNT);
    eval 'sub SNDCTL_SEQ_GETINCOUNT () { &_IOR (ord(\'Q\'), 5, \'int\');}' unless defined(&SNDCTL_SEQ_GETINCOUNT);
    eval 'sub SNDCTL_SEQ_PERCMODE () { &_IOW (ord(\'Q\'), 6, \'int\');}' unless defined(&SNDCTL_SEQ_PERCMODE);
    eval 'sub SNDCTL_FM_LOAD_INSTR () { &_IOW (ord(\'Q\'), 7, \'struct sbi_instrument\');}' unless defined(&SNDCTL_FM_LOAD_INSTR);
    eval 'sub SNDCTL_SEQ_TESTMIDI () { &_IOW (ord(\'Q\'), 8, \'int\');}' unless defined(&SNDCTL_SEQ_TESTMIDI);
    eval 'sub SNDCTL_SEQ_RESETSAMPLES () { &_IOW (ord(\'Q\'), 9, \'int\');}' unless defined(&SNDCTL_SEQ_RESETSAMPLES);
    eval 'sub SNDCTL_SEQ_NRSYNTHS () { &_IOR (ord(\'Q\'),10, \'int\');}' unless defined(&SNDCTL_SEQ_NRSYNTHS);
    eval 'sub SNDCTL_SEQ_NRMIDIS () { &_IOR (ord(\'Q\'),11, \'int\');}' unless defined(&SNDCTL_SEQ_NRMIDIS);
    eval 'sub SNDCTL_MIDI_INFO () { &_IOWR(ord(\'Q\'),12, \'struct midi_info\');}' unless defined(&SNDCTL_MIDI_INFO);
    eval 'sub SNDCTL_SEQ_THRESHOLD () { &_IOW (ord(\'Q\'),13, \'int\');}' unless defined(&SNDCTL_SEQ_THRESHOLD);
    eval 'sub SNDCTL_SEQ_TRESHOLD () { &SNDCTL_SEQ_THRESHOLD;}' unless defined(&SNDCTL_SEQ_TRESHOLD);
    eval 'sub SNDCTL_SYNTH_MEMAVL () { &_IOWR(ord(\'Q\'),14, \'int\');}' unless defined(&SNDCTL_SYNTH_MEMAVL);
    eval 'sub SNDCTL_FM_4OP_ENABLE () { &_IOW (ord(\'Q\'),15, \'int\');}' unless defined(&SNDCTL_FM_4OP_ENABLE);
    eval 'sub SNDCTL_PMGR_ACCESS () { &_IOWR(ord(\'Q\'),16, \'struct patmgr_info\');}' unless defined(&SNDCTL_PMGR_ACCESS);
    eval 'sub SNDCTL_SEQ_PANIC () { &_IO (ord(\'Q\'),17);}' unless defined(&SNDCTL_SEQ_PANIC);
    eval 'sub SNDCTL_SEQ_OUTOFBAND () { &_IOW (ord(\'Q\'),18, \'struct seq_event_rec\');}' unless defined(&SNDCTL_SEQ_OUTOFBAND);
    eval 'sub SNDCTL_SEQ_GETTIME () { &_IOR (ord(\'Q\'),19, \'int\');}' unless defined(&SNDCTL_SEQ_GETTIME);
    eval 'sub SNDCTL_TMR_TIMEBASE () { &_IOWR(ord(\'T\'), 1, \'int\');}' unless defined(&SNDCTL_TMR_TIMEBASE);
    eval 'sub SNDCTL_TMR_START () { &_IO (ord(\'T\'), 2);}' unless defined(&SNDCTL_TMR_START);
    eval 'sub SNDCTL_TMR_STOP () { &_IO (ord(\'T\'), 3);}' unless defined(&SNDCTL_TMR_STOP);
    eval 'sub SNDCTL_TMR_CONTINUE () { &_IO (ord(\'T\'), 4);}' unless defined(&SNDCTL_TMR_CONTINUE);
    eval 'sub SNDCTL_TMR_TEMPO () { &_IOWR(ord(\'T\'), 5, \'int\');}' unless defined(&SNDCTL_TMR_TEMPO);
    eval 'sub SNDCTL_TMR_SOURCE () { &_IOWR(ord(\'T\'), 6, \'int\');}' unless defined(&SNDCTL_TMR_SOURCE);
    eval 'sub TMR_INTERNAL () {0x1;}' unless defined(&TMR_INTERNAL);
    eval 'sub TMR_EXTERNAL () {0x2;}' unless defined(&TMR_EXTERNAL);
    eval 'sub TMR_MODE_MIDI () {0x10;}' unless defined(&TMR_MODE_MIDI);
    eval 'sub TMR_MODE_FSK () {0x20;}' unless defined(&TMR_MODE_FSK);
    eval 'sub TMR_MODE_CLS () {0x40;}' unless defined(&TMR_MODE_CLS);
    eval 'sub TMR_MODE_SMPTE () {0x80;}' unless defined(&TMR_MODE_SMPTE);
    eval 'sub SNDCTL_TMR_METRONOME () { &_IOW (ord(\'T\'), 7, \'int\');}' unless defined(&SNDCTL_TMR_METRONOME);
    eval 'sub SNDCTL_TMR_SELECT () { &_IOW (ord(\'T\'), 8, \'int\');}' unless defined(&SNDCTL_TMR_SELECT);
    if(defined(&_AIX) || defined(&AIX)) {
	eval 'sub _PATCHKEY {
	    my($id) = @_;
    	    eval q((0xfd00|$id));
	}' unless defined(&_PATCHKEY);
    } else {
	eval 'sub _PATCHKEY {
	    my($id) = @_;
    	    eval q((($id<<8)|0xfd));
	}' unless defined(&_PATCHKEY);
    }
    eval 'sub GUS_PATCH () { &_PATCHKEY(0x4);}' unless defined(&GUS_PATCH);
    eval 'sub OBSOLETE_GUS_PATCH () { &_PATCHKEY(0x2);}' unless defined(&OBSOLETE_GUS_PATCH);
    eval 'sub WAVE_16_BITS () {0x1;}' unless defined(&WAVE_16_BITS);
    eval 'sub WAVE_UNSIGNED () {0x2;}' unless defined(&WAVE_UNSIGNED);
    eval 'sub WAVE_LOOPING () {0x4;}' unless defined(&WAVE_LOOPING);
    eval 'sub WAVE_BIDIR_LOOP () {0x8;}' unless defined(&WAVE_BIDIR_LOOP);
    eval 'sub WAVE_LOOP_BACK () {0x10;}' unless defined(&WAVE_LOOP_BACK);
    eval 'sub WAVE_SUSTAIN_ON () {0x20;}' unless defined(&WAVE_SUSTAIN_ON);
    eval 'sub WAVE_ENVELOPES () {0x40;}' unless defined(&WAVE_ENVELOPES);
    eval 'sub WAVE_VIBRATO () {0x10000;}' unless defined(&WAVE_VIBRATO);
    eval 'sub WAVE_TREMOLO () {0x20000;}' unless defined(&WAVE_TREMOLO);
    eval 'sub WAVE_SCALE () {0x40000;}' unless defined(&WAVE_SCALE);
    eval 'sub SYSEX_PATCH () { &_PATCHKEY(0x5);}' unless defined(&SYSEX_PATCH);
    eval 'sub MAUI_PATCH () { &_PATCHKEY(0x6);}' unless defined(&MAUI_PATCH);
    eval 'sub PS_NO_PATCHES () {0;}' unless defined(&PS_NO_PATCHES);
    eval 'sub PS_MGR_NOT_OK () {1;}' unless defined(&PS_MGR_NOT_OK);
    eval 'sub PS_MGR_OK () {2;}' unless defined(&PS_MGR_OK);
    eval 'sub PS_MANAGED () {3;}' unless defined(&PS_MANAGED);
    eval 'sub SNDCTL_PMGR_IFACE () { &_IOWR(ord(\'P\'), 1, \'struct patmgr_info\');}' unless defined(&SNDCTL_PMGR_IFACE);
    eval 'sub PM_K_EVENT () {1;}' unless defined(&PM_K_EVENT);
    eval 'sub PM_K_COMMAND () {2;}' unless defined(&PM_K_COMMAND);
    eval 'sub PM_K_RESPONSE () {3;}' unless defined(&PM_K_RESPONSE);
    eval 'sub PM_ERROR () {4;}' unless defined(&PM_ERROR);
    eval 'sub PM_GET_DEVTYPE () {1;}' unless defined(&PM_GET_DEVTYPE);
    eval 'sub PMTYPE_FM2 () {1;}' unless defined(&PMTYPE_FM2);
    eval 'sub PMTYPE_FM4 () {2;}' unless defined(&PMTYPE_FM4);
    eval 'sub PMTYPE_WAVE () {3;}' unless defined(&PMTYPE_WAVE);
    eval 'sub PM_GET_NRPGM () {2;}' unless defined(&PM_GET_NRPGM);
    eval 'sub PM_GET_PGMMAP () {3;}' unless defined(&PM_GET_PGMMAP);
    eval 'sub PM_GET_PGM_PATCHES () {4;}' unless defined(&PM_GET_PGM_PATCHES);
    eval 'sub PM_GET_PATCH () {5;}' unless defined(&PM_GET_PATCH);
    eval 'sub PM_SET_PATCH () {6;}' unless defined(&PM_SET_PATCH);
    eval 'sub PM_READ_PATCH () {7;}' unless defined(&PM_READ_PATCH);
    eval 'sub PM_WRITE_PATCH () {8;}' unless defined(&PM_WRITE_PATCH);
    eval 'sub _PM_LOAD_PATCH () {0x100;}' unless defined(&_PM_LOAD_PATCH);
    eval 'sub PM_E_OPENED () {1;}' unless defined(&PM_E_OPENED);
    eval 'sub PM_E_CLOSED () {2;}' unless defined(&PM_E_CLOSED);
    eval 'sub PM_E_PATCH_RESET () {3;}' unless defined(&PM_E_PATCH_RESET);
    eval 'sub PM_E_PATCH_LOADED () {4;}' unless defined(&PM_E_PATCH_LOADED);
    eval 'sub SEQ_NOTEOFF () {0;}' unless defined(&SEQ_NOTEOFF);
    eval 'sub SEQ_FMNOTEOFF () { &SEQ_NOTEOFF;}' unless defined(&SEQ_FMNOTEOFF);
    eval 'sub SEQ_NOTEON () {1;}' unless defined(&SEQ_NOTEON);
    eval 'sub SEQ_FMNOTEON () { &SEQ_NOTEON;}' unless defined(&SEQ_FMNOTEON);
    eval 'sub SEQ_WAIT () { &TMR_WAIT_ABS;}' unless defined(&SEQ_WAIT);
    eval 'sub SEQ_PGMCHANGE () {3;}' unless defined(&SEQ_PGMCHANGE);
    eval 'sub SEQ_FMPGMCHANGE () { &SEQ_PGMCHANGE;}' unless defined(&SEQ_FMPGMCHANGE);
    eval 'sub SEQ_SYNCTIMER () { &TMR_START;}' unless defined(&SEQ_SYNCTIMER);
    eval 'sub SEQ_MIDIPUTC () {5;}' unless defined(&SEQ_MIDIPUTC);
    eval 'sub SEQ_DRUMON () {6;}' unless defined(&SEQ_DRUMON);
    eval 'sub SEQ_DRUMOFF () {7;}' unless defined(&SEQ_DRUMOFF);
    eval 'sub SEQ_ECHO () { &TMR_ECHO;}' unless defined(&SEQ_ECHO);
    eval 'sub SEQ_AFTERTOUCH () {9;}' unless defined(&SEQ_AFTERTOUCH);
    eval 'sub SEQ_CONTROLLER () {10;}' unless defined(&SEQ_CONTROLLER);
    eval 'sub CTL_BANK_SELECT () {0x;}' unless defined(&CTL_BANK_SELECT);
    eval 'sub CTL_MODWHEEL () {0x1;}' unless defined(&CTL_MODWHEEL);
    eval 'sub CTL_BREATH () {0x2;}' unless defined(&CTL_BREATH);
    eval 'sub CTL_FOOT () {0x4;}' unless defined(&CTL_FOOT);
    eval 'sub CTL_PORTAMENTO_TIME () {0x5;}' unless defined(&CTL_PORTAMENTO_TIME);
    eval 'sub CTL_DATA_ENTRY () {0x6;}' unless defined(&CTL_DATA_ENTRY);
    eval 'sub CTL_MAIN_VOLUME () {0x7;}' unless defined(&CTL_MAIN_VOLUME);
    eval 'sub CTL_BALANCE () {0x8;}' unless defined(&CTL_BALANCE);
    eval 'sub CTL_PAN () {0xa;}' unless defined(&CTL_PAN);
    eval 'sub CTL_EXPRESSION () {0xb;}' unless defined(&CTL_EXPRESSION);
    eval 'sub CTL_GENERAL_PURPOSE1 () {0x10;}' unless defined(&CTL_GENERAL_PURPOSE1);
    eval 'sub CTL_GENERAL_PURPOSE2 () {0x11;}' unless defined(&CTL_GENERAL_PURPOSE2);
    eval 'sub CTL_GENERAL_PURPOSE3 () {0x12;}' unless defined(&CTL_GENERAL_PURPOSE3);
    eval 'sub CTL_GENERAL_PURPOSE4 () {0x13;}' unless defined(&CTL_GENERAL_PURPOSE4);
    eval 'sub CTL_DAMPER_PEDAL () {0x40;}' unless defined(&CTL_DAMPER_PEDAL);
    eval 'sub CTL_SUSTAIN () { &CTL_DAMPER_PEDAL;}' unless defined(&CTL_SUSTAIN);
    eval 'sub CTL_HOLD () { &CTL_DAMPER_PEDAL;}' unless defined(&CTL_HOLD);
    eval 'sub CTL_PORTAMENTO () {0x41;}' unless defined(&CTL_PORTAMENTO);
    eval 'sub CTL_SOSTENUTO () {0x42;}' unless defined(&CTL_SOSTENUTO);
    eval 'sub CTL_SOFT_PEDAL () {0x43;}' unless defined(&CTL_SOFT_PEDAL);
    eval 'sub CTL_HOLD2 () {0x45;}' unless defined(&CTL_HOLD2);
    eval 'sub CTL_GENERAL_PURPOSE5 () {0x50;}' unless defined(&CTL_GENERAL_PURPOSE5);
    eval 'sub CTL_GENERAL_PURPOSE6 () {0x51;}' unless defined(&CTL_GENERAL_PURPOSE6);
    eval 'sub CTL_GENERAL_PURPOSE7 () {0x52;}' unless defined(&CTL_GENERAL_PURPOSE7);
    eval 'sub CTL_GENERAL_PURPOSE8 () {0x53;}' unless defined(&CTL_GENERAL_PURPOSE8);
    eval 'sub CTL_EXT_EFF_DEPTH () {0x5b;}' unless defined(&CTL_EXT_EFF_DEPTH);
    eval 'sub CTL_TREMOLO_DEPTH () {0x5c;}' unless defined(&CTL_TREMOLO_DEPTH);
    eval 'sub CTL_CHORUS_DEPTH () {0x5d;}' unless defined(&CTL_CHORUS_DEPTH);
    eval 'sub CTL_DETUNE_DEPTH () {0x5e;}' unless defined(&CTL_DETUNE_DEPTH);
    eval 'sub CTL_CELESTE_DEPTH () { &CTL_DETUNE_DEPTH;}' unless defined(&CTL_CELESTE_DEPTH);
    eval 'sub CTL_PHASER_DEPTH () {0x5f;}' unless defined(&CTL_PHASER_DEPTH);
    eval 'sub CTL_DATA_INCREMENT () {0x60;}' unless defined(&CTL_DATA_INCREMENT);
    eval 'sub CTL_DATA_DECREMENT () {0x61;}' unless defined(&CTL_DATA_DECREMENT);
    eval 'sub CTL_NONREG_PARM_NUM_LSB () {0x62;}' unless defined(&CTL_NONREG_PARM_NUM_LSB);
    eval 'sub CTL_NONREG_PARM_NUM_MSB () {0x63;}' unless defined(&CTL_NONREG_PARM_NUM_MSB);
    eval 'sub CTL_REGIST_PARM_NUM_LSB () {0x64;}' unless defined(&CTL_REGIST_PARM_NUM_LSB);
    eval 'sub CTL_REGIST_PARM_NUM_MSB () {0x65;}' unless defined(&CTL_REGIST_PARM_NUM_MSB);
    eval 'sub CTRL_PITCH_BENDER () {255;}' unless defined(&CTRL_PITCH_BENDER);
    eval 'sub CTRL_PITCH_BENDER_RANGE () {254;}' unless defined(&CTRL_PITCH_BENDER_RANGE);
    eval 'sub CTRL_EXPRESSION () {253;}' unless defined(&CTRL_EXPRESSION);
    eval 'sub CTRL_MAIN_VOLUME () {252;}' unless defined(&CTRL_MAIN_VOLUME);
    eval 'sub SEQ_BALANCE () {11;}' unless defined(&SEQ_BALANCE);
    eval 'sub SEQ_VOLMODE () {12;}' unless defined(&SEQ_VOLMODE);
    eval 'sub VOL_METHOD_ADAGIO () {1;}' unless defined(&VOL_METHOD_ADAGIO);
    eval 'sub VOL_METHOD_LINEAR () {2;}' unless defined(&VOL_METHOD_LINEAR);
    eval 'sub SEQ_FULLSIZE () {0xfd;}' unless defined(&SEQ_FULLSIZE);
    eval 'sub SEQ_PRIVATE () {0xfe;}' unless defined(&SEQ_PRIVATE);
    eval 'sub SEQ_EXTENDED () {0xff;}' unless defined(&SEQ_EXTENDED);
    eval 'sub FM_PATCH () { &_PATCHKEY(0x1);}' unless defined(&FM_PATCH);
    eval 'sub OPL3_PATCH () { &_PATCHKEY(0x3);}' unless defined(&OPL3_PATCH);
    eval 'sub SYNTH_TYPE_FM () {0;}' unless defined(&SYNTH_TYPE_FM);
    eval 'sub SYNTH_TYPE_SAMPLE () {1;}' unless defined(&SYNTH_TYPE_SAMPLE);
    eval 'sub SYNTH_TYPE_MIDI () {2;}' unless defined(&SYNTH_TYPE_MIDI);
    eval 'sub FM_TYPE_ADLIB () {0x;}' unless defined(&FM_TYPE_ADLIB);
    eval 'sub FM_TYPE_OPL3 () {0x1;}' unless defined(&FM_TYPE_OPL3);
    eval 'sub MIDI_TYPE_MPU401 () {0x401;}' unless defined(&MIDI_TYPE_MPU401);
    eval 'sub SAMPLE_TYPE_BASIC () {0x10;}' unless defined(&SAMPLE_TYPE_BASIC);
    eval 'sub SAMPLE_TYPE_GUS () { &SAMPLE_TYPE_BASIC;}' unless defined(&SAMPLE_TYPE_GUS);
    eval 'sub SAMPLE_TYPE_AWE32 () {0x20;}' unless defined(&SAMPLE_TYPE_AWE32);
    eval 'sub SYNTH_CAP_PERCMODE () {0x1;}' unless defined(&SYNTH_CAP_PERCMODE);
    eval 'sub SYNTH_CAP_OPL3 () {0x2;}' unless defined(&SYNTH_CAP_OPL3);
    eval 'sub SYNTH_CAP_INPUT () {0x4;}' unless defined(&SYNTH_CAP_INPUT);
    eval 'sub SNDCTL_MIDI_PRETIME () { &_IOWR(ord(\'m\'), 0, \'int\');}' unless defined(&SNDCTL_MIDI_PRETIME);
    eval 'sub SNDCTL_MIDI_MPUMODE () { &_IOWR(ord(\'m\'), 1, \'int\');}' unless defined(&SNDCTL_MIDI_MPUMODE);
    eval 'sub SNDCTL_MIDI_MPUCMD () { &_IOWR(ord(\'m\'), 2,  &mpu_command_rec);}' unless defined(&SNDCTL_MIDI_MPUCMD);
    eval 'sub MIOSPASSTHRU () { &_IOWR(ord(\'m\'), 3, \'int\');}' unless defined(&MIOSPASSTHRU);
    eval 'sub MIOGPASSTHRU () { &_IOWR(ord(\'m\'), 4, \'int\');}' unless defined(&MIOGPASSTHRU);
    eval 'sub SNDCTL_DSP_HALT () { &_IO (ord(\'P\'), 0);}' unless defined(&SNDCTL_DSP_HALT);
    eval 'sub SNDCTL_DSP_RESET () { &SNDCTL_DSP_HALT;}' unless defined(&SNDCTL_DSP_RESET);
    eval 'sub SNDCTL_DSP_SYNC () { &_IO (ord(\'P\'), 1);}' unless defined(&SNDCTL_DSP_SYNC);
    eval 'sub SNDCTL_DSP_SPEED () { &_IOWR(ord(\'P\'), 2, \'int\');}' unless defined(&SNDCTL_DSP_SPEED);
    eval 'sub SNDCTL_DSP_STEREO () { &_IOWR(ord(\'P\'), 3, \'int\');}' unless defined(&SNDCTL_DSP_STEREO);
    eval 'sub SNDCTL_DSP_GETBLKSIZE () { &_IOR(ord(\'P\'), 4, \'int\');}' unless defined(&SNDCTL_DSP_GETBLKSIZE);
    eval 'sub SNDCTL_DSP_SETBLKSIZE () { &_IOW(ord(\'P\'), 4, \'int\');}' unless defined(&SNDCTL_DSP_SETBLKSIZE);
    eval 'sub SNDCTL_DSP_SETFMT () { &_IOWR(ord(\'P\'),5, \'int\');}' unless defined(&SNDCTL_DSP_SETFMT);
    eval 'sub SOUND_PCM_WRITE_CHANNELS () { &_IOWR(ord(\'P\'), 6, \'int\');}' unless defined(&SOUND_PCM_WRITE_CHANNELS);
    eval 'sub SNDCTL_DSP_CHANNELS () { &SOUND_PCM_WRITE_CHANNELS;}' unless defined(&SNDCTL_DSP_CHANNELS);
    eval 'sub SOUND_PCM_WRITE_FILTER () { &_IOWR(ord(\'P\'), 7, \'int\');}' unless defined(&SOUND_PCM_WRITE_FILTER);
    eval 'sub SNDCTL_DSP_POST () { &_IO (ord(\'P\'), 8);}' unless defined(&SNDCTL_DSP_POST);
    eval 'sub SNDCTL_DSP_SUBDIVIDE () { &_IOWR(ord(\'P\'), 9, \'int\');}' unless defined(&SNDCTL_DSP_SUBDIVIDE);
    eval 'sub SNDCTL_DSP_SETFRAGMENT () { &_IOWR(ord(\'P\'),10, \'int\');}' unless defined(&SNDCTL_DSP_SETFRAGMENT);
    eval 'sub SNDCTL_DSP_GETFMTS () { &_IOR (ord(\'P\'),11, \'int\');}' unless defined(&SNDCTL_DSP_GETFMTS);
    eval 'sub SNDCTL_DSP_GETOSPACE () { &_IOR (ord(\'P\'),12,  &audio_buf_info);}' unless defined(&SNDCTL_DSP_GETOSPACE);
    eval 'sub SNDCTL_DSP_GETISPACE () { &_IOR (ord(\'P\'),13,  &audio_buf_info);}' unless defined(&SNDCTL_DSP_GETISPACE);
    eval 'sub SNDCTL_DSP_NONBLOCK () { &_IO (ord(\'P\'),14);}' unless defined(&SNDCTL_DSP_NONBLOCK);
    eval 'sub SNDCTL_DSP_GETCAPS () { &_IOR (ord(\'P\'),15, \'int\');}' unless defined(&SNDCTL_DSP_GETCAPS);
    eval 'sub PCM_CAP_REVISION () {0xff;}' unless defined(&PCM_CAP_REVISION);
    eval 'sub PCM_CAP_DUPLEX () {0x100;}' unless defined(&PCM_CAP_DUPLEX);
    eval 'sub PCM_CAP_REALTIME () {0x200;}' unless defined(&PCM_CAP_REALTIME);
    eval 'sub PCM_CAP_BATCH () {0x400;}' unless defined(&PCM_CAP_BATCH);
    eval 'sub PCM_CAP_COPROC () {0x800;}' unless defined(&PCM_CAP_COPROC);
    eval 'sub PCM_CAP_TRIGGER () {0x1000;}' unless defined(&PCM_CAP_TRIGGER);
    eval 'sub PCM_CAP_MMAP () {0x2000;}' unless defined(&PCM_CAP_MMAP);
    eval 'sub PCM_CAP_MULTI () {0x4000;}' unless defined(&PCM_CAP_MULTI);
    eval 'sub PCM_CAP_BIND () {0x8000;}' unless defined(&PCM_CAP_BIND);
    eval 'sub PCM_CAP_INPUT () {0x10000;}' unless defined(&PCM_CAP_INPUT);
    eval 'sub PCM_CAP_OUTPUT () {0x20000;}' unless defined(&PCM_CAP_OUTPUT);
    eval 'sub PCM_CAP_VIRTUAL () {0x40000;}' unless defined(&PCM_CAP_VIRTUAL);
    eval 'sub PCM_CAP_ANALOGOUT () {0x100000;}' unless defined(&PCM_CAP_ANALOGOUT);
    eval 'sub PCM_CAP_ANALOGIN () {0x200000;}' unless defined(&PCM_CAP_ANALOGIN);
    eval 'sub PCM_CAP_DIGITALOUT () {0x400000;}' unless defined(&PCM_CAP_DIGITALOUT);
    eval 'sub PCM_CAP_DIGITALIN () {0x800000;}' unless defined(&PCM_CAP_DIGITALIN);
    eval 'sub PCM_CAP_ADMASK () {0xf00000;}' unless defined(&PCM_CAP_ADMASK);
    eval 'sub PCM_CAP_SPECIAL () {0x1000000;}' unless defined(&PCM_CAP_SPECIAL);
    eval 'sub PCM_CAP_SHADOW () {0x;}' unless defined(&PCM_CAP_SHADOW);
    eval 'sub DSP_CH_MASK () {0x6000000;}' unless defined(&DSP_CH_MASK);
    eval 'sub DSP_CH_ANY () {0x;}' unless defined(&DSP_CH_ANY);
    eval 'sub DSP_CH_MONO () {0x2000000;}' unless defined(&DSP_CH_MONO);
    eval 'sub DSP_CH_STEREO () {0x4000000;}' unless defined(&DSP_CH_STEREO);
    eval 'sub DSP_CH_MULTI () {0x6000000;}' unless defined(&DSP_CH_MULTI);
    eval 'sub PCM_CAP_HIDDEN () {0x8000000;}' unless defined(&PCM_CAP_HIDDEN);
    eval 'sub PCM_CAP_FREERATE () {0x10000000;}' unless defined(&PCM_CAP_FREERATE);
    eval 'sub PCM_CAP_MODEM () {0x20000000;}' unless defined(&PCM_CAP_MODEM);
    eval 'sub PCM_CAP_DEFAULT () {0x40000000;}' unless defined(&PCM_CAP_DEFAULT);
    eval 'sub DSP_CAP_ADMASK () { &PCM_CAP_ADMASK;}' unless defined(&DSP_CAP_ADMASK);
    eval 'sub DSP_CAP_ANALOGIN () { &PCM_CAP_ANALOGIN;}' unless defined(&DSP_CAP_ANALOGIN);
    eval 'sub DSP_CAP_ANALOGOUT () { &PCM_CAP_ANALOGOUT;}' unless defined(&DSP_CAP_ANALOGOUT);
    eval 'sub DSP_CAP_BATCH () { &PCM_CAP_BATCH;}' unless defined(&DSP_CAP_BATCH);
    eval 'sub DSP_CAP_BIND () { &PCM_CAP_BIND;}' unless defined(&DSP_CAP_BIND);
    eval 'sub DSP_CAP_COPROC () { &PCM_CAP_COPROC;}' unless defined(&DSP_CAP_COPROC);
    eval 'sub DSP_CAP_DEFAULT () { &PCM_CAP_DEFAULT;}' unless defined(&DSP_CAP_DEFAULT);
    eval 'sub DSP_CAP_DIGITALIN () { &PCM_CAP_DIGITALIN;}' unless defined(&DSP_CAP_DIGITALIN);
    eval 'sub DSP_CAP_DIGITALOUT () { &PCM_CAP_DIGITALOUT;}' unless defined(&DSP_CAP_DIGITALOUT);
    eval 'sub DSP_CAP_DUPLEX () { &PCM_CAP_DUPLEX;}' unless defined(&DSP_CAP_DUPLEX);
    eval 'sub DSP_CAP_FREERATE () { &PCM_CAP_FREERATE;}' unless defined(&DSP_CAP_FREERATE);
    eval 'sub DSP_CAP_HIDDEN () { &PCM_CAP_HIDDEN;}' unless defined(&DSP_CAP_HIDDEN);
    eval 'sub DSP_CAP_INPUT () { &PCM_CAP_INPUT;}' unless defined(&DSP_CAP_INPUT);
    eval 'sub DSP_CAP_MMAP () { &PCM_CAP_MMAP;}' unless defined(&DSP_CAP_MMAP);
    eval 'sub DSP_CAP_MODEM () { &PCM_CAP_MODEM;}' unless defined(&DSP_CAP_MODEM);
    eval 'sub DSP_CAP_MULTI () { &PCM_CAP_MULTI;}' unless defined(&DSP_CAP_MULTI);
    eval 'sub DSP_CAP_OUTPUT () { &PCM_CAP_OUTPUT;}' unless defined(&DSP_CAP_OUTPUT);
    eval 'sub DSP_CAP_REALTIME () { &PCM_CAP_REALTIME;}' unless defined(&DSP_CAP_REALTIME);
    eval 'sub DSP_CAP_REVISION () { &PCM_CAP_REVISION;}' unless defined(&DSP_CAP_REVISION);
    eval 'sub DSP_CAP_SHADOW () { &PCM_CAP_SHADOW;}' unless defined(&DSP_CAP_SHADOW);
    eval 'sub DSP_CAP_TRIGGER () { &PCM_CAP_TRIGGER;}' unless defined(&DSP_CAP_TRIGGER);
    eval 'sub DSP_CAP_VIRTUAL () { &PCM_CAP_VIRTUAL;}' unless defined(&DSP_CAP_VIRTUAL);
    eval 'sub SNDCTL_DSP_GETTRIGGER () { &_IOR (ord(\'P\'),16, \'int\');}' unless defined(&SNDCTL_DSP_GETTRIGGER);
    eval 'sub SNDCTL_DSP_SETTRIGGER () { &_IOW (ord(\'P\'),16, \'int\');}' unless defined(&SNDCTL_DSP_SETTRIGGER);
    eval 'sub PCM_ENABLE_INPUT () {0x1;}' unless defined(&PCM_ENABLE_INPUT);
    eval 'sub PCM_ENABLE_OUTPUT () {0x2;}' unless defined(&PCM_ENABLE_OUTPUT);
    eval 'sub SNDCTL_DSP_GETIPTR () { &_IOR (ord(\'P\'),17,  &count_info);}' unless defined(&SNDCTL_DSP_GETIPTR);
    eval 'sub SNDCTL_DSP_GETOPTR () { &_IOR (ord(\'P\'),18,  &count_info);}' unless defined(&SNDCTL_DSP_GETOPTR);
    eval 'sub SNDCTL_DSP_MAPINBUF () { &_IOR (ord(\'P\'), 19,  &buffmem_desc);}' unless defined(&SNDCTL_DSP_MAPINBUF);
    eval 'sub SNDCTL_DSP_MAPOUTBUF () { &_IOR (ord(\'P\'), 20,  &buffmem_desc);}' unless defined(&SNDCTL_DSP_MAPOUTBUF);
    eval 'sub SNDCTL_DSP_SETSYNCRO () { &_IO (ord(\'P\'), 21);}' unless defined(&SNDCTL_DSP_SETSYNCRO);
    eval 'sub SNDCTL_DSP_SETDUPLEX () { &_IO (ord(\'P\'), 22);}' unless defined(&SNDCTL_DSP_SETDUPLEX);
    eval 'sub SNDCTL_DSP_GETODELAY () { &_IOR (ord(\'P\'), 23, \'int\');}' unless defined(&SNDCTL_DSP_GETODELAY);
    eval 'sub SOUND_PCM_READ_RATE () { &_IOR (ord(\'P\'), 2, \'int\');}' unless defined(&SOUND_PCM_READ_RATE);
    eval 'sub SOUND_PCM_READ_CHANNELS () { &_IOR (ord(\'P\'), 6, \'int\');}' unless defined(&SOUND_PCM_READ_CHANNELS);
    eval 'sub SOUND_PCM_READ_BITS () { &_IOR (ord(\'P\'), 5, \'int\');}' unless defined(&SOUND_PCM_READ_BITS);
    eval 'sub SOUND_PCM_READ_FILTER () { &_IOR (ord(\'P\'), 7, \'int\');}' unless defined(&SOUND_PCM_READ_FILTER);
    eval 'sub CPF_NONE () {0x;}' unless defined(&CPF_NONE);
    eval 'sub CPF_FIRST () {0x1;}' unless defined(&CPF_FIRST);
    eval 'sub CPF_LAST () {0x2;}' unless defined(&CPF_LAST);
    eval 'sub SNDCTL_COPR_RESET () { &_IO (ord(\'C\'), 0);}' unless defined(&SNDCTL_COPR_RESET);
    eval 'sub SNDCTL_COPR_LOAD () { &_IOWR(ord(\'C\'), 1,  &copr_buffer);}' unless defined(&SNDCTL_COPR_LOAD);
    eval 'sub SNDCTL_COPR_RDATA () { &_IOWR(ord(\'C\'), 2,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_RDATA);
    eval 'sub SNDCTL_COPR_RCODE () { &_IOWR(ord(\'C\'), 3,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_RCODE);
    eval 'sub SNDCTL_COPR_WDATA () { &_IOW (ord(\'C\'), 4,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_WDATA);
    eval 'sub SNDCTL_COPR_WCODE () { &_IOW (ord(\'C\'), 5,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_WCODE);
    eval 'sub SNDCTL_COPR_RUN () { &_IOWR(ord(\'C\'), 6,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_RUN);
    eval 'sub SNDCTL_COPR_HALT () { &_IOWR(ord(\'C\'), 7,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_HALT);
    eval 'sub SNDCTL_COPR_SENDMSG () { &_IOW (ord(\'C\'), 8,  &copr_msg);}' unless defined(&SNDCTL_COPR_SENDMSG);
    eval 'sub SNDCTL_COPR_RCVMSG () { &_IOR (ord(\'C\'), 9,  &copr_msg);}' unless defined(&SNDCTL_COPR_RCVMSG);
    eval 'sub SOUND_MIXER_NRDEVICES () {25;}' unless defined(&SOUND_MIXER_NRDEVICES);
    eval 'sub SOUND_MIXER_VOLUME () {0;}' unless defined(&SOUND_MIXER_VOLUME);
    eval 'sub SOUND_MIXER_BASS () {1;}' unless defined(&SOUND_MIXER_BASS);
    eval 'sub SOUND_MIXER_TREBLE () {2;}' unless defined(&SOUND_MIXER_TREBLE);
    eval 'sub SOUND_MIXER_SYNTH () {3;}' unless defined(&SOUND_MIXER_SYNTH);
    eval 'sub SOUND_MIXER_PCM () {4;}' unless defined(&SOUND_MIXER_PCM);
    eval 'sub SOUND_MIXER_SPEAKER () {5;}' unless defined(&SOUND_MIXER_SPEAKER);
    eval 'sub SOUND_MIXER_LINE () {6;}' unless defined(&SOUND_MIXER_LINE);
    eval 'sub SOUND_MIXER_MIC () {7;}' unless defined(&SOUND_MIXER_MIC);
    eval 'sub SOUND_MIXER_CD () {8;}' unless defined(&SOUND_MIXER_CD);
    eval 'sub SOUND_MIXER_IMIX () {9;}' unless defined(&SOUND_MIXER_IMIX);
    eval 'sub SOUND_MIXER_ALTPCM () {10;}' unless defined(&SOUND_MIXER_ALTPCM);
    eval 'sub SOUND_MIXER_RECLEV () {11;}' unless defined(&SOUND_MIXER_RECLEV);
    eval 'sub SOUND_MIXER_IGAIN () {12;}' unless defined(&SOUND_MIXER_IGAIN);
    eval 'sub SOUND_MIXER_OGAIN () {13;}' unless defined(&SOUND_MIXER_OGAIN);
    eval 'sub SOUND_MIXER_LINE1 () {14;}' unless defined(&SOUND_MIXER_LINE1);
    eval 'sub SOUND_MIXER_LINE2 () {15;}' unless defined(&SOUND_MIXER_LINE2);
    eval 'sub SOUND_MIXER_LINE3 () {16;}' unless defined(&SOUND_MIXER_LINE3);
    eval 'sub SOUND_MIXER_DIGITAL1 () {17;}' unless defined(&SOUND_MIXER_DIGITAL1);
    eval 'sub SOUND_MIXER_DIGITAL2 () {18;}' unless defined(&SOUND_MIXER_DIGITAL2);
    eval 'sub SOUND_MIXER_DIGITAL3 () {19;}' unless defined(&SOUND_MIXER_DIGITAL3);
    eval 'sub SOUND_MIXER_PHONEIN () {20;}' unless defined(&SOUND_MIXER_PHONEIN);
    eval 'sub SOUND_MIXER_PHONEOUT () {21;}' unless defined(&SOUND_MIXER_PHONEOUT);
    eval 'sub SOUND_MIXER_VIDEO () {22;}' unless defined(&SOUND_MIXER_VIDEO);
    eval 'sub SOUND_MIXER_RADIO () {23;}' unless defined(&SOUND_MIXER_RADIO);
    eval 'sub SOUND_MIXER_MONITOR () {24;}' unless defined(&SOUND_MIXER_MONITOR);
    eval 'sub SOUND_ONOFF_MIN () {28;}' unless defined(&SOUND_ONOFF_MIN);
    eval 'sub SOUND_ONOFF_MAX () {30;}' unless defined(&SOUND_ONOFF_MAX);
    eval 'sub SOUND_MIXER_MUTE () {28;}' unless defined(&SOUND_MIXER_MUTE);
    eval 'sub SOUND_MIXER_ENHANCE () {29;}' unless defined(&SOUND_MIXER_ENHANCE);
    eval 'sub SOUND_MIXER_LOUD () {30;}' unless defined(&SOUND_MIXER_LOUD);
    eval 'sub SOUND_MIXER_NONE () {31;}' unless defined(&SOUND_MIXER_NONE);
    eval 'sub SOUND_DEVICE_LABELS () {{ "Vol  ", "Bass ", "Trebl", "Synth", "Pcm  ", "Spkr ", "Line ", "Mic  ", "CD   ", "Mix  ", "Pcm2 ", "Rec  ", "IGain", "OGain", "Line1", "Line2", "Line3", "Digital1", "Digital2", "Digital3", "PhoneIn", "PhoneOut", "Video", "Radio", "Monitor"};}' unless defined(&SOUND_DEVICE_LABELS);
    eval 'sub SOUND_DEVICE_NAMES () {{ "vol", "bass", "treble", "synth", "pcm", "speaker", "line", "mic", "cd", "mix", "pcm2", "rec", "igain", "ogain", "line1", "line2", "line3", "dig1", "dig2", "dig3", "phin", "phout", "video", "radio", "monitor"};}' unless defined(&SOUND_DEVICE_NAMES);
    eval 'sub SOUND_MIXER_RECSRC () {0xff;}' unless defined(&SOUND_MIXER_RECSRC);
    eval 'sub SOUND_MIXER_DEVMASK () {0xfe;}' unless defined(&SOUND_MIXER_DEVMASK);
    eval 'sub SOUND_MIXER_RECMASK () {0xfd;}' unless defined(&SOUND_MIXER_RECMASK);
    eval 'sub SOUND_MIXER_CAPS () {0xfc;}' unless defined(&SOUND_MIXER_CAPS);
    eval 'sub SOUND_CAP_EXCL_INPUT () {0x1;}' unless defined(&SOUND_CAP_EXCL_INPUT);
    eval 'sub SOUND_MIXER_STEREODEVS () {0xfb;}' unless defined(&SOUND_MIXER_STEREODEVS);
    eval 'sub SOUND_MASK_VOLUME () {(1<<  &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MASK_VOLUME);
    eval 'sub SOUND_MASK_BASS () {(1<<  &SOUND_MIXER_BASS);}' unless defined(&SOUND_MASK_BASS);
    eval 'sub SOUND_MASK_TREBLE () {(1<<  &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MASK_TREBLE);
    eval 'sub SOUND_MASK_SYNTH () {(1<<  &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MASK_SYNTH);
    eval 'sub SOUND_MASK_PCM () {(1<<  &SOUND_MIXER_PCM);}' unless defined(&SOUND_MASK_PCM);
    eval 'sub SOUND_MASK_SPEAKER () {(1<<  &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MASK_SPEAKER);
    eval 'sub SOUND_MASK_LINE () {(1<<  &SOUND_MIXER_LINE);}' unless defined(&SOUND_MASK_LINE);
    eval 'sub SOUND_MASK_MIC () {(1<<  &SOUND_MIXER_MIC);}' unless defined(&SOUND_MASK_MIC);
    eval 'sub SOUND_MASK_CD () {(1<<  &SOUND_MIXER_CD);}' unless defined(&SOUND_MASK_CD);
    eval 'sub SOUND_MASK_IMIX () {(1<<  &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MASK_IMIX);
    eval 'sub SOUND_MASK_ALTPCM () {(1<<  &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MASK_ALTPCM);
    eval 'sub SOUND_MASK_RECLEV () {(1<<  &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MASK_RECLEV);
    eval 'sub SOUND_MASK_IGAIN () {(1<<  &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MASK_IGAIN);
    eval 'sub SOUND_MASK_OGAIN () {(1<<  &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MASK_OGAIN);
    eval 'sub SOUND_MASK_LINE1 () {(1<<  &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MASK_LINE1);
    eval 'sub SOUND_MASK_LINE2 () {(1<<  &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MASK_LINE2);
    eval 'sub SOUND_MASK_LINE3 () {(1<<  &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MASK_LINE3);
    eval 'sub SOUND_MASK_DIGITAL1 () {(1<<  &SOUND_MIXER_DIGITAL1);}' unless defined(&SOUND_MASK_DIGITAL1);
    eval 'sub SOUND_MASK_DIGITAL2 () {(1<<  &SOUND_MIXER_DIGITAL2);}' unless defined(&SOUND_MASK_DIGITAL2);
    eval 'sub SOUND_MASK_DIGITAL3 () {(1<<  &SOUND_MIXER_DIGITAL3);}' unless defined(&SOUND_MASK_DIGITAL3);
    eval 'sub SOUND_MASK_PHONEIN () {(1<<  &SOUND_MIXER_PHONEIN);}' unless defined(&SOUND_MASK_PHONEIN);
    eval 'sub SOUND_MASK_PHONEOUT () {(1<<  &SOUND_MIXER_PHONEOUT);}' unless defined(&SOUND_MASK_PHONEOUT);
    eval 'sub SOUND_MASK_RADIO () {(1<<  &SOUND_MIXER_RADIO);}' unless defined(&SOUND_MASK_RADIO);
    eval 'sub SOUND_MASK_VIDEO () {(1<<  &SOUND_MIXER_VIDEO);}' unless defined(&SOUND_MASK_VIDEO);
    eval 'sub SOUND_MASK_MONITOR () {(1<<  &SOUND_MIXER_MONITOR);}' unless defined(&SOUND_MASK_MONITOR);
    eval 'sub SOUND_MASK_MUTE () {(1<<  &SOUND_MIXER_MUTE);}' unless defined(&SOUND_MASK_MUTE);
    eval 'sub SOUND_MASK_ENHANCE () {(1<<  &SOUND_MIXER_ENHANCE);}' unless defined(&SOUND_MASK_ENHANCE);
    eval 'sub SOUND_MASK_LOUD () {(1<<  &SOUND_MIXER_LOUD);}' unless defined(&SOUND_MASK_LOUD);
    eval 'sub MIXER_READ {
        my($dev) = @_;
	    eval q( &_IOR(ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_READ);
    eval 'sub SOUND_MIXER_READ_VOLUME () { &MIXER_READ( &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MIXER_READ_VOLUME);
    eval 'sub SOUND_MIXER_READ_BASS () { &MIXER_READ( &SOUND_MIXER_BASS);}' unless defined(&SOUND_MIXER_READ_BASS);
    eval 'sub SOUND_MIXER_READ_TREBLE () { &MIXER_READ( &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MIXER_READ_TREBLE);
    eval 'sub SOUND_MIXER_READ_SYNTH () { &MIXER_READ( &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MIXER_READ_SYNTH);
    eval 'sub SOUND_MIXER_READ_PCM () { &MIXER_READ( &SOUND_MIXER_PCM);}' unless defined(&SOUND_MIXER_READ_PCM);
    eval 'sub SOUND_MIXER_READ_SPEAKER () { &MIXER_READ( &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MIXER_READ_SPEAKER);
    eval 'sub SOUND_MIXER_READ_LINE () { &MIXER_READ( &SOUND_MIXER_LINE);}' unless defined(&SOUND_MIXER_READ_LINE);
    eval 'sub SOUND_MIXER_READ_MIC () { &MIXER_READ( &SOUND_MIXER_MIC);}' unless defined(&SOUND_MIXER_READ_MIC);
    eval 'sub SOUND_MIXER_READ_CD () { &MIXER_READ( &SOUND_MIXER_CD);}' unless defined(&SOUND_MIXER_READ_CD);
    eval 'sub SOUND_MIXER_READ_IMIX () { &MIXER_READ( &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MIXER_READ_IMIX);
    eval 'sub SOUND_MIXER_READ_ALTPCM () { &MIXER_READ( &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MIXER_READ_ALTPCM);
    eval 'sub SOUND_MIXER_READ_RECLEV () { &MIXER_READ( &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MIXER_READ_RECLEV);
    eval 'sub SOUND_MIXER_READ_IGAIN () { &MIXER_READ( &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MIXER_READ_IGAIN);
    eval 'sub SOUND_MIXER_READ_OGAIN () { &MIXER_READ( &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MIXER_READ_OGAIN);
    eval 'sub SOUND_MIXER_READ_LINE1 () { &MIXER_READ( &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MIXER_READ_LINE1);
    eval 'sub SOUND_MIXER_READ_LINE2 () { &MIXER_READ( &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MIXER_READ_LINE2);
    eval 'sub SOUND_MIXER_READ_LINE3 () { &MIXER_READ( &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MIXER_READ_LINE3);
    eval 'sub SOUND_MIXER_READ_DIGITAL1 () { &MIXER_READ( &SOUND_MIXER_DIGITAL1);}' unless defined(&SOUND_MIXER_READ_DIGITAL1);
    eval 'sub SOUND_MIXER_READ_DIGITAL2 () { &MIXER_READ( &SOUND_MIXER_DIGITAL2);}' unless defined(&SOUND_MIXER_READ_DIGITAL2);
    eval 'sub SOUND_MIXER_READ_DIGITAL3 () { &MIXER_READ( &SOUND_MIXER_DIGITAL3);}' unless defined(&SOUND_MIXER_READ_DIGITAL3);
    eval 'sub SOUND_MIXER_READ_PHONEIN () { &MIXER_READ( &SOUND_MIXER_PHONEIN);}' unless defined(&SOUND_MIXER_READ_PHONEIN);
    eval 'sub SOUND_MIXER_READ_PHONEOUT () { &MIXER_READ( &SOUND_MIXER_PHONEOUT);}' unless defined(&SOUND_MIXER_READ_PHONEOUT);
    eval 'sub SOUND_MIXER_READ_RADIO () { &MIXER_READ( &SOUND_MIXER_RADIO);}' unless defined(&SOUND_MIXER_READ_RADIO);
    eval 'sub SOUND_MIXER_READ_VIDEO () { &MIXER_READ( &SOUND_MIXER_VIDEO);}' unless defined(&SOUND_MIXER_READ_VIDEO);
    eval 'sub SOUND_MIXER_READ_MONITOR () { &MIXER_READ( &SOUND_MIXER_MONITOR);}' unless defined(&SOUND_MIXER_READ_MONITOR);
    eval 'sub SOUND_MIXER_READ_MUTE () { &MIXER_READ( &SOUND_MIXER_MUTE);}' unless defined(&SOUND_MIXER_READ_MUTE);
    eval 'sub SOUND_MIXER_READ_ENHANCE () { &MIXER_READ( &SOUND_MIXER_ENHANCE);}' unless defined(&SOUND_MIXER_READ_ENHANCE);
    eval 'sub SOUND_MIXER_READ_LOUD () { &MIXER_READ( &SOUND_MIXER_LOUD);}' unless defined(&SOUND_MIXER_READ_LOUD);
    eval 'sub SOUND_MIXER_READ_RECSRC () { &MIXER_READ( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_READ_RECSRC);
    eval 'sub SOUND_MIXER_READ_DEVMASK () { &MIXER_READ( &SOUND_MIXER_DEVMASK);}' unless defined(&SOUND_MIXER_READ_DEVMASK);
    eval 'sub SOUND_MIXER_READ_RECMASK () { &MIXER_READ( &SOUND_MIXER_RECMASK);}' unless defined(&SOUND_MIXER_READ_RECMASK);
    eval 'sub SOUND_MIXER_READ_STEREODEVS () { &MIXER_READ( &SOUND_MIXER_STEREODEVS);}' unless defined(&SOUND_MIXER_READ_STEREODEVS);
    eval 'sub SOUND_MIXER_READ_CAPS () { &MIXER_READ( &SOUND_MIXER_CAPS);}' unless defined(&SOUND_MIXER_READ_CAPS);
    eval 'sub MIXER_WRITE {
        my($dev) = @_;
	    eval q( &_IOWR(ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_WRITE);
    eval 'sub SOUND_MIXER_WRITE_VOLUME () { &MIXER_WRITE( &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MIXER_WRITE_VOLUME);
    eval 'sub SOUND_MIXER_WRITE_BASS () { &MIXER_WRITE( &SOUND_MIXER_BASS);}' unless defined(&SOUND_MIXER_WRITE_BASS);
    eval 'sub SOUND_MIXER_WRITE_TREBLE () { &MIXER_WRITE( &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MIXER_WRITE_TREBLE);
    eval 'sub SOUND_MIXER_WRITE_SYNTH () { &MIXER_WRITE( &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MIXER_WRITE_SYNTH);
    eval 'sub SOUND_MIXER_WRITE_PCM () { &MIXER_WRITE( &SOUND_MIXER_PCM);}' unless defined(&SOUND_MIXER_WRITE_PCM);
    eval 'sub SOUND_MIXER_WRITE_SPEAKER () { &MIXER_WRITE( &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MIXER_WRITE_SPEAKER);
    eval 'sub SOUND_MIXER_WRITE_LINE () { &MIXER_WRITE( &SOUND_MIXER_LINE);}' unless defined(&SOUND_MIXER_WRITE_LINE);
    eval 'sub SOUND_MIXER_WRITE_MIC () { &MIXER_WRITE( &SOUND_MIXER_MIC);}' unless defined(&SOUND_MIXER_WRITE_MIC);
    eval 'sub SOUND_MIXER_WRITE_CD () { &MIXER_WRITE( &SOUND_MIXER_CD);}' unless defined(&SOUND_MIXER_WRITE_CD);
    eval 'sub SOUND_MIXER_WRITE_IMIX () { &MIXER_WRITE( &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MIXER_WRITE_IMIX);
    eval 'sub SOUND_MIXER_WRITE_ALTPCM () { &MIXER_WRITE( &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MIXER_WRITE_ALTPCM);
    eval 'sub SOUND_MIXER_WRITE_RECLEV () { &MIXER_WRITE( &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MIXER_WRITE_RECLEV);
    eval 'sub SOUND_MIXER_WRITE_IGAIN () { &MIXER_WRITE( &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MIXER_WRITE_IGAIN);
    eval 'sub SOUND_MIXER_WRITE_OGAIN () { &MIXER_WRITE( &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MIXER_WRITE_OGAIN);
    eval 'sub SOUND_MIXER_WRITE_LINE1 () { &MIXER_WRITE( &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MIXER_WRITE_LINE1);
    eval 'sub SOUND_MIXER_WRITE_LINE2 () { &MIXER_WRITE( &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MIXER_WRITE_LINE2);
    eval 'sub SOUND_MIXER_WRITE_LINE3 () { &MIXER_WRITE( &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MIXER_WRITE_LINE3);
    eval 'sub SOUND_MIXER_WRITE_DIGITAL1 () { &MIXER_WRITE( &SOUND_MIXER_DIGITAL1);}' unless defined(&SOUND_MIXER_WRITE_DIGITAL1);
    eval 'sub SOUND_MIXER_WRITE_DIGITAL2 () { &MIXER_WRITE( &SOUND_MIXER_DIGITAL2);}' unless defined(&SOUND_MIXER_WRITE_DIGITAL2);
    eval 'sub SOUND_MIXER_WRITE_DIGITAL3 () { &MIXER_WRITE( &SOUND_MIXER_DIGITAL3);}' unless defined(&SOUND_MIXER_WRITE_DIGITAL3);
    eval 'sub SOUND_MIXER_WRITE_PHONEIN () { &MIXER_WRITE( &SOUND_MIXER_PHONEIN);}' unless defined(&SOUND_MIXER_WRITE_PHONEIN);
    eval 'sub SOUND_MIXER_WRITE_PHONEOUT () { &MIXER_WRITE( &SOUND_MIXER_PHONEOUT);}' unless defined(&SOUND_MIXER_WRITE_PHONEOUT);
    eval 'sub SOUND_MIXER_WRITE_RADIO () { &MIXER_WRITE( &SOUND_MIXER_RADIO);}' unless defined(&SOUND_MIXER_WRITE_RADIO);
    eval 'sub SOUND_MIXER_WRITE_VIDEO () { &MIXER_WRITE( &SOUND_MIXER_VIDEO);}' unless defined(&SOUND_MIXER_WRITE_VIDEO);
    eval 'sub SOUND_MIXER_WRITE_MONITOR () { &MIXER_WRITE( &SOUND_MIXER_MONITOR);}' unless defined(&SOUND_MIXER_WRITE_MONITOR);
    eval 'sub SOUND_MIXER_WRITE_MUTE () { &MIXER_WRITE( &SOUND_MIXER_MUTE);}' unless defined(&SOUND_MIXER_WRITE_MUTE);
    eval 'sub SOUND_MIXER_WRITE_ENHANCE () { &MIXER_WRITE( &SOUND_MIXER_ENHANCE);}' unless defined(&SOUND_MIXER_WRITE_ENHANCE);
    eval 'sub SOUND_MIXER_WRITE_LOUD () { &MIXER_WRITE( &SOUND_MIXER_LOUD);}' unless defined(&SOUND_MIXER_WRITE_LOUD);
    eval 'sub SOUND_MIXER_WRITE_RECSRC () { &MIXER_WRITE( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_WRITE_RECSRC);
    eval 'sub SOUND_MIXER_INFO () { &_IOR(ord(\'M\'), 101,  &mixer_info);}' unless defined(&SOUND_MIXER_INFO);
    eval 'sub LEFT_CHN () {0;}' unless defined(&LEFT_CHN);
    eval 'sub RIGHT_CHN () {1;}' unless defined(&RIGHT_CHN);
    eval 'sub EV_SEQ_LOCAL () {0x80;}' unless defined(&EV_SEQ_LOCAL);
    eval 'sub EV_TIMING () {0x81;}' unless defined(&EV_TIMING);
    eval 'sub EV_CHN_COMMON () {0x92;}' unless defined(&EV_CHN_COMMON);
    eval 'sub EV_CHN_VOICE () {0x93;}' unless defined(&EV_CHN_VOICE);
    eval 'sub EV_SYSEX () {0x94;}' unless defined(&EV_SYSEX);
    eval 'sub MIDI_NOTEOFF () {0x80;}' unless defined(&MIDI_NOTEOFF);
    eval 'sub MIDI_NOTEON () {0x90;}' unless defined(&MIDI_NOTEON);
    eval 'sub MIDI_KEY_PRESSURE () {0xa0;}' unless defined(&MIDI_KEY_PRESSURE);
    eval 'sub MIDI_CTL_CHANGE () {0xb0;}' unless defined(&MIDI_CTL_CHANGE);
    eval 'sub MIDI_PGM_CHANGE () {0xc0;}' unless defined(&MIDI_PGM_CHANGE);
    eval 'sub MIDI_CHN_PRESSURE () {0xd0;}' unless defined(&MIDI_CHN_PRESSURE);
    eval 'sub MIDI_PITCH_BEND () {0xe0;}' unless defined(&MIDI_PITCH_BEND);
    eval 'sub MIDI_SYSTEM_PREFIX () {0xf0;}' unless defined(&MIDI_SYSTEM_PREFIX);
    eval 'sub TMR_WAIT_REL () {1;}' unless defined(&TMR_WAIT_REL);
    eval 'sub TMR_WAIT_ABS () {2;}' unless defined(&TMR_WAIT_ABS);
    eval 'sub TMR_STOP () {3;}' unless defined(&TMR_STOP);
    eval 'sub TMR_START () {4;}' unless defined(&TMR_START);
    eval 'sub TMR_CONTINUE () {5;}' unless defined(&TMR_CONTINUE);
    eval 'sub TMR_TEMPO () {6;}' unless defined(&TMR_TEMPO);
    eval 'sub TMR_ECHO () {8;}' unless defined(&TMR_ECHO);
    eval 'sub TMR_CLOCK () {9;}' unless defined(&TMR_CLOCK);
    eval 'sub TMR_SPP () {10;}' unless defined(&TMR_SPP);
    eval 'sub TMR_TIMESIG () {11;}' unless defined(&TMR_TIMESIG);
    eval 'sub LOCL_STARTAUDIO () {1;}' unless defined(&LOCL_STARTAUDIO);
    if(!defined(&_KERNEL) || defined(&USE_SEQ_MACROS)) {
	unless(defined(&USE_SIMPLE_MACROS)) {
	    eval 'sub SEQ_DEFINEBUF {
	        my($len) = @_;
    		eval q(\'u_char\'  $_seqbuf[$len]; \'int\'  &_seqbuflen = $len;\'int\'  &_seqbufptr = 0);
	    }' unless defined(&SEQ_DEFINEBUF);
	    eval 'sub SEQ_USE_EXTBUF () {
	        eval q( &extern \'u_char\'  $_seqbuf[];  &extern \'int\'  &_seqbuflen; &extern \'int\'  &_seqbufptr);
	    }' unless defined(&SEQ_USE_EXTBUF);
	    eval 'sub SEQ_DECLAREBUF () {
	        eval q( &SEQ_USE_EXTBUF());
	    }' unless defined(&SEQ_DECLAREBUF);
	    eval 'sub SEQ_PM_DEFINES () {\'struct patmgr_info\'  &_pm_info;}' unless defined(&SEQ_PM_DEFINES);
	    eval 'sub _SEQ_NEEDBUF {
	        my($len) = @_;
    		eval q( &if (( &_seqbufptr+($len)) >  &_seqbuflen)  &seqbuf_dump());
	    }' unless defined(&_SEQ_NEEDBUF);
	    eval 'sub _SEQ_ADVBUF {
	        my($len) = @_;
    		eval q( &_seqbufptr += $len);
	    }' unless defined(&_SEQ_ADVBUF);
	    eval 'sub SEQ_DUMPBUF () { &seqbuf_dump;}' unless defined(&SEQ_DUMPBUF);
	} else {
	    eval 'sub _SEQ_NEEDBUF {
	        my($len) = @_;
    		eval q();
	    }' unless defined(&_SEQ_NEEDBUF);
	}
	eval 'sub PM_LOAD_PATCH {
	    my($dev, $bank, $pgm) = @_;
    	    eval q(( &SEQ_DUMPBUF(),  ($_pm_info->{command}) =  &_PM_LOAD_PATCH,  ($_pm_info->{device})=$dev,  ($_pm_info->{data}->{data8[0]})=$pgm,  ($_pm_info->{parm1}) = $bank,  ($_pm_info->{parm2}) = 1,  &ioctl( &seqfd,  &SNDCTL_PMGR_ACCESS, & &_pm_info)));
	}' unless defined(&PM_LOAD_PATCH);
	eval 'sub PM_LOAD_PATCHES {
	    my($dev, $bank, $pgm) = @_;
    	    eval q(( &SEQ_DUMPBUF(),  ($_pm_info->{command}) =  &_PM_LOAD_PATCH,  ($_pm_info->{device})=$dev,  &bcopy( $pgm,  ($_pm_info->{data}->{data8}), 128),  ($_pm_info->{parm1}) = $bank,  ($_pm_info->{parm2}) = 128,  &ioctl( &seqfd,  &SNDCTL_PMGR_ACCESS, & &_pm_info)));
	}' unless defined(&PM_LOAD_PATCHES);
	eval 'sub SEQ_VOLUME_MODE {
	    my($dev, $mode) = @_;
    	    eval q({  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &SEQ_EXTENDED;  $_seqbuf[ &_seqbufptr+1] =  &SEQ_VOLMODE;  $_seqbuf[ &_seqbufptr+2] = ($dev);  $_seqbuf[ &_seqbufptr+3] = ($mode);  $_seqbuf[ &_seqbufptr+4] = 0;  $_seqbuf[ &_seqbufptr+5] = 0;  $_seqbuf[ &_seqbufptr+6] = 0;  $_seqbuf[ &_seqbufptr+7] = 0;  &_SEQ_ADVBUF(8);});
	}' unless defined(&SEQ_VOLUME_MODE);
	eval 'sub _CHN_VOICE {
	    my($dev, $event, $chn, $note, $parm) = @_;
    	    eval q({  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &EV_CHN_VOICE;  $_seqbuf[ &_seqbufptr+1] = ($dev);  $_seqbuf[ &_seqbufptr+2] = ($event);  $_seqbuf[ &_seqbufptr+3] = ($chn);  $_seqbuf[ &_seqbufptr+4] = ($note);  $_seqbuf[ &_seqbufptr+5] = ($parm);  $_seqbuf[ &_seqbufptr+6] = (0);  $_seqbuf[ &_seqbufptr+7] = 0;  &_SEQ_ADVBUF(8);});
	}' unless defined(&_CHN_VOICE);
	eval 'sub SEQ_START_NOTE {
	    my($dev, $chn, $note, $vol) = @_;
    	    eval q( &_CHN_VOICE($dev,  &MIDI_NOTEON, $chn, $note, $vol));
	}' unless defined(&SEQ_START_NOTE);
	eval 'sub SEQ_STOP_NOTE {
	    my($dev, $chn, $note, $vol) = @_;
    	    eval q( &_CHN_VOICE($dev,  &MIDI_NOTEOFF, $chn, $note, $vol));
	}' unless defined(&SEQ_STOP_NOTE);
	eval 'sub SEQ_KEY_PRESSURE {
	    my($dev, $chn, $note, $pressure) = @_;
    	    eval q( &_CHN_VOICE($dev,  &MIDI_KEY_PRESSURE, $chn, $note, $pressure));
	}' unless defined(&SEQ_KEY_PRESSURE);
	eval 'sub _CHN_COMMON {
	    my($dev, $event, $chn, $p1, $p2, $w14) = @_;
    	    eval q({  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &EV_CHN_COMMON;  $_seqbuf[ &_seqbufptr+1] = ($dev);  $_seqbuf[ &_seqbufptr+2] = ($event);  $_seqbuf[ &_seqbufptr+3] = ($chn);  $_seqbuf[ &_seqbufptr+4] = ($p1);  $_seqbuf[ &_seqbufptr+5] = ($p2); *& $_seqbuf[ &_seqbufptr+6] = ($w14);  &_SEQ_ADVBUF(8);});
	}' unless defined(&_CHN_COMMON);
	eval 'sub SEQ_SYSEX {
	    my($dev, $buf, $len) = @_;
    	    eval q({ \'int\'  &i,  &l=($len);  &if ( &l>6) &l=6;  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &EV_SYSEX;  &for( &i=0; &i< &l; &i++) $_seqbuf[ &_seqbufptr+ &i+1] = ($buf)[ &i];  &for( &i= &l; &i<6; &i++) $_seqbuf[ &_seqbufptr+ &i+1] = 0xff;  &_SEQ_ADVBUF(8);});
	}' unless defined(&SEQ_SYSEX);
	eval 'sub SEQ_CHN_PRESSURE {
	    my($dev, $chn, $pressure) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_CHN_PRESSURE, $chn, $pressure, 0, 0));
	}' unless defined(&SEQ_CHN_PRESSURE);
	eval 'sub SEQ_SET_PATCH {
	    my($dev, $chn, $patch) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_PGM_CHANGE, $chn, $patch, 0, 0));
	}' unless defined(&SEQ_SET_PATCH);
	eval 'sub SEQ_CONTROL {
	    my($dev, $chn, $controller, $value) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_CTL_CHANGE, $chn, $controller, 0, $value));
	}' unless defined(&SEQ_CONTROL);
	eval 'sub SEQ_BENDER {
	    my($dev, $chn, $value) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_PITCH_BEND, $chn, 0, 0, $value));
	}' unless defined(&SEQ_BENDER);
	eval 'sub SEQ_V2_X_CONTROL {
	    my($dev, $voice, $controller, $value) = @_;
    	    eval q({  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &SEQ_EXTENDED;  $_seqbuf[ &_seqbufptr+1] =  &SEQ_CONTROLLER;  $_seqbuf[ &_seqbufptr+2] = ($dev);  $_seqbuf[ &_seqbufptr+3] = ($voice);  $_seqbuf[ &_seqbufptr+4] = ($controller); *& $_seqbuf[ &_seqbufptr+5] = ($value);  $_seqbuf[ &_seqbufptr+7] = 0;  &_SEQ_ADVBUF(8);});
	}' unless defined(&SEQ_V2_X_CONTROL);
	eval 'sub SEQ_PITCHBEND {
	    my($dev, $voice, $value) = @_;
    	    eval q( &SEQ_V2_X_CONTROL($dev, $voice,  &CTRL_PITCH_BENDER, $value));
	}' unless defined(&SEQ_PITCHBEND);
	eval 'sub SEQ_BENDER_RANGE {
	    my($dev, $voice, $value) = @_;
    	    eval q( &SEQ_V2_X_CONTROL($dev, $voice,  &CTRL_PITCH_BENDER_RANGE, $value));
	}' unless defined(&SEQ_BENDER_RANGE);
	eval 'sub SEQ_EXPRESSION {
	    my($dev, $voice, $value) = @_;
    	    eval q( &SEQ_CONTROL($dev, $voice,  &CTL_EXPRESSION, $value*128));
	}' unless defined(&SEQ_EXPRESSION);
	eval 'sub SEQ_MAIN_VOLUME {
	    my($dev, $voice, $value) = @_;
    	    eval q( &SEQ_CONTROL($dev, $voice,  &CTL_MAIN_VOLUME, ($value*16383)/100));
	}' unless defined(&SEQ_MAIN_VOLUME);
	eval 'sub SEQ_PANNING {
	    my($dev, $voice, $pos) = @_;
    	    eval q( &SEQ_CONTROL($dev, $voice,  &CTL_PAN, ($pos+128) / 2));
	}' unless defined(&SEQ_PANNING);
	eval 'sub _TIMER_EVENT {
	    my($ev, $parm) = @_;
    	    eval q({  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr+0] =  &EV_TIMING;  $_seqbuf[ &_seqbufptr+1] = ($ev);  $_seqbuf[ &_seqbufptr+2] = 0;  $_seqbuf[ &_seqbufptr+3] = 0; *& $_seqbuf[ &_seqbufptr+4] = ($parm);  &_SEQ_ADVBUF(8); });
	}' unless defined(&_TIMER_EVENT);
	eval 'sub SEQ_START_TIMER () {
	    eval q( &_TIMER_EVENT( &TMR_START, 0));
	}' unless defined(&SEQ_START_TIMER);
	eval 'sub SEQ_STOP_TIMER () {
	    eval q( &_TIMER_EVENT( &TMR_STOP, 0));
	}' unless defined(&SEQ_STOP_TIMER);
	eval 'sub SEQ_CONTINUE_TIMER () {
	    eval q( &_TIMER_EVENT( &TMR_CONTINUE, 0));
	}' unless defined(&SEQ_CONTINUE_TIMER);
	eval 'sub SEQ_WAIT_TIME {
	    my($ticks) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_WAIT_ABS, $ticks));
	}' unless defined(&SEQ_WAIT_TIME);
	eval 'sub SEQ_DELTA_TIME {
	    my($ticks) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_WAIT_REL, $ticks));
	}' unless defined(&SEQ_DELTA_TIME);
	eval 'sub SEQ_ECHO_BACK {
	    my($key) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_ECHO, $key));
	}' unless defined(&SEQ_ECHO_BACK);
	eval 'sub SEQ_SET_TEMPO {
	    my($value) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_TEMPO, $value));
	}' unless defined(&SEQ_SET_TEMPO);
	eval 'sub SEQ_SONGPOS {
	    my($pos) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_SPP, $pos));
	}' unless defined(&SEQ_SONGPOS);
	eval 'sub SEQ_TIME_SIGNATURE {
	    my($sig) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_TIMESIG, $sig));
	}' unless defined(&SEQ_TIME_SIGNATURE);
	eval 'sub _LOCAL_EVENT {
	    my($ev, $parm) = @_;
    	    eval q({  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr+0] =  &EV_SEQ_LOCAL;  $_seqbuf[ &_seqbufptr+1] = ($ev);  $_seqbuf[ &_seqbufptr+2] = 0;  $_seqbuf[ &_seqbufptr+3] = 0; *& $_seqbuf[ &_seqbufptr+4] = ($parm);  &_SEQ_ADVBUF(8); });
	}' unless defined(&_LOCAL_EVENT);
	eval 'sub SEQ_PLAYAUDIO {
	    my($devmask) = @_;
    	    eval q( &_LOCAL_EVENT( &LOCL_STARTAUDIO, $devmask));
	}' unless defined(&SEQ_PLAYAUDIO);
	eval 'sub SEQ_MIDIOUT {
	    my($device, $byte) = @_;
    	    eval q({  &_SEQ_NEEDBUF(4);  $_seqbuf[ &_seqbufptr] =  &SEQ_MIDIPUTC;  $_seqbuf[ &_seqbufptr+1] = ($byte);  $_seqbuf[ &_seqbufptr+2] = ($device);  $_seqbuf[ &_seqbufptr+3] = 0;  &_SEQ_ADVBUF(4);});
	}' unless defined(&SEQ_MIDIOUT);
	eval 'sub SEQ_WRPATCH {
	    my($patchx, $len) = @_;
    	    eval q({  &if ( &_seqbufptr)  &seqbuf_dump();  &if ( &write( &seqfd, ($patchx), $len)==-1)  &perror(\\"Write patch: /dev/sequencer\\"); });
	}' unless defined(&SEQ_WRPATCH);
	eval 'sub SEQ_WRPATCH2 {
	    my($patchx, $len) = @_;
    	    eval q((  &seqbuf_dump(),  &write( &seqfd, ($patchx), $len) ));
	}' unless defined(&SEQ_WRPATCH2);
    }
    eval 'sub SNDCTL_DSP_SAMPLESIZE () { &SNDCTL_DSP_SETFMT;}' unless defined(&SNDCTL_DSP_SAMPLESIZE);
    eval 'sub SOUND_PCM_WRITE_BITS () { &SNDCTL_DSP_SETFMT;}' unless defined(&SOUND_PCM_WRITE_BITS);
    eval 'sub SOUND_PCM_SETFMT () { &SNDCTL_DSP_SETFMT;}' unless defined(&SOUND_PCM_SETFMT);
    eval 'sub SOUND_PCM_WRITE_RATE () { &SNDCTL_DSP_SPEED;}' unless defined(&SOUND_PCM_WRITE_RATE);
    eval 'sub SOUND_PCM_POST () { &SNDCTL_DSP_POST;}' unless defined(&SOUND_PCM_POST);
    eval 'sub SOUND_PCM_RESET () { &SNDCTL_DSP_RESET;}' unless defined(&SOUND_PCM_RESET);
    eval 'sub SOUND_PCM_SYNC () { &SNDCTL_DSP_SYNC;}' unless defined(&SOUND_PCM_SYNC);
    eval 'sub SOUND_PCM_SUBDIVIDE () { &SNDCTL_DSP_SUBDIVIDE;}' unless defined(&SOUND_PCM_SUBDIVIDE);
    eval 'sub SOUND_PCM_SETFRAGMENT () { &SNDCTL_DSP_SETFRAGMENT;}' unless defined(&SOUND_PCM_SETFRAGMENT);
    eval 'sub SOUND_PCM_GETFMTS () { &SNDCTL_DSP_GETFMTS;}' unless defined(&SOUND_PCM_GETFMTS);
    eval 'sub SOUND_PCM_GETOSPACE () { &SNDCTL_DSP_GETOSPACE;}' unless defined(&SOUND_PCM_GETOSPACE);
    eval 'sub SOUND_PCM_GETISPACE () { &SNDCTL_DSP_GETISPACE;}' unless defined(&SOUND_PCM_GETISPACE);
    eval 'sub SOUND_PCM_NONBLOCK () { &SNDCTL_DSP_NONBLOCK;}' unless defined(&SOUND_PCM_NONBLOCK);
    eval 'sub SOUND_PCM_GETCAPS () { &SNDCTL_DSP_GETCAPS;}' unless defined(&SOUND_PCM_GETCAPS);
    eval 'sub SOUND_PCM_GETTRIGGER () { &SNDCTL_DSP_GETTRIGGER;}' unless defined(&SOUND_PCM_GETTRIGGER);
    eval 'sub SOUND_PCM_SETTRIGGER () { &SNDCTL_DSP_SETTRIGGER;}' unless defined(&SOUND_PCM_SETTRIGGER);
    eval 'sub SOUND_PCM_SETSYNCRO () { &SNDCTL_DSP_SETSYNCRO;}' unless defined(&SOUND_PCM_SETSYNCRO);
    eval 'sub SOUND_PCM_GETIPTR () { &SNDCTL_DSP_GETIPTR;}' unless defined(&SOUND_PCM_GETIPTR);
    eval 'sub SOUND_PCM_GETOPTR () { &SNDCTL_DSP_GETOPTR;}' unless defined(&SOUND_PCM_GETOPTR);
    eval 'sub SOUND_PCM_MAPINBUF () { &SNDCTL_DSP_MAPINBUF;}' unless defined(&SOUND_PCM_MAPINBUF);
    eval 'sub SOUND_PCM_MAPOUTBUF () { &SNDCTL_DSP_MAPOUTBUF;}' unless defined(&SOUND_PCM_MAPOUTBUF);
    if(0) {
	eval 'sub OSSV4_EXPERIMENT () {1;}' unless defined(&OSSV4_EXPERIMENT);
    } else {
	undef(&OSSV4_EXPERIMENT) if defined(&OSSV4_EXPERIMENT);
    }
    if(defined(&SOUND_VERSION)) {
	undef(&SOUND_VERSION) if defined(&SOUND_VERSION);
	eval 'sub SOUND_VERSION () {0x40000;}' unless defined(&SOUND_VERSION);
    }
    eval 'sub OSS_LONGNAME_SIZE () {64;}' unless defined(&OSS_LONGNAME_SIZE);
    eval 'sub OSS_LABEL_SIZE () {16;}' unless defined(&OSS_LABEL_SIZE);
    eval 'sub OSS_DEVNODE_SIZE () {32;}' unless defined(&OSS_DEVNODE_SIZE);
    eval 'sub SNDCTL_DSP_GETPLAYVOL () { &_IOR (ord(\'P\'), 24, \'int\');}' unless defined(&SNDCTL_DSP_GETPLAYVOL);
    eval 'sub SNDCTL_DSP_SETPLAYVOL () { &_IOWR(ord(\'P\'), 24, \'int\');}' unless defined(&SNDCTL_DSP_SETPLAYVOL);
    eval 'sub SNDCTL_DSP_GETERROR () { &_IOR (ord(\'P\'), 25,  &audio_errinfo);}' unless defined(&SNDCTL_DSP_GETERROR);
    eval 'sub SNDCTL_DSP_SYNCGROUP () { &_IOWR(ord(\'P\'), 28,  &oss_syncgroup);}' unless defined(&SNDCTL_DSP_SYNCGROUP);
    eval 'sub SNDCTL_DSP_SYNCSTART () { &_IOW (ord(\'P\'), 29, \'int\');}' unless defined(&SNDCTL_DSP_SYNCSTART);
    eval 'sub SNDCTL_DSP_COOKEDMODE () { &_IOW (ord(\'P\'), 30, \'int\');}' unless defined(&SNDCTL_DSP_COOKEDMODE);
    eval 'sub SNDCTL_DSP_SILENCE () { &_IO (ord(\'P\'), 31);}' unless defined(&SNDCTL_DSP_SILENCE);
    eval 'sub SNDCTL_DSP_SKIP () { &_IO (ord(\'P\'), 32);}' unless defined(&SNDCTL_DSP_SKIP);
    eval 'sub SNDCTL_DSP_HALT_INPUT () { &_IO (ord(\'P\'), 33);}' unless defined(&SNDCTL_DSP_HALT_INPUT);
    eval 'sub SNDCTL_DSP_RESET_INPUT () { &SNDCTL_DSP_HALT_INPUT;}' unless defined(&SNDCTL_DSP_RESET_INPUT);
    eval 'sub SNDCTL_DSP_HALT_OUTPUT () { &_IO (ord(\'P\'), 34);}' unless defined(&SNDCTL_DSP_HALT_OUTPUT);
    eval 'sub SNDCTL_DSP_RESET_OUTPUT () { &SNDCTL_DSP_HALT_OUTPUT;}' unless defined(&SNDCTL_DSP_RESET_OUTPUT);
    eval 'sub SNDCTL_DSP_LOW_WATER () { &_IOW (ord(\'P\'), 34, \'int\');}' unless defined(&SNDCTL_DSP_LOW_WATER);
    unless(defined(&OSS_NO_LONG_LONG)) {
	eval 'sub SNDCTL_DSP_CURRENT_IPTR () { &_IOR (ord(\'P\'), 35,  &oss_count_t);}' unless defined(&SNDCTL_DSP_CURRENT_IPTR);
	eval 'sub SNDCTL_DSP_CURRENT_OPTR () { &_IOR (ord(\'P\'), 36,  &oss_count_t);}' unless defined(&SNDCTL_DSP_CURRENT_OPTR);
    }
    eval 'sub SNDCTL_DSP_GET_RECSRC_NAMES () { &_IOR (ord(\'P\'), 37,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_DSP_GET_RECSRC_NAMES);
    eval 'sub SNDCTL_DSP_GET_RECSRC () { &_IOR (ord(\'P\'), 38, \'int\');}' unless defined(&SNDCTL_DSP_GET_RECSRC);
    eval 'sub SNDCTL_DSP_SET_RECSRC () { &_IOWR(ord(\'P\'), 38, \'int\');}' unless defined(&SNDCTL_DSP_SET_RECSRC);
    eval 'sub SNDCTL_DSP_GET_PLAYTGT_NAMES () { &_IOR (ord(\'P\'), 39,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_DSP_GET_PLAYTGT_NAMES);
    eval 'sub SNDCTL_DSP_GET_PLAYTGT () { &_IOR (ord(\'P\'), 40, \'int\');}' unless defined(&SNDCTL_DSP_GET_PLAYTGT);
    eval 'sub SNDCTL_DSP_SET_PLAYTGT () { &_IOWR(ord(\'P\'), 40, \'int\');}' unless defined(&SNDCTL_DSP_SET_PLAYTGT);
    eval 'sub SNDCTL_DSP_GETRECVOL () { &_IOR (ord(\'P\'), 41, \'int\');}' unless defined(&SNDCTL_DSP_GETRECVOL);
    eval 'sub SNDCTL_DSP_SETRECVOL () { &_IOWR(ord(\'P\'), 41, \'int\');}' unless defined(&SNDCTL_DSP_SETRECVOL);
    eval 'sub SNDCTL_DSP_GET_CHNORDER () { &_IOR (ord(\'P\'), 42, \'unsigned long long\');}' unless defined(&SNDCTL_DSP_GET_CHNORDER);
    eval 'sub SNDCTL_DSP_SET_CHNORDER () { &_IOWR(ord(\'P\'), 42, \'unsigned long long\');}' unless defined(&SNDCTL_DSP_SET_CHNORDER);
    eval 'sub CHID_UNDEF () {0;}' unless defined(&CHID_UNDEF);
    eval 'sub CHID_L () {1;}' unless defined(&CHID_L);
    eval 'sub CHID_R () {2;}' unless defined(&CHID_R);
    eval 'sub CHID_C () {3;}' unless defined(&CHID_C);
    eval 'sub CHID_LFE () {4;}' unless defined(&CHID_LFE);
    eval 'sub CHID_LS () {5;}' unless defined(&CHID_LS);
    eval 'sub CHID_RS () {6;}' unless defined(&CHID_RS);
    eval 'sub CHID_LR () {7;}' unless defined(&CHID_LR);
    eval 'sub CHID_RR () {8;}' unless defined(&CHID_RR);
    eval 'sub CHNORDER_UNDEF () {0x;}' unless defined(&CHNORDER_UNDEF);
    eval 'sub CHNORDER_NORMAL () {0x87654321;}' unless defined(&CHNORDER_NORMAL);
    eval 'sub MAX_PEAK_CHANNELS () {128;}' unless defined(&MAX_PEAK_CHANNELS);
    eval 'sub SNDCTL_DSP_GETIPEAKS () { &_IOR(ord(\'P\'), 43,  &oss_peaks_t);}' unless defined(&SNDCTL_DSP_GETIPEAKS);
    eval 'sub SNDCTL_DSP_GETOPEAKS () { &_IOR(ord(\'P\'), 44,  &oss_peaks_t);}' unless defined(&SNDCTL_DSP_GETOPEAKS);
    eval 'sub SNDCTL_DSP_POLICY () { &_IOW(ord(\'P\'), 45, \'int\');}' unless defined(&SNDCTL_DSP_POLICY);
    eval 'sub SNDCTL_DSP_GETCHANNELMASK () { &_IOWR(ord(\'P\'), 64, \'int\');}' unless defined(&SNDCTL_DSP_GETCHANNELMASK);
    eval 'sub SNDCTL_DSP_BIND_CHANNEL () { &_IOWR(ord(\'P\'), 65, \'int\');}' unless defined(&SNDCTL_DSP_BIND_CHANNEL);
    eval 'sub DSP_BIND_QUERY () {0x;}' unless defined(&DSP_BIND_QUERY);
    eval 'sub DSP_BIND_FRONT () {0x1;}' unless defined(&DSP_BIND_FRONT);
    eval 'sub DSP_BIND_SURR () {0x2;}' unless defined(&DSP_BIND_SURR);
    eval 'sub DSP_BIND_CENTER_LFE () {0x4;}' unless defined(&DSP_BIND_CENTER_LFE);
    eval 'sub DSP_BIND_HANDSET () {0x8;}' unless defined(&DSP_BIND_HANDSET);
    eval 'sub DSP_BIND_MIC () {0x10;}' unless defined(&DSP_BIND_MIC);
    eval 'sub DSP_BIND_MODEM1 () {0x20;}' unless defined(&DSP_BIND_MODEM1);
    eval 'sub DSP_BIND_MODEM2 () {0x40;}' unless defined(&DSP_BIND_MODEM2);
    eval 'sub DSP_BIND_I2S () {0x80;}' unless defined(&DSP_BIND_I2S);
    eval 'sub DSP_BIND_SPDIF () {0x100;}' unless defined(&DSP_BIND_SPDIF);
    eval 'sub DSP_BIND_REAR () {0x200;}' unless defined(&DSP_BIND_REAR);
    eval 'sub OSS_GETVERSION () { &_IOR (ord(\'M\'), 118, \'int\');}' unless defined(&OSS_GETVERSION);
    eval 'sub MIXT_DEVROOT () {0;}' unless defined(&MIXT_DEVROOT);
    eval 'sub MIXT_GROUP () {1;}' unless defined(&MIXT_GROUP);
    eval 'sub MIXT_ONOFF () {2;}' unless defined(&MIXT_ONOFF);
    eval 'sub MIXT_ENUM () {3;}' unless defined(&MIXT_ENUM);
    eval 'sub MIXT_MONOSLIDER () {4;}' unless defined(&MIXT_MONOSLIDER);
    eval 'sub MIXT_STEREOSLIDER () {5;}' unless defined(&MIXT_STEREOSLIDER);
    eval 'sub MIXT_MESSAGE () {6;}' unless defined(&MIXT_MESSAGE);
    eval 'sub MIXT_MONOVU () {7;}' unless defined(&MIXT_MONOVU);
    eval 'sub MIXT_STEREOVU () {8;}' unless defined(&MIXT_STEREOVU);
    eval 'sub MIXT_MONOPEAK () {9;}' unless defined(&MIXT_MONOPEAK);
    eval 'sub MIXT_STEREOPEAK () {10;}' unless defined(&MIXT_STEREOPEAK);
    eval 'sub MIXT_RADIOGROUP () {11;}' unless defined(&MIXT_RADIOGROUP);
    eval 'sub MIXT_MARKER () {12;}' unless defined(&MIXT_MARKER);
    eval 'sub MIXT_VALUE () {13;}' unless defined(&MIXT_VALUE);
    eval 'sub MIXT_HEXVALUE () {14;}' unless defined(&MIXT_HEXVALUE);
    eval 'sub MIXT_MONODB () {15;}' unless defined(&MIXT_MONODB);
    eval 'sub MIXT_STEREODB () {16;}' unless defined(&MIXT_STEREODB);
    eval 'sub MIXT_SLIDER () {17;}' unless defined(&MIXT_SLIDER);
    eval 'sub MIXT_3D () {18;}' unless defined(&MIXT_3D);
    eval 'sub MIXF_READABLE () {0x1;}' unless defined(&MIXF_READABLE);
    eval 'sub MIXF_WRITEABLE () {0x2;}' unless defined(&MIXF_WRITEABLE);
    eval 'sub MIXF_POLL () {0x4;}' unless defined(&MIXF_POLL);
    eval 'sub MIXF_HZ () {0x8;}' unless defined(&MIXF_HZ);
    eval 'sub MIXF_STRING () {0x10;}' unless defined(&MIXF_STRING);
    eval 'sub MIXF_DYNAMIC () {0x10;}' unless defined(&MIXF_DYNAMIC);
    eval 'sub MIXF_OKFAIL () {0x20;}' unless defined(&MIXF_OKFAIL);
    eval 'sub MIXF_FLAT () {0x40;}' unless defined(&MIXF_FLAT);
    eval 'sub MIXF_LEGACY () {0x80;}' unless defined(&MIXF_LEGACY);
    eval 'sub MIXEXT_SCOPE_MASK () {0x3f;}' unless defined(&MIXEXT_SCOPE_MASK);
    eval 'sub MIXEXT_SCOPE_OTHER () {0x;}' unless defined(&MIXEXT_SCOPE_OTHER);
    eval 'sub MIXEXT_SCOPE_INPUT () {0x1;}' unless defined(&MIXEXT_SCOPE_INPUT);
    eval 'sub MIXEXT_SCOPE_OUTPUT () {0x2;}' unless defined(&MIXEXT_SCOPE_OUTPUT);
    eval 'sub MIXEXT_SCOPE_MONITOR () {0x3;}' unless defined(&MIXEXT_SCOPE_MONITOR);
    eval 'sub MIXEXT_SCOPE_RECSWITCH () {0x4;}' unless defined(&MIXEXT_SCOPE_RECSWITCH);
    eval 'sub OSS_ENUM_MAXVALUE () {255;}' unless defined(&OSS_ENUM_MAXVALUE);
    eval 'sub OPEN_READ () { &PCM_ENABLE_INPUT;}' unless defined(&OPEN_READ);
    eval 'sub OPEN_WRITE () { &PCM_ENABLE_OUTPUT;}' unless defined(&OPEN_WRITE);
    eval 'sub OPEN_READWRITE () {( &OPEN_READ| &OPEN_WRITE);}' unless defined(&OPEN_READWRITE);
    eval 'sub OSS_MAX_SAMPLE_RATES () {20;}' unless defined(&OSS_MAX_SAMPLE_RATES);
    eval 'sub MIXER_CAP_VIRTUAL () {0x1;}' unless defined(&MIXER_CAP_VIRTUAL);
    eval 'sub MIDI_CAP_MPU401 () {0x1;}' unless defined(&MIDI_CAP_MPU401);
    eval 'sub MIDI_CAP_INPUT () {0x2;}' unless defined(&MIDI_CAP_INPUT);
    eval 'sub MIDI_CAP_OUTPUT () {0x4;}' unless defined(&MIDI_CAP_OUTPUT);
    eval 'sub MIDI_CAP_INOUT () {( &MIDI_CAP_INPUT| &MIDI_CAP_OUTPUT);}' unless defined(&MIDI_CAP_INOUT);
    eval 'sub MIDI_CAP_VIRTUAL () {0x8;}' unless defined(&MIDI_CAP_VIRTUAL);
    eval 'sub MIDI_CAP_MTCINPUT () {0x10;}' unless defined(&MIDI_CAP_MTCINPUT);
    eval 'sub MIDI_CAP_CLIENT () {0x20;}' unless defined(&MIDI_CAP_CLIENT);
    eval 'sub MIDI_CAP_SERVER () {0x40;}' unless defined(&MIDI_CAP_SERVER);
    eval 'sub MIDI_CAP_INTERNAL () {0x80;}' unless defined(&MIDI_CAP_INTERNAL);
    eval 'sub MIDI_CAP_EXTERNAL () {0x100;}' unless defined(&MIDI_CAP_EXTERNAL);
    eval 'sub MIDI_CAP_PTOP () {0x200;}' unless defined(&MIDI_CAP_PTOP);
    eval 'sub MIDI_CAP_MTC () {0x400;}' unless defined(&MIDI_CAP_MTC);
    eval 'sub SNDCTL_SYSINFO () { &_IOR (ord(\'X\'), 1,  &oss_sysinfo);}' unless defined(&SNDCTL_SYSINFO);
    eval 'sub OSS_SYSINFO () { &SNDCTL_SYSINFO;}' unless defined(&OSS_SYSINFO);
    eval 'sub SNDCTL_MIX_NRMIX () { &_IOR (ord(\'X\'), 2, \'int\');}' unless defined(&SNDCTL_MIX_NRMIX);
    eval 'sub SNDCTL_MIX_NREXT () { &_IOWR(ord(\'X\'), 3, \'int\');}' unless defined(&SNDCTL_MIX_NREXT);
    eval 'sub SNDCTL_MIX_EXTINFO () { &_IOWR(ord(\'X\'), 4,  &oss_mixext);}' unless defined(&SNDCTL_MIX_EXTINFO);
    eval 'sub SNDCTL_MIX_READ () { &_IOWR(ord(\'X\'), 5,  &oss_mixer_value);}' unless defined(&SNDCTL_MIX_READ);
    eval 'sub SNDCTL_MIX_WRITE () { &_IOWR(ord(\'X\'), 6,  &oss_mixer_value);}' unless defined(&SNDCTL_MIX_WRITE);
    eval 'sub SNDCTL_AUDIOINFO () { &_IOWR(ord(\'X\'), 7,  &oss_audioinfo);}' unless defined(&SNDCTL_AUDIOINFO);
    eval 'sub SNDCTL_MIX_ENUMINFO () { &_IOWR(ord(\'X\'), 8,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_MIX_ENUMINFO);
    eval 'sub SNDCTL_MIDIINFO () { &_IOWR(ord(\'X\'), 9,  &oss_midi_info);}' unless defined(&SNDCTL_MIDIINFO);
    eval 'sub SNDCTL_MIXERINFO () { &_IOWR(ord(\'X\'),10,  &oss_mixerinfo);}' unless defined(&SNDCTL_MIXERINFO);
    eval 'sub SNDCTL_CARDINFO () { &_IOWR(ord(\'X\'),11,  &oss_card_info);}' unless defined(&SNDCTL_CARDINFO);
    eval 'sub SNDCTL_ENGINEINFO () { &_IOWR(ord(\'X\'),12,  &oss_audioinfo);}' unless defined(&SNDCTL_ENGINEINFO);
    eval 'sub SNDCTL_AUDIOINFO_EX () { &_IOWR(ord(\'X\'),13,  &oss_audioinfo);}' unless defined(&SNDCTL_AUDIOINFO_EX);
    eval 'sub SNDCTL_SETSONG () { &_IOW (ord(\'Y\'), 2, \'oss_longname_t\');}' unless defined(&SNDCTL_SETSONG);
    eval 'sub SNDCTL_GETSONG () { &_IOR (ord(\'Y\'), 2, \'oss_longname_t\');}' unless defined(&SNDCTL_GETSONG);
    eval 'sub SNDCTL_SETNAME () { &_IOW (ord(\'Y\'), 3, \'oss_longname_t\');}' unless defined(&SNDCTL_SETNAME);
    eval 'sub SNDCTL_SETLABEL () { &_IOW (ord(\'Y\'), 4,  &oss_label_t);}' unless defined(&SNDCTL_SETLABEL);
    eval 'sub SNDCTL_GETLABEL () { &_IOR (ord(\'Y\'), 4,  &oss_label_t);}' unless defined(&SNDCTL_GETLABEL);
}
1;
