/*
 * Copyright © 2007 Christian Persch
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <config.h>

#include <glib/gi18n-lib.h>

#include "mucharmap.h"
#include "mucharmap-private.h"

G_GNUC_INTERNAL void
_mucharmap_intl_ensure_initialized (void)
{
	static gboolean initialised = FALSE;

	if (initialised)
		return;

	#ifdef ENABLE_NLS
		bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
		#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
			bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
		#endif
	#endif /* #ifdef ENABLE_NLS */
}

